#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>

#include "snp_Config.h"
#include "snp_DataReader.h"
#include "snp_MemoryControl.h"
#include "snp_GetTime.h"
#include "snp_TypeI.h"
#include "snp_Chi.h"

/* t@Cf[^IŕێČvZ */
void MainProgramMulti(char *inputFile, int L);

int main(int argc, char* argv[])
{
    int L = 0;  /* 肷`q */
    char inputFile[1024];   /*  */

    if(argc != 3){
        printf("[usage]main.exe [InputFile] [L]\n");
        return 255;
    }
    strcpy(inputFile, argv[1]);
    L = atoi(argv[2]);

    MainProgramMulti(inputFile, L);

}


/* t@Cf[^IŕێČvZ */
void MainProgramMulti(char *inputFile, int L)
{
    int retval = 0;

    long i = 0;
	long j = 0;
    long fileLine = 0; /* ̓t@C̃C */
    long dataNum = 0;   /* ̓f[^̃Tvl */
    long index = 0;
    long maxIndex = 0;

    int *paternNum = NULL;
    double **frequency = NULL;  /* px */
    char **sequence = NULL; /* V[PXf[^ */

    FILE *fpIn = NULL;

    /* t@CI[v */
    retval = InputFileOpen(&fpIn, inputFile);
    if (retval != 0){
        goto finalize;
    }

    /* ̓t@C̃C擾 */
    fileLine = DataReaderCountFileLine(fpIn);

    /* t@C|C^擪ɖ߂ */
    fseek(fpIn, 0L, SEEK_SET);

    /* ̓f[^̃Tvl擾 */
    dataNum =  DataReaderGetHaplotypeSampleNum(fpIn);

    /* V[PXf[^̃m */
    sequence = (char**)mallocChar2Dim(dataNum, L);
    if (NULL == sequence) { goto finalize; }
    /* p^[px̃m */
    frequency = (double**)malloc1Dim(sizeof(double*), fileLine - L);
    if (NULL == frequency) { goto finalize; }
    /* p^[̃m */
    paternNum = (int*)malloc1Dim(sizeof(int*), fileLine - L);
    if (NULL == paternNum) { goto finalize; }

    /* el̈`qiŏLjf[^擾 */
    for (i = 0; i < L; i++){
        DataReaderSetHaplotypeSequence(fpIn, sequence, i);
    }
    /* pxvZ */
    paternNum[index] = DataReaderCalcHaplotypeFrequency(sequence, dataNum, L, &frequency[index]);
    index++;

	for (i = L; i < fileLine-1; i++){
        /* el̎̈`qf[^擾 */
        DataReaderSetHaplotypeSequence(fpIn, sequence, i%L);
        /* pxvZ */
        paternNum[index] = DataReaderCalcHaplotypeFrequency(sequence, dataNum, L, &frequency[index]);
        index++;
	}
    maxIndex = index;


    /* mFpo */
    for (index = 0; index < maxIndex; index++){
        printf("%ld, ", index);
        for (i = 0; i < paternNum[index]; i++){
            printf("%lf, ", frequency[index][i]);
        }
        printf("\n");
    }
   

finalize:;
    /* t@CN[Y */
    FileClose(fpIn);
    /* mۂJ */
    freeChar2Dim(sequence, dataNum);
    freeDouble2Dim(frequency, fileLine - L);
    free1Dim(paternNum);

    return;
}
