// Ԍv

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>

#include "snp_Config.h"
#include "snp_Permutation.h"
#include "snp_Factorial.h"
#include "snp_Q.h"
#include "snp_G.h"
#include "snp_Table.h"
#include "snp_Primitive.h"
#include "snp_MCMC.h"
#include "snp_Gsampler.h"
#include "snp_DataReader.h"
#include "snp_MemoryControl.h"
#include "snp_GetTime.h"


#define NUM_TM	100
double tm[NUM_TM];  /* Ԍvp */

/* vg^Cv錾 */
void ExecuteMain(char *fileName);
/* t@CPsǂݍŌvZ */
void MainProgramA(InputData *inputData);
/* t@Cf[^IŕێČvZ */
void MainProgramB(InputData *inputData);

int main(int argc, char* argv[])
{
    int num = 0;
    //char fileName[1024];
    InputData inputData={"", "", "", PRINT_LEVEL, SCORE, REPEAT, ANALYSIS, DATA_TYPE};

    double t1 = 0.0, t2 = 0.0;

    t1 = gettimeofdaySec(); /* Jn */

    /****************************/
    /* ͂Ŏw肷ꍇ */
    /****************************/
    if(argc != 9){
        printf("[usage]main.exe [InputFile1] [InputFile2] [OutputFile1] [OutputLevel1] [Score] [Repeat] [Analysis] [DataType]\n");
        return 255;
    }
    strcpy(inputData.inputFile1, argv[1]);
    strcpy(inputData.inputFile2, argv[2]);
    strcpy(inputData.outputFile1, argv[3]);
    inputData.outputLevel = atoi(argv[4]);
    inputData.score = atoi(argv[5]);
    inputData.repeat = atol(argv[6]);
    inputData.analysis = atoi(argv[7]);
    inputData.dataType = atoi(argv[8]);

    /* XRAvZ@̎w */
    iWay = inputData.score;

    /* t@CPsǂݍŌvZ */
    //MainProgramA(&inputData);
    /* t@Cf[^IŕێČvZ */
    MainProgramB(&inputData);


    /**********************************/
    /* ͂t@Cǂݍޏꍇ */
    /**********************************/
    //if(argc != 2){
    //    printf("[usage]main.exe [InputConfigFile]\n");
    //    return 255;
    //}
    /* ͐ݒt@C擾 */
    //strcpy(fileName, argv[1]);
    /* Cs */
    //ExecuteMain(fileName);

    t2 = gettimeofdaySec(); /* I */

    printf("time Init - Calc  %lf (sec)\n", tm[1] - t1);
    printf("time Calculation  %lf (sec)\n", tm[2] - tm[1]);
    printf("time Calc - End   %lf (sec)\n", t2 - tm[2]);

    printf("time: %lf (sec)\n", t2 - t1);

    return 0;
}

/* ͂ݒt@CǂݍŎs */
/* ͂Ŏw肷ꍇɂ͎gpȂ */
void ExecuteMain(char *fileName)
{
    InputData inputData={"", "", "", PRINT_LEVEL, SCORE, REPEAT, ANALYSIS};

    /* ͐ݒt@Cp[^擾 */
    DataReaderSetInputData(fileName, &inputData);

    /* XRAvZ@̎w */
    iWay = inputData.score;

    /* t@CPsǂݍŌvZ */
    MainProgramA(&inputData);

    /* t@Cf[^IŕێČvZ */
    //MainProgramB(&inputData);

    return;
}

/* t@CPsǂݍŌvZ */
void MainProgramA(InputData *inputData)
{
//    int retval = 0;
//    int retval1 = 0;
//    int retval2 = 0;
//
//    long i = 0;
//    long fileLine1 = 0; /* ̓t@C̃C */
//    long fileLine2 = 0;
//    long repeat = 0; /* Permutation̎s */
//
//    int **T = NULL;     /* 􌻕\ */
//    double Sobs = 0;    /* Score̒l@ϑn */
//    int count = 0;
//
//    double Hj = 0;
//    double p = 0;
//    double F = 0;
//    double Pr = 0;
//
//    FILE *fpIn1 = NULL;
//    FILE *fpIn2 = NULL;
//    FILE *fpOut = NULL;
//
//    SnpData snpData1;
//    SnpData snpData2;
//                    
//    Table Tbl;
//    
//    repeat = inputData->repeat;
//
//    /* log e[u쐬 */
//    retval = FactorialSetFactorial(SNP_DATA_LEN * 2);
//
//    /* t@CI[v */
//    retval = InputFileOpen(&fpIn1, inputData->inputFile1);
//    if (retval != 0){
//        goto finalize;
//    }
//    retval = InputFileOpen(&fpIn2, inputData->inputFile2);
//    if (retval != 0){
//        goto finalize;
//    }
//    retval = OutputFileOpen(&fpOut, inputData->outputFile1);
//    if (retval != 0){
//        goto finalize;
//    }
//
//    /* ̓t@Ct@Co */
//    DataReaderOutputHeader(fpOut, inputData);
//
//    /* 􌻕\T̃m */
//    T = (int**)mallocInt2Dim(ROW, COLUMN);
//    if (NULL == T){ goto finalize; }
//
//    /* f[^Psڂ̓f[^ł͂Ȃ̂Őɓǂݍł */
//    retval = DataReaderSetData(fpIn1, &snpData1, fileLine1, inputData->dataType);
//    if (retval != 0){ 
//        return;
//    }
//    fileLine1++;
//    retval = DataReaderSetData(fpIn2, &snpData2, fileLine2, inputData->dataType);
//    if (retval != 0){ 
//        return;
//    }
//    fileLine2++;
//    /* ŏ̃[vŌvZsȂ悤Ƀ_~[lݒ */
//    snpData1.pos = -2;
//    snpData2.pos = -1;
//
//    while ( retval1 == 0 || retval2 == 0 ){
//        /* f[^posrAӏ̈`qł邱ƂmF */
//        if (snpData1.pos == snpData2.pos) {
//            /* Q̃f[^SNPalleles̏Ԃ`FbNA􌻕\쐬 */
//            retval = DataReaderCheckSNPalleles(&snpData1, &snpData2, T);
//            if (retval != 0){
//                printf("%s data incorrect!\n", snpData1.rsNumber);
//            }
//            else{
//                switch(inputData->analysis){
//                    case 0:
//                        /* XRAvZ */
//                        Sobs = TableCalcScore(T);
//
//                        /* Permutations */
//                        count = PermutationExecute(T, Sobs, repeat);
//
//                        /* Permutationł̊mPr(T) */
//                        retval = TableMakeTableIntArray(&Tbl, T);
//                        Pr = FactorialGetLogCombination(Tbl.verticalSum[0], Tbl.table[0][0]) + 
//                            FactorialGetLogCombination(Tbl.verticalSum[1], Tbl.table[0][1]) +
//                            FactorialGetLogFactorial(Tbl.horizontalSum[0]) +
//                            FactorialGetLogFactorial(Tbl.horizontalSum[1]) -
//                            FactorialGetLogFactorial(Tbl.horizontalSum[0] + Tbl.horizontalSum[1]);
//
//                        /* m@ŌvZ */
//                        Hj = GGetNumberOfDiInHj(Tbl, Sobs);
//                        F = FactorialGetCombination(Tbl.horizontalSum[0] + Tbl.horizontalSum[1], Tbl.horizontalSum[0]);
//                        p = Hj/F;
//
//                        /* 茋ʃt@Co */
//                        DataReaderOutputResult(inputData->outputLevel, fpOut, &snpData1, &snpData2, &Tbl,
//                                            Sobs, Pr, Hj, F, p, count, repeat);
//                        break;
//                    default:
//                        break;
//                }
//            }
//
//            /* f[^s\̂Ɏ߂ */
//            retval1 = DataReaderSetData(fpIn1, &snpData1, fileLine1, inputData->dataType);
//            if (retval1 != 0){ 
//                //continue;
//            }
//            fileLine1++;
//            /* f[^s\̂Ɏ߂ */
//            retval2 = DataReaderSetData(fpIn2, &snpData2, fileLine2, inputData->dataType);
//            if (retval2 != 0){ 
//                //continue;
//            }
//            fileLine2++;
//        }
//        /* f[^posvȂꍇÃf[^ǂ */
//        else if (snpData1.pos < snpData2.pos) {
//            /* f[^s\̂Ɏ߂ */
//            retval1 = DataReaderSetData(fpIn1, &snpData1, fileLine1, inputData->dataType);
//            if (retval1 != 0){ 
//                continue;
//            }
//            fileLine1++;
//        }
//        else if (snpData1.pos > snpData2.pos) {
//            /* f[^s\̂Ɏ߂ */
//            retval2 = DataReaderSetData(fpIn2, &snpData2, fileLine2, inputData->dataType);
//            if (retval2 != 0){ 
//                continue;
//            }
//            fileLine2++;
//        }
//    }
//
//finalize:;
//    /* t@CN[Y */
//    FileClose(fpIn1);
//    FileClose(fpIn2);
//    FileClose(fpOut);
//    /* mۂJ */
//    freeInt2Dim(T, ROW);
//    /* loge[uNA */
//    FactorialDeleteFactorial();
//    /* \tablẽJ */
//    TableFinalTable(&Tbl);

    return;
}

/* t@Cf[^IŕێČvZ */
void MainProgramB(InputData *inputData)
{
    int retval = 0;

    long i = 0;
    long fileLine1 = 0; /* ̓t@C̃C */
    long fileLine2 = 0;
    long dataNum = 0;   /* pbLO̓̓f[^ */
    long repeat = 0;    /* Permutation̎s */

    int **T = NULL;     /* 􌻕\ */
    double Sobs = 0;    /* Score̒l ϑn */
    int count = 0;
    int sampleNum = 0;

    double Hj = 0;
    double p = 0;
    double F = 0;
    double Pr = 0;

    FILE *fpIn1 = NULL;
    FILE *fpIn2 = NULL;
    FILE *fpOut = NULL;

    SnpData *snpTmpData1 = NULL;
    SnpData *snpTmpData2 = NULL;
    SnpData *snpData1 = NULL;
    SnpData *snpData2 = NULL;

    OutputData *outputData = NULL;

    Table Tbl;
    
    repeat = inputData->repeat;

    /* t@CI[v */
    retval = InputFileOpen(&fpIn1, inputData->inputFile1);
    if (retval != 0){
        goto finalize;
    }
    retval = InputFileOpen(&fpIn2, inputData->inputFile2);
    if (retval != 0){
        goto finalize;
    }
    retval = OutputFileOpen(&fpOut, inputData->outputFile1);
    if (retval != 0){
        goto finalize;
    }

    /* 􌻕\T̃m */
    T = (int**)mallocInt2Dim(ROW, COLUMN);
    if (NULL == T){ goto finalize; }

    /* ̓t@C̃C擾 */
    fileLine1 = DataReaderCountFileLine(fpIn1);
    fileLine2 = DataReaderCountFileLine(fpIn2);

    /* t@C|C^擪ɖ߂ */
    fseek(fpIn1, 0L, SEEK_SET);
    fseek(fpIn2, 0L, SEEK_SET);

    /* f[^ꎞi[p\̂̃m */
    snpTmpData1 = (SnpData*)malloc1Dim(sizeof(SnpData), fileLine1);
    snpTmpData2 = (SnpData*)malloc1Dim(sizeof(SnpData), fileLine2);

    /* f[^t@Cǂݍݍ\̂Ɏ߂ */
    DataReaderSetAllData(fpIn1, snpTmpData1, fileLine1, inputData->dataType);
    DataReaderSetAllData(fpIn2, snpTmpData2, fileLine2, inputData->dataType);

    /* ̓f[^̐`FbNĕ񉻗p̓̓f[^쐬 */
    dataNum = DataReaderMakeParallelData(snpTmpData1, snpTmpData2, fileLine1, fileLine2, &snpData1, &snpData2);

    /* gpȂz̃J */
    free1Dim(snpTmpData1);
    free1Dim(snpTmpData2);
    snpTmpData1 = NULL;
    snpTmpData2 = NULL;

    /* o͗pf[^i[\̔z̃m */
    outputData = (OutputData*)malloc1Dim(sizeof(OutputData), dataNum);

    sampleNum = snpData1[0].dataNum + snpData2[0].dataNum;
    /* log e[u쐬 */
    retval = FactorialSetFactorial(sampleNum * 2);

    /* mFp@t@Co */
    //DataReaderOutputAllData(fpOut, snpData2, dataNum);

    tm[1] = gettimeofdaySec(); /* vZJn */

    for (i = 0; i < dataNum; i++){
        /* Q̓̓f[^􌻕\쐬 */
        DataReaderMakeTable(&snpData1[i], &snpData2[i], T);

        switch(inputData->analysis){
            case 0:
                /* XRAvZ */
                outputData[i].Sobs = TableCalcScore(T);

                /* Permutations */
                outputData[i].count = PermutationExecute(T, outputData[i].Sobs, repeat);

                /* Permutationł̊mPr(T) */
                retval = TableMakeTableIntArray(&Tbl, T);
                outputData[i].Pr = 
                    FactorialGetLogCombination(Tbl.verticalSum[0], Tbl.table[0][0]) + 
                    FactorialGetLogCombination(Tbl.verticalSum[1], Tbl.table[0][1]) +
                    FactorialGetLogFactorial(Tbl.horizontalSum[0]) +
                    FactorialGetLogFactorial(Tbl.horizontalSum[1]) -
                    FactorialGetLogFactorial(Tbl.horizontalSum[0] + Tbl.horizontalSum[1]);

                /* m@ŌvZ */
                outputData[i].p = GCalcP(Tbl, outputData[i].Sobs);

                /* \tablẽJ */
                TableFinalTable(&Tbl);

                break;
            default:
                break;
        }
    }

    tm[2] = gettimeofdaySec(); /* vZI */

    /* 茋ʃt@Co */
    DataReaderOutputAllResult(inputData->outputLevel, fpOut, snpData1, snpData2, outputData, inputData, dataNum);


finalize:;
    /* t@CN[Y */
    FileClose(fpIn1);
    FileClose(fpIn2);
    FileClose(fpOut);
    /* mۂJ */
    freeInt2Dim(T, ROW);
    free1Dim(snpTmpData1);
    free1Dim(snpTmpData2);
    free1Dim(snpData1);
    free1Dim(snpData2);
    free1Dim(outputData);
    /* loge[uNA */
    FactorialDeleteFactorial();
    /* \tablẽJ */
    //TableFinalTable(&Tbl);

    return;
}
