#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>

#include "snp_CalcScore.h"

int main(int argc, char* argv[])
{
    InputScore inputScore={"", "", "", 0, "", 0, 0};

    if(argc != 8){
        printf("[usage]main.exe [InputFile1] [InputFile2] [OutputFile] [AreaFileType] [BlockAreaFile] [Score] [dataType] \n");
        return 255;
    }
    strcpy(inputScore.inputFile1, argv[1]);
    strcpy(inputScore.inputFile2, argv[2]);
    strcpy(inputScore.outputFile1, argv[3]);
    inputScore.areaFileType = atoi(argv[4]);
    strcpy(inputScore.blockAreaFile, argv[5]);
    inputScore.score = atoi(argv[6]);
    inputScore.dataType = atoi(argv[7]);

    /* XRAvZ@̎w */
    iWay = inputScore.score;

    /* SNPScorevZs */
    MainProgramScore(&inputScore);

}


/* ScoreScorevZs */
void MainProgramScore(InputScore *inputScore)
{
    int retval = 0;
    int flag = 0;
    long i = 0;
	long j = 0;
    long index = 0;
    long fileLine1 = 0; /* ̓t@Cicasej̃C */
    long fileLine2 = 0; /* ̓t@Cicontorlj̃C */
    long areaFileLine = 0; /* haplotypeubN̈wt@C̃C */
    long a = 0;         /* number of haplotype copies (=sequences) in case */
    long b = 0;         /* number of haplotype copies (=sequences) in control */
    long n = 0;
    long dataNum;       /* caseAcontrolf[^̑SNP */
    long jStart = 0;    /* haplotypeubN̍ŏSNP */
    long jEnd = 0;      /* haplotypeubN̍ŌSNP */
    long blockNum = 0;  /* haplotypeubN */
    long startPos = 0;
    long endPos = 0;

    int **T = NULL;             /* 􌻕\ */
    int *populationType = NULL;
    long *blockArea = NULL;     /* ehaplotypeubN̈i[ */
    long *linkSNPNum = NULL;    /* ehaplotypeubNSNP */
    long *linkSNPStart = NULL;  /* ehaplotypeubN̍ŏSNP */
    double *Sobs = NULL;        /* eSNP̃XRA */

    FILE *fpCase = NULL;    /* ́icasejt@C|C^ */
    FILE *fpCntl = NULL;    /* ́icontroljt@C|C^ */
    FILE *fpOut = NULL;     /* o̓t@C|C^ */
    FILE *fpArea = NULL;    /* haplotypeubN̈wt@C|C^ */

    char *caseData = NULL;      /* Tvf[^icaseji[p */
    char *controlData = NULL;   /* Tvf[^icontrolji[p */

    SnpData *snpTmpData1 = NULL;
    SnpData *snpTmpData2 = NULL;
    SnpData *snpData1 = NULL;
    SnpData *snpData2 = NULL;


    /* t@CI[v */
    retval = InputFileOpen(&fpCase, inputScore->inputFile1);
    if (retval != 0){
        goto finalize;
    }
    retval = InputFileOpen(&fpCntl, inputScore->inputFile2);
    if (retval != 0){
        goto finalize;
    }
    retval = OutputFileOpen(&fpOut, inputScore->outputFile1);
    if (retval != 0){
        goto finalize;
    }
    retval = InputFileOpen(&fpArea, inputScore->blockAreaFile);
    if (retval != 0){
        goto finalize;
    }

/****************************************************************/
/* f[^                                                   */
/****************************************************************/
 
    /* haplotypeubN̈wt@C̃C擾 */
    areaFileLine = DataReaderCountFileLine(fpArea);
    /* haplotypeubN̈i[pz̃m */
    blockArea = (long*)malloc1Dim(sizeof(long), areaFileLine);
    if (NULL == blockArea){ goto finalize; }
    /* t@C|C^擪ɖ߂ */
    fseek(fpArea, 0L, SEEK_SET);
    /* haplotypeubN̈zɎ߂ */
    DataReaderSetHaplotypeBlockArea(fpArea, blockArea);

    /* ̓t@C̃C擾 */
    fileLine1 = DataReaderCountFileLine(fpCase);
    fileLine2 = DataReaderCountFileLine(fpCntl);

    /* t@C|C^擪ɖ߂ */
    fseek(fpCase, 0L, SEEK_SET);
    fseek(fpCntl, 0L, SEEK_SET);

    /* f[^ꎞi[p\̂̃m */
    snpTmpData1 = (SnpData*)malloc1Dim(sizeof(SnpData), fileLine1);
    if (NULL == snpTmpData1){ goto finalize; }
    snpTmpData2 = (SnpData*)malloc1Dim(sizeof(SnpData), fileLine2);
    if (NULL == snpTmpData2){ goto finalize; }

    /* f[^t@Cǂݍݍ\̂Ɏ߂ */
    DataReaderSetAllData(fpCase, snpTmpData1, fileLine1, inputScore->dataType);
    DataReaderSetAllData(fpCntl, snpTmpData2, fileLine2, inputScore->dataType);

    /* ̓f[^̐`FbNĕ񉻗p̓̓f[^쐬 */
    /* MPI_Bcast̉񐔂炷߂ɃTvf[^͕ʔzicaseData, controlDatajŕێ */
    dataNum = DataReaderMakeParallelData(snpTmpData1, snpTmpData2, fileLine1, fileLine2, &snpData1, &snpData2, &caseData, &controlData);

    /* gpȂz̃J */
    /* \SnpDataõJ */
    DataReaderSnpDataMemoryFree(snpTmpData1, fileLine1);
    DataReaderSnpDataMemoryFree(snpTmpData2, fileLine2);
    snpTmpData1 = NULL;
    snpTmpData2 = NULL;

    /* ̓f[^̃Tv擾 */
    a = snpData1[0].dataNum;
    b = snpData2[0].dataNum;
    n = a + b;

    /* \SnpDataɃTvf[^Rs[ */
    DataReaderDataCopyToSnpData(snpData1, caseData, dataNum, a);
    DataReaderDataCopyToSnpData(snpData2, controlData, dataNum, b);

/****************************************************************/
/* m                                                   */
/****************************************************************/

    /* haplotypeubN */
    if (inputScore->areaFileType == 0){
        blockNum = areaFileLine - 1;
    }
    else {
        /* haplotypeubŇvZ */
        if (blockArea[0] > dataNum){
            blockNum = 1;
            blockArea[1] = dataNum; /* linkSNPNum̒lf[^ɂȂ */
        }
        else{
            blockNum = (dataNum - (blockArea[0] - blockArea[1]) ) / blockArea[1];
        }
    }
    /* ehaplotypeubN̈SNPi[pz̃m */
    linkSNPNum = (long*)malloc1Dim(sizeof(long), blockNum);
    if (NULL == linkSNPNum){ goto finalize; }
    /* ehaplotypeubN̈̍ŏSNPʊi[pz̃m */
    linkSNPStart = (long*)malloc1Dim(sizeof(long), blockNum);
    if (NULL == linkSNPStart){ goto finalize; }

    /* ehaplotypeubN̈ɊYSNPf[^ */
    if (inputScore->areaFileType == 0){
        for (i = 0; i < blockNum; i++){ /* Ä̏dꍇl */
            startPos = blockArea[i];
            endPos = blockArea[i+1];
            flag = 0;
            /* ̓f[^̓|WVŃ\[gĂƉ */
            for (j = 0; j < dataNum; j++){
                if (startPos <= snpData1[j].pos){
                    if (snpData1[j].pos < endPos){
                        /* ̈SNPJEg */
                        linkSNPNum[i]++;
                        /* ̈̍ŏSNPʂێ */
                        if (0 == flag ){
                            linkSNPStart[i] = j;
                            flag = 1;
                        }
                    }
                    /* ȍ~ÄɊYf[^͏oȂ̂Ŏ̃ubN𒲂ׂ */
                    else {
                        break;
                    }
                }
            }
        }
    }
     else {
        for (i = 0; i < blockNum; i++){
            linkSNPNum[i] = blockArea[0];
            linkSNPStart[i] = i * blockArea[1];
        }
    }

    /* 􌻕\T̃m */
    T = (int**)mallocInt2Dim(ROW, COLUMN);
    if (NULL == T){ goto finalize; }
    /* populationTypẽm */
    populationType = (int*)malloc1Dim(sizeof(int), a + b);
    if (NULL == populationType) { goto finalize; }
    /* eSNP̃XRAi[pz̃m */
    Sobs = (double*)malloc1Dim(sizeof(double), dataNum);
    if (NULL == Sobs) { goto finalize; }

/****************************************************************/
/* ScorevZ                                                    */
/****************************************************************/

    /* haplotypeubNPʂŃ[v */
    jStart = 0;
    index = 0;
    for (i = 0; i < blockNum; i++){
        jStart = linkSNPStart[i];
        jEnd = jStart + linkSNPNum[i];
        /* ehaplotypeubNŃ[v */
        for (j = jStart; j < jEnd; j++){
            /* ϑl􌻕\쐬 */
            DataReaderPopulationType(&snpData1[j], &snpData2[j], populationType);
            DataReaderMakeTableDi(&snpData1[j], &snpData2[j], populationType, T);
            /* XRAvZ@XRAvZ0ɂȂĂ܂ꍇ-1Ԃ */
            Sobs[index] = TableCalcScore(T);
            index++;
        }
    }

/****************************************************************/
/* ScorevZʏo                                            */
/****************************************************************/

    index = 0;
    fprintf(fpOut, "CaseData    = %s\n", inputScore->inputFile1);
    fprintf(fpOut, "ControlData = %s\n", inputScore->inputFile2);
    fprintf(fpOut, "BlockArea\tSNPNum\trsNumber\tPosition\tScore\tP\n");
    if (inputScore->areaFileType == 0){
        for (i = 0; i < blockNum; i++){
            jStart = linkSNPStart[i];
            jEnd = jStart + linkSNPNum[i];
            /* ehaplotypeubNŃ[v */
            for (j = jStart; j < jEnd; j++){
                fprintf(fpOut, "%ld-%ld\t%ld\t%s\t%ld\t%.3e\t \n", 
                    blockArea[i],
                    blockArea[i+1],
                    linkSNPNum[i],
                    snpData1[j].rsNumber,
                    snpData1[j].pos,
                    Sobs[index]);
                index++;
            }
        }
    }
    else {
        for (i = 0; i < blockNum; i++){
            jStart = linkSNPStart[i];
            jEnd = jStart + linkSNPNum[i];
            /* ehaplotypeubNŃ[v */
            for (j = jStart; j < jEnd; j++){
                fprintf(fpOut, "%ld-%ld\t%ld\t%s\t%ld\t%.3e\t \n", 
                    snpData1[ linkSNPStart[i] ].pos,
                    snpData1[ linkSNPStart[i] + linkSNPNum[i] - 1 ].pos,
                    linkSNPNum[i],
                    snpData1[j].rsNumber,
                    snpData1[j].pos,
                    Sobs[j]);
            }
        }
    }

/****************************************************************/
/* I                                                     */
/****************************************************************/

finalize:;
    /* t@CN[Y */
    FileClose(fpCase);
    FileClose(fpCntl);
    FileClose(fpOut);
    FileClose(fpArea);
    /* mۂJ */
    free1Dim(blockArea);
    free1Dim(linkSNPNum);
    free1Dim(linkSNPStart);
    freeInt2Dim(T, ROW);
    free1Dim(populationType);
    free1Dim(Sobs);
    DataReaderSnpDataMemoryFree(snpTmpData1, fileLine1);
    DataReaderSnpDataMemoryFree(snpTmpData2, fileLine2);
    free1Dim(caseData);
    free1Dim(controlData);
    free1Dim(snpData1);
    free1Dim(snpData2);

    return;
}
