#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <math.h>

#include "snp_DataReader.h"
#include "snp_Config.h"
#include "snp_MemoryControl.h"

/**********************/
/* ̓t@CJ */
/**********************/
int InputFileOpen(FILE **fp, char *file)
{
    int retval = 0;

    /* t@CI[v */
    *fp = fopen(file, "r");
    if (NULL == *fp){
        printf("input file open error! FileName:%s\n", file);
        retval = 1;
    }

    return retval;
}

/**********************/
/* o̓t@CJ */
/**********************/
int OutputFileOpen(FILE **fp, char *file)
{
    int retval = 0;

    /* t@CI[v */
    *fp = fopen(file, "w");
    if (NULL == *fp){
        printf("output file open error! FileName:%s\n", file);
        retval = 1;
    }

    return retval;
}

/********************/
/* t@C */
/********************/
void FileClose(FILE *fp)
{
    if (fp != NULL){
        fclose(fp);
    }
}


/********************************/
/* t@C̍sJEg */
/********************************/
long DataReaderCountFileLine(FILE *fp)
{
    long index = 0;
    long count = 0;
    char buf[MAX_LEN];

    /* 蕶ǂݍ */
    while ( fgets(buf, MAX_LEN, fp) != NULL ){
        index = strlen(buf);
        if ('\n' == buf[index-1]){
            count++;
        }
    }

    return count;
}

/********************************/
/* ̓f[^\̂Ɏ߂ */
/********************************/
int DataReaderSetAllData(FILE *fp, SnpData *snpData, long line, int dataType)
{
    int retval = 0;

    switch(dataType){
        case 0:
            /* ̓f[^Hapmap */
            retval = DataReaderSetAllHapmapData(fp, snpData, line);
            break;
        case 1:
            /* ̓f[^HaplotypeData */
            retval = DataReaderSetAllHaplotypeData(fp, snpData, line);
            break;
        case 2:
            /* ̓f[^PhasingHapmap */
            retval = DataReaderSetAllPhasingHapmapData(fp, snpData, line);
            break;
        default:
            break;
    }
    return retval;
}

/********************************/
/* ̓f[^s\̂Ɏ߂ */
/********************************/
int DataReaderSetData(FILE *fp, SnpData *snpData, long line, int dataType)
{
    int retval = 0;

    switch(dataType){
        case 0:
            /* ̓f[^Hapmap */
            retval = DataReaderSetHapmapData(fp, snpData, line);
            break;
        case 1:
            /* ̓f[^HaplotypeData */
            retval = DataReaderSetHaplotypeData(fp, snpData, line);
            break;
        case 2:
            /* ̓f[^PhasingHapmap */
            retval = DataReaderSetPhasingHapmapData(fp, snpData, line);
            break;
        default:
            break;
    }
    return retval;
}

/********************************/
/* Hapmapf[^\̂Ɏ߂ */
/********************************/
int DataReaderSetAllHapmapData(FILE *fp, SnpData *snpData, long line)
{
    int retval = 0;
    long i = 0;
    long sampleNum = 0;

    /* HapmapDatãTv擾 */
    sampleNum = DataReaderGetHapmapSampleNum(fp);
    /* t@Cǂݍ */
    for (i = 1; i < line; i++){
        /* SNPf[^i[pz̃m */
        snpData[i].SNPdata = (char*)malloc1Dim(sizeof(char), sampleNum);
        retval = DataReaderSetHapmapData(fp, &snpData[i], i);
    }

    return retval;
}

/************************************/
/* Hapmapf[^s\̂Ɏ߂ */
/************************************/
int DataReaderSetHapmapData(FILE *fp, SnpData *snpData, long line)
{
    int i = 0;
    int retval = -1;    /* t@CŌ܂ŗĂꍇ-1Ԃ */
    int character = 0;
    int column = 1;     /* Hapmapf[^̗ */
    int refNum = 0;     /* SNPalleles̃p^[ */
    int index = 0;
    int dataIndex = 0;
    char tmp[20];

    /* \̂̏ */
    snpData->missingDataCount = 0;
    snpData->SNPallelesCount[0] = 0;
    snpData->SNPallelesCount[1] = 0;
    snpData->SNPallelesCount[2] = 0;

    /* Pǂݍ */
    while ( feof(fp) == 0 ){
        character = fgetc(fp);
        /* Psǂݍ񂾂lێďI */
        if ('\n' == character){
            snpData->dataNum = dataIndex;
            snpData->allelesNum = refNum;
            retval = 0;
            dataIndex = 0;
            break;
        }
        /* t@ĈQsڈȍ~珈s */
        else if (line > 0){
            /* t@C̗JEg */
            if (isspace(character) != 0){
                if (HAPMAP_RS_NUM == column){
                    snpData->rsNumber[index] = '\0';
                }
                else if (HAPMAP_POS == column){
                    tmp[index] = '\0';
                    snpData->pos = atol(tmp);
                }
                else if (HAPMAP_CHROM == column){
                    snpData->chrom[index] = '\0';
                }
                column++;
                index = 0;
            }
            /* rs#擾 */
            else if (HAPMAP_RS_NUM == column){
                if (isalnum(character) != 0){
                    snpData->rsNumber[index] = character;
                    index++;
                }
            }
            /* SNPallels擾 */
            else if (HAPMAP_ALLELES == column){
                if (isalpha(character) != 0){
                    snpData->SNPalleles[refNum] = character;
                    refNum++;
                }
            }
            /* chrom擾 */
            else if (HAPMAP_CHROM == column){
                if (isalnum(character) != 0){
                    snpData->chrom[index] = character;
                    index++;
                }
            }
            /* pos擾 */
            else if (HAPMAP_POS == column){
                tmp[index] = character;
                index++;
            }
            /* 12ڈڍs̃f[^QƂ */
            else if (column >= HAPMAP_DATA){
                for (i = 0; i < refNum; i++){
                    /* SNPallelesƈvf[^JEg */
                    if (snpData->SNPalleles[i] == character){
                        snpData->SNPallelesCount[i]++;
                    }
                }
                /* Nƈvf[^JEg */
                if ('N' == character){
                    snpData->missingDataCount++;
                }
                /* `qf[^i[ */
                snpData->SNPdata[dataIndex] = character;
                dataIndex++;
            }
        }
    }
    return retval;
}

/*********************************/
/* HaplotypeData\̂Ɏ߂ */
/*********************************/
int DataReaderSetAllHaplotypeData(FILE *fp, SnpData *snpData, long line)
{
    int retval = 0;
    long i = 0;
    long sampleNum = 0;


    /* Haplotypef[^̃Tv擾 */
    sampleNum = DataReaderGetHaplotypeSampleNum(fp);
    for (i = 1; i < line; i++){
        /* SNPf[^i[pz̃m */
        snpData[i].SNPdata = (char*)malloc1Dim(sizeof(char), sampleNum);
        retval = DataReaderSetHaplotypeData(fp, &snpData[i], i);
    }

    return retval;
}

/*************************************/
/* HaplotypeDatas\̂Ɏ߂ */
/*************************************/
int DataReaderSetHaplotypeData(FILE *fp, SnpData *snpData, long line)
{
    int i = 0;
    int retval = -1;    /* t@CŌ܂ŗĂꍇ-1Ԃ */
    int character = 0;
    int column = 1;     /* Haplotypef[^̗ */
    int refNum = 0;     /* SNPalleles̃p^[ */
    int index = 0;
    int dataIndex = 0;
    char tmp[20];

    /* \̂̏ */
    snpData->missingDataCount = 0;
    snpData->SNPallelesCount[0] = 0;
    snpData->SNPallelesCount[1] = 0;
    snpData->SNPallelesCount[2] = 0;

    /* Pǂݍ */
    while ( feof(fp) == 0 ){
        character = fgetc(fp);
        /* Psǂݍ񂾂lێďI */
        if ('\n' == character){
            snpData->dataNum = dataIndex;
            snpData->allelesNum = refNum;
            retval = 0;
            dataIndex = 0;
            break;
        }
        /* t@ĈQsڈȍ~珈s */
        else if (line > 0){
            /* t@C̗JEg */
            if (isspace(character) != 0){
                if (HAPLOTYPE_RS_NUM == column){
                    snpData->rsNumber[index] = '\0';
                }
                else if (HAPLOTYPE_POS == column){
                    tmp[index] = '\0';
                    snpData->pos = atol(tmp);
                }
                else if (HAPLOTYPE_CHROM == column){
                    snpData->chrom[index] = '\0';
                }
                column++;
                index = 0;
            }
            /* rs#擾 */
            else if (HAPLOTYPE_RS_NUM == column){
                if (isalnum(character) != 0){
                    snpData->rsNumber[index] = character;
                    index++;
                }
            }
            /* SNPallels擾 */
            else if (HAPLOTYPE_ALLELES == column){
                if (isalpha(character) != 0){
                    snpData->SNPalleles[refNum] = character;
                    refNum++;
                }
            }
            /* chrom擾 */
            else if (HAPLOTYPE_CHROM == column){
                if (isalnum(character) != 0){
                    snpData->chrom[index] = character;
                    index++;
                }
            }
            /* pos擾 */
            else if (HAPLOTYPE_POS == column){
                tmp[index] = character;
                index++;
            }
            /* 7ڈڍs̃f[^QƂ */
            else if (column >= HAPLOTYPE_DATA){
                for (i = 0; i < refNum; i++){
                    /* SNPallelesƈvf[^JEg */
                    if (snpData->SNPalleles[i] == character){
                        snpData->SNPallelesCount[i]++;
                    }
                }
                /* Nƈvf[^JEg */
                if ('N' == character){
                    snpData->missingDataCount++;
                }
                /* `qf[^i[ */
                snpData->SNPdata[dataIndex] = character;
                dataIndex++;
            }
        }
    }
    return retval;
}

/*********************************************/
/* phasingꂽHapmapf[^\̂Ɏ߂ */
/*********************************************/
int DataReaderSetAllPhasingHapmapData(FILE *fp, SnpData *snpData, long line)
{
    int retval = 0;
    long i = 0;
    long sampleNum = 0;

    /* phasingꂽHapmapf[^̃Tv擾 */
    sampleNum = DataReaderGetPhasingHapmapSampleNum(fp);
    /* t@Cǂݍ */
    for (i = 1; i < line; i++){
        /* SNPf[^i[pz̃m */
        snpData[i].SNPdata = (char*)malloc1Dim(sizeof(char), sampleNum);
        retval = DataReaderSetPhasingHapmapData(fp, &snpData[i], i);
    }

    return retval;
}

/*************************************************/
/* phasingꂽHapmapf[^s\̂Ɏ߂ */
/*************************************************/
int DataReaderSetPhasingHapmapData(FILE *fp, SnpData *snpData, long line)
{
    int i = 0;
    int retval = -1;    /* t@CŌ܂ŗĂꍇ-1Ԃ */
    int character = 0;
    int column = 1;     /* f[^̗ */
    int refNum = 0;     /* SNPalleles̃p^[ */
    int index = 0;
    int dataIndex = 0;
    int flag = 0;
    char tmp[20];

    /* \̂̏ */
    snpData->missingDataCount = 0;
    snpData->SNPallelesCount[0] = 0;
    snpData->SNPallelesCount[1] = 0;
    snpData->SNPallelesCount[2] = 0;

    /* chromݒ */
    strcpy(snpData->chrom, "----");

    /* Pǂݍ */
    while ( feof(fp) == 0 ){
        character = fgetc(fp);
        /* Psǂݍ񂾂lێďI */
        if ('\n' == character){
            snpData->dataNum = dataIndex;
            snpData->allelesNum = refNum;
            retval = 0;
            dataIndex = 0;
            break;
        }
        /* t@ĈQsڈȍ~珈s */
        else if (line > 0){
            /* t@C̗JEg */
            if (isspace(character) != 0){
                if (PHASE_RS_NUM == column){
                    snpData->rsNumber[index] = '\0';
                }
                else if (PHASE_POS == column){
                    tmp[index] = '\0';
                    snpData->pos = atol(tmp);
                }
                column++;
                index = 0;
            }
            /* rs#擾 */
            else if (PHASE_RS_NUM == column){
                if (isalnum(character) != 0){
                    snpData->rsNumber[index] = character;
                    index++;
                }
            }
            /* pos擾 */
            else if (PHASE_POS == column){
                tmp[index] = character;
                index++;
            }
            /* 3ڈȍ~̃f[^QƂ */
            else if (column >= PHASE_DATA){
                /* Nƈvf[^JEg */
                if ('N' == character){
                    snpData->missingDataCount++;
                } 
                else{
                    for (i = 0; i < refNum; i++){
                        /* SNPallelesƈvf[^JEg */
                        if (snpData->SNPalleles[i] == character){
                            snpData->SNPallelesCount[i]++;
                            flag = 1;
                        }
                    } 
                    /* tOĂȂꍇAQځiRځjNPalleles擾 */
                    if (flag == 0){
                        /* SNPalleles擾 */
                        snpData->SNPalleles[refNum] = character;
                        /* SNPallelesƈvf[^JEg */
                        snpData->SNPallelesCount[refNum]++;
                        refNum++;
                    }
                    /* tÕNA */
                    flag = 0;
                }
                /* `qf[^i[ */
                snpData->SNPdata[dataIndex] = character;
                dataIndex++;
            }
        }
    }
    return retval;
}

/*********************************************/
/* \SnpDataɃTvf[^Rs[ */
/*********************************************/
int DataReaderDataCopyToSnpData(SnpData *snpData, char *sampleData, long dataNum, long sampleNum)
{
    long i = 0;

    for (i = 0; i < dataNum; i++){
        /* Tvf[^̃AhX */
        snpData[i].SNPdata = &sampleData[i * sampleNum];
    }

    return 0;
}

/*****************************************/
/* \SnpDatãmۂ */
/*****************************************/
int DataReaderSnpDataMemoryAllocate(SnpData *snpData, long dataNum, long sampleNum)
{
    long i = 0;

    /* t@Cǂݍ */
    for (i = 0; i < dataNum; i++){
        /* SNPf[^i[pz̃m */
        snpData[i].SNPdata = (char*)malloc1Dim(sizeof(char), sampleNum);
    }

    return 0;
}

/*****************************************/
/* \SnpDataõJ */
/*****************************************/
int DataReaderSnpDataMemoryFree(SnpData *snpData, long dataNum)
{
    long i = 0;

    if (NULL != snpData){
        for (i = 0; i < dataNum; i++){
            /* SNPf[^i[pz̃J */
            free1Dim(snpData[i].SNPdata);
        }
        free1Dim(snpData);
    }

    return 0;
}

/*****************************************/
/* haplotypeubN̈zɊi[ */
/*****************************************/
int DataReaderSetHaplotypeBlockArea(FILE *fp, long *blockArea)
{
    long index = 0;
    long strIndex = 0;
    long valIndex = 0;
    char string[MAX_LEN];
    char value[MAX_LEN];

    /* sǂݍ */
    while ( (fgets(string, MAX_LEN, fp)) != NULL){
        strIndex = 0;
        valIndex = 0;
        while (string[strIndex] != '\n'){
            value[valIndex] = string[strIndex];
            strIndex++;
            valIndex++;
        }
        value[valIndex] = '\0';
        blockArea[index] = atol(value);
        index++;
    }
    return 0;
}

/********************************************/
/* ׂĂ̍\̃f[^t@Cɏo͂ */
/********************************************/
//void DataReaderOutputAllData(FILE *fp, SnpData *snpData, long line)
//{
//    long i = 0;
//
//    for (i = 0; i < line; i++){
//        DataReaderOutputData(fp, &snpData[i]);
//
//    }
//}

/************************************/
/* \̃f[^t@Cɏo͂ */
/************************************/
//void DataReaderOutputData(FILE *fp, SnpData *snpData)
//{
//    int j = 0;
//
//    fprintf(fp, "%10s, %10ld, ", snpData->rsNumber, snpData->pos);
//    for (j = 0; j < snpData->allelesNum; j++){
//        fprintf(fp, "%c=>%3d, ", snpData->SNPalleles[j], snpData->SNPallelesCount[j]);
//    }
//    fprintf(fp, "N=>%3d, DataNum=>%3d, ", snpData->missingDataCount, snpData->dataNum);
//    /* el`q̃f[^͕ێȂ */
//    //for (j = 0; j < snpData->dataNum*2; j++){
//    //    fprintf(fp, "%c", snpData->SNPdata[j]);
//    //}
//    fprintf(fp, "\n");
//}

/******************************/
/* ̓f[^\̂Ɏ߂ */
/******************************/
//int DataReaderSetInputData(char *filename, InputData *inputData)
//{
//    int retval = 0;
//    FILE *fp = NULL;
//    char tmp[MAX_LEN];
//
//    /* t@CI[v */
//    retval = InputFileOpen(&fp, filename);
//    if (retval != 0){
//        return -1;
//    }
//
//    retval = DataReaderGetValue(fp, "InputFile1", tmp);
//    if(retval == 0){
//        strcpy(inputData->inputFile1, tmp);
//    }
//    retval = DataReaderGetValue(fp, "InputFile2", tmp);
//    if(retval == 0){
//        strcpy(inputData->inputFile2, tmp);
//    }
//    retval = DataReaderGetValue(fp, "OutputFile1", tmp);
//    if(retval == 0){
//        strcpy(inputData->outputFile1, tmp);
//    }
//    retval = DataReaderGetValue(fp, "OutputLevel", tmp);
//    if(retval == 0){
//        inputData->outputLevel = atoi(tmp);
//    }
//    retval = DataReaderGetValue(fp, "Score", tmp);
//    if(retval == 0){
//        inputData->score = atoi(tmp);
//    }
//    retval = DataReaderGetValue(fp, "Repeat", tmp);
//    if(retval == 0){
//        inputData->repeat = atol(tmp);
//    }
//    retval = DataReaderGetValue(fp, "Analysis", tmp);
//    if(retval == 0){
//        inputData->analysis = atoi(tmp);
//    }
//
//    /* t@CN[Y */
//    FileClose(fp);
//
//    return retval;
//}

/******************************************************/
/* ͐ݒt@Cw肵L[ɑΉlԂ */
/******************************************************/
//int DataReaderGetValue(FILE *fp, char *key, char *value)
//{
//    int len = 0;
//    int strIndex = 0;
//    int valIndex = 0;
//    int retval = -1;
//    char string[MAX_LEN];
//
//    len = strlen(key);
//
//    /* t@C|C^擪ɖ߂ */
//    fseek(fp, 0L, SEEK_SET);
//
//    /* sǂݍ */
//    while ( (fgets(string, MAX_LEN, fp)) != NULL){
//        /* w肵L[ꍇAl擾 */
//        if (strncmp(key, string, len) == 0){
//            strIndex = len + 1;
//            while (string[strIndex] != '\n'){
//                value[valIndex] = string[strIndex];
//                strIndex++;
//                valIndex++;
//            }
//            value[valIndex] = '\0';
//            retval = 0;
//        }
//    }
//    return retval;
//}

/************************************/
/* Q̓̓f[^􌻕\쐬 */
/************************************/
int DataReaderMakeTable(SnpData *snpData1, SnpData *snpData2, int **T)
{
    /* SNPallelesQ̏ꍇ */
    if ( (2 == snpData1->allelesNum) && (2 == snpData2->allelesNum) ){
        /* 􌻕\̍쐬 */
        T[0][0] = snpData1->SNPallelesCount[0];
        T[0][1] = snpData1->SNPallelesCount[1];
        T[1][0] = snpData2->SNPallelesCount[0];
        T[1][1] = snpData2->SNPallelesCount[1];
    }
    /* SNPallelesR̏ꍇ */
    else if ( (3 == snpData1->allelesNum) && (3 == snpData2->allelesNum) ){
        /* 􌻕\̍쐬 */
        T[0][0] = snpData1->SNPallelesCount[0];
        T[0][1] = snpData1->SNPallelesCount[1] + snpData1->SNPallelesCount[2];
        T[1][0] = snpData2->SNPallelesCount[0];
        T[1][1] = snpData2->SNPallelesCount[1] + snpData2->SNPallelesCount[2];
    }
    return 0;
}

/***********************************/
/* QSNPallelȅԓւ */
/***********************************/
int DataReaderShiftSNPalleles(SnpData *snpData, int allele1, int allele2)
{
    int tmpCount = 0;
    char tmpSNP = 0;

    /* ̃f[^ꎞޔ */
    tmpSNP = snpData->SNPalleles[allele1];
    tmpCount = snpData->SNPallelesCount[allele1];
    /* ԓւ */
    snpData->SNPalleles[allele1] = snpData->SNPalleles[allele2];
    snpData->SNPalleles[allele2] = tmpSNP;
    snpData->SNPallelesCount[allele1] = snpData->SNPallelesCount[allele2];
    snpData->SNPallelesCount[allele2] = tmpCount;

    return 0;
}

/********************************************/
/* Q̃f[^SNPalleles̏Ԃ`FbN */
/********************************************/
int DataReaderCheckSNPalleles(SnpData *snpData1, SnpData *snpData2)
{
    int i = 0;
    int j = 0;
    int index = 0;
    int count = 0;

    /* SNPallelesQ̏ꍇ */
    if ( (2 == snpData1->allelesNum) && (2 == snpData2->allelesNum) ){
        /* Q̃f[^SNPalleles̏ԂꍇAȂ */
        if ( (snpData1->SNPalleles[0] == snpData2->SNPalleles[0]) && (snpData1->SNPalleles[1] == snpData2->SNPalleles[1]) ){
            return 0;
        }
        /* Q̃f[^SNPalleles̏Ԃt]ĂꍇAԂւ */
        else if ( (snpData1->SNPalleles[0] == snpData2->SNPalleles[1]) && (snpData1->SNPalleles[1] == snpData2->SNPalleles[0]) ){
            /* QSNPallelȅԓւ */
            DataReaderShiftSNPalleles(snpData2, 0, 1);
            return 0;
        }
        /* Q̃f[^SNPallelesقȂĂꍇ */
        else{
            return -1;
        }
    }
    /* SNPallelesR̏ꍇ */
    else if ( (3 == snpData1->allelesNum) && (3 == snpData2->allelesNum) ){
        /* P̃f[^genotyoePƂSNP肷 */
        for (i = 1; i < 3; i++){
            if(snpData1->SNPallelesCount[i] > snpData1->SNPallelesCount[index]){
                index = i;
            }
        }
        if (index != 0){
            /* genotyoePƂSNPf[^z̐擪ɂ */
            /* QSNPallelȅԓւ */
            DataReaderShiftSNPalleles(snpData1, 0, index);
        }
        /* snpData1snpData2SNPf[^̕т낦 */
        for (i = 0; i < 3; i++){
            for (j = 0; j < 3; j++){
                if (snpData1->SNPalleles[i] == snpData2->SNPalleles[j]){
                    count++;
                    if (i == j){
                        break;
                    }
                    else{
                        /* snpData2SNPf[^̕яύX */
                        /* QSNPallelȅԓւ */
                        DataReaderShiftSNPalleles(snpData2, i, j);
                        break;
                    }
                }
            }
        }
        /* Q̃f[^SNPallelesłȂꍇ */
        if (count != 3){
            return -1;
        }
        return 0;
    }
    /* caseSNPallelesQAcontrolSNPallelesP̏ꍇ */
    /* PhasingHapmapcasẽf[^A/T݂Acontrol̃f[^A݂Ȃ悤ȏꍇ */
    else if ( (2 == snpData1->allelesNum) && (1 == snpData2->allelesNum) ){
        /* PڂSNPalleleꍇ */
        if (snpData1->SNPalleles[0] == snpData2->SNPalleles[0]){
            /* controlɂQڂSNPalleleRs[ */
            snpData2->SNPalleles[1] = snpData1->SNPalleles[1];
            snpData2->allelesNum++;
            return 0;
        }
        /* PڂSNPalleleႤꍇ */
        else if (snpData1->SNPalleles[1] == snpData2->SNPalleles[0]){
            /* controlɂQڂSNPalleleRs[ */
            snpData2->SNPalleles[0] = snpData1->SNPalleles[1];
            snpData2->allelesNum++;
            /* QSNPallelȅԓւ */
            DataReaderShiftSNPalleles(snpData2, 0, 1);
            return 0;
        }
    }
    /* caseSNPallelesPAcontrolSNPallelesQ̏ꍇ */
    /* PhasingHapmapcasẽf[^A݂Acontrol̃f[^A/T݂悤ȏꍇ */
    else if ( (1 == snpData1->allelesNum) && (2 == snpData2->allelesNum) ){
        /* PڂSNPalleleꍇ */
        if (snpData1->SNPalleles[0] == snpData2->SNPalleles[0]){
            /* controlɂQڂSNPalleleRs[ */
            snpData1->SNPalleles[1] = snpData2->SNPalleles[1];
            snpData1->allelesNum++;
            return 0;
        }
        /* PڂSNPalleleႤꍇ */
        else if (snpData1->SNPalleles[0] == snpData2->SNPalleles[1]){
            /* caseɂQڂSNPalleleRs[ */
            snpData1->SNPalleles[1] = snpData2->SNPalleles[0];
            snpData1->allelesNum++;
            /* QSNPallelȅԓւ */
            DataReaderShiftSNPalleles(snpData2, 0, 1);
            return 0;
        }
    }
    /* caseSNPallelesPAcontrolSNPallelesP̏ꍇ */
    /* PhasingHapmapcaseAcontrol̃f[^A݂Ȃ悤ȏꍇ */
    else if ( (1 == snpData1->allelesNum) && (1 == snpData2->allelesNum) ){
        /* PڂSNPalleleꍇ */
        if (snpData1->SNPalleles[0] == snpData2->SNPalleles[0]){
            /* QڂSNPallele */
            snpData1->SNPalleles[1] = '-';
            snpData2->SNPalleles[1] = '-';
            snpData1->allelesNum++;
            snpData2->allelesNum++;
            return 0;
        }
        /* PڂSNPalleleႤꍇ */
        else{
            /* caseɂQڂSNPalleleRs[ */
            snpData1->SNPalleles[1] = snpData2->SNPalleles[0];
            snpData1->allelesNum++;
            /* controlɂQڂSNPalleleRs[ */
            snpData2->SNPalleles[1] = snpData1->SNPalleles[0];
            snpData2->allelesNum++;
            /* QSNPallelȅԓւ */
            DataReaderShiftSNPalleles(snpData2, 0, 1);
            return 0;
        }
    }
    else{
        return -1;
    }
    return 0;
}

/******************************************************************/    
/* ̓f[^̐`FbNĕ񉻗p̓̓f[^쐬 */
/******************************************************************/
long DataReaderMakeParallelData(SnpData *snpTmpData1, SnpData *snpTmpData2, long line1, long line2, SnpData **snpData1, SnpData **snpData2, char **caseData, char **controlData)
{
    int retval = 0;
    long a = 0;
    long b = 0;
    long index = 0;
    long dataCount = 0;
    long caseIndex = 1;
    long controlIndex = 1;

    a = snpTmpData1[1].dataNum;
    b = snpTmpData2[1].dataNum;

    while ( caseIndex < line1 || controlIndex < line2 ){
        /* f[^posrAӏ̈`qł邱ƂmF */
        if (snpTmpData1[caseIndex].pos == snpTmpData2[controlIndex].pos){
            /* Q̃f[^SNPalleles̏Ԃ`FbN */
            retval = DataReaderCheckSNPalleles(&snpTmpData1[caseIndex], &snpTmpData2[controlIndex]);
            if(0 == retval){
                /* DataJEg */
                dataCount++;
            }
            /* snpTmpData1(case)̎̃f[^QƂ */
            caseIndex++;
            /* snpTmpData2̎̃f[^QƂ */
            controlIndex++;
        }
        else if (snpTmpData1[caseIndex].pos < snpTmpData2[controlIndex].pos){
            /* snpData1(case)̎̃f[^QƂ */
            caseIndex++;
        }
        else if (snpTmpData1[caseIndex].pos > snpTmpData2[controlIndex].pos){
            /* snpData2(control)̎̃f[^QƂ */
            controlIndex++;
        }
    }

    /* f[^i[p\̂̃m */
    *snpData1 = (SnpData*)malloc1Dim(sizeof(SnpData), dataCount);
    *snpData2 = (SnpData*)malloc1Dim(sizeof(SnpData), dataCount);
    /* Tvf[^i[pchar^z̃m */
    *caseData = (char*)malloc1Dim(sizeof(char), dataCount * a);
    *controlData = (char*)malloc1Dim(sizeof(char), dataCount * b);

    caseIndex = 1;
    controlIndex = 1;
    while ( caseIndex < line1 || controlIndex < line2 ){
        /* f[^posrAӏ̈`qł邱ƂmF */
        if (snpTmpData1[caseIndex].pos == snpTmpData2[controlIndex].pos){
            /* Q̃f[^SNPalleles̏Ԃ`FbN */
            retval = DataReaderCheckSNPalleles(&snpTmpData1[caseIndex], &snpTmpData2[controlIndex]);
            if(0 == retval){
                /* 񉻃f[^̍쐬 */
                //(*snpData1)[index] = snpTmpData1[caseIndex];
                strcpy( (*snpData1)[index].rsNumber, snpTmpData1[caseIndex].rsNumber );
                strcpy( (*snpData1)[index].SNPalleles, snpTmpData1[caseIndex].SNPalleles );
                strcpy( (*snpData1)[index].chrom, snpTmpData1[caseIndex].chrom );
                (*snpData1)[index].pos = snpTmpData1[caseIndex].pos;
                strncpy( &(*caseData)[index * a], snpTmpData1[caseIndex].SNPdata, a );
                (*snpData1)[index].allelesNum = snpTmpData1[caseIndex].allelesNum;
                (*snpData1)[index].dataNum = snpTmpData1[caseIndex].dataNum;
                (*snpData1)[index].SNPallelesCount[0] = snpTmpData1[caseIndex].SNPallelesCount[0];
                (*snpData1)[index].SNPallelesCount[1] = snpTmpData1[caseIndex].SNPallelesCount[1];
                (*snpData1)[index].SNPallelesCount[2] = snpTmpData1[caseIndex].SNPallelesCount[2];
                (*snpData1)[index].missingDataCount = snpTmpData1[caseIndex].missingDataCount;
                //(*snpData2)[index] = snpTmpData2[controlIndex];
                strcpy( (*snpData2)[index].rsNumber, snpTmpData2[caseIndex].rsNumber );
                strcpy( (*snpData2)[index].SNPalleles, snpTmpData2[caseIndex].SNPalleles );
                strcpy( (*snpData2)[index].chrom, snpTmpData2[caseIndex].chrom );
                (*snpData2)[index].pos = snpTmpData2[caseIndex].pos;
                strncpy( &(*controlData)[index * b], snpTmpData2[caseIndex].SNPdata, b );
                (*snpData2)[index].allelesNum = snpTmpData2[caseIndex].allelesNum;
                (*snpData2)[index].dataNum = snpTmpData2[caseIndex].dataNum;
                (*snpData2)[index].SNPallelesCount[0] = snpTmpData2[caseIndex].SNPallelesCount[0];
                (*snpData2)[index].SNPallelesCount[1] = snpTmpData2[caseIndex].SNPallelesCount[1];
                (*snpData2)[index].SNPallelesCount[2] = snpTmpData2[caseIndex].SNPallelesCount[2];
                (*snpData2)[index].missingDataCount = snpTmpData2[caseIndex].missingDataCount;

                index++;
            }
            /* snpTmpData1(case)̎̃f[^QƂ */
            caseIndex++;
            /* snpTmpData2̎̃f[^QƂ */
            controlIndex++;
        }
        else if (snpTmpData1[caseIndex].pos < snpTmpData2[controlIndex].pos){
            /* snpData1(case)̎̃f[^QƂ */
            caseIndex++;
        }
        else if (snpTmpData1[caseIndex].pos > snpTmpData2[controlIndex].pos){
            /* snpData2(control)̎̃f[^QƂ */
            controlIndex++;
        }
    }
    
    return dataCount;
}


/******************************************/
/* ̓t@C̏t@Cɏo͂ */
/******************************************/
//void DataReaderOutputHeader(FILE *fp, InputData *inputData)
//{
//    fprintf(fp, "case Data    => %s\n", inputData->inputFile1);
//    fprintf(fp, "control Data => %s\n\n", inputData->inputFile2);
//    if (0 == iWay){
//        fprintf(fp, "XRAvZFPearsonScore\n");
//    }
//    else{
//        fprintf(fp, "XRAvZFFst\n");
//    }
//
//    switch(inputData->outputLevel){
//        case 0:
//            /* 茋ʃt@Cóilevel0j */
//            break;
//        case 1:
//            /* 茋ʃt@Cóilevel1j wb_[o*/
//            fprintf(fp, "\nrs# chrom pos alleles p score a1 a2 b1 b2\n");
//            break;
//        default:
//            /* 茋ʃt@Cóilevel0j */
//            break;
//    }
//}

/********************************/
/* 茋ʂt@Cɏo͂ */
/********************************/
//void DataReaderOutputAllResult(int level, FILE *fp, SnpData *snpData1, SnpData *snpData2, OutputData *outputData, InputData *inputData, long dataNum)
//{
//    long i = 0;
//
//    /* ̓t@Ct@Co */
//    DataReaderOutputHeader(fp, inputData);
//
//    for (i = 0; i < dataNum; i++){
//        DataReaderOutputResult(level, fp, &snpData1[i], &snpData2[i], &outputData[i], inputData->repeat);
//
//    }
//}

/********************************************/
/* P`q̌茋ʂt@Cɏo͂ */
/********************************************/
//void DataReaderOutputResult(int level, FILE *fp, SnpData *snpData1, SnpData *snpData2, OutputData *outputData, long repeat)
//{
//    switch(level){
//        case 0:
//            /* 茋ʃt@Cóilevel0j */
//            DataReaderOutputResultLevel0(fp, snpData1, snpData2, outputData, repeat);
//            break;
//        case 1:
//            /* 茋ʃt@Cóilevel1j */
//            DataReaderOutputResultLevel1(fp, snpData1, snpData2, outputData);
//            break;
//        default:
//            /* 茋ʃt@Cóilevel0j */
//            DataReaderOutputResultLevel0(fp, snpData1, snpData2, outputData, repeat);
//            break;
//    }
//}

/**********************************/
/* 茋ʃt@Cóilevel0j */
/**********************************/
//void DataReaderOutputResultLevel0(FILE *fp, SnpData *snpData1, SnpData *snpData2, OutputData *outputData, long repeat)
//{
//    int a1 = 0;
//    int a2 = 0;
//    int b1 = 0;
//    int b2 = 0;
//
//    /* t@Co */
//    fprintf(fp, "\n");
//    fprintf(fp, "*** SnpData Infomation ***\n");
//    fprintf(fp, "rs# => %10s : chrom => %5s : pos => %10ld : ", snpData1->rsNumber, snpData1->chrom, snpData1->pos);
//    if (2 == snpData1->allelesNum){
//        fprintf(fp, "SNPalleles => %c/%c \n", snpData1->SNPalleles[0], snpData1->SNPalleles[1]);
//        a1 = snpData1->SNPallelesCount[0];
//        a2 = snpData1->SNPallelesCount[1];
//        b1 = snpData2->SNPallelesCount[0];
//        b2 = snpData2->SNPallelesCount[1];
//    }
//    else if (3 == snpData1->allelesNum){
//        fprintf(fp, "SNPalleles => %c/%c%c \n", snpData1->SNPalleles[0], snpData1->SNPalleles[1], snpData1->SNPalleles[2]);
//        a1 = snpData1->SNPallelesCount[0];
//        a2 = snpData1->SNPallelesCount[1] + snpData1->SNPallelesCount[2];
//        b1 = snpData2->SNPallelesCount[0];
//        b2 = snpData2->SNPallelesCount[1] + snpData2->SNPallelesCount[2];
//    }
//    fprintf(fp, "  ** Observer **\n");
//    fprintf(fp, "    Table   | genotype1 | genotype2 |  sum  || NNf[^ | Tvl\n");
//    fprintf(fp, "    case    | %9d | %9d | %4d  || %10d | %12d\n", a1, a2, a1+a2, snpData1->missingDataCount, snpData1->dataNum);
//    fprintf(fp, "    control | %9d | %9d | %4d  || %10d | %12d\n", b1, b2, b1+b2, snpData2->missingDataCount, snpData2->dataNum);
//    fprintf(fp, "    sum     | %9d | %9d | %4d\n", a1+b1, a2+b2, a1+a2+b1+b2);
//    fprintf(fp, "    Sobs => %.10lf\n", outputData->Sobs);
//    fprintf(fp, "    Pr => %.10e\n", exp(outputData->Pr));
//    fprintf(fp, "  ** Permutationi_֐j **\n");
//    fprintf(fp, "    count(S>=Sobs) => %d : repeat(roop) => %ld\n", outputData->count, repeat);
//    fprintf(fp, "    count / repeat => %.10lf\n", (double)outputData->count/repeat);
//    fprintf(fp, "  ** m@ p = Hj/F **\n");
//    //fprintf(fp, "    Hj => %.10e\n", outputData->Hj);
//    //fprintf(fp, "    F  => %.10e\n", outputData->F);
//    fprintf(fp, "    p  => %.10e\n", outputData->p);
//}

/**********************************/
/* 茋ʃt@Cóilevel1j */
/**********************************/
//void DataReaderOutputResultLevel1(FILE *fp, SnpData *snpData1, SnpData *snpData2, OutputData *outputData)
//{
//    int a1 = 0;
//    int a2 = 0;
//    int b1 = 0;
//    int b2 = 0;
//
//    /* t@Co */
//    //fprintf(fp, "\nrs# chrom pos alleles p score a1 a2 b1 b2\n");
//    fprintf(fp, "%s %s %ld ", snpData1->rsNumber, snpData1->chrom, snpData1->pos);
//    if (2 == snpData1->allelesNum){
//        fprintf(fp, "%c/%c ", snpData1->SNPalleles[0], snpData1->SNPalleles[1]);
//        a1 = snpData1->SNPallelesCount[0];
//        a2 = snpData1->SNPallelesCount[1];
//        b1 = snpData2->SNPallelesCount[0];
//        b2 = snpData2->SNPallelesCount[1];
//    }
//    else if (3 == snpData1->allelesNum){
//        fprintf(fp, "%c/%c%c ", snpData1->SNPalleles[0], snpData1->SNPalleles[1], snpData1->SNPalleles[2]);
//        a1 = snpData1->SNPallelesCount[0];
//        a2 = snpData1->SNPallelesCount[1] + snpData1->SNPallelesCount[2];
//        b1 = snpData2->SNPallelesCount[0];
//        b2 = snpData2->SNPallelesCount[1] + snpData2->SNPallelesCount[2];
//    }
//    fprintf(fp, "%.10e %.10lf %d %d %d %d\n", outputData->p, outputData->Sobs, a1, a2, b1, b2);
//}

/**************************************/
/* ̓f[^̃Tv擾 */
/**************************************/
long DataReaderGetSampleNum(FILE *fp, int dataType)
{
    long retval = 0;

    switch(dataType){
        case 0:
            /* ̓f[^Hapmap */
            retval = DataReaderGetHapmapSampleNum(fp);
            break;
        case 1:
            /* ̓f[^HaplotypeData */
            retval = DataReaderGetHaplotypeSampleNum(fp);
            break;
        case 2:
            /* ̓f[^PhasingHapmap */
            retval = DataReaderGetPhasingHapmapSampleNum(fp);
            break;
        default:
            break;
    }

    return retval;
}

/*****************************************/
/* HapmapDatãTv擾 */
/*****************************************/
long DataReaderGetHapmapSampleNum(FILE *fp)
{
    int character = 0;
    long column = 1;     /* Haplotypef[^̗ */
    long dataNum = 0;    /* Tvl */

    /* Pǂݍ */
    while ( feof(fp) == 0 ){
        character = fgetc(fp);
        /* Psǂݍ񂾂lԂďI */
        if ('\n' == character){
            return dataNum * 2;
        }
        /* t@C̗JEg */
        else if (isspace(character) != 0){
            column++;
            /* 12ڈڍs̃f[^JEg */
            if (column >= HAPMAP_DATA){
                dataNum++;
            }
        }
    }

    /* HapmapData͈liPjłQ̈`qf[^Ă̂łQ{ */
    return dataNum * 2;
}

/***************************************/
/* HaplotypeDatãTv擾 */
/***************************************/
long DataReaderGetHaplotypeSampleNum(FILE *fp)
{
    int character = 0;
    long column = 1;     /* Haplotypef[^̗ */
    long dataNum = 0;    /* Tv */

    /* Pǂݍ */
    while ( feof(fp) == 0 ){
        character = fgetc(fp);
        /* Psǂݍ񂾂lԂďI */
        if ('\n' == character){
            return dataNum;
        }
        /* t@C̗JEg */
        else if (isspace(character) != 0){
            column++;
            /* 7ڈڍs̃f[^JEg */
            if (column >= HAPLOTYPE_DATA){
                dataNum++;
            }
        }
    }
    return dataNum;
}

/***************************************************/
/* phasingꂽHapmapf[^̃Tv擾 */
/***************************************************/
long DataReaderGetPhasingHapmapSampleNum(FILE *fp)
{
    int character = 0;
    long column = 1;     /* phasingꂽHapmapf[^̗ */
    long dataNum = 0;    /* Tv */

    /* Pǂݍ */
    while ( feof(fp) == 0 ){
        character = fgetc(fp);
        /* Psǂݍ񂾂lԂďI */
        if ('\n' == character){
            return dataNum;
        }
        /* t@C̗JEg */
        else if (isspace(character) != 0){
            column++;
            /* 3ڈڍs̃f[^JEg */
            if (column >= PHASE_DATA){
                dataNum++;
            }
        }
    }
    return dataNum;
}

/***********************************************/
/* HaplotypeDatas̈`qf[^zɊi[ */
/***********************************************/
int DataReaderSetHaplotypeSequence(FILE *fp, char **sequence, int index)
{
    int retval = -1;    /* t@CŌ܂ŗĂꍇ-1Ԃ */
    int character = 0;
    int column = 1;     /* Haplotypef[^̗ */
    int dataIndex = 0;

    /* \̂̏ */

    /* Pǂݍ */
    while ( feof(fp) == 0 ){
        character = fgetc(fp);
        /* Psǂݍ񂾂lێďI */
        if ('\n' == character){
            retval = 0;
            break;
        }
        /* t@C̗JEg */
        else if (isspace(character) != 0){
            column++;
        }
        /* 12ڈڍs̃f[^QƂ */
        else if (column >= HAPLOTYPE_DATA){
            /* `qf[^i[ */
            sequence[dataIndex][index] = character;
            dataIndex++;
        }
    }
    return retval;
}

/***************************/
/* eHaplotype̕pxvZ */
/***************************/
int DataReaderCalcHaplotypeFrequency(char **sequence, long dataNum, int L, double **frequency)
{
    int i = 0;
    int total = 0;
	int patern = 0;
	int flag = 0;
	int index = 0;
	int nextIndex = 0;
    int retval = -1;

    int *reference = NULL;
	int *count = NULL;

    /* m */
	reference = (int*)malloc1Dim(sizeof(int), dataNum);
    if (NULL == reference) { goto finalize; }
	count = (int*)malloc1Dim(sizeof(int), dataNum);
    if (NULL == count) { goto finalize; }

    while(total < dataNum){
        count[patern] = 0;
		flag = 0;
		nextIndex = 0;

		for(i = index; i < dataNum; i++){
            /* łɌoꂽp^[̓dJEgh~ */
			if(reference[i] == 0){
                /* Qƃp^[Ɠp^[ł΃JEg */
				if(strncmp(sequence[index], sequence[i], L)==0){
					reference[i] = 1;
					count[patern]++;
					total++;
				}
				else{
                    /* ̎Qƃp^[L */
					if(nextIndex == 0){
						nextIndex = i;
					}
				}
			}
		}
		patern++;
		index = nextIndex;
	}

    /* pxi[pm */
	*frequency = (double*)malloc1Dim(sizeof(double), patern);
    if (NULL == *frequency) { goto finalize; }
    /* pxvZ */
    for (i = 0; i < patern; i++){
        (*frequency)[i] = (double)count[i] / total;
    }
    retval = patern;

finalize:;
    /* mۂJ */
    free1Dim(reference);
    free1Dim(count);

    return retval;
}

/************************/
/* populationTypevZ */
/************************/
int DataReaderPopulationType(SnpData *snpData1, SnpData *snpData2, int *populationType)
{
    long a = 0;
    long b = 0;
    long n = 0;
    long h = 0;

    a = snpData1->dataNum;
    b = snpData2->dataNum;
    n = a+b;

    for (h = 0; h < a; h++){
        populationType[h] = 0;
    }
    for (h = a; h < n; h++){
        populationType[h] = 1;
    }

    return 0;
}

/****************************************/
/* Q̓̓f[^Di􌻕\쐬 */
/****************************************/
int DataReaderMakeTableDi(SnpData *snpData1, SnpData *snpData2, int *d, int **T)
{
    int i = 0;
    int j = 0;
    long h = 0;
    long a = 0;
    long b = 0;
    long n = 0;
    long len = 0;
    char reference = 0;

    int *data = NULL;
    int *data1 = NULL;
    int *data2 = NULL;

    a = snpData1->dataNum;
    b = snpData2->dataNum;
    n = a + b;
   
    /* datãm */
    data = (int*)malloc1Dim(sizeof(int), n);
    if (NULL == data) { goto finalize; }
    /* data1̃m */
    data1 = (int*)malloc1Dim(sizeof(int), a);
    if (NULL == data1) { goto finalize; }
    /* data2̃m */
    data2 = (int*)malloc1Dim(sizeof(int), b);
    if (NULL == data2) { goto finalize; }

    /* Qƕ */
    reference = DataReaderMaximumNuc(snpData1);

    /* genotypevZ */
    DataReaderCalcGenotype(snpData1, reference, data1);
    DataReaderCalcGenotype(snpData2, reference, data2);
    for (h = 0; h < a; h++){
        data[h] = data1[h];
    }
    for (h = 0; h < b; h++){
        data[h + a] = data2[h];
    }

    /* 􌻕\0ŏ */
    for (i = 0; i < ROW; i++){
        for (j = 0; j < COLUMN; j++){
            T[i][j] = 0;
        }
    }
    /* 􌻕\쐬 */
    for (h = 0; h < n; h++){
        T[ d[h] ][ data[h] ]++;
    }

finalize:;
    /* mۂJ */
	free1Dim(data);
    free1Dim(data1);
    free1Dim(data2);

    return 0;
}

/******************/
/* QƕԂ */
/******************/
char DataReaderMaximumNuc(SnpData *snpData)
{
    int tmp = 0;
    int max = 0;
    int maxi = 0;
    int count[5] = {0, 0, 0, 0, 0};
    char nuc[5] = {'N', 'T', 'C', 'A', 'G'};
    long h = 0;
    long maxIndex = 0;

    maxIndex = snpData->dataNum;

    for (h = 0; h < maxIndex; h++){
        tmp = 0;
        switch (snpData->SNPdata[h]){
            case 'U': tmp = 1;
                      break;
            case 'u': tmp = 1;
                      break;
            case 'T': tmp = 1;
                      break;
            case 't': tmp = 1;
                      break;
            case 'C': tmp = 2;
                      break;
            case 'c': tmp = 2;
                      break;
            case 'A': tmp = 3;
                      break;
            case 'a': tmp = 3;
                      break;
            case 'G': tmp = 4;
                      break;
            case 'g': tmp = 4;
                      break;
            default:  break;
        }
        count[tmp]++;
    }

    for (tmp = 1; tmp < 5; tmp++){
        if (max < count[tmp]){
            max = count[tmp];
            maxi = tmp;
        }
    }

    return nuc[maxi];
}

/******************/
/* genotypevZ */
/******************/
int DataReaderCalcGenotype(SnpData *snpData, char reference, int *result)
{
    long h = 0;
    long maxIndex = 0;

    maxIndex = snpData->dataNum;

    for (h = 0; h < maxIndex; h++){
        if (snpData->SNPdata[h] == reference){
            result[h] = 0;
        }
        else{
            result[h] = 1;
        }
    }

    return 0;
}

/***************************/
/* eHaplotype̕pxvZ */
/***************************/
long DataReaderHaplotypeFrequency(SnpData *snpData1, SnpData *snpData2, long jStart, long jEnd, char ***haplotype, double **freq)
{
    int retval = -1;
    long i = 0;
    long j = 0;
    long h = 0;
    long a = 0;
    long b = 0;
    long m = 0;
    long maxHaplotypeNumber = 0;
    long total = 0;
	long patern = 0;
	long index = 0;
	long nextIndex = 0;

    char **allHaplotype = NULL; /* ׂĂhaplotypef[^i[p */
    int *referenceFlag = NULL;
	int *count = NULL;
	int *tmp = NULL;

    m = jEnd - jStart;

    /* Tvl */
    a = snpData1[0].dataNum;
    b = snpData2[0].dataNum;
    maxHaplotypeNumber = a + b;

    /* allHaplotypẽm */
    allHaplotype = (char**)mallocChar2Dim(maxHaplotypeNumber, m);
    if (NULL == allHaplotype) { goto finalize; }
    /* m */
	referenceFlag = (int*)malloc1Dim(sizeof(int), maxHaplotypeNumber);
    if (NULL == referenceFlag) { goto finalize; }
	count = (int*)malloc1Dim(sizeof(int), maxHaplotypeNumber);
    if (NULL == count) { goto finalize; }
	tmp = (int*)malloc1Dim(sizeof(int), maxHaplotypeNumber);
    if (NULL == tmp) { goto finalize; }

    /* ׂĂhaplotypef[^i[ */
    for (j = jStart; j < jEnd; j++){
        for (h = 0; h < a; h++){
            allHaplotype[h][index] = snpData1[j].SNPdata[h];
        }
        for (h = 0; h < b; h++){
            allHaplotype[h + a][index] = snpData2[j].SNPdata[h];
        }
        index++;
    }

    index = 0;
    while(total < maxHaplotypeNumber){
        count[patern] = 0;
		nextIndex = 0;
        tmp[patern] = index;

		for(i = index; i < maxHaplotypeNumber; i++){
            /* łɌoꂽp^[̓dJEgh~ */
			if(referenceFlag[i] == 0){
                /* Qƃp^[Ɠp^[ł΃JEg */
				if(strncmp(allHaplotype[index], allHaplotype[i], m)==0){
					referenceFlag[i] = 1;
					count[patern]++;
					total++;
				}
				else{
                    /* ̎Qƃp^[L */
					if(nextIndex == 0){
						nextIndex = i;
					}
				}
			}
		}
		patern++;
		index = nextIndex;
	}

    /* haplotypei[pm */
    *haplotype = (char**)mallocChar2Dim(patern, m);
    if (NULL == haplotype) { goto finalize; }
    /* pxi[pm */
	*freq = (double*)malloc1Dim(sizeof(double), patern);
    if (NULL == freq) { goto finalize; }

    for (i = 0; i < patern; i++){
        /* ohaplotypep^[i[ */
        strncpy((*haplotype)[i], allHaplotype[ tmp[i] ], m);
        /* pxvZ */
        (*freq)[i] = (double)count[i] / total;
    }
    retval = patern;

finalize:;
    /* mۂJ */
    freeChar2Dim(allHaplotype, maxHaplotypeNumber);
    free1Dim(referenceFlag);
    free1Dim(count);
    free1Dim(tmp);

    return retval;
}

/*****************************/
/* SnpDataV[PXɕϊ */
/*****************************/
int DataReaderSequences(SnpData *snpData, long jStart, long jEnd, char **sequence)
{
    long j = 0;
    long h = 0;
    long m = 0;
	long index = 0;
    long dataNum = 0;

    /* Tv */
    dataNum = snpData[0].dataNum;

    /* ׂĂhaplotypef[^i[ */
    for (j = jStart; j < jEnd; j++){
        for (h = 0; h < dataNum; h++){
            sequence[h][index] = snpData[j].SNPdata[h];
        }
        index++;
    }

    return 0;
}

/**************************************/
/* DNAzf[^SnpData̔zɕϊ */
/**************************************/
int DataReaderSequenceToSnpData(char **sequences, SnpData *snpData, long dataNum, long size)
{
    /* dataNumFSNP */
    /* sizeFTvlia or bj */
    long j = 0;
    long h = 0;

    /* cƉϊ */
    for (j = 0; j < dataNum; j++){
        snpData[j].dataNum = size;
        snpData[j].pos = j;
        for (h = 0; h < size; h++){
            snpData[j].SNPdata[h] = sequences[h][j];
        }
    }

    return 0;
}
