/************************************************************************/
/************************************************************************/
#ifndef __HEADER_FILE_DATA_READER__
#define __HEADER_FILE_DATA_READER__

#include "snp_Config.h"
#include "snp_Table.h"

/* ̓f[^i[p\ */
typedef struct struct_SNPData { 
	char rsNumber[RS_NUM_LEN];      /* rs# */ 
	char SNPalleles[SNP_NUM];       /* SNPalleles */
    char chrom[CHROM_LEN];          /* chrom */
    long pos;                       /* pos */
	//char SNPdata[SNP_DATA_LEN];     /* SNPf[^i[p */
    char *SNPdata;                  /* SNPf[^i[p */
    int allelesNum;                 /* SNPalleles̃p^[ */
    int dataNum;                    /* f[^̃Tv */
    int SNPallelesCount[SNP_COUNT]; /* SNPallelesƍvf[^ */
    int missingDataCount;           /* MissingData(N)̃f[^ */
} SnpData;

/* o̓f[^i[p\ */
typedef struct struct_OutputData { 
    double Sobs;
    double Pr;
    double Hj;
    double F;
    double p;
    int count;
} OutputData;

/* vg^Cv錾 */
/* ̓t@CJ */
int InputFileOpen(FILE **fp, char *file);
/* o̓t@CJ */
int OutputFileOpen(FILE **fp, char *file);
/* t@C */
void FileClose(FILE *fp);

/* t@C̍sJEg */
long DataReaderCountFileLine(FILE *fp);
/* ̓f[^\̂Ɏ߂ */
int DataReaderSetAllData(FILE *fp, SnpData *snpData, long line, int dataType);
/* ̓f[^s\̂Ɏ߂ */
int DataReaderSetData(FILE *fp, SnpData *snpData, long line, int dataType);
/* Hapmapf[^\̂Ɏ߂ */
int DataReaderSetAllHapmapData(FILE *fp, SnpData *snpData, long line);
/* Hapmapf[^s\̂Ɏ߂ */
int DataReaderSetHapmapData(FILE *fp, SnpData *snpData, long line);
/* HaplotypeData\̂Ɏ߂ */
int DataReaderSetAllHaplotypeData(FILE *fp, SnpData *snpData, long line);
/* HaplotypeDatas\̂Ɏ߂ */
int DataReaderSetHaplotypeData(FILE *fp, SnpData *snpData, long line);
/* phasingꂽHapmapf[^\̂Ɏ߂ */
int DataReaderSetAllPhasingHapmapData(FILE *fp, SnpData *snpData, long line);
/* phasingꂽHapmapf[^s\̂Ɏ߂ */
int DataReaderSetPhasingHapmapData(FILE *fp, SnpData *snpData, long line);
/* \SnpDataɃTvf[^Rs[ */
int DataReaderDataCopyToSnpData(SnpData *snpData, char *sampleData, long dataNum, long sampleNum);
/* \SnpDataõmۂ */
int DataReaderSnpDataMemoryAllocate(SnpData *snpData, long dataNum, long sampleNum);
/* \SnpDataõJ */
int DataReaderSnpDataMemoryFree(SnpData *snpData, long dataNum);
/* haplotypeubN̈zɊi[ */
int DataReaderSetHaplotypeBlockArea(FILE *fp, long *blockArea);
/* \̃f[^t@Cɏo͂ */
//void DataReaderOutputAllData(FILE *fp, SnpData *snpData, long line);
/* \̃f[^t@Cɏo͂ */
//void DataReaderOutputData(FILE *fp, SnpData *snpData);

/* ̓f[^\̂Ɏ߂ */
//int DataReaderSetInputData(char *filename, InputData *inputData);
/* slԂ */
//int DataReaderGetValue(FILE *fp, char *key, char *value);

/* Q̓̓f[^􌻕\쐬 */
int DataReaderMakeTable(SnpData *snpData1, SnpData *snpData2, int **T);
/* QSNPallelȅԓւ */
int DataReaderShiftSNPalleles(SnpData *snpData, int allele1, int allele2);
/* Q̃f[^SNPalleles̏Ԃ`FbN */
int DataReaderCheckSNPalleles(SnpData *snpData1, SnpData *snpData2);
/* ̓f[^̐`FbNĕ񉻗p̓̓f[^쐬 */
long DataReaderMakeParallelData(SnpData *snpTmpData1, SnpData *snpTmpData2, long line1, long line2, SnpData **snpData1, SnpData **snpData2, char **caseData, char **controlData);

/* ̓t@C̏t@Cɏo͂ */
//void DataReaderOutputHeader(FILE *fp, InputData *inputData);
/* 茋ʂt@Cɏo͂ */
//void DataReaderOutputAllResult(int level, FILE *fp, SnpData *snpData1, SnpData *snpData2, OutputData *outputData, InputData *inputData, long dataNum);
/* P`q̌茋ʂt@Cɏo͂ */
//void DataReaderOutputResult(int level, FILE *fp, SnpData *snpData1, SnpData *snpData2, OutputData *outputData, long repeat);
/* 茋ʃt@Cóilevel0j */
//void DataReaderOutputResultLevel0(FILE *fp, SnpData *snpData1, SnpData *snpData2, OutputData *outputData, long repeat);
/* 茋ʃt@Cóilevel1j */
//void DataReaderOutputResultLevel1(FILE *fp, SnpData *snpData1, SnpData *snpData2, OutputData *outputData);

/* ̓f[^̃Tvl擾 */
long DataReaderGetSampleNum(FILE *fp, int dataType);
/* HapmapDatãTv擾 */
long DataReaderGetHapmapSampleNum(FILE *fp);
/* HaplotypeDatãTvl擾 */
long DataReaderGetHaplotypeSampleNum(FILE *fp);
/* phasingꂽHapmapf[^̃Tvl擾 */
long DataReaderGetPhasingHapmapSampleNum(FILE *fp);

/* HaplotypeDatas̈`qf[^zɊi[ */
int DataReaderSetHaplotypeSequence(FILE *fp, char **sequence, int index);
/* eHaplotype̕pxvZ */
int DataReaderCalcHaplotypeFrequency(char **sequence, long dataNum, int L, double **frequency);
/* SnpDataV[PXɕϊ */
int DataReaderSequences(SnpData *snpData, long start, long linkedSNPnum, char **sequence);

/* populationTypevZ */
int DataReaderPopulationType(SnpData *snpData1, SnpData *snpData2, int *populationType);
/* Q̓̓f[^Di􌻕\쐬 */
int DataReaderMakeTableDi(SnpData *snpData1, SnpData *snpData2, int *d, int **T);
/* QƕԂ */
char DataReaderMaximumNuc(SnpData *snpData);
/* genotypevZ */
int DataReaderCalcGenotype(SnpData *snpData, char reference, int *result);
/* eHaplotype̕pxvZ */
long DataReaderHaplotypeFrequency(SnpData *snpData1, SnpData *snpData2, long jStart, long jEnd, char ***haplotype, double **freq);
/* SnpDataV[PXɕϊ */
int DataReaderSequences(SnpData *snpData, long jStart, long jEnd, char **sequence);
/* DNAzf[^SnpData̔zɕϊ */
int DataReaderSequenceToSnpData(char **sequences, SnpData *snpData, long dataNum, long size);

#endif /* __HEADER_FILE_DATA_READER__ */
