/************************************************************************/
/************************************************************************/
#ifndef __HEADER_FILE_TYPEI__
#define __HEADER_FILE_TYPEI__

#include "snp_Config.h"
#include "snp_DataReader.h"
#include "snp_MemoryControl.h"
#include "snp_GetTime.h"
#include "snp_Random.h"


/* 入力データ格納用構造体 */
typedef struct struct_InputDataForTypeI {
    char inputFile1[MAX_LEN];   /* 入力ファイル名 */
    char inputFile2[MAX_LEN];   /* 入力ファイル名 */
    char outputFile1[MAX_LEN];  /* 出力ファイル名 */
    int areaFileType;           /* 領域指定ファイルのタイプ */
    char blockAreaFile[MAX_LEN];/* haplotypeブロック領域指定ファイル名 */
    int score;                  /* スコア計算方法の指定 */
    long repeat;                /* 繰り返し回数 */
    long gen;                   /* MCMC世代数 */
    int dataType;               /* 入力データフォーマットの指定 */
} InputTypeI;


/* MultiLocus検定を行う */
void MainProgramMulti(InputTypeI *inputTypeI, int nProc, int rank);
/* ハプロタイプ関連解析のType I errorの確率計算を実行する */
int TypeIExecute(double *freq, char **haplotype, long L, double Sobs, long a, long b, long dataNum, double *typeIError, long repeat, long gen);
/* MCMCを実行 */
void TypeIMarkov(int **X, double *h, long L);
/* 最初のhaplotypeが全部というセット */
int TypeIStartSet2(long sampleSize, long L, int *result);
/* 初期頻度に比例させた最初のセットを作成 */
int TypeIStartSet(long sampleSize, double *frequency, long L, int *result);
/* 初期頻度に比例した値をランダムに返す */
long TypeIDiscreteRandomValue(double *xlist, long len);
/* 確率1/2で0か1を返す */
int TypeIZeroOne();
/* ハプロタイプからXで表されている数の配列を作成 */
int TypeISampling(int *X, char **haplotype, long dataNum, long L, char **sequences);


#endif /* __HEADER_FILE_TYPEI__ */
