/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import test.FindMaximalSegment;

public class QuikRepeatFinder2 {
    static double[][] matrix = new double[][]{{1.0, -1.0, -1.0, -1.0, -1.0}, {-1.0, 1.0, -1.0, -1.0, -1.0}, {-1.0, -1.0, 1.0, -1.0, -1.0}, {-1.0, -1.0, -1.0, 1.0, -1.0}, {-1.0, -1.0, -1.0, -1.0, -1.0}};

    public static void main(String[] argv) throws FileNotFoundException, IOException {
        FileReader in0 = new FileReader(argv[0]);
        int threshold = new Integer(argv[1]);
        BufferedReader d0 = new BufferedReader(in0);
        String title = "";
        StringBuffer data = new StringBuffer();
        String option = argv[2];
        int position = 0;
        if (option.equals("tab")) {
            System.out.println("UnitSize\tStart\tEnd\tRegionSize");
        }
        try {
            while (true) {
                String str;
                if ((str = d0.readLine()) == null) {
                    throw new EOFException();
                }
                if (str.length() == 0) continue;
                if (str.charAt(0) == '>') {
                    if (title.length() > 0 && data.length() > 0) {
                        QuikRepeatFinder2.findRepeat(title, data.toString(), position, threshold, option);
                        position += data.length();
                    }
                    title = str.substring(1);
                    data = new StringBuffer();
                    continue;
                }
                data.append(str);
                if (data.length() <= 10000000) continue;
                QuikRepeatFinder2.findRepeat(title, data.toString(), position, threshold, option);
                position += data.length();
                data = new StringBuffer();
            }
        }
        catch (EOFException e) {
            QuikRepeatFinder2.findRepeat(title, data.toString(), position, threshold, option);
            d0.close();
            ((Reader)in0).close();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        d0.close();
        ((Reader)in0).close();
    }

    public static void findRepeat(String title, String data, int start, int threshold, String option) {
        int[] enumSequence = QuikRepeatFinder2.DNA2integer(data);
        int unitLen = 1;
        while (unitLen <= 100) {
            double[] score = QuikRepeatFinder2.score(matrix, enumSequence, unitLen);
            double[][] areas = FindMaximalSegment.areas(score, threshold);
            int num = areas.length;
            int j = 0;
            while (j < num) {
                if (areas[j][2] > FindMaximalSegment.threshold) {
                    if (option.equals("tab")) {
                        int areaStart = (int)(areas[j][0] + (double)start);
                        int areaEnd = (int)(areas[j][1] + (double)start);
                        System.out.println(String.valueOf(unitLen) + "\t" + areaStart + "\t" + areaEnd + "\t" + (int)(areas[j][1] - areas[j][0]));
                    } else {
                        System.out.print(">" + (int)((areas[j][0] + areas[j][1]) / 2.0 + (double)start) + "\t");
                        System.out.println(title);
                        int k = 0;
                        k = (int)areas[j][0];
                        while ((double)k < areas[j][1]) {
                            System.out.println(data.substring(k, k + unitLen));
                            k += unitLen;
                        }
                        if (k + unitLen < data.length()) {
                            System.out.println(data.substring(k, k + unitLen));
                        } else {
                            System.out.println(data.substring(k));
                        }
                    }
                    int i = (int)areas[j][0];
                    while ((double)i <= areas[j][1]) {
                        enumSequence[i] = 4;
                        ++i;
                    }
                }
                ++j;
            }
            ++unitLen;
        }
    }

    public static int[] DNA2integer(String data) {
        int len = data.length();
        int[] result = new int[len];
        int i = 0;
        while (i < len) {
            char c = data.charAt(i);
            switch (c) {
                case 'T': {
                    result[i] = 0;
                    break;
                }
                case 't': {
                    result[i] = 0;
                    break;
                }
                case 'U': {
                    result[i] = 0;
                    break;
                }
                case 'u': {
                    result[i] = 0;
                    break;
                }
                case 'C': {
                    result[i] = 1;
                    break;
                }
                case 'c': {
                    result[i] = 1;
                    break;
                }
                case 'A': {
                    result[i] = 2;
                    break;
                }
                case 'a': {
                    result[i] = 2;
                    break;
                }
                case 'G': {
                    result[i] = 3;
                    break;
                }
                case 'g': {
                    result[i] = 3;
                    break;
                }
                default: {
                    result[i] = 4;
                }
            }
            ++i;
        }
        return result;
    }

    public static double[] score(double[][] matrix, int[] data, int lag) {
        int len = data.length;
        double[] result = new double[len];
        int i = 0;
        while (i < len - lag) {
            result[i] = matrix[data[i]][data[i + lag]];
            ++i;
        }
        return result;
    }

    public static double[] score(String data, int lag) {
        int len = data.length();
        double[] result = new double[len];
        int i = 0;
        while (i < len - lag) {
            result[i] = data.charAt(i) == data.charAt(i + lag) ? 1.0 : -1.0;
            ++i;
        }
        return result;
    }
}

