/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.tag;

import java.io.*;
import java.net.*;
import java.util.*;
import paraselene.*;
import paraselene.tag.*;
import paraselene.mockup.*;

/**
 * HTMLタグの属性。
 * スレッドセーフです。
 */
public class Attribute implements Serializable {
	private static final long serialVersionUID = 2L;
	private String	name;
	private AttributeValuable	value;
	private Page	embed;

	protected Attribute() {}

	synchronized void setPage( Page p ) {
		embed = p;
		if ( value != null )	value.setPage( p );
	}
	/**
	 * 複製の作成。
	 * @return 複製。
	 */
	public Attribute getReplica() {
		return new Attribute( name, value.getValuableReplica() );
	}

	/**
	 * コンストラクタ。nは小文字に変換される。
	 * @param n 属性名。
	 * @param v 属性値。
	 */
	public Attribute( String n, String v ) {
		setName( n );
		set( v );
	}

	/**
	 * コンストラクタ。nは小文字に変換される。
	 * 値を持たない属性を作成します。
	 * @param n 属性名。
	 */
	public Attribute( String n ) {
		setName( n );
	}

	/**
	 * コンストラクタ。nは小文字に変換される。
	 * @param n 属性名。
	 * @param v 属性値。
	 */
	public Attribute( String n, Valuable v ) {
		setName( n );
		set( v );
	}

	/**
	 * 属性名の設定。nは小文字に変換される。
	 * @param n 属性名。
	 */
	protected void setName( String n ) {
		name = n.toLowerCase( Locale.ENGLISH );
	}

	/**
	 * 属性名の取得。小文字で返す。
	 * return 属性名。
	 */
	public String getName() {
		return name;
	}

	/**
	 * 属性値の設定。
	 * @param v 属性値。
	 */
	public void set( String v ) {
		value = Converter.toAttributeValuable( getName(), v, null );
		setPage( embed );
	}

	/**
	 * 属性値の設定。
	 * @param v 属性値。
	 * @param dec URIデコード文字コード。
	 */
	public void set( String v, String dec ) {
		value = Converter.toAttributeValuable( getName(), v, dec );
		setPage( embed );
	}

	/**
	 * 属性値の設定。
	 * @param v 属性値。
	 */
	public void set( Valuable v ) {
		value = Converter.toAttributeValuable( getName(), v, null );
		setPage( embed );
	}

	/**
	 * 属性値の設定。
	 * @param v 属性値。
	 * @param dec URIデコード文字コード。
	 */
	public void set( Valuable v, String dec ) {
		value = Converter.toAttributeValuable( getName(), v, dec );
		setPage( embed );
	}

	/**
	 * 属性値の取得。
	 * @return 属性値。無ければnull。
	 */
	public AttributeValuable get() {
		return value;
	}

	/**
	 * 属性値の取得。文字列で返します。
	 * @return 属性値。無ければnull。
	 */
	public String getString() {
		AttributeValuable	t = get();
		if ( t == null )	return null;
		return t.toString( HTMLPart.StringMode.ATTRIBUTE );
	}

	/**
	 * 文字列生成。
	 * @return 値を出力用に正規化したもの。
	 */
	protected String getValueString() {
		if ( value == null )	return null;
		return value.toString( HTMLPart.StringMode.ATTRIBUTE );
	}

	/**
	 * 文字列化。
	 * @param xml true:xhtmlである、false:htmlである。
	 * @return 文字列。
	 */
	public String toHtmlString( boolean xml ) {
		StringBuilder	buf = new StringBuilder( name );
		if ( getValueString() != null ) {
			buf = buf.append( "=" );
			buf = buf.append( "\"" );
			buf = buf.append( getValueString() );
			buf = buf.append( "\"" );
		}
		else if ( xml ) {
			buf = buf.append( "=" );
			buf = buf.append( "\"" );
			buf = buf.append( name );
			buf = buf.append( "\"" );
		}
		return buf.toString();
	}

	/**
	 * 文字列化。xxx=xxx形式で返します。
	 * @return 文字列。
	 */
	public String toString() {
		try {
			return toHtmlString ( false );
		}
		catch( Exception e ) {
			return e.toString();
		}
	}
}

