/*
 * Decompiled with CFR 0.152.
 */
package paraselene.css;

import java.util.ArrayList;
import java.util.HashMap;
import paraselene.HTMLPart;
import paraselene.Page;
import paraselene.Valuable;
import paraselene.css.Property;
import paraselene.css.Selector;
import paraselene.tag.AttributeValuable;

public class Style
extends HTMLPart
implements AttributeValuable {
    private static final long serialVersionUID = 2L;
    private ArrayList<Selector> selector = new ArrayList();
    private ArrayList<Property> prop = new ArrayList();
    private HashMap<String, Property> map = new HashMap();

    private Style() {
    }

    public Style(Property ... p) {
        this.setProperty(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setPage(Page p) {
        super.setPage(p);
        Style style = this;
        synchronized (style) {
            if (this.prop == null) {
                return;
            }
            int cnt = this.prop.size();
            for (int i = 0; i < cnt; ++i) {
                this.prop.get(i).setPage(p);
            }
        }
    }

    @Override
    public HTMLPart getReplica() {
        return (HTMLPart)((Object)this.getValuableReplica());
    }

    @Override
    public synchronized Valuable getValuableReplica() {
        int cnt = this.prop.size();
        Property[] p = new Property[cnt];
        for (int i = 0; i < cnt; ++i) {
            p[i] = this.prop.get(i).getReplica();
        }
        Style style = new Style(p);
        cnt = this.selector.size();
        Selector[] s = new Selector[cnt];
        for (int i = 0; i < cnt; ++i) {
            s[i] = this.selector.get(i).getReplica();
        }
        style.setSelector(s);
        return style;
    }

    public synchronized void setSelector(Selector ... s) {
        for (int i = 0; i < s.length; ++i) {
            this.selector.add(s[i]);
        }
    }

    public synchronized void setProperty(Property p) {
        this.prop.add(p);
        this.prop.remove(this.map.put(p.getName(), p));
    }

    public void setProperty(Property ... p) {
        for (int i = 0; i < p.length; ++i) {
            this.setProperty(p[i]);
        }
    }

    public synchronized void removeProperty(String name) {
        this.prop.remove(this.map.remove(name));
    }

    public synchronized Property getProperty(String name) {
        return this.map.get(name);
    }

    public synchronized Property[] getAllProperty() {
        return this.prop.toArray(new Property[0]);
    }

    @Override
    public String toString(HTMLPart.StringMode mode) {
        int i;
        int cnt;
        StringBuilder buf = new StringBuilder();
        if (mode != HTMLPart.StringMode.ATTRIBUTE) {
            cnt = this.selector.size();
            for (i = 0; i < cnt; ++i) {
                buf = buf.append(this.selector.get(i).toString());
            }
            buf = buf.append('{');
        }
        cnt = this.prop.size();
        for (i = 0; i < cnt; ++i) {
            buf = buf.append(this.prop.get(i).toString());
        }
        if (mode != HTMLPart.StringMode.ATTRIBUTE) {
            buf = buf.append('}');
        }
        return buf.toString();
    }

    @Override
    public String toString() {
        return this.toString(HTMLPart.StringMode.PLAIN);
    }
}

