/*
 * Decompiled with CFR 0.152.
 */
package paraselene.mockup;

import java.net.URI;
import java.util.ArrayList;
import paraselene.Color;
import paraselene.HTMLPart;
import paraselene.NumberValue;
import paraselene.Page;
import paraselene.Text;
import paraselene.mockup.Converter;
import paraselene.mockup.Linker;
import paraselene.mockup.Make;
import paraselene.mockup.Param;
import paraselene.mockup.PrePage;
import paraselene.mockup.Source;
import paraselene.mockup.TagException;
import paraselene.mockup.TagMap;
import paraselene.mockup.TextSource;
import paraselene.tag.Attribute;
import paraselene.tag.AttributeValuable;
import paraselene.tag.Tag;

class TagSource
extends Tag
implements Source {
    private static long seq = 0L;
    private String val_name = "tag" + Long.toString(seq);

    String getTagString() {
        return new Text(this.getFirstTag()).toString(HTMLPart.StringMode.BODY);
    }

    TagSource(String n, boolean single_f) {
        super(n, single_f);
        if (++seq < 0L) {
            seq = 0L;
        }
    }

    @Override
    public String getValName() {
        return this.val_name;
    }

    private String getAttributeSource(Attribute a) throws TagException {
        String name_str;
        Attribute name_atr;
        String name = a.getName();
        AttributeValuable text = a.get();
        String val = null;
        if (text != null) {
            val = text.toString(HTMLPart.StringMode.ATTRIBUTE);
        }
        if ("name".equals(name) && val != null) {
            val = Page.getIndexName(val);
        }
        StringBuilder buf = new StringBuilder("new Attribute(");
        buf = buf.append(Make.escape(name));
        buf = buf.append(",");
        if (Converter.isColor(name)) {
            try {
                if (text != null) {
                    val = new Color(val).toString();
                }
            }
            catch (Exception e) {
                throw new TagException("\u8272\u306e\u6307\u5b9a\u304c\u4e0d\u6b63\u3067\u3059");
            }
            buf = buf.append("new Color(");
            buf = buf.append(Make.escape(val));
            buf = buf.append("))");
            return buf.toString();
        }
        if (Converter.isNumber(name)) {
            try {
                new NumberValue(val);
            }
            catch (Exception e) {
                throw new TagException("\u5024\u306e\u6307\u5b9a\u304c\u4e0d\u6b63\u3067\u3059");
            }
            buf = buf.append("new NumberValue(");
            buf = buf.append(Make.escape(val));
            buf = buf.append("))");
            return buf.toString();
        }
        if (Converter.isStyle(name)) {
            buf = buf.append("new Style(Property.create(");
            buf = buf.append(Make.escape(val));
            buf = buf.append(",");
            buf = buf.append(Make.escape(((PrePage)this.embed).getParsingCharset()));
            buf = buf.append(")))");
            return buf.toString();
        }
        boolean uri_f = Converter.isURI(name);
        if (!uri_f && "param".equals(this.getName()) && "value".equalsIgnoreCase(name) && (name_atr = this.getAttribute("name")) != null && (name_str = name_atr.getString()) != null) {
            int cnt = Param.PARAM_URI.getDataCount();
            for (int i = 0; i < cnt; ++i) {
                String p_name = Param.PARAM_URI.getData(i);
                if (!p_name.equalsIgnoreCase(name_str)) continue;
                uri_f = true;
                break;
            }
        }
        if (uri_f) {
            try {
                URI uri = new URI(val);
                val = Linker.readme.resolvePath(uri);
            }
            catch (Exception e) {
                throw new TagException("URI[" + val + "]\u306e\u6307\u5b9a\u304c\u4e0d\u6b63\u3067\u3059");
            }
            buf = buf.append("new URIValue(");
            buf = buf.append(val);
            buf = buf.append("))");
            return buf.toString();
        }
        buf = buf.append("new Text(");
        buf = buf.append(Make.escape(val));
        buf = buf.append("))");
        return buf.toString();
    }

    private static String append(String ... s) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < s.length; ++i) {
            buf = buf.append(s[i]);
        }
        return buf.toString();
    }

    private static boolean orEquals(String s1, String ... s2) {
        for (int i = 0; i < s2.length; ++i) {
            if (!s1.equals(s2[i])) continue;
            return true;
        }
        return false;
    }

    private Attribute[] eraseAttribute(Attribute[] a) {
        ArrayList<Attribute> ret = new ArrayList<Attribute>();
        for (int i = 0; i < a.length; ++i) {
            String name = a[i].getName();
            String val = a[i].getString();
            if (val != null && "id".equals(name) && val.indexOf("paraselene$id$") >= 0) continue;
            ret.add(a[i]);
        }
        return ret.toArray(new Attribute[0]);
    }

    @Override
    public String toSource() {
        StringBuilder buf = null;
        try {
            String[] name = TagMap.getSource(this);
            buf = new StringBuilder(name[0]);
            buf = buf.append(" ");
            buf = buf.append(this.val_name);
            buf = buf.append("=");
            buf = buf.append(name[1]);
            buf = buf.append(";\n");
            Attribute[] attr = this.eraseAttribute(this.getAllAttribute());
            if (attr.length > 0) {
                buf = buf.append(this.val_name);
                buf = buf.append(".setAttribute(");
                for (int i = 0; i < attr.length; ++i) {
                    if (i > 0) {
                        buf = buf.append(",");
                    }
                    buf = buf.append(this.getAttributeSource(attr[i]));
                }
                buf = buf.append(");\n");
            }
            int cnt = this.getHTMLPartCount();
            for (int i = 0; i < cnt; ++i) {
                Source src = (Source)((Object)this.getHTMLPart(i));
                buf = buf.append(src.toSource());
                buf = buf.append(this.val_name);
                buf = buf.append(".addHTMLPart(");
                buf = buf.append(src.getValName());
                buf = buf.append(");\n");
            }
        }
        catch (TagException e) {
            System.err.println(e.getMessage());
            System.err.println(this.toString());
            System.exit(1);
        }
        return buf.toString();
    }

    @Override
    protected Text makeText(String str) {
        return new TextSource(str);
    }
}

