/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene;

import java.io.*;

/**
 * URIクエリパラメータ。xxx=yyy形式のデータ。
 */
public class QueryItem implements Serializable {
	private static final long serialVersionUID = 1L;
	private String name;
	private String value;

	private QueryItem(){}
	/**
	 * コンストラクタ。
	 * @param n パラメータ名。
	 * @param v パラメータ値。エスケープしないで下さい。
	 */
	public QueryItem( String n, String v ) {
		name = n;
		value = v;
	}

	/**
	 * コンストラクタ。パラメータ値は設定されません。
	 * @param n パラメータ名。
	 */
	public QueryItem( String n ) {
		this( n, null );
	}

	/**
	 * パラメータ名の取得。
	 * @return パラメータ名。
	 */
	public String getName() {
		return name;
	}

	/**
	 * パラメータ値の取得。
	 * @return パラメータ値。
	 */
	public String getValue() {
		return value;
	}

	/**
	 * 文字列化。
	 * @return 文字列。
	 */
	public String toString() {
		StringBuilder	buf = new StringBuilder( name );
		buf = buf.append( "=" );
		buf = buf.append( value );
		return buf.toString();
	}
}

