/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.tag;

import paraselene.*;
import java.io.*;
import java.net.*;

/**
 * Aタグ。
 */
public class Anchor extends Tag {
	private static final long serialVersionUID = 2L;

	/**
	 * コンストラクタ。
	 */
	public Anchor() {
		super( "a", false );
	}

	protected Tag newReplica() {
		return new Anchor();
	}

	private static final String ON_CLICK = "return paraselene_agency_a(this,'%s');";

	public void write( PrintWriter w, StringMode mode ) {
		Page	page = getAssignedPage();
		if ( page.isAjax() ) {
			Attribute	attr = getAttribute( "href" );
			if ( attr != null && getAttribute( "target" ) == null && getAttribute( "onclick" ) == null ) {
				URIValue	v = (URIValue)attr.get();
				if ( v != null ) {
					if ( v.isParaselenePagePath() ) {
						setAttribute( new Attribute( "onclick", String.format( ON_CLICK, page.getUniqueKey() ) ) );
					}
				}
			}
		}
		super.write( w, mode );
	}
}

