/*
 * Decompiled with CFR 0.152.
 */
package paraselene.ajax;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import paraselene.ajax.JSON;
import paraselene.ajax.Null;

class JSONData
implements Serializable {
    private static final long serialVersionUID = 2L;
    private String name = null;
    private Object value = null;
    private Object[] mval = null;

    private String escape(String str) {
        char[] ch = str.toCharArray();
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < ch.length; ++i) {
            if (ch[i] == '\"' || ch[i] == '\\') {
                buf = buf.append('\\');
            }
            buf = buf.append(ch[i]);
        }
        return buf.toString();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        if (this.name != null) {
            buf = buf.append("\"");
            buf = buf.append(this.escape(this.name));
            buf = buf.append("\":");
        }
        if (this.value != null) {
            if (this.value instanceof String) {
                buf = buf.append("\"");
                buf = buf.append(this.escape(this.value.toString()));
                buf = buf.append("\"");
            } else {
                buf = buf.append(this.value.toString());
            }
        } else if (this.mval != null) {
            buf = buf.append("[");
            for (int i = 0; i < this.mval.length; ++i) {
                if (i > 0) {
                    buf = buf.append(",");
                }
                if (this.mval[i] instanceof String) {
                    buf = buf.append("\"");
                    buf = buf.append(this.escape(this.mval[i].toString()));
                    buf = buf.append("\"");
                    continue;
                }
                buf = buf.append(this.mval[i].toString());
            }
            buf = buf.append("]");
        }
        return buf.toString();
    }

    private JSONData() {
    }

    JSONData(String n, Object val) {
        this.name = n;
        if (val == null) {
            this.value = new Null();
            return;
        }
        if (val instanceof String || val instanceof Number || val instanceof Boolean) {
            this.value = val;
            return;
        }
        Class<?> cls = val.getClass();
        if (cls.isPrimitive()) {
            this.value = val;
            return;
        }
        if (cls.isArray()) {
            cls = null;
            ArrayList<Object> val_a = new ArrayList<Object>();
            int len = Array.getLength(val);
            for (int i = 0; i < len; ++i) {
                Object sub = Array.get(val, i);
                if (sub == null) {
                    val_a.add(new Null());
                    continue;
                }
                if (sub instanceof String || sub instanceof Number || sub instanceof Boolean) {
                    val_a.add(sub);
                    continue;
                }
                if (sub instanceof Serializable) {
                    val_a.add(new JSON((Serializable)sub));
                    continue;
                }
                val_a.add(sub);
            }
            this.mval = val_a.toArray(new Object[0]);
            return;
        }
        if (val instanceof Serializable) {
            this.value = new JSON((Serializable)val);
            return;
        }
        this.value = val;
    }
}

