/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.tag.form;


import paraselene.tag.*;

/**
 * 複数行テキストボックス。
 */
public class MultiTextBox extends Control {
	private static final long serialVersionUID = 2L;
	private static final String	NAME = "textarea";

	/**
	 * コンストラクタ。
	 */
	public MultiTextBox() {
		super( NAME, false );
	}

	protected Tag newReplica() {
		return copy4Replica( new MultiTextBox() );
	}

	/**
	 * 入力不可であるか？
	 * @return true:入力不可、false:入力可能。
	 */
	public boolean isReadOnly() {
		return Control.Status.READONLY.isSet( this );
	}

	/**
	 * 入力不可設定。
	 * @param flag true:入力不可にする、false:入力可能にする。
	 */
	public void setReadOnly( boolean flag ) {
		Control.Status.READONLY.set( this, flag );
	}

}


