/*
 * Decompiled with CFR 0.152.
 */
package paraselene.supervisor;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.concurrent.locks.ReentrantLock;
import paraselene.Page;
import paraselene.supervisor.Option;
import paraselene.supervisor.PageID;

public class History
implements Serializable {
    private static final long serialVersionUID = 2L;
    private ArrayList<Page> hist = new ArrayList();
    private int histry_no;
    private ReentrantLock lock = new ReentrantLock();
    private ArrayList<Page> popup = new ArrayList();
    volatile boolean drop_f = false;
    volatile String session_id;

    boolean tryLock() {
        if (this.lock.isHeldByCurrentThread()) {
            return true;
        }
        Option.trace("call tryLock ", new Object[0]);
        boolean ret = this.lock.tryLock();
        Option.trace("tryLock %s ", new Object[]{ret});
        return ret;
    }

    void lock() {
        if (this.lock.isHeldByCurrentThread()) {
            return;
        }
        Option.trace("call lock ", new Object[0]);
        this.lock.lock();
        Option.trace("locked ", new Object[0]);
    }

    void unlock() {
        Option.trace("call unlock ", new Object[0]);
        this.lock.unlock();
        Option.trace("unlocked ", new Object[0]);
    }

    private History() {
    }

    History(int n, String s) {
        this.histry_no = n;
        this.session_id = s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addPopup(Page page) {
        if (page.getPopupType() == null) {
            return false;
        }
        ArrayList<Page> arrayList = this.popup;
        synchronized (arrayList) {
            this.removePopup(page);
            this.popup.add(page);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removePopup(Page page) {
        String key = page.getUniqueKey();
        ArrayList<Page> arrayList = this.popup;
        synchronized (arrayList) {
            int cnt = this.popup.size();
            for (int i = 0; i < cnt; ++i) {
                if (!this.popup.get(i).getUniqueKey().equals(key)) continue;
                this.popup.remove(i);
                return;
            }
        }
        Option.trace("donot remove, not found %s", key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearPopup() {
        ArrayList<Page> arrayList = this.popup;
        synchronized (arrayList) {
            this.popup.clear();
            Option.trace("popup clear", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Page page) {
        if (page == null) {
            return;
        }
        if (this.addPopup(page)) {
            return;
        }
        ArrayList<Page> arrayList = this.hist;
        synchronized (arrayList) {
            int cnt = this.getHistoryCount();
            Page old = null;
            if (cnt > 0) {
                old = this.getPage();
            }
            if (page.isHistoryClear()) {
                for (int i = 0; i < cnt; ++i) {
                    Page h = this.hist.get(i);
                    if (!page.equals(h)) continue;
                    for (int j = cnt - 1; j >= i; --j) {
                        this.hist.remove(j).setHistoryKey(0);
                    }
                    break;
                }
            }
            if (page.isAllowHistoryAdd()) {
                this.hist.add(page);
                page.setHistoryKey(this.histry_no);
            }
            if ((cnt = this.getHistoryCount()) == 0 || old != this.getPage()) {
                this.clearPopup();
            }
        }
    }

    public int getHistoryCount() {
        return this.hist.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page getPage(PageID id) {
        if (id == null) {
            return null;
        }
        ArrayList<Page> arrayList = this.hist;
        synchronized (arrayList) {
            int cnt = this.getHistoryCount();
            for (int i = 0; i < cnt; ++i) {
                Page h = this.hist.get(i);
                if (!h.equals(id)) continue;
                return h;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page[] getBrowsingPage() {
        ArrayList<Page> list = new ArrayList<Page>();
        this.lock();
        ArrayList<Page> arrayList = this.popup;
        synchronized (arrayList) {
            int cnt = this.popup.size();
            for (int i = 0; i < cnt; ++i) {
                list.add(this.popup.get(i));
            }
        }
        list.add(this.getPage());
        return list.toArray(new Page[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page getBrowsingPage(String uni) {
        int i;
        int cnt;
        Page page = null;
        ArrayList<Page> arrayList = this.popup;
        synchronized (arrayList) {
            cnt = this.popup.size();
            for (i = 0; i < cnt; ++i) {
                page = this.popup.get(i);
                if (!page.getUniqueKey().equals(uni)) continue;
                return page;
            }
        }
        arrayList = this.hist;
        synchronized (arrayList) {
            cnt = this.getHistoryCount();
            for (i = 0; i < cnt; ++i) {
                page = this.hist.get(i);
                if (!page.getUniqueKey().equals(uni)) continue;
                return page;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePage(int last_no) {
        if (last_no < 0) {
            return;
        }
        if (last_no == 0) {
            this.clearPopup();
        }
        ArrayList<Page> arrayList = this.hist;
        synchronized (arrayList) {
            int cnt = this.getHistoryCount();
            for (int i = cnt - 1; i >= 0; --i) {
                if (last_no == 0) {
                    this.hist.remove(i).setHistoryKey(0);
                    return;
                }
                --last_no;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePage(PageID page_id) {
        ArrayList<Page> arrayList = this.hist;
        synchronized (arrayList) {
            int cnt = this.getHistoryCount();
            for (int i = cnt - 1; i >= 0; --i) {
                Page page = this.hist.get(i);
                if (page.getID() != page_id) continue;
                this.hist.remove(i).setHistoryKey(0);
                if (i != cnt - 1) continue;
                this.clearPopup();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePage() {
        this.clearPopup();
        ArrayList<Page> arrayList = this.hist;
        synchronized (arrayList) {
            int cnt = this.getHistoryCount();
            for (int i = 0; i < cnt; ++i) {
                this.hist.get(i).setHistoryKey(0);
            }
            this.hist.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Page getPage(int last_no) {
        if (last_no < 0) {
            return null;
        }
        ArrayList<Page> arrayList = this.hist;
        synchronized (arrayList) {
            int cnt = this.getHistoryCount();
            for (int i = cnt - 1; i >= 0; --i) {
                if (last_no == 0) {
                    return this.hist.get(i);
                }
                --last_no;
            }
        }
        return null;
    }

    public Page getPage() {
        return this.getPage(0);
    }
}

