/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.ajax.data;

import paraselene.*;
import paraselene.tag.*;
import paraselene.css.*;
import paraselene.supervisor.*;
import java.io.*;


public class Open extends TagData {
	private static final long serialVersionUID = 2L;

	public String	page_id = null;
	public int		base_z = 1;
	public String	bg;
	public String	bg2;
	public String	border;
	public String	title = "　";
	public boolean	modal = false;
	public boolean	active = false;

	private Open(){
		super();
	}

	private String toBg( CSSValuable[] v ) {
		if ( v == null )	return "";
		StringBuilder	buf = new StringBuilder();
		for ( int i = 0; i < v.length; i++ ) {
			buf = buf.append( v[i].toString( HTMLPart.StringMode.CSS ) );
			buf = buf.append( " " );
		}
		return buf.toString();
	}

	private Color getColor( CSSValuable[] v ) {
		if ( v != null ) {
			for ( int i = 0; i < v.length; i++ ) {
				if ( v[i] instanceof Color )	return (Color)v[i];
			}
		}
		return new Color( WebColor.WHITESMOKE );
	}

	private CSSValuable[] shift( Color org, int v ) {
		YUV	yuv = org.getYUV();
		if ( yuv.y < 128 )	yuv.y += v;
		else	yuv.y -= v;
		return new CSSValuable[] { new Color( yuv ) };
	}

	public Open( Page page, boolean act_f ) {
		super( page.getFirstTagByType( "body" ), !act_f );
		page_id = page.getUniqueKey();
		base_z = page.getZindex();
		CSSValuable[]	st = page.getPopupBackGround();
		Color	c = getColor( st );
		bg = toBg( st );
		bg2 = toBg( shift( c, 48 ) );
		border = toBg( shift( c, 24 ) );
		Tag	title_tag = page.getFirstTagByType( "title" );
		if ( title_tag != null )	title = title_tag.getValueString();
		if ( title == null )	title = "　";
		modal = page.getPopupType() == Popup.Type.MODAL;
		active = act_f;
	}
}

