/*
 * Paraselene
 * Copyright (c) 2009, 2010  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.tag;

import paraselene.*;
import paraselene.ui.*;
import paraselene.tag.form.*;
import paraselene.supervisor.*;
import java.io.*;
import java.net.*;
import java.util.*;

/**
 * Aタグ。
 */
public class Anchor extends Tag implements PageHooker, Clickable {
	private static final long serialVersionUID = 2L;
	private static final String	ANCHOR_ID = "paraselene$anchor$id";

	/**
	 * コンストラクタ。
	 */
	public Anchor() {
		super( "a", false );
	}

	protected Tag newReplica() {
		Anchor	a = new Anchor();
		a.setUserData( getUserData() );
		return a;
	}

	public Forward beforeInput( Page page, RequestParameter req, Forward fw ) throws Exception {
		return fw;
	}

	public void afterOutput( Page from, Page to, RequestParameter req ) throws Exception {
		String	id = makeID();
		StringBuilder	buf = new StringBuilder( "function(ev){" );
		buf = buf.append( "if(!paraselene_agency_a(paraselene_get_id('" );
		buf = buf.append( id );
		buf = buf.append( "'),'" );
		buf = buf.append( getAssignedPage().getUniqueKey() );
		buf = buf.append( "'))paraselene_kill_event(ev);}" );
		setAnonymousEventHandler( "click", buf.toString() );

		Attribute	href = getAttribute( "href" );
		if ( href == null )	return;
		if ( req.getSupervisor().isMyHostURI( href.getString() ) ) {
			URIValue	uv = (URIValue)href.get();
			QueryItem[]	item = uv.getQuery();
			ArrayList<QueryItem>	list = new ArrayList<QueryItem>();
			for ( int i = 0; i < item.length; i++ ) {
				if ( Form.PAGE_UKEY.equals( item[i].getName() ) )	return;
				list.add( item[i] );
			}
			list.add( new QueryItem( Form.PAGE_UKEY, getAssignedPage().getUniqueKey() ) );
			list.add( new QueryItem( ANCHOR_ID, id ) );
			uv.setQuery( list.toArray( new QueryItem[0] ) );
		}
	}

	private boolean	pushed = false;
	private Object	obj = null;

	public boolean isClicked() {
		return pushed;
	}

	public void setClicked( boolean flag ) {
		pushed = flag;
	}

	public Object getUserData() {
		return obj;
	}

	public void setUserData( Object user_date ) {
		obj = user_date;
	}

	public boolean isClicked( RequestParameter req ) {
		RequestItem	item = req.getItem( ANCHOR_ID );
		if ( item == null )	return false;
		return makeID().equals( item.getValue() );
	}
}

