/*
 * Paraselene
 * Copyright (c) 2009, 2010  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.tag.form;

import paraselene.tag.*;

/**
 * リストの選択項目。OPTIONタグ。
 */
public class SelectItem extends Control {
	private static final long serialVersionUID = 1L;
	private static final String NAME = "option";
	Select	list = null;

	/**
	 * コンストラクタ。
	 */
	public SelectItem() {
		super( NAME, false );
	}

	/**
	 * コンストラクタ。
	 * @param str 見出し文字列。
	 * @param value 設定値(value値)。
	 */
	public SelectItem( String str, String value ) {
		this();
		super.setValueString( str );
		setValueString( value );
	}

	protected Tag newReplica() {
		return copy4Replica( new SelectItem() );
	}

	/**
	 * 選択状態の取得。
	 * @return true:選択されている、false:選択されていない。
	 */
	public boolean isSelected() {
		return Control.Status.SELECTED.isSet( this );
	}

	/**
	 * 選択状態の設定。
	 */
	public void setSelected( boolean flag ) {
		boolean	once = true;
		if ( list != null ) {
			once = !list.isMultiple();
		}
		if ( flag && once ) {
			SelectItem[]	item = list.getItemArray();
			for ( int i = 0; i < item.length; i++ ) {
				if ( item[i] == this )	continue;
				item[i].setSelected( false );
			}
		}
		Control.Status.SELECTED.set( this, flag );
	}

	/**
	 * 値の設定。タグ内部ではなく、value属性値に設定します。
	 * @param v 設定値。
	 */
	public void setValueString( String v ) {
		setValueAttribute( v );
	}

	/**
	 * 値の取得。タグ内部ではなく、value属性値から取得します。
	 * @return 文字列。
	 */
	public String getValueString() {
		return getValueAttribute();
	}
}



