/*
 * Paraselene
 * Copyright (c) 2009, 2010  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.ui;

import paraselene.supervisor.*;

/**
 * クリック可能なタグである事を示します。
 */
public interface Clickable {
	/**
	 * 押下されたか？
	 * @return true:押下された、false:押下されていない。
	 */
	boolean isClicked();

	/**
	 * 押下状態の設定。
	 * @param flag true:押下された、false:押下されていない。
	 */
	void setClicked( boolean flag );

	/**
	 * ユーザーデータ取得。
	 * @return 紐づけたデータ。
	 */
	Object getUserData();

	/**
	 * ユーザーデータ設定。
	 * @param user_date 紐づけるデータ。
	 */
	void setUserData( Object user_date );

	/**
	 * クリック判定。フレームワークが判定に使用します。
	 * @param req リクエスト内容。
	 * @return true:押下された、false:押下されていない。
	 */
	boolean isClicked( RequestParameter req );
}

