/*
 * Paraselene
 * Copyright (c) 2009, 2010  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.ui;

import paraselene.*;
import paraselene.supervisor.*;

/**
 * これを実装したタグは、ページ本体処理から独立して、
 * タグ側でユーザーアクセスを処理できます。
 */
public interface PageHooker {
	/**
	 * Page#input の前に呼ばれます。
	 * @param page 続いて input がコールされるページ。
	 * @param req リクエスト内容。
	 * @param fw デフォルト遷移先。
	 * @exception Exception 処理の継続が不可能(ブラウザには500を返す)。
	 */
	Forward beforeInput( Page page, RequestParameter req, Forward fw ) throws Exception;

	/**
	 * Page#output の後に呼ばれます。
	 * @param from 遷移元ページ。初めて表示されている場合nullです。
	 * @param to output がコールされたページ。
	 * @param req リクエスト内容。
	 * @exception Exception 処理の継続が不可能(ブラウザには500を返す)。
	 */
	void afterOutput( Page from, Page to, RequestParameter req ) throws Exception;

}

