/*
 * Decompiled with CFR 0.152.
 */
package paraselene.tag.attr;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Locale;
import paraselene.Text;
import paraselene.supervisor.PageID;
import paraselene.supervisor.Supervisor;
import paraselene.tag.attr.Attribute;

public class URIAttribute
extends Attribute {
    private static final long serialVersionUID = 1L;
    private static final String DOWNLOAD_DIR = "rabbit/";
    private static String[] uri_name = new String[]{"href", "codebase", "src", "cite", "action", "profile", "background", "code", "data"};
    private static HashMap<String, String> uri_map = new HashMap();
    private String out_enc;

    public static boolean isURI(String n) {
        return uri_map.get(n.toLowerCase(Locale.ENGLISH)) != null;
    }

    private URIAttribute() {
    }

    @Override
    public Attribute getReplica() {
        try {
            return new URIAttribute(this.getName(), this.getURI(), this.out_enc, this.out_enc);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public URIAttribute(String n, URI u, String dec, String enc) throws UnsupportedEncodingException {
        this.setName(n);
        this.setEncode(enc);
        this.set(u, dec);
    }

    public static String encode(String uri, String enc) throws UnsupportedEncodingException {
        if (enc == null) {
            return uri;
        }
        String[] frag = uri.split("#");
        if (frag.length == 0) {
            return uri;
        }
        String[] query = frag[0].split("\\?");
        if (query.length == 0) {
            return uri;
        }
        String[] test = query[0].split(":");
        String scheme = null;
        String main_path = test[test.length - 1];
        if (test.length > 1) {
            if (test.length == 2) {
                StringBuffer sc = new StringBuffer(test[0]);
                if (main_path.indexOf("//") == 0) {
                    main_path = main_path.substring(2);
                    sc = sc.append("://");
                } else {
                    sc = sc.append(":");
                }
                scheme = sc.toString();
            } else {
                StringBuilder sc = new StringBuilder();
                for (int i = 0; i < test.length - 1; ++i) {
                    sc = sc.append(test[i]);
                    sc = sc.append(":");
                }
                scheme = sc.toString();
            }
        } else {
            int len = query[0].length();
            if (len > 0 && query[0].charAt(len - 1) == ':') {
                scheme = query[0];
                main_path = "";
            }
        }
        StringBuffer buf = new StringBuffer(" ");
        buf = buf.append(main_path);
        buf = buf.append(" ");
        String[] path = buf.toString().split("/");
        buf = new StringBuffer(URLEncoder.encode(path[0], enc));
        for (int i = 1; i < path.length; ++i) {
            buf = buf.append("/");
            buf = buf.append(URLEncoder.encode(path[i], enc));
        }
        String tmp = buf.toString();
        buf = new StringBuffer(tmp.substring(1, tmp.length() - 1));
        if (query.length > 1) {
            buf = buf.append("?");
            String[] param = query[1].split("&");
            for (int i = 0; i < param.length; ++i) {
                if (i > 0) {
                    buf = buf.append("&");
                }
                String[] data = param[i].split("=");
                buf = buf.append(URLEncoder.encode(data[0], enc));
                buf = buf.append("=");
                if (data.length <= 1) continue;
                buf = buf.append(URLEncoder.encode(data[1], enc));
            }
        }
        if (frag.length > 1) {
            buf = buf.append("#");
            buf = buf.append(URLEncoder.encode(frag[1], enc));
        }
        if (scheme != null) {
            StringBuffer full = new StringBuffer(scheme);
            buf = full.append(buf);
        }
        return buf.toString();
    }

    public URIAttribute(String n, String u, String enc) throws UnsupportedEncodingException, URISyntaxException {
        this(n, u != null ? new URI(URIAttribute.encode(u, enc)) : null, enc, enc);
    }

    public void set(URI u, String dec) throws UnsupportedEncodingException {
        if (u == null) {
            super.set((Text)null);
        } else {
            this.set(URLDecoder.decode(u.toString(), dec));
        }
    }

    public URI getURI() {
        if (super.get() == null) {
            return null;
        }
        try {
            return new URI(URIAttribute.encode(super.getValueString(), this.out_enc));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public String[] getQuery() {
        URI uri = this.getURI();
        String q = uri.getQuery();
        if (q == null) {
            return new String[0];
        }
        return q.split("&");
    }

    public void setQuery(String[] query) {
        this.set(URIAttribute.setQuery(this.getURI(), query));
    }

    public static String pageToURI(PageID pid, String fragment, String ... query) {
        StringBuffer buf = new StringBuffer(Supervisor.LINK_DEF[0]);
        buf = buf.append(pid.getID());
        if (fragment != null) {
            buf = buf.append("#");
            buf = buf.append(fragment);
        }
        try {
            return URIAttribute.setQuery(new URI(buf.toString()), query);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String pageToDownloadURI(PageID pid, String filename, String ... query) {
        StringBuffer buf = new StringBuffer(DOWNLOAD_DIR);
        buf = buf.append(URIAttribute.pageToURI(pid, null, new String[0]));
        buf = buf.append("/");
        buf = buf.append(filename);
        try {
            return URIAttribute.setQuery(new URI(buf.toString()), query);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String makeAbsolutePath(Scheme prt, int port, String path) {
        StringBuffer buf = new StringBuffer(prt.str);
        if (port == prt.port) {
            port = 0;
        }
        buf = buf.append(port);
        if (path == null) {
            path = "/";
        }
        if (path.charAt(0) != '/') {
            buf = buf.append("/");
        }
        buf = buf.append(path);
        return buf.toString();
    }

    private static String setQuery(URI uri, String[] query) {
        int port;
        if (query == null) {
            query = new String[]{};
        }
        StringBuffer buf = new StringBuffer();
        String tmp = uri.getScheme();
        if (tmp != null) {
            buf = buf.append(tmp);
            buf = buf.append("://");
        }
        if ((tmp = uri.getUserInfo()) != null) {
            buf = buf.append(tmp);
            buf = buf.append("@");
        }
        if ((tmp = uri.getHost()) != null) {
            buf = buf.append(tmp);
        }
        if ((port = uri.getPort()) != -1) {
            buf = buf.append(":");
            buf = buf.append(port);
        }
        buf = buf.append(uri.getPath());
        for (int i = 0; i < query.length; ++i) {
            buf = i == 0 ? buf.append("?") : buf.append("&");
            buf = buf.append(query[i]);
        }
        tmp = uri.getFragment();
        if (tmp != null) {
            buf = buf.append("#");
            buf = buf.append(tmp);
        }
        return buf.toString();
    }

    public void setEncode(String enc) throws UnsupportedEncodingException {
        URLEncoder.encode("\u30c6\u30b9\u30c8", enc);
        this.out_enc = enc;
    }

    @Override
    protected String getValueString() {
        try {
            return Supervisor.makeWithSessionURI(super.getValueString(), this.out_enc);
        }
        catch (Exception e) {
            return null;
        }
        catch (NoClassDefFoundError nc) {
            try {
                return URIAttribute.encode(super.getValueString(), this.out_enc);
            }
            catch (Exception e2) {
                return null;
            }
        }
    }

    static {
        for (int i = 0; i < uri_name.length; ++i) {
            uri_map.put(uri_name[i], uri_name[i]);
        }
    }

    public static enum Scheme {
        HTTP(Supervisor.LINK_DEF[1], "http", 80),
        HTTPS(Supervisor.LINK_DEF[2], "https", 443);

        private static final long serialVersionUID = 1L;
        String str;
        String prot;
        int port;

        private Scheme(String s, String p, int pt) {
            this.str = s;
            this.prot = p;
            this.port = pt;
        }

        private boolean equalsString(String o) {
            return this.prot.equals(o);
        }

        public static Scheme getScheme(URI uri) {
            Scheme[] s = Scheme.values();
            String p = uri.getScheme();
            for (int i = 0; i < s.length; ++i) {
                if (!s[i].equalsString(p)) continue;
                return s[i];
            }
            return null;
        }
    }
}

