/*
 * Decompiled with CFR 0.152.
 */
package paraselene.tag.form;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import paraselene.tag.Tag;
import paraselene.tag.attr.Attribute;
import paraselene.tag.form.ControlException;

public abstract class Control
extends Tag {
    private String title;
    private Object obj = null;

    public void setTitle(String t) {
        this.title = t;
    }

    public String getTitle() {
        return this.title;
    }

    public void setUserData(Object user_date) {
        this.obj = user_date;
    }

    public Object getUserData() {
        return this.obj;
    }

    public Control(String s, boolean f) {
        super(s, f);
    }

    public boolean isDisabled() {
        return Status.DISABLED.isSet(this);
    }

    public void setDisabled(boolean flag) {
        Status.DISABLED.set(this, flag);
    }

    public static void trim(Control ... cont) {
        for (int i = 0; i < cont.length; ++i) {
            if (cont[i].isEmptyValue()) continue;
            cont[i].setValueString(cont[i].getValueString().trim());
        }
    }

    public static void checkPattern(String mes, CharGroup cg, Control ... cont) throws ControlException {
        Control.checkPattern(mes, cg, null, null, cont);
    }

    public static void checkPattern(String mes, CharGroup cg, char[] include, char[] exclude, Control ... cont) throws ControlException {
        ArrayList<Control> list = new ArrayList<Control>();
        for (int i = 0; i < cont.length; ++i) {
            Matcher m;
            int j;
            char[] ch;
            if (cont[i].isEmptyValue()) continue;
            String str = cont[i].getValueString();
            if (include != null) {
                StringBuffer buf = new StringBuffer();
                ch = str.toCharArray();
                for (int k = 0; k < ch.length; ++k) {
                    boolean flag = true;
                    for (j = 0; j < include.length; ++j) {
                        if (ch[k] != include[j]) continue;
                        flag = false;
                        break;
                    }
                    if (!flag) continue;
                    buf = buf.append(ch[k]);
                }
                str = buf.toString();
            }
            if ((m = cg.pattern.matcher(str)).matches()) {
                list.add(cont[i]);
                continue;
            }
            if (exclude == null) continue;
            ch = str.toCharArray();
            boolean flag = true;
            for (int k = 0; k < ch.length; ++k) {
                for (j = 0; j < exclude.length; ++j) {
                    if (ch[k] != exclude[j]) continue;
                    flag = false;
                    break;
                }
                if (!flag) break;
            }
            if (flag) continue;
            list.add(cont[i]);
        }
        if (list.size() > 0) {
            throw new ControlException(mes, list.toArray(new Control[0]));
        }
    }

    public static void checkNull(String mes, Control ... cont) throws ControlException {
        ArrayList<Control> list = new ArrayList<Control>();
        for (int i = 0; i < cont.length; ++i) {
            if (!cont[i].isEmptyValue()) continue;
            list.add(cont[i]);
        }
        if (list.size() > 0) {
            throw new ControlException(mes, list.toArray(new Control[0]));
        }
    }

    public static Date toDate(String mes, Control year, Control month, Control day) throws ControlException {
        int y = 0;
        int m = 0;
        int d = 0;
        try {
            y = Integer.parseInt(year.getValueString());
        }
        catch (Exception e) {
            throw new ControlException(mes, year);
        }
        try {
            m = Integer.parseInt(month.getValueString()) - 1;
        }
        catch (Exception e) {
            throw new ControlException(mes, month);
        }
        try {
            d = Integer.parseInt(day.getValueString());
        }
        catch (Exception e) {
            throw new ControlException(mes, day);
        }
        GregorianCalendar c = new GregorianCalendar(y, m, d);
        int cy = c.get(1);
        int cm = c.get(2);
        int cd = c.get(5);
        if (y != cy) {
            throw new ControlException(mes, year);
        }
        if (m != cm) {
            throw new ControlException(mes, month);
        }
        if (d != cd) {
            throw new ControlException(mes, day);
        }
        return new Date(c.getTime().getTime());
    }

    public Date toDate(String mes, SimpleDateFormat format) throws ControlException {
        String val = this.getValueString();
        if (val == null) {
            return null;
        }
        try {
            return new Date(format.parse(val).getTime());
        }
        catch (ParseException e) {
            throw new ControlException(mes, this);
        }
    }

    public BigInteger toInteger(String mes, int radix, BigInteger min, BigInteger max) throws ControlException {
        String src = this.getValueString();
        if (src == null) {
            return null;
        }
        src = src.trim();
        BigInteger ret = null;
        try {
            ret = new BigInteger(src, radix);
        }
        catch (Exception e) {
            throw new ControlException(mes, this);
        }
        if (min != null && ret.compareTo(min) == -1) {
            throw new ControlException(mes, this);
        }
        if (max != null && ret.compareTo(max) == 1) {
            throw new ControlException(mes, this);
        }
        return ret;
    }

    public BigInteger toInteger(String mes, BigInteger min, BigInteger max) throws ControlException {
        return this.toInteger(mes, 10, min, max);
    }

    public BigDecimal toDecimal(String mes, int place, BigDecimal min, BigDecimal max) throws ControlException {
        String src = this.getValueString();
        if (src == null) {
            return null;
        }
        src = src.trim();
        BigDecimal ret = null;
        try {
            ret = new BigDecimal(src);
        }
        catch (Exception e) {
            throw new ControlException(mes, this);
        }
        String[] div = src.split("\\.");
        if (div.length > 1 && div[1].length() > place) {
            throw new ControlException(mes, this);
        }
        if (min != null && ret.compareTo(min) == -1) {
            throw new ControlException(mes, this);
        }
        if (max != null && ret.compareTo(max) == 1) {
            throw new ControlException(mes, this);
        }
        return ret;
    }

    public void checkLength(String mes, int min_len, int max_len) throws ControlException {
        this.checkMaxLength(mes, max_len);
        this.checkMinLength(mes, min_len);
    }

    public void checkMaxLength(String mes, int max_len) throws ControlException {
        String str = this.getValueString();
        if (str == null) {
            str = "";
        }
        if (str.length() > max_len) {
            throw new ControlException(mes, this);
        }
    }

    public void checkMinLength(String mes, int min_len) throws ControlException {
        String str = this.getValueString();
        if (str == null) {
            str = "";
        }
        if (str.length() < min_len) {
            throw new ControlException(mes, this);
        }
    }

    public static enum CharGroup {
        NUMBER("\\p{Digit}"),
        ALPHA("\\p{Alpha}"),
        ALNUM("\\p{Alnum}"),
        ASCII("\\p{ASCII}");

        private static final long serialVersionUID = 1L;
        Pattern pattern;

        private CharGroup(String s) {
            this.pattern = Pattern.compile(".*[^" + s + "]+.*");
        }
    }

    static enum Status {
        SELECTED("selected"),
        DISABLED("disabled"),
        READONLY("readonly"),
        CHECKED("checked");

        private static final long serialVersionUID = 1L;
        private String str;
        private Attribute attr;

        private Status(String s) {
            this.str = s;
            this.attr = new Attribute(s);
        }

        boolean isSet(Tag t) {
            return t.getAttribute(this.str) != null;
        }

        void set(Tag t, boolean flag) {
            try {
                if (flag) {
                    t.setAttribute(this.attr);
                } else {
                    t.removeAttribute(this.str);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

