/*
 * Decompiled with CFR 0.152.
 */
package paraselene.tag.form;

import java.io.PrintWriter;
import paraselene.HTMLPart;
import paraselene.tag.Tag;
import paraselene.tag.attr.Attribute;
import paraselene.tag.form.ControlException;
import paraselene.tag.form.Input;

public class SingleTextBox
extends Input {
    private static final long serialVersionUID = 1L;
    private boolean password_f = false;
    private boolean hidden_f = false;

    public SingleTextBox(boolean pw_f) {
        super(pw_f ? Input.Type.PASSWORD : Input.Type.TEXT);
        this.password_f = pw_f;
    }

    public boolean isPassword() {
        return this.password_f;
    }

    @Override
    protected Tag newReplica() {
        return new SingleTextBox(this.password_f);
    }

    @Override
    protected String getFirstTag() {
        if (!this.hidden_f) {
            return super.getFirstTag();
        }
        boolean xml = false;
        if (this.embed != null) {
            xml = this.embed.isXML();
        }
        StringBuffer buf = new StringBuffer("<");
        buf = buf.append(this.getName());
        for (String k : this.attr.keySet()) {
            if ("value".equals(k)) continue;
            buf = buf.append(" ");
            buf = buf.append(((Attribute)this.attr.get(k)).toHtmlString(xml));
        }
        if (xml && this.isSimpleTag()) {
            buf = buf.append(" /");
        }
        buf = buf.append(">");
        return buf.toString();
    }

    @Override
    public void write(PrintWriter w, HTMLPart.StringMode mode) {
        if (this.password_f) {
            this.hidden_f = true;
        }
        super.write(w, mode);
        this.hidden_f = false;
    }

    @Override
    public HTMLPart getReplica() {
        SingleTextBox stb = (SingleTextBox)super.getReplica();
        stb.password_f = this.password_f;
        return stb;
    }

    public void checkMaxLength(String mes) throws ControlException {
        Attribute attr = this.getAttribute("maxlength");
        this.checkMaxLength(mes, Integer.parseInt(attr.getString()));
    }

    public void trim() {
        SingleTextBox.trim(this);
    }
}

