/*
 * Decompiled with CFR 0.152.
 */
package paraselene.tag.table;

import java.util.ArrayList;
import paraselene.HTMLPart;
import paraselene.tag.Tag;
import paraselene.tag.table.Line;

public class Table
extends Tag {
    private static final long serialVersionUID = 1L;
    static final String TR = "tr";

    public Table() {
        this("table");
    }

    Table(String s) {
        super(s, false);
    }

    @Override
    protected Tag newReplica() {
        return new Table();
    }

    public Line[] getLineArray() {
        Tag[] tag = this.getTagArray();
        ArrayList<Line> line = new ArrayList<Line>();
        for (int i = 0; i < tag.length; ++i) {
            if (!(tag[i] instanceof Line)) continue;
            line.add((Line)tag[i]);
        }
        return line.toArray(new Line[0]);
    }

    public void addLine(Line line) {
        this.addHTMLPart((HTMLPart)line);
    }

    public void addLine(int idx, Line line) {
        Line[] l = this.getLineArray();
        if (l.length <= idx) {
            this.addHTMLPart((HTMLPart)line);
            return;
        }
        this.addHTMLPart(this.indexOf(l[idx]), (HTMLPart)line);
    }

    public int indexOfLine(Line line) {
        Line[] l = this.getLineArray();
        for (int i = 0; i < l.length; ++i) {
            if (l[i] != line) continue;
            return i;
        }
        return -1;
    }

    public void removeLine(int idx) {
        Line[] l = this.getLineArray();
        if (l.length <= idx) {
            return;
        }
        this.removeHTMLPart(l[idx]);
    }

    public void removeLine(Line line) {
        this.removeHTMLPart(line);
    }

    public void removeLine(int start, int end) {
        Line[] l = this.getLineArray();
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = l.length - 1;
        }
        for (int i = start; i <= end; ++i) {
            this.removeHTMLPart(l[i]);
        }
    }

    public Line getLineReplica(int idx) {
        Line[] l = this.getLineArray();
        if (l.length == 0) {
            return null;
        }
        if (idx < 0 || idx >= l.length) {
            return null;
        }
        return (Line)l[idx].getReplica();
    }

    public int getLineCount() {
        Line[] l = this.getLineArray();
        return l.length;
    }
}

