/*
 * Decompiled with CFR 0.152.
 */
package paraselene.ajax;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import paraselene.ajax.AjaxHolder;
import paraselene.ajax.AjaxInformation;
import paraselene.ajax.AjaxMonitor;
import paraselene.ajax.JSON;
import paraselene.supervisor.RequestParameter;
import paraselene.supervisor.SandBox;

public class Ajax
implements Serializable,
HttpSessionBindingListener {
    private static final long serialVersionUID = 1L;
    private static final String KEY = "paraselene$ajax";
    private static HashMap<String, HashMap<String, LinkedList<AjaxHolder>>> map = new HashMap();
    private static AjaxMonitor monitor = new AjaxMonitor(map);
    private static HashMap<String, Object> comet_wait = new HashMap();
    public Serializable[] data;
    public static final String COMET = "paraselene_comet";

    public static void entryComet(String key) {
        if (!COMET.equals(key)) {
            return;
        }
        RequestParameter req = SandBox.getCurrentRequestParameter();
        if (req == null) {
            return;
        }
        HttpSession session = req.getSession();
        if (session == null) {
            return;
        }
        Ajax.get_comet_waiter(session.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeComet(String id) {
        HashMap<String, Object> hashMap = comet_wait;
        synchronized (hashMap) {
            comet_wait.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object get_comet_waiter(String id) {
        HashMap<String, Object> hashMap = comet_wait;
        synchronized (hashMap) {
            Object obj = comet_wait.get(id);
            if (obj == null) {
                obj = new Ajax();
                comet_wait.put(id, obj);
            }
            return obj;
        }
    }

    private Ajax() {
    }

    private Ajax(LinkedList<AjaxHolder> obj) {
        AjaxHolder h;
        ArrayList<Serializable> list = new ArrayList<Serializable>();
        while ((h = obj.poll()) != null) {
            list.add(h.obj);
        }
        this.data = list.toArray(new Serializable[0]);
    }

    public void valueBound(HttpSessionBindingEvent ev) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void valueUnbound(HttpSessionBindingEvent ev) {
        String id = ev.getSession().getId();
        HashMap<String, HashMap<String, LinkedList<AjaxHolder>>> hashMap = map;
        synchronized (hashMap) {
            map.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AjaxInformation[] getInformation() {
        HashMap<String, HashMap<String, LinkedList<AjaxHolder>>> hashMap = map;
        synchronized (hashMap) {
            return AjaxInformation.getInformation(map);
        }
    }

    private static LinkedList<AjaxHolder> getQueue(HttpSession session, String key) {
        String id = session.getId();
        HashMap<String, LinkedList<AjaxHolder>> obj = map.get(id);
        LinkedList<AjaxHolder> que = null;
        if (obj == null) {
            session.removeAttribute(KEY);
            obj = new HashMap();
            map.put(id, obj);
            session.setAttribute(KEY, (Object)new Ajax());
        } else {
            que = obj.get(key);
        }
        if (que == null) {
            que = new LinkedList();
            obj.put(key, que);
        }
        return que;
    }

    private static LinkedList<AjaxHolder> getQueue(String id, String key) {
        HashMap<String, LinkedList<AjaxHolder>> obj = map.get(id);
        if (obj == null) {
            return null;
        }
        LinkedList<AjaxHolder> que = obj.get(key);
        if (que == null) {
            que = new LinkedList();
            obj.put(key, que);
        }
        return que;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(HttpSession session, String key, Serializable ... o) {
        if (session == null) {
            return;
        }
        HashMap<String, HashMap<String, LinkedList<AjaxHolder>>> hashMap = map;
        synchronized (hashMap) {
            LinkedList<AjaxHolder> que = Ajax.getQueue(session, key);
            for (int i = 0; i < o.length; ++i) {
                que.offer(new AjaxHolder(o[i]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void add(String session, String key, Serializable ... o) {
        if (session == null) {
            return;
        }
        HashMap<String, HashMap<String, LinkedList<AjaxHolder>>> hashMap = map;
        synchronized (hashMap) {
            LinkedList<AjaxHolder> que = Ajax.getQueue(session, key);
            for (int i = 0; i < o.length; ++i) {
                que.offer(new AjaxHolder(o[i]));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addComet(String session, Serializable ... o) {
        Object obj;
        Object object = obj = Ajax.get_comet_waiter(session);
        synchronized (object) {
            Ajax.add(session, COMET, o);
            try {
                obj.notifyAll();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSON get(HttpSession session, String key) {
        if (session == null) {
            return null;
        }
        boolean comet_f = COMET.equals(key);
        LinkedList<AjaxHolder> que = null;
        HashMap<String, HashMap<String, LinkedList<AjaxHolder>>> hashMap = map;
        synchronized (hashMap) {
            que = Ajax.getQueue(session, key);
            if (comet_f && que.size() > 0) {
                comet_f = false;
            }
            if (!comet_f) {
                return new JSON(new Ajax(que));
            }
        }
        JSON ret = null;
        if (comet_f) {
            Object obj;
            Object object = obj = Ajax.get_comet_waiter(session.getId());
            synchronized (object) {
                try {
                    obj.notifyAll();
                    obj.wait(180000L);
                }
                catch (Exception e) {
                    return new JSON(new Ajax(new LinkedList<AjaxHolder>()));
                }
            }
        }
        HashMap<String, HashMap<String, LinkedList<AjaxHolder>>> hashMap2 = map;
        synchronized (hashMap2) {
            ret = new JSON(new Ajax(que));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(HttpSession session, String key) {
        if (session == null) {
            return;
        }
        HashMap<String, HashMap<String, LinkedList<AjaxHolder>>> hashMap = map;
        synchronized (hashMap) {
            Ajax.getQueue(session, key).clear();
        }
    }
}

