/*
 * Decompiled with CFR 0.152.
 */
package paraselene.supervisor;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.SocketException;
import java.net.URI;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import paraselene.Downloadable;
import paraselene.HTTPDate;
import paraselene.Page;
import paraselene.URIValue;
import paraselene.ajax.Ajax;
import paraselene.supervisor.AliasData;
import paraselene.supervisor.CacheBin;
import paraselene.supervisor.CacheWriter;
import paraselene.supervisor.Closure;
import paraselene.supervisor.DataHolder;
import paraselene.supervisor.Feedback;
import paraselene.supervisor.Forward;
import paraselene.supervisor.History;
import paraselene.supervisor.Null;
import paraselene.supervisor.NullPage4Alias;
import paraselene.supervisor.Option;
import paraselene.supervisor.OutputHolder;
import paraselene.supervisor.PageFactory;
import paraselene.supervisor.PageID;
import paraselene.supervisor.PageServerInformation;
import paraselene.supervisor.PathData;
import paraselene.supervisor.RequestItem;
import paraselene.supervisor.RequestParameter;
import paraselene.supervisor.SandBox;
import paraselene.supervisor.ServerInformation;
import paraselene.supervisor.SessionData;
import paraselene.supervisor.TransactionSequencer;
import paraselene.tag.Tag;

public abstract class Supervisor
extends HttpServlet {
    static final String SESSION_DATA = "paraselene$data";
    private static final int[] LINK_LEN = new int[]{TransactionSequencer.LINK_DEF[0].length(), TransactionSequencer.LINK_DEF[1].length(), TransactionSequencer.LINK_DEF[2].length()};
    private static final String[] LINK_PROT = new String[]{"", "http://", "https://"};
    private static volatile HashMap<Thread, DataHolder> data_map_th = new HashMap();
    private static volatile HashMap<Supervisor, DataHolder> data_map_sv = new HashMap();
    private static final Page null4alias;
    private static final int PAGE_ID_JSON = -1;
    private static final int PAGE_ID_FORM_JSON = -2;
    public static final String A_AJAX_KEY = "paraselene_a_ajax";
    private static final String XHTML = "application/xhtml+xml";

    private static String resolvePage(ServerInformation holder, PageID from_page, String p, int from_key, int to_key) {
        try {
            URI u = new URI(p);
            PageID to = null;
            Page page = from_page.getPageFactory().getPage(Integer.parseInt(u.getPath().substring(LINK_LEN[0])));
            if (page != null) {
                to = page.getID();
                to.getPageFactory().returnPage(page);
            }
            if (to != null) {
                String fragment;
                StringBuilder path = new StringBuilder(TransactionSequencer.makeURI(page.isCheckRepeatSameRequest() ? holder.getTransactionSequencer() : null, from_page, to, from_key, to_key, !holder.isSearchEngine()));
                String query = u.getQuery();
                if (query != null) {
                    path = path.append("?");
                    path = path.append(query);
                }
                if ((fragment = u.getFragment()) != null) {
                    path = path.append("#");
                    path = path.append(fragment);
                }
                return path.toString();
            }
            return "PageID_Not_Found(" + p + ")";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    private static String resolveHost(ServerInformation holder, String path, int def_no) {
        try {
            int port = Integer.parseInt(path.substring(LINK_LEN[def_no]));
            StringBuilder buf = new StringBuilder(LINK_PROT[def_no]);
            buf = buf.append(holder.getServerName());
            if (port > 0 && port < 65535) {
                buf = buf.append(":");
                buf = buf.append(port);
            }
            buf = buf.append(holder.getContextPath());
            return buf.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    private static String getTarget(Tag tag) {
        if (tag == null) {
            return null;
        }
        String name = tag.getName();
        String ret = null;
        if ("a".equals(name) || "form".equals(name)) {
            ret = tag.getAttributeToString("target");
        } else if (("frame".equals(name) || "iframe".equals(name)) && (ret = tag.getAttributeToString("name")) == null) {
            ret = tag.getAttributeToString("id");
        }
        return ret;
    }

    static PageServerInformation getPageServerInformation() {
        DataHolder h;
        PageServerInformation psi;
        Page page = SandBox.getCurrentPage();
        if (page != null && (psi = page.getPageServerInformation()) != null) {
            return psi;
        }
        Supervisor sv = null;
        RequestParameter req = SandBox.getCurrentRequestParameter();
        if (req != null) {
            sv = req.getSupervisor();
        }
        if ((h = Supervisor.getDataHolder(sv)) == null) {
            return null;
        }
        return new PageServerInformation(h);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DataHolder getDataHolder(Supervisor sv) {
        HashMap<Thread, DataHolder> hashMap = data_map_th;
        synchronized (hashMap) {
            DataHolder h;
            if (sv != null && (h = data_map_sv.get((Object)sv)) != null) {
                return h;
            }
            return data_map_th.get(Thread.currentThread());
        }
    }

    private DataHolder getDataHolder() {
        return Supervisor.getDataHolder(this);
    }

    public static String makeWithSessionURI(String uri, String enc, Tag tag) throws UnsupportedEncodingException {
        int to_key;
        int from_key;
        ServerInformation holder;
        boolean xml_f = false;
        Page page = null;
        if (tag != null) {
            page = tag.getAssignedPage();
            xml_f = page.isXML();
        }
        if ((holder = Supervisor.getDataHolder(null)) == null && page != null) {
            holder = page.getPageServerInformation();
        }
        if (holder == null) {
            return URIValue.encode(uri, enc, xml_f);
        }
        if (page != null) {
            from_key = page.getHistoryKey();
            to_key = holder.getHistorySet().toInt(Supervisor.getTarget(tag), from_key);
        } else {
            to_key = 0;
            from_key = 0;
        }
        String[] part = uri.split("/");
        boolean flag = false;
        String head = null;
        boolean alias_f = false;
        block4: for (int i = 0; i < part.length; ++i) {
            int def_no;
            for (def_no = 0; def_no < TransactionSequencer.LINK_DEF.length; ++def_no) {
                if (part[i].length() < LINK_LEN[def_no] || !TransactionSequencer.LINK_DEF[def_no].equals(part[i].substring(0, LINK_LEN[def_no]))) continue;
                flag = true;
                break;
            }
            switch (def_no) {
                case 0: {
                    part[i] = Supervisor.resolvePage(holder, page.getID(), part[i], from_key, to_key);
                    continue block4;
                }
                case 1: 
                case 2: {
                    head = Supervisor.resolveHost(holder, part[i], def_no);
                    part[i] = "";
                }
            }
        }
        if (flag) {
            StringBuilder buf = new StringBuilder(part[0]);
            for (int i = 1; i < part.length; ++i) {
                if (buf.length() > 0) {
                    buf = buf.append("/");
                }
                buf = buf.append(part[i]);
            }
            uri = buf.toString();
            uri = holder instanceof DataHolder ? ((DataHolder)holder).response.encodeURL(URIValue.encode(uri, enc, xml_f)) : URIValue.encode(uri, enc, xml_f);
        } else {
            alias_f = holder.getPageFactory().isAlias(uri);
            if (alias_f && to_key != 0) {
                String[] dev = uri.split("/");
                StringBuilder buf = new StringBuilder(TransactionSequencer.SELENE[5]);
                buf = buf.append(".");
                buf = buf.append(Integer.toString(to_key, 36));
                buf = buf.append(".");
                buf = buf.append(TransactionSequencer.SELENE[6]);
                buf = buf.append(".");
                if (dev.length == 0) {
                    buf = buf.append(uri);
                    uri = buf.toString();
                } else {
                    StringBuilder p = new StringBuilder();
                    for (int i = 0; i < dev.length - 1; ++i) {
                        p = p.append(dev[i]);
                        p = p.append("/");
                    }
                    p = p.append((CharSequence)buf);
                    p = p.append(dev[dev.length - 1]);
                    uri = p.toString();
                }
            }
            uri = !alias_f && Supervisor.isMyHost(uri) && holder instanceof DataHolder ? ((DataHolder)holder).response.encodeURL(URIValue.encode(uri, enc, xml_f)) : URIValue.encode(uri, enc, xml_f);
        }
        if (head != null) {
            StringBuilder buf = new StringBuilder(head);
            buf = buf.append("/");
            buf = buf.append(uri);
            uri = buf.toString();
        }
        return uri;
    }

    private static boolean isMyHost(DataHolder holder, String uri) {
        if (uri == null) {
            return false;
        }
        try {
            URI test = new URI(URIValue.encode(uri, "utf-8"));
            if (!test.isAbsolute()) {
                return true;
            }
            String sch = test.getScheme();
            if (sch != null && !"https".equals(sch) && !"http".equals(sch)) {
                return false;
            }
            String host = test.getHost();
            if (host == null) {
                return true;
            }
            if (holder == null) {
                return false;
            }
            if (host.equals(holder.getServerName())) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    static boolean isMyHost(String uri) {
        DataHolder holder = Supervisor.getDataHolder(null);
        return Supervisor.isMyHost(holder, uri);
    }

    public boolean isMyHostURI(String uri) {
        DataHolder holder = this.getDataHolder();
        return Supervisor.isMyHost(holder, uri);
    }

    static SessionData getSessionData(Supervisor sv) {
        DataHolder holder = Supervisor.getDataHolder(sv);
        if (holder == null) {
            return null;
        }
        return holder.data;
    }

    public abstract PageFactory getPageFactory();

    public abstract void onError(Throwable var1);

    private Forward onErrorDebug(Throwable e, HttpServletRequest req, HttpServletResponse res, int status) {
        Forward fw = new Forward(status);
        Option.debug(e);
        if (!(e instanceof SocketException)) {
            this.onError(e);
        }
        try {
            fw.Action(this, res);
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            this.onError(e2);
        }
        if (!(e instanceof SocketException)) {
            HttpSession session = req.getSession(false);
            Supervisor.clear_session(session);
        }
        return fw;
    }

    private Forward onErrorDebug(Throwable e, HttpServletRequest req, HttpServletResponse res) {
        return this.onErrorDebug(e, req, res, 500);
    }

    private static void clear_session(HttpSession s) {
        if (s != null) {
            s.invalidate();
        }
        Option.traceWithStack("session cleared", new Object[0]);
    }

    public abstract Forward onIllegalRequest(IllegalRequest var1, RequestParameter var2, Page var3, Page var4);

    private void doAction(HttpServletRequest request, HttpServletResponse res) {
        HttpSession session = null;
        SessionData data = null;
        DataHolder holder = this.getDataHolder();
        if (holder != null) {
            data = holder.data;
        }
        RequestParameter req = null;
        try {
            String call_key;
            if (data == null) {
                System.out.println("SessionData null");
                res.sendError(500);
                return;
            }
            boolean session_f = false;
            req = holder.request;
            session = req.getSession();
            String uri = req.getURI().toString();
            PageFactory fact = this.getPageFactory();
            PathData path_data = new PathData();
            Forward fw = null;
            Page last_page = null;
            Page next_page = null;
            AliasData alias = fact.getPage(uri);
            if (alias == null) {
                path_data = TransactionSequencer.parsePath(data.seq, uri, fact, data.hist);
                if (TransactionSequencer.isMustSession(uri)) {
                    if (holder.isSearchEngine()) {
                        new Forward(403).Action(this, res);
                        Supervisor.clear_session(session);
                        return;
                    }
                    if (holder.session_null && path_data != null && (fw = this.onIllegalRequest(IllegalRequest.SESSION_ERROR, req, path_data.from, path_data.to)) != null) {
                        session_f = fw.session_clear_f;
                        last_page = null;
                        path_data.from = null;
                        path_data.to = next_page = fw.getPage(null);
                        if (next_page == null) {
                            fw.Action(this, res);
                            if (session_f) {
                                Supervisor.clear_session(session);
                            }
                            return;
                        }
                    }
                }
            } else {
                path_data.from = null4alias;
                path_data.to = alias.page;
                path_data.to_histry = alias.to_histry;
            }
            if (path_data == null) {
                fw = new Forward(403);
                fw.Action(this, res);
                return;
            }
            if (path_data.redirect != null) {
                if (!holder.data.write(this, path_data.redirect, holder)) {
                    fw = new Forward(403);
                    fw.Action(this, res);
                }
                return;
            }
            last_page = path_data.from;
            next_page = path_data.to;
            RequestItem ukey = req.getItem("paraselene_page_ukey");
            RequestItem ajax = req.getItem(A_AJAX_KEY);
            if (ajax == null) {
                ajax = req.getItem("paraselene_form_ajax");
            }
            if (ajax != null || ukey != null) {
                String call_key2 = ajax != null ? ajax.getValue(0) : ukey.getValue(0);
                Option.trace("call_key=%s", call_key2);
                Page sub = null;
                History history = data.hist.get(path_data.from_histry != null ? path_data.from_histry : 0);
                if (history != null) {
                    sub = history.getBrowsingPage(call_key2);
                }
                if (sub != null) {
                    fact.returnPage(last_page);
                    last_page = sub;
                } else {
                    if (!"-1".equals(call_key2)) {
                        fw = data.redirect(req.getURI());
                        if (fw != null) {
                            fw.Action(this, res);
                            return;
                        }
                        fw = this.onIllegalRequest(IllegalRequest.SESSION_ERROR, req, last_page, next_page);
                        if (fw == null || fw.getStatus() == 0) {
                            fw = new Forward(403);
                        }
                        fw.Action(this, res);
                        Supervisor.clear_session(session);
                        return;
                    }
                    ajax = null;
                }
            }
            if (ajax == null && last_page != null) {
                if (last_page instanceof Null) {
                    System.out.println("last page is null");
                    fw = new Forward(403);
                    fw.Action(this, res);
                    Supervisor.clear_session(session);
                    return;
                }
                if (last_page.isAllowHistoryAdd()) {
                    Page sub = null;
                    History history = data.hist.get(path_data.from_histry != null ? path_data.from_histry : 0);
                    if (history != null) {
                        sub = history.getPage(last_page.getID());
                    }
                    if (sub != null) {
                        fact.returnPage(last_page);
                        last_page = sub;
                    } else {
                        fw = this.onIllegalRequest(IllegalRequest.NOT_FOUND_HISTORY, req, last_page, next_page);
                        if (fw != null) {
                            session_f = fw.session_clear_f;
                            last_page = fact.getNullPage();
                            next_page = fw.getPage(null);
                            if (next_page == null) {
                                fw.Action(this, res);
                                if (session_f) {
                                    Supervisor.clear_session(session);
                                }
                                return;
                            }
                        }
                    }
                }
            } else if (ajax == null) {
                last_page = fact.getNullPage();
            }
            if (next_page != null) {
                if (next_page instanceof Null) {
                    System.out.println("next page is null");
                    fw = new Forward(403);
                    fw.Action(this, res);
                    Supervisor.clear_session(session);
                    return;
                }
            } else {
                fw = new Forward(403);
                fw.Action(this, res);
                Supervisor.clear_session(session);
                return;
            }
            if (path_data.called && (fw = this.onIllegalRequest(IllegalRequest.REPEAT_SAME_REQUEST, req, last_page, next_page)) != null) {
                session_f = fw.session_clear_f;
                last_page = fact.getNullPage();
                next_page = fw.getPage(null);
                if (next_page == null) {
                    fw.Action(this, res);
                    if (session_f) {
                        Supervisor.clear_session(session);
                    }
                    return;
                }
            }
            if (fw == null) {
                Page do_page;
                int from_key = 0;
                int to_key = 0;
                if (path_data.from_histry != null) {
                    from_key = path_data.from_histry;
                }
                if (path_data.to_histry != null) {
                    to_key = path_data.to_histry;
                }
                if ((do_page = last_page.reflect(req)) != null && do_page != last_page) {
                    last_page = do_page;
                }
                last_page.setRequestParameter(req);
                if (next_page != null) {
                    fw = from_key != to_key ? new Forward(next_page.getID(), true, false) : (last_page.getID() == next_page.getID() ? new Feedback(last_page) : (Closure.isClosure(last_page, next_page, req) ? (last_page.getPopupType() == null ? new Closure(next_page) : new Closure(last_page)) : new Forward(next_page.getID(), true, false)));
                    fact.returnPage(next_page);
                }
                Option.trace("%s input(%s) call", last_page.getID(), fw);
                fw = SandBox.input(last_page, req, fw);
                session = req.getSession();
                Option.trace("%s input return %s", last_page.getID(), fw);
                last_page.setInitialized(false);
                last_page.setRequestParameter(null);
                session_f = fw.session_clear_f;
                if (fw.getPageID() == Closure.CLOSE) {
                    Forward old = fw;
                    fw = new Feedback(last_page);
                    Option.trace("%s to %s", old, fw);
                }
                if (!last_page.isAjax() && fw.isLeave() || fw.getStatus() != 0) {
                    fw.Action(this, res);
                    if (session_f) {
                        Supervisor.clear_session(session);
                    }
                    return;
                }
            }
            int out_hist_key = 0;
            if (path_data.to_histry != null) {
                out_hist_key = path_data.to_histry;
            }
            OutputHolder oh = new OutputHolder(ajax != null && last_page.isAjax(), out_hist_key, last_page, fw, req, data);
            oh.call();
            String key = last_page.getUniqueKey();
            ajax = req.getItem(A_AJAX_KEY);
            if (ajax != null && key.equals(call_key = ajax.getValue(0))) {
                Ajax.remove(session, key);
                Ajax.add(session, key, oh.getPostBack());
                Page ajax_page = this.getPageFactory().getPage(-1);
                ajax_page.output(null, req);
                this.write(new Page[]{ajax_page, ajax_page}, session_f, fw, holder);
                Option.trace("JSON postback %s", key);
                return;
            }
            ajax = req.getItem("paraselene_form_ajax");
            if (ajax != null && key.equals(call_key = ajax.getValue(0))) {
                Ajax.remove(session, key);
                Ajax.add(session, key, oh.getPostBack());
                Page ajax_page = this.getPageFactory().getPage(-2);
                ajax_page.output(last_page, req);
                data.redirect(new Page[]{ajax_page, ajax_page}, fw, req).Action(this, res);
                Option.trace("FORM postback %s", key);
                return;
            }
            Page[] out_ret = oh.getPage();
            if (out_ret == null) {
                System.out.println("output_call false");
                fw = new Forward(500);
                fw.Action(this, res);
                return;
            }
            Option.trace("no ajax result %s/%s", out_ret[1].getID(), out_ret[1].getUniqueKey());
            this.write(out_ret, session_f, fw, holder);
        }
        catch (Throwable e) {
            this.onErrorDebug(e, request, res);
        }
    }

    HttpSession makeNewSession(HttpSession old) {
        DataHolder holder = this.getDataHolder();
        if (holder == null) {
            return old;
        }
        if (old != null) {
            if (holder.data != null) {
                holder.data.planed_clear = true;
            }
            Supervisor.clear_session(old);
            if (holder.data != null) {
                holder.data.planed_clear = false;
            }
        }
        HttpSession session = holder.getRequest().getSession(true);
        session.setAttribute(SESSION_DATA, (Object)holder.data);
        return session;
    }

    void write(Page[] out_ret, boolean session_f, Forward fw, DataHolder holder) throws Exception {
        try {
            this.writeWork(out_ret, session_f, fw, holder);
        }
        catch (Exception e) {
            String[] name = ((Object)((Object)this)).getClass().getName().split("\\.");
            StringBuilder buf = new StringBuilder();
            int cnt = name.length - 1;
            for (int i = 0; i < cnt; ++i) {
                buf = buf.append(name[i]);
                buf = buf.append(".");
            }
            String p_name = buf.toString();
            StackTraceElement[] st = e.getStackTrace();
            boolean flag = false;
            for (int i = 0; i < st.length; ++i) {
                if (!st[i].getMethodName().equals("getInputStream") || st[i].getClassName().indexOf(p_name) != 0) continue;
                flag = true;
                break;
            }
            if (flag) {
                throw e;
            }
            Option.debug(e);
            Option.trace("write error %s", e.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeWork(Page[] out_ret, boolean session_f, Forward fw, DataHolder holder) throws Exception {
        SessionData data = holder.data;
        HttpServletResponse res = holder.response;
        out_ret[1].setResponse(res);
        Page next_page = out_ret[0];
        RequestParameter param = holder.request;
        HttpSession session = param.getSession();
        try {
            session.setAttribute(SESSION_DATA, (Object)data);
        }
        catch (Exception e) {
            session = null;
        }
        if (session_f) {
            Supervisor.clear_session(session);
            session = null;
        } else if (session == null) {
            session = holder.getRequest().getSession(true);
            session.setAttribute(SESSION_DATA, (Object)data);
        }
        if (!session_f && param.getMethod() == RequestParameter.Method.POST) {
            data.redirect(out_ret, fw, param).Action(this, res);
        } else {
            String mime = out_ret[1].getContentType();
            if (mime == null) {
                StringBuilder buf = null;
                if (next_page.isXML()) {
                    RequestParameter.HeaderQuality[] head = param.getHeaderWithQuality("Accept");
                    if (head != null) {
                        for (int i = 0; i < head.length; ++i) {
                            Float f = head[i].getQuality();
                            if (f != null && (double)f.floatValue() <= 0.0 || !XHTML.equalsIgnoreCase(head[i].getValue())) continue;
                            buf = new StringBuilder(XHTML);
                            break;
                        }
                    }
                    if (buf == null) {
                        RequestParameter.Mobile mob = param.judgeMobile();
                        switch (mob) {
                            case AU: 
                            case DOCOMO: 
                            case J_PHONE: {
                                buf = new StringBuilder(XHTML);
                            }
                        }
                    }
                }
                if (buf == null) {
                    buf = new StringBuilder("text/html");
                }
                buf = buf.append("; charset=");
                mime = buf.append(next_page.getCharset()).toString();
            }
            res.setContentType(mime);
            HTTPDate date = next_page.getLastModified();
            String[] mod = param.getHeader("If-Modified-Since");
            if (mod != null && date != null) {
                try {
                    if (date.compareTo(new HTTPDate(mod[0])) <= 0) {
                        res.setStatus(304);
                        res.setContentType(mime);
                        data.hist.forceNewNo(next_page.getHistoryKey());
                        data.hist.get(next_page.getHistoryKey()).add(next_page);
                        return;
                    }
                }
                catch (ParseException pe) {
                    // empty catch block
                }
            }
            if (date != null) {
                res.addHeader("Last-Modified", date.toString());
                res.addHeader("Cache-Control", "public");
            } else if (next_page.isNoCache()) {
                res.addHeader("Pragma", "no-cache");
                res.addHeader("Cache-Control", "no-cache, no-store, must-revalidate");
            }
            if (fw != null && fw.out_cookie != null) {
                int ck_cnt = fw.out_cookie.size();
                for (int i = 0; i < ck_cnt; ++i) {
                    res.addCookie(fw.out_cookie.get(i));
                }
            }
            if (this.gzip(param, holder.getRequest(), res, out_ret[1], data, mime)) {
                data.hist.get(next_page.getHistoryKey()).add(next_page);
                return;
            }
            if (out_ret[1] instanceof Downloadable) {
                CacheBin cb = new CacheBin(mime, false);
                cb.write((Downloadable)((Object)out_ret[1]), param, data, res);
            } else {
                CacheWriter w = new CacheWriter(out_ret[1], mime, param, data);
                History h = data.hist.get(out_ret[1].getHistoryKey());
                try {
                    if (h != null) {
                        h.lock();
                    }
                    out_ret[1].write(w);
                }
                finally {
                    if (h != null) {
                        h.unlock();
                    }
                }
                w.writeTo(res);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean gzip(RequestParameter param, HttpServletRequest req, HttpServletResponse res, Page page, SessionData data, String mime) throws Exception {
        if (!page.isGZIP()) {
            return false;
        }
        String[] pcol = req.getProtocol().split("\\/");
        if (pcol[pcol.length - 1].equals("1.0")) {
            return false;
        }
        RequestParameter.HeaderQuality[] encode = param.getHeaderWithQuality("Accept-Encoding");
        boolean gzip_f = false;
        if (encode != null) {
            for (int i = 0; i < encode.length; ++i) {
                float q;
                if (!"gzip".equalsIgnoreCase(encode[i].getValue())) continue;
                Float f = encode[i].getQuality();
                float f2 = q = f == null ? 1.0f : f.floatValue();
                if (!(q > 0.0f)) continue;
                gzip_f = true;
                break;
            }
        }
        if (!gzip_f) {
            return false;
        }
        res.addHeader("Content-Encoding", "gzip");
        if (page instanceof Downloadable) {
            CacheBin cb = new CacheBin(mime, true);
            cb.write((Downloadable)((Object)page), param, data, res);
        } else {
            CacheWriter w = new CacheWriter(page, mime, param, data);
            History h = data.hist.get(page.getHistoryKey());
            try {
                if (h != null) {
                    h.lock();
                }
                page.write(w);
            }
            finally {
                if (h != null) {
                    h.unlock();
                }
            }
            GZIPOutputStream gz_out = new GZIPOutputStream((OutputStream)res.getOutputStream());
            w.writeTo(res, new PrintWriter(new OutputStreamWriter((OutputStream)gz_out, page.getCharset())));
            gz_out.finish();
        }
        return true;
    }

    RequestParameter normalReq(HttpServletRequest req) {
        RequestParameter ret = new RequestParameter();
        Enumeration e = req.getParameterNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String[] val = req.getParameterValues(key);
            for (int i = 0; i < val.length; ++i) {
                ret.addItem(key, val[i]);
            }
        }
        return ret;
    }

    public abstract int getRequestMaxCount();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Forward preset(RequestParameter.Method method, HttpServletRequest request, HttpServletResponse res) throws UnsupportedEncodingException, IOException {
        if (!SandBox.isSafeFreeMemory()) {
            return new Forward(503);
        }
        DataHolder holder = new DataHolder(this, request);
        HttpSession session = request.getSession(false);
        SessionData data = null;
        if (session == null) {
            data = new SessionData(request);
            holder.session_null = true;
        } else {
            data = (SessionData)session.getAttribute(SESSION_DATA);
            holder.session_null = false;
            if (data == null) {
                data = new SessionData(request);
                session.setAttribute(SESSION_DATA, (Object)data);
                holder.session_null = true;
            } else if (!data.isSame(request)) {
                Supervisor.clear_session(session);
                session = null;
                data = new SessionData(request);
                holder.session_null = true;
            }
        }
        holder.response = res;
        holder.data = data;
        PathData p = TransactionSequencer.parsePath(null, request.getRequestURI(), this.getPageFactory(), null);
        if (p != null && p.from != null) {
            request.setCharacterEncoding(p.from.getCharset());
        }
        RequestParameter req = null;
        try {
            req = this.parseRequest(request, p);
        }
        catch (Exception e) {
            return this.onErrorDebug(e, request, res, 422);
        }
        req.setParam(method, request, this);
        String[] header = req.getHeaderNames();
        ArrayList<String> log = new ArrayList<String>();
        StringBuilder buf = new StringBuilder("client access\n");
        buf = buf.append(req.getMethod().toString());
        buf = buf.append(" ");
        buf = buf.append(req.getURI());
        buf = buf.append("\n");
        log.add(buf.toString());
        for (int i = 0; i < header.length; ++i) {
            String[] val = req.getHeader(header[i]);
            for (int j = 0; j < val.length; ++j) {
                buf = new StringBuilder(header[i]);
                buf = buf.append(" : ");
                buf = buf.append(val[j]);
                buf = buf.append("\n");
                log.add(buf.toString());
            }
        }
        Option.appendTrace(log.toArray(new String[0]));
        holder.setSearchEngine(req.judgeSearchEngine() != RequestParameter.SearchEngine.NO_SEARCHENGINE);
        holder.request = req;
        int cnt = this.getRequestMaxCount();
        HashMap<Thread, DataHolder> hashMap = data_map_th;
        synchronized (hashMap) {
            if (cnt > 0 && cnt < data_map_th.size()) {
                return new Forward(503);
            }
            data_map_th.put(Thread.currentThread(), holder);
            data_map_sv.put(this, holder);
        }
        return null;
    }

    RequestParameter parseRequest(HttpServletRequest request, PathData p) throws Exception {
        String head = request.getHeader("Content-Type");
        if (head != null && "multipart/form-data".equals(head = head.split(";")[0])) {
            throw new Exception("Gate class must extend UploadableSupervisor!");
        }
        return this.normalReq(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doGet(HttpServletRequest req, HttpServletResponse res) {
        try {
            Serializable fw = this.preset(RequestParameter.Method.GET, req, res);
            if (fw != null) {
                fw.Action(this, res);
                return;
            }
            this.doAction(req, res);
        }
        catch (Exception e) {
            this.onErrorDebug(e, req, res);
        }
        finally {
            HashMap<Thread, DataHolder> hashMap = data_map_th;
            synchronized (hashMap) {
                data_map_th.remove(Thread.currentThread());
                data_map_sv.remove((Object)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doPost(HttpServletRequest req, HttpServletResponse res) {
        try {
            Serializable fw = this.preset(RequestParameter.Method.POST, req, res);
            if (fw != null) {
                fw.Action(this, res);
                return;
            }
            this.doAction(req, res);
        }
        catch (Exception e) {
            this.onErrorDebug(e, req, res);
        }
        finally {
            HashMap<Thread, DataHolder> hashMap = data_map_th;
            synchronized (hashMap) {
                data_map_th.remove(Thread.currentThread());
                data_map_sv.remove((Object)this);
            }
        }
    }

    static {
        SandBox.doStart();
        null4alias = new NullPage4Alias();
    }

    public static enum IllegalRequest {
        REPEAT_SAME_REQUEST,
        NOT_FOUND_HISTORY,
        SESSION_ERROR;

        private static final long serialVersionUID = 1L;
    }
}

