/*
 * Paraselene
 * Copyright (c) 2009  Akira Terasaki
 * このファイルは同梱されている License.txt に定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene;

import java.util.*;
import java.io.*;

/**
 * MIME Media Type。以下の物が取得可能です。
 * <table border='1'>
 * <tr><th>MIME Media Type</th><th>拡張子</th>
 * <tr><td>application/andrew-inset</td><td>ez&nbsp;</td></tr>
 * <tr><td>application/atom</td><td>atom&nbsp;</td></tr>
 * <tr><td>application/atomcat+xml</td><td>atomcat&nbsp;</td></tr>
 * <tr><td>application/atomserv+xml</td><td>atomsrv&nbsp;</td></tr>
 * <tr><td>application/cap</td><td>cap&nbsp;pcap&nbsp;</td></tr>
 * <tr><td>application/cu-seeme</td><td>cu&nbsp;</td></tr>
 * <tr><td>application/dsptype</td><td>tsp&nbsp;</td></tr>
 * <tr><td>application/futuresplash</td><td>spl&nbsp;</td></tr>
 * <tr><td>application/hta</td><td>hta&nbsp;</td></tr>
 * <tr><td>application/java-archive</td><td>jar&nbsp;</td></tr>
 * <tr><td>application/java-serialized-object</td><td>ser&nbsp;</td></tr>
 * <tr><td>application/java-vm</td><td>class&nbsp;</td></tr>
 * <tr><td>application/mac-binhex40</td><td>hqx&nbsp;</td></tr>
 * <tr><td>application/mac-compactpro</td><td>cpt&nbsp;</td></tr>
 * <tr><td>application/mathematica</td><td>nb&nbsp;</td></tr>
 * <tr><td>application/msaccess</td><td>mdb&nbsp;</td></tr>
 * <tr><td>application/msword</td><td>doc&nbsp;dot&nbsp;</td></tr>
 * <tr><td>application/octet-stream</td><td>bin&nbsp;</td></tr>
 * <tr><td>application/oda</td><td>oda&nbsp;</td></tr>
 * <tr><td>application/ogg</td><td>ogg&nbsp;ogx&nbsp;</td></tr>
 * <tr><td>application/pdf</td><td>pdf&nbsp;</td></tr>
 * <tr><td>application/pgp-keys</td><td>key&nbsp;</td></tr>
 * <tr><td>application/pgp-signature</td><td>pgp&nbsp;</td></tr>
 * <tr><td>application/pics-rules</td><td>prf&nbsp;</td></tr>
 * <tr><td>application/postscript</td><td>ps&nbsp;ai&nbsp;eps&nbsp;</td></tr>
 * <tr><td>application/rar</td><td>rar&nbsp;</td></tr>
 * <tr><td>application/rdf+xml</td><td>rdf&nbsp;</td></tr>
 * <tr><td>application/rss+xml</td><td>rss&nbsp;</td></tr>
 * <tr><td>application/rtf</td><td>rtf&nbsp;</td></tr>
 * <tr><td>application/smil</td><td>smi&nbsp;smil&nbsp;</td></tr>
 * <tr><td>application/wordperfect</td><td>wpd&nbsp;</td></tr>
 * <tr><td>application/wordperfect5.1</td><td>wp5&nbsp;</td></tr>
 * <tr><td>application/xhtml+xml</td><td>xhtml&nbsp;xht&nbsp;</td></tr>
 * <tr><td>application/xml</td><td>xml&nbsp;xsl&nbsp;</td></tr>
 * <tr><td>application/zip</td><td>zip&nbsp;</td></tr>
 * <tr><td>application/vnd.cinderella</td><td>cdy&nbsp;</td></tr>
 * <tr><td>application/vnd.google-earth.kml+xml</td><td>kml&nbsp;</td></tr>
 * <tr><td>application/vnd.google-earth.kmz</td><td>kmz&nbsp;</td></tr>
 * <tr><td>application/vnd.mozilla.xul+xml</td><td>xul&nbsp;</td></tr>
 * <tr><td>application/vnd.ms-excel</td><td>xls&nbsp;xlb&nbsp;xlt&nbsp;</td></tr>
 * <tr><td>application/vnd.ms-pki.seccat</td><td>cat&nbsp;</td></tr>
 * <tr><td>application/vnd.ms-pki.stl</td><td>stl&nbsp;</td></tr>
 * <tr><td>application/vnd.ms-powerpoint</td><td>ppt&nbsp;pps&nbsp;</td></tr>
 * <tr><td>application/vnd.oasis.opendocument.chart</td><td>odc&nbsp;</td></tr>
 * <tr><td>application/vnd.oasis.opendocument.database</td><td>odb&nbsp;</td></tr>
 * <tr><td>application/vnd.oasis.opendocument.formula</td><td>odf&nbsp;</td></tr>
 * <tr><td>application/vnd.oasis.opendocument.graphics</td><td>odg&nbsp;</td></tr>
 * <tr><td>application/vnd.oasis.opendocument.graphics-template</td><td>otg&nbsp;</td></tr>
 * <tr><td>application/vnd.oasis.opendocument.image</td><td>odi&nbsp;</td></tr>
 * <tr><td>application/vnd.oasis.opendocument.presentation</td><td>odp&nbsp;</td></tr>
 * <tr><td>application/vnd.oasis.opendocument.presentation-template</td><td>otp&nbsp;</td></tr>
 * <tr><td>application/vnd.oasis.opendocument.spreadsheet</td><td>ods&nbsp;</td></tr>
 * <tr><td>application/vnd.oasis.opendocument.spreadsheet-template</td><td>ots&nbsp;</td></tr>
 * <tr><td>application/vnd.oasis.opendocument.text</td><td>odt&nbsp;</td></tr>
 * <tr><td>application/vnd.oasis.opendocument.text-master</td><td>odm&nbsp;</td></tr>
 * <tr><td>application/vnd.oasis.opendocument.text-template</td><td>ott&nbsp;</td></tr>
 * <tr><td>application/vnd.oasis.opendocument.text-web</td><td>oth&nbsp;</td></tr>
 * <tr><td>application/vnd.rim.cod</td><td>cod&nbsp;</td></tr>
 * <tr><td>application/vnd.smaf</td><td>mmf&nbsp;</td></tr>
 * <tr><td>application/vnd.stardivision.calc</td><td>sdc&nbsp;</td></tr>
 * <tr><td>application/vnd.stardivision.chart</td><td>sds&nbsp;</td></tr>
 * <tr><td>application/vnd.stardivision.draw</td><td>sda&nbsp;</td></tr>
 * <tr><td>application/vnd.stardivision.impress</td><td>sdd&nbsp;</td></tr>
 * <tr><td>application/vnd.stardivision.math</td><td>sdf&nbsp;</td></tr>
 * <tr><td>application/vnd.stardivision.writer</td><td>sdw&nbsp;</td></tr>
 * <tr><td>application/vnd.stardivision.writer-global</td><td>sgl&nbsp;</td></tr>
 * <tr><td>application/vnd.sun.xml.calc</td><td>sxc&nbsp;</td></tr>
 * <tr><td>application/vnd.sun.xml.calc.template</td><td>stc&nbsp;</td></tr>
 * <tr><td>application/vnd.sun.xml.draw</td><td>sxd&nbsp;</td></tr>
 * <tr><td>application/vnd.sun.xml.draw.template</td><td>std&nbsp;</td></tr>
 * <tr><td>application/vnd.sun.xml.impress</td><td>sxi&nbsp;</td></tr>
 * <tr><td>application/vnd.sun.xml.impress.template</td><td>sti&nbsp;</td></tr>
 * <tr><td>application/vnd.sun.xml.math</td><td>sxm&nbsp;</td></tr>
 * <tr><td>application/vnd.sun.xml.writer</td><td>sxw&nbsp;</td></tr>
 * <tr><td>application/vnd.sun.xml.writer.global</td><td>sxg&nbsp;</td></tr>
 * <tr><td>application/vnd.sun.xml.writer.template</td><td>stw&nbsp;</td></tr>
 * <tr><td>application/vnd.symbian.install</td><td>sis&nbsp;</td></tr>
 * <tr><td>application/vnd.visio</td><td>vsd&nbsp;</td></tr>
 * <tr><td>application/vnd.wap.wbxml</td><td>wbxml&nbsp;</td></tr>
 * <tr><td>application/vnd.wap.wmlc</td><td>wmlc&nbsp;</td></tr>
 * <tr><td>application/vnd.wap.wmlscriptc</td><td>wmlsc&nbsp;</td></tr>
 * <tr><td>application/x-123</td><td>wk&nbsp;</td></tr>
 * <tr><td>application/x-7z-compressed</td><td>7z&nbsp;</td></tr>
 * <tr><td>application/x-abiword</td><td>abw&nbsp;</td></tr>
 * <tr><td>application/x-apple-diskimage</td><td>dmg&nbsp;</td></tr>
 * <tr><td>application/x-bcpio</td><td>bcpio&nbsp;</td></tr>
 * <tr><td>application/x-bittorrent</td><td>torrent&nbsp;</td></tr>
 * <tr><td>application/x-cab</td><td>cab&nbsp;</td></tr>
 * <tr><td>application/x-cbr</td><td>cbr&nbsp;</td></tr>
 * <tr><td>application/x-cbz</td><td>cbz&nbsp;</td></tr>
 * <tr><td>application/x-cdf</td><td>cdf&nbsp;</td></tr>
 * <tr><td>application/x-cdlink</td><td>vcd&nbsp;</td></tr>
 * <tr><td>application/x-chess-pgn</td><td>pgn&nbsp;</td></tr>
 * <tr><td>application/x-cpio</td><td>cpio&nbsp;</td></tr>
 * <tr><td>application/x-csh</td><td>csh&nbsp;</td></tr>
 * <tr><td>application/x-debian-package</td><td>deb&nbsp;udeb&nbsp;</td></tr>
 * <tr><td>application/x-director</td><td>dcr&nbsp;dir&nbsp;dxr&nbsp;</td></tr>
 * <tr><td>application/x-dms</td><td>dms&nbsp;</td></tr>
 * <tr><td>application/x-doom</td><td>wad&nbsp;</td></tr>
 * <tr><td>application/x-dvi</td><td>dvi&nbsp;</td></tr>
 * <tr><td>application/x-httpd-eruby</td><td>rhtml&nbsp;</td></tr>
 * <tr><td>application/x-flac</td><td>flac&nbsp;</td></tr>
 * <tr><td>application/x-font</td><td>pfa&nbsp;pfb&nbsp;gsf&nbsp;pcf&nbsp;pcf.Z&nbsp;</td></tr>
 * <tr><td>application/x-freemind</td><td>mm&nbsp;</td></tr>
 * <tr><td>application/x-futuresplash</td><td>spl&nbsp;</td></tr>
 * <tr><td>application/x-gnumeric</td><td>gnumeric&nbsp;</td></tr>
 * <tr><td>application/x-go-sgf</td><td>sgf&nbsp;</td></tr>
 * <tr><td>application/x-graphing-calculator</td><td>gcf&nbsp;</td></tr>
 * <tr><td>application/x-gtar</td><td>gtar&nbsp;tgz&nbsp;taz&nbsp;</td></tr>
 * <tr><td>application/x-hdf</td><td>hdf&nbsp;</td></tr>
 * <tr><td>application/x-httpd-php</td><td>phtml&nbsp;pht&nbsp;php&nbsp;</td></tr>
 * <tr><td>application/x-httpd-php-source</td><td>phps&nbsp;</td></tr>
 * <tr><td>application/x-httpd-php3</td><td>php3&nbsp;</td></tr>
 * <tr><td>application/x-httpd-php3-preprocessed</td><td>php3p&nbsp;</td></tr>
 * <tr><td>application/x-httpd-php4</td><td>php4&nbsp;</td></tr>
 * <tr><td>application/x-ica</td><td>ica&nbsp;</td></tr>
 * <tr><td>application/x-internet-signup</td><td>ins&nbsp;isp&nbsp;</td></tr>
 * <tr><td>application/x-iphone</td><td>iii&nbsp;</td></tr>
 * <tr><td>application/x-iso9660-image</td><td>iso&nbsp;</td></tr>
 * <tr><td>application/x-java-jnlp-file</td><td>jnlp&nbsp;</td></tr>
 * <tr><td>application/x-javascript</td><td>js&nbsp;</td></tr>
 * <tr><td>application/x-jmol</td><td>jmz&nbsp;</td></tr>
 * <tr><td>application/x-kchart</td><td>chrt&nbsp;</td></tr>
 * <tr><td>application/x-killustrator</td><td>kil&nbsp;</td></tr>
 * <tr><td>application/x-koan</td><td>skp&nbsp;skd&nbsp;skt&nbsp;skm&nbsp;</td></tr>
 * <tr><td>application/x-kpresenter</td><td>kpr&nbsp;kpt&nbsp;</td></tr>
 * <tr><td>application/x-kspread</td><td>ksp&nbsp;</td></tr>
 * <tr><td>application/x-kword</td><td>kwd&nbsp;kwt&nbsp;</td></tr>
 * <tr><td>application/x-latex</td><td>latex&nbsp;</td></tr>
 * <tr><td>application/x-lha</td><td>lha&nbsp;</td></tr>
 * <tr><td>application/x-lyx</td><td>lyx&nbsp;</td></tr>
 * <tr><td>application/x-lzh</td><td>lzh&nbsp;</td></tr>
 * <tr><td>application/x-lzx</td><td>lzx&nbsp;</td></tr>
 * <tr><td>application/x-maker</td><td>frm&nbsp;maker&nbsp;frame&nbsp;fm&nbsp;fb&nbsp;book&nbsp;fbdoc&nbsp;</td></tr>
 * <tr><td>application/x-mif</td><td>mif&nbsp;</td></tr>
 * <tr><td>application/x-ms-wmd</td><td>wmd&nbsp;</td></tr>
 * <tr><td>application/x-ms-wmz</td><td>wmz&nbsp;</td></tr>
 * <tr><td>application/x-msdos-program</td><td>com&nbsp;exe&nbsp;bat&nbsp;dll&nbsp;</td></tr>
 * <tr><td>application/x-msi</td><td>msi&nbsp;</td></tr>
 * <tr><td>application/x-netcdf</td><td>nc&nbsp;</td></tr>
 * <tr><td>application/x-ns-proxy-autoconfig</td><td>pac&nbsp;</td></tr>
 * <tr><td>application/x-nwc</td><td>nwc&nbsp;</td></tr>
 * <tr><td>application/x-object</td><td>o&nbsp;</td></tr>
 * <tr><td>application/x-oz-application</td><td>oza&nbsp;</td></tr>
 * <tr><td>application/x-pkcs7-certreqresp</td><td>p7r&nbsp;</td></tr>
 * <tr><td>application/x-pkcs7-crl</td><td>crl&nbsp;</td></tr>
 * <tr><td>application/x-python-code</td><td>pyc&nbsp;pyo&nbsp;</td></tr>
 * <tr><td>application/x-quicktimeplayer</td><td>qtl&nbsp;</td></tr>
 * <tr><td>application/x-redhat-package-manager</td><td>rpm&nbsp;</td></tr>
 * <tr><td>application/x-sh</td><td>sh&nbsp;</td></tr>
 * <tr><td>application/x-shar</td><td>shar&nbsp;</td></tr>
 * <tr><td>application/x-shockwave-flash</td><td>swf&nbsp;swfl&nbsp;</td></tr>
 * <tr><td>application/x-stuffit</td><td>sit&nbsp;sitx&nbsp;</td></tr>
 * <tr><td>application/x-sv4cpio</td><td>sv4cpio&nbsp;</td></tr>
 * <tr><td>application/x-sv4crc</td><td>sv4crc&nbsp;</td></tr>
 * <tr><td>application/x-tar</td><td>tar&nbsp;</td></tr>
 * <tr><td>application/x-tcl</td><td>tcl&nbsp;</td></tr>
 * <tr><td>application/x-tex-gf</td><td>gf&nbsp;</td></tr>
 * <tr><td>application/x-tex-pk</td><td>pk&nbsp;</td></tr>
 * <tr><td>application/x-texinfo</td><td>texinfo&nbsp;texi&nbsp;</td></tr>
 * <tr><td>application/x-trash</td><td>~&nbsp;%&nbsp;bak&nbsp;old&nbsp;sik&nbsp;</td></tr>
 * <tr><td>application/x-troff</td><td>t&nbsp;tr&nbsp;roff&nbsp;</td></tr>
 * <tr><td>application/x-troff-man</td><td>man&nbsp;</td></tr>
 * <tr><td>application/x-troff-me</td><td>me&nbsp;</td></tr>
 * <tr><td>application/x-troff-ms</td><td>ms&nbsp;</td></tr>
 * <tr><td>application/x-ustar</td><td>ustar&nbsp;</td></tr>
 * <tr><td>application/x-wais-source</td><td>src&nbsp;</td></tr>
 * <tr><td>application/x-wingz</td><td>wz&nbsp;</td></tr>
 * <tr><td>application/x-x509-ca-cert</td><td>crt&nbsp;</td></tr>
 * <tr><td>application/x-xcf</td><td>xcf&nbsp;</td></tr>
 * <tr><td>application/x-xfig</td><td>fig&nbsp;</td></tr>
 * <tr><td>application/x-xpinstall</td><td>xpi&nbsp;</td></tr>
 * <tr><td>audio/basic</td><td>au&nbsp;snd&nbsp;</td></tr>
 * <tr><td>audio/midi</td><td>mid&nbsp;midi&nbsp;kar&nbsp;</td></tr>
 * <tr><td>audio/mpeg</td><td>mpga&nbsp;mpega&nbsp;mp2&nbsp;mp3&nbsp;m4a&nbsp;</td></tr>
 * <tr><td>audio/mpegurl</td><td>m3u&nbsp;</td></tr>
 * <tr><td>audio/ogg</td><td>oga&nbsp;spx&nbsp;</td></tr>
 * <tr><td>audio/prs.sid</td><td>sid&nbsp;</td></tr>
 * <tr><td>audio/x-aiff</td><td>aif&nbsp;aiff&nbsp;aifc&nbsp;</td></tr>
 * <tr><td>audio/x-gsm</td><td>gsm&nbsp;</td></tr>
 * <tr><td>audio/x-mpegurl</td><td>m3u&nbsp;</td></tr>
 * <tr><td>audio/x-ms-wma</td><td>wma&nbsp;</td></tr>
 * <tr><td>audio/x-ms-wax</td><td>wax&nbsp;</td></tr>
 * <tr><td>audio/x-pn-realaudio</td><td>ra&nbsp;rm&nbsp;ram&nbsp;</td></tr>
 * <tr><td>audio/x-realaudio</td><td>ra&nbsp;</td></tr>
 * <tr><td>audio/x-scpls</td><td>pls&nbsp;</td></tr>
 * <tr><td>audio/x-sd2</td><td>sd2&nbsp;</td></tr>
 * <tr><td>audio/x-wav</td><td>wav&nbsp;</td></tr>
 * <tr><td>chemical/x-alchemy</td><td>alc&nbsp;</td></tr>
 * <tr><td>chemical/x-cache</td><td>cac&nbsp;cache&nbsp;</td></tr>
 * <tr><td>chemical/x-cache-csf</td><td>csf&nbsp;</td></tr>
 * <tr><td>chemical/x-cactvs-binary</td><td>cbin&nbsp;cascii&nbsp;ctab&nbsp;</td></tr>
 * <tr><td>chemical/x-cdx</td><td>cdx&nbsp;</td></tr>
 * <tr><td>chemical/x-cerius</td><td>cer&nbsp;</td></tr>
 * <tr><td>chemical/x-chem3d</td><td>c3d&nbsp;</td></tr>
 * <tr><td>chemical/x-chemdraw</td><td>chm&nbsp;</td></tr>
 * <tr><td>chemical/x-cif</td><td>cif&nbsp;</td></tr>
 * <tr><td>chemical/x-cmdf</td><td>cmdf&nbsp;</td></tr>
 * <tr><td>chemical/x-cml</td><td>cml&nbsp;</td></tr>
 * <tr><td>chemical/x-compass</td><td>cpa&nbsp;</td></tr>
 * <tr><td>chemical/x-crossfire</td><td>bsd&nbsp;</td></tr>
 * <tr><td>chemical/x-csml</td><td>csml&nbsp;csm&nbsp;</td></tr>
 * <tr><td>chemical/x-ctx</td><td>ctx&nbsp;</td></tr>
 * <tr><td>chemical/x-cxf</td><td>cxf&nbsp;cef&nbsp;</td></tr>
 * <tr><td>chemical/x-embl-dl-nucleotide</td><td>emb&nbsp;embl&nbsp;</td></tr>
 * <tr><td>chemical/x-galactic-spc</td><td>spc&nbsp;</td></tr>
 * <tr><td>chemical/x-gamess-input</td><td>inp&nbsp;gam&nbsp;gamin&nbsp;</td></tr>
 * <tr><td>chemical/x-gaussian-checkpoint</td><td>fch&nbsp;fchk&nbsp;</td></tr>
 * <tr><td>chemical/x-gaussian-cube</td><td>cub&nbsp;</td></tr>
 * <tr><td>chemical/x-gaussian-input</td><td>gau&nbsp;gjc&nbsp;gjf&nbsp;</td></tr>
 * <tr><td>chemical/x-gaussian-log</td><td>gal&nbsp;</td></tr>
 * <tr><td>chemical/x-gcg8-sequence</td><td>gcg&nbsp;</td></tr>
 * <tr><td>chemical/x-genbank</td><td>gen&nbsp;</td></tr>
 * <tr><td>chemical/x-hin</td><td>hin&nbsp;</td></tr>
 * <tr><td>chemical/x-isostar</td><td>istr&nbsp;ist&nbsp;</td></tr>
 * <tr><td>chemical/x-jcamp-dx</td><td>jdx&nbsp;dx&nbsp;</td></tr>
 * <tr><td>chemical/x-kinemage</td><td>kin&nbsp;</td></tr>
 * <tr><td>chemical/x-macmolecule</td><td>mcm&nbsp;</td></tr>
 * <tr><td>chemical/x-macromodel-input</td><td>mmd&nbsp;mmod&nbsp;</td></tr>
 * <tr><td>chemical/x-mdl-molfile</td><td>mol&nbsp;</td></tr>
 * <tr><td>chemical/x-mdl-rdfile</td><td>rd&nbsp;</td></tr>
 * <tr><td>chemical/x-mdl-rxnfile</td><td>rxn&nbsp;</td></tr>
 * <tr><td>chemical/x-mdl-sdfile</td><td>sd&nbsp;sdf&nbsp;</td></tr>
 * <tr><td>chemical/x-mdl-tgf</td><td>tgf&nbsp;</td></tr>
 * <tr><td>chemical/x-mmcif</td><td>mcif&nbsp;</td></tr>
 * <tr><td>chemical/x-mol2</td><td>mol2&nbsp;</td></tr>
 * <tr><td>chemical/x-molconn-Z</td><td>b&nbsp;</td></tr>
 * <tr><td>chemical/x-mopac-graph</td><td>gpt&nbsp;</td></tr>
 * <tr><td>chemical/x-mopac-input</td><td>mop&nbsp;mopcrt&nbsp;mpc&nbsp;dat&nbsp;zmt&nbsp;</td></tr>
 * <tr><td>chemical/x-mopac-out</td><td>moo&nbsp;</td></tr>
 * <tr><td>chemical/x-mopac-vib</td><td>mvb&nbsp;</td></tr>
 * <tr><td>chemical/x-ncbi-asn1</td><td>asn&nbsp;</td></tr>
 * <tr><td>chemical/x-ncbi-asn1-ascii</td><td>prt&nbsp;ent&nbsp;</td></tr>
 * <tr><td>chemical/x-ncbi-asn1-binary</td><td>val&nbsp;aso&nbsp;</td></tr>
 * <tr><td>chemical/x-ncbi-asn1-spec</td><td>asn&nbsp;</td></tr>
 * <tr><td>chemical/x-pdb</td><td>pdb&nbsp;ent&nbsp;</td></tr>
 * <tr><td>chemical/x-rosdal</td><td>ros&nbsp;</td></tr>
 * <tr><td>chemical/x-swissprot</td><td>sw&nbsp;</td></tr>
 * <tr><td>chemical/x-vamas-iso14976</td><td>vms&nbsp;</td></tr>
 * <tr><td>chemical/x-vmd</td><td>vmd&nbsp;</td></tr>
 * <tr><td>chemical/x-xtel</td><td>xtel&nbsp;</td></tr>
 * <tr><td>chemical/x-xyz</td><td>xyz&nbsp;</td></tr>
 * <tr><td>image/gif</td><td>gif&nbsp;</td></tr>
 * <tr><td>image/ief</td><td>ief&nbsp;</td></tr>
 * <tr><td>image/jpeg</td><td>jpeg&nbsp;jpg&nbsp;jpe&nbsp;</td></tr>
 * <tr><td>image/pcx</td><td>pcx&nbsp;</td></tr>
 * <tr><td>image/png</td><td>png&nbsp;</td></tr>
 * <tr><td>image/svg+xml</td><td>svg&nbsp;svgz&nbsp;</td></tr>
 * <tr><td>image/tiff</td><td>tiff&nbsp;tif&nbsp;</td></tr>
 * <tr><td>image/vnd.djvu</td><td>djvu&nbsp;djv&nbsp;</td></tr>
 * <tr><td>image/vnd.wap.wbmp</td><td>wbmp&nbsp;</td></tr>
 * <tr><td>image/x-cmu-raster</td><td>ras&nbsp;</td></tr>
 * <tr><td>image/x-coreldraw</td><td>cdr&nbsp;</td></tr>
 * <tr><td>image/x-coreldrawpattern</td><td>pat&nbsp;</td></tr>
 * <tr><td>image/x-coreldrawtemplate</td><td>cdt&nbsp;</td></tr>
 * <tr><td>image/x-corelphotopaint</td><td>cpt&nbsp;</td></tr>
 * <tr><td>image/x-icon</td><td>ico&nbsp;</td></tr>
 * <tr><td>image/x-jg</td><td>art&nbsp;</td></tr>
 * <tr><td>image/x-jng</td><td>jng&nbsp;</td></tr>
 * <tr><td>image/x-ms-bmp</td><td>bmp&nbsp;</td></tr>
 * <tr><td>image/x-photoshop</td><td>psd&nbsp;</td></tr>
 * <tr><td>image/x-portable-anymap</td><td>pnm&nbsp;</td></tr>
 * <tr><td>image/x-portable-bitmap</td><td>pbm&nbsp;</td></tr>
 * <tr><td>image/x-portable-graymap</td><td>pgm&nbsp;</td></tr>
 * <tr><td>image/x-portable-pixmap</td><td>ppm&nbsp;</td></tr>
 * <tr><td>image/x-rgb</td><td>rgb&nbsp;</td></tr>
 * <tr><td>image/x-xbitmap</td><td>xbm&nbsp;</td></tr>
 * <tr><td>image/x-xpixmap</td><td>xpm&nbsp;</td></tr>
 * <tr><td>image/x-xwindowdump</td><td>xwd&nbsp;</td></tr>
 * <tr><td>message/rfc822</td><td>eml&nbsp;</td></tr>
 * <tr><td>model/iges</td><td>igs&nbsp;iges&nbsp;</td></tr>
 * <tr><td>model/mesh</td><td>msh&nbsp;mesh&nbsp;silo&nbsp;</td></tr>
 * <tr><td>model/vrml</td><td>wrl&nbsp;vrml&nbsp;</td></tr>
 * <tr><td>text/calendar</td><td>ics&nbsp;icz&nbsp;</td></tr>
 * <tr><td>text/css</td><td>css&nbsp;</td></tr>
 * <tr><td>text/csv</td><td>csv&nbsp;</td></tr>
 * <tr><td>text/h323</td><td>323&nbsp;</td></tr>
 * <tr><td>text/html</td><td>html&nbsp;htm&nbsp;shtml&nbsp;</td></tr>
 * <tr><td>text/iuls</td><td>uls&nbsp;</td></tr>
 * <tr><td>text/mathml</td><td>mml&nbsp;</td></tr>
 * <tr><td>text/plain</td><td>asc&nbsp;txt&nbsp;text&nbsp;pot&nbsp;</td></tr>
 * <tr><td>text/richtext</td><td>rtx&nbsp;</td></tr>
 * <tr><td>text/scriptlet</td><td>sct&nbsp;wsc&nbsp;</td></tr>
 * <tr><td>text/texmacs</td><td>tm&nbsp;ts&nbsp;</td></tr>
 * <tr><td>text/tab-separated-values</td><td>tsv&nbsp;</td></tr>
 * <tr><td>text/vnd.sun.j2me.app-descriptor</td><td>jad&nbsp;</td></tr>
 * <tr><td>text/vnd.wap.wml</td><td>wml&nbsp;</td></tr>
 * <tr><td>text/vnd.wap.wmlscript</td><td>wmls&nbsp;</td></tr>
 * <tr><td>text/x-bibtex</td><td>bib&nbsp;</td></tr>
 * <tr><td>text/x-boo</td><td>boo&nbsp;</td></tr>
 * <tr><td>text/x-c++hdr</td><td>h++&nbsp;hpp&nbsp;hxx&nbsp;hh&nbsp;</td></tr>
 * <tr><td>text/x-c++src</td><td>c++&nbsp;cpp&nbsp;cxx&nbsp;cc&nbsp;</td></tr>
 * <tr><td>text/x-chdr</td><td>h&nbsp;</td></tr>
 * <tr><td>text/x-component</td><td>htc&nbsp;</td></tr>
 * <tr><td>text/x-csh</td><td>csh&nbsp;</td></tr>
 * <tr><td>text/x-csrc</td><td>c&nbsp;</td></tr>
 * <tr><td>text/x-dsrc</td><td>d&nbsp;</td></tr>
 * <tr><td>text/x-diff</td><td>diff&nbsp;patch&nbsp;</td></tr>
 * <tr><td>text/x-haskell</td><td>hs&nbsp;</td></tr>
 * <tr><td>text/x-java</td><td>java&nbsp;</td></tr>
 * <tr><td>text/x-literate-haskell</td><td>lhs&nbsp;</td></tr>
 * <tr><td>text/x-moc</td><td>moc&nbsp;</td></tr>
 * <tr><td>text/x-pascal</td><td>p&nbsp;pas&nbsp;</td></tr>
 * <tr><td>text/x-pcs-gcd</td><td>gcd&nbsp;</td></tr>
 * <tr><td>text/x-perl</td><td>pl&nbsp;pm&nbsp;</td></tr>
 * <tr><td>text/x-python</td><td>py&nbsp;</td></tr>
 * <tr><td>text/x-setext</td><td>etx&nbsp;</td></tr>
 * <tr><td>text/x-sh</td><td>sh&nbsp;</td></tr>
 * <tr><td>text/x-tcl</td><td>tcl&nbsp;tk&nbsp;</td></tr>
 * <tr><td>text/x-tex</td><td>tex&nbsp;ltx&nbsp;sty&nbsp;cls&nbsp;</td></tr>
 * <tr><td>text/x-vcalendar</td><td>vcs&nbsp;</td></tr>
 * <tr><td>text/x-vcard</td><td>vcf&nbsp;</td></tr>
 * <tr><td>video/3gpp</td><td>3gp&nbsp;</td></tr>
 * <tr><td>video/dl</td><td>dl&nbsp;</td></tr>
 * <tr><td>video/dv</td><td>dif&nbsp;dv&nbsp;</td></tr>
 * <tr><td>video/fli</td><td>fli&nbsp;</td></tr>
 * <tr><td>video/gl</td><td>gl&nbsp;</td></tr>
 * <tr><td>video/mpeg</td><td>mpeg&nbsp;mpg&nbsp;mpe&nbsp;</td></tr>
 * <tr><td>video/mp4</td><td>mp4&nbsp;</td></tr>
 * <tr><td>video/ogg</td><td>ogv&nbsp;</td></tr>
 * <tr><td>video/quicktime</td><td>qt&nbsp;mov&nbsp;</td></tr>
 * <tr><td>video/vnd.mpegurl</td><td>mxu&nbsp;</td></tr>
 * <tr><td>video/x-la-asf</td><td>lsf&nbsp;lsx&nbsp;</td></tr>
 * <tr><td>video/x-mng</td><td>mng&nbsp;</td></tr>
 * <tr><td>video/x-ms-asf</td><td>asf&nbsp;asx&nbsp;</td></tr>
 * <tr><td>video/x-ms-wm</td><td>wm&nbsp;</td></tr>
 * <tr><td>video/x-ms-wmv</td><td>wmv&nbsp;</td></tr>
 * <tr><td>video/x-ms-wmx</td><td>wmx&nbsp;</td></tr>
 * <tr><td>video/x-ms-wvx</td><td>wvx&nbsp;</td></tr>
 * <tr><td>video/x-msvideo</td><td>avi&nbsp;</td></tr>
 * <tr><td>video/x-sgi-movie</td><td>movie&nbsp;</td></tr>
 * <tr><td>x-conference/x-cooltalk</td><td>ice&nbsp;</td></tr>
 * <tr><td>x-epoc/x-sisx-app</td><td>sisx&nbsp;</td></tr>
 * <tr><td>x-world/x-vrml</td><td>vrm&nbsp;vrml&nbsp;wrl&nbsp;</td></tr>
 * </table>
 */
public class MimeType {
	private static HashMap<String, String>	map = new HashMap<String, String>();
	private static HashMap<String, HashMap<String, String[]>>	rev = new HashMap<String, HashMap<String, String[]>>();
	static {
set_rev("application","andrew-inset",new String[]{"ez"});
set_rev("application","atom",new String[]{"atom"});
set_rev("application","atomcat+xml",new String[]{"atomcat"});
set_rev("application","atomserv+xml",new String[]{"atomsrv"});
set_rev("application","cap",new String[]{"cap","pcap"});
set_rev("application","cu-seeme",new String[]{"cu"});
set_rev("application","dsptype",new String[]{"tsp"});
set_rev("application","futuresplash",new String[]{"spl"});
set_rev("application","hta",new String[]{"hta"});
set_rev("application","java-archive",new String[]{"jar"});
set_rev("application","java-serialized-object",new String[]{"ser"});
set_rev("application","java-vm",new String[]{"class"});
set_rev("application","mac-binhex40",new String[]{"hqx"});
set_rev("application","mac-compactpro",new String[]{"cpt"});
set_rev("application","mathematica",new String[]{"nb"});
set_rev("application","msaccess",new String[]{"mdb"});
set_rev("application","msword",new String[]{"doc","dot"});
set_rev("application","octet-stream",new String[]{"bin"});
set_rev("application","oda",new String[]{"oda"});
set_rev("application","ogg",new String[]{"ogg","ogx"});
set_rev("application","pdf",new String[]{"pdf"});
set_rev("application","pgp-keys",new String[]{"key"});
set_rev("application","pgp-signature",new String[]{"pgp"});
set_rev("application","pics-rules",new String[]{"prf"});
set_rev("application","postscript",new String[]{"ps","ai","eps"});
set_rev("application","rar",new String[]{"rar"});
set_rev("application","rdf+xml",new String[]{"rdf"});
set_rev("application","rss+xml",new String[]{"rss"});
set_rev("application","rtf",new String[]{"rtf"});
set_rev("application","smil",new String[]{"smi","smil"});
set_rev("application","wordperfect",new String[]{"wpd"});
set_rev("application","wordperfect5.1",new String[]{"wp5"});
set_rev("application","xhtml+xml",new String[]{"xhtml","xht"});
set_rev("application","xml",new String[]{"xml","xsl"});
set_rev("application","zip",new String[]{"zip"});
set_rev("application","vnd.cinderella",new String[]{"cdy"});
set_rev("application","vnd.google-earth.kml+xml",new String[]{"kml"});
set_rev("application","vnd.google-earth.kmz",new String[]{"kmz"});
set_rev("application","vnd.mozilla.xul+xml",new String[]{"xul"});
set_rev("application","vnd.ms-excel",new String[]{"xls","xlb","xlt"});
set_rev("application","vnd.ms-pki.seccat",new String[]{"cat"});
set_rev("application","vnd.ms-pki.stl",new String[]{"stl"});
set_rev("application","vnd.ms-powerpoint",new String[]{"ppt","pps"});
set_rev("application","vnd.oasis.opendocument.chart",new String[]{"odc"});
set_rev("application","vnd.oasis.opendocument.database",new String[]{"odb"});
set_rev("application","vnd.oasis.opendocument.formula",new String[]{"odf"});
set_rev("application","vnd.oasis.opendocument.graphics",new String[]{"odg"});
set_rev("application","vnd.oasis.opendocument.graphics-template",new String[]{"otg"});
set_rev("application","vnd.oasis.opendocument.image",new String[]{"odi"});
set_rev("application","vnd.oasis.opendocument.presentation",new String[]{"odp"});
set_rev("application","vnd.oasis.opendocument.presentation-template",new String[]{"otp"});
set_rev("application","vnd.oasis.opendocument.spreadsheet",new String[]{"ods"});
set_rev("application","vnd.oasis.opendocument.spreadsheet-template",new String[]{"ots"});
set_rev("application","vnd.oasis.opendocument.text",new String[]{"odt"});
set_rev("application","vnd.oasis.opendocument.text-master",new String[]{"odm"});
set_rev("application","vnd.oasis.opendocument.text-template",new String[]{"ott"});
set_rev("application","vnd.oasis.opendocument.text-web",new String[]{"oth"});
set_rev("application","vnd.rim.cod",new String[]{"cod"});
set_rev("application","vnd.smaf",new String[]{"mmf"});
set_rev("application","vnd.stardivision.calc",new String[]{"sdc"});
set_rev("application","vnd.stardivision.chart",new String[]{"sds"});
set_rev("application","vnd.stardivision.draw",new String[]{"sda"});
set_rev("application","vnd.stardivision.impress",new String[]{"sdd"});
set_rev("application","vnd.stardivision.math",new String[]{"sdf"});
set_rev("application","vnd.stardivision.writer",new String[]{"sdw"});
set_rev("application","vnd.stardivision.writer-global",new String[]{"sgl"});
set_rev("application","vnd.sun.xml.calc",new String[]{"sxc"});
set_rev("application","vnd.sun.xml.calc.template",new String[]{"stc"});
set_rev("application","vnd.sun.xml.draw",new String[]{"sxd"});
set_rev("application","vnd.sun.xml.draw.template",new String[]{"std"});
set_rev("application","vnd.sun.xml.impress",new String[]{"sxi"});
set_rev("application","vnd.sun.xml.impress.template",new String[]{"sti"});
set_rev("application","vnd.sun.xml.math",new String[]{"sxm"});
set_rev("application","vnd.sun.xml.writer",new String[]{"sxw"});
set_rev("application","vnd.sun.xml.writer.global",new String[]{"sxg"});
set_rev("application","vnd.sun.xml.writer.template",new String[]{"stw"});
set_rev("application","vnd.symbian.install",new String[]{"sis"});
set_rev("application","vnd.visio",new String[]{"vsd"});
set_rev("application","vnd.wap.wbxml",new String[]{"wbxml"});
set_rev("application","vnd.wap.wmlc",new String[]{"wmlc"});
set_rev("application","vnd.wap.wmlscriptc",new String[]{"wmlsc"});
set_rev("application","x-123",new String[]{"wk"});
set_rev("application","x-7z-compressed",new String[]{"7z"});
set_rev("application","x-abiword",new String[]{"abw"});
set_rev("application","x-apple-diskimage",new String[]{"dmg"});
set_rev("application","x-bcpio",new String[]{"bcpio"});
set_rev("application","x-bittorrent",new String[]{"torrent"});
set_rev("application","x-cab",new String[]{"cab"});
set_rev("application","x-cbr",new String[]{"cbr"});
set_rev("application","x-cbz",new String[]{"cbz"});
set_rev("application","x-cdf",new String[]{"cdf"});
set_rev("application","x-cdlink",new String[]{"vcd"});
set_rev("application","x-chess-pgn",new String[]{"pgn"});
set_rev("application","x-cpio",new String[]{"cpio"});
set_rev("application","x-csh",new String[]{"csh"});
set_rev("application","x-debian-package",new String[]{"deb","udeb"});
set_rev("application","x-director",new String[]{"dcr","dir","dxr"});
set_rev("application","x-dms",new String[]{"dms"});
set_rev("application","x-doom",new String[]{"wad"});
set_rev("application","x-dvi",new String[]{"dvi"});
set_rev("application","x-httpd-eruby",new String[]{"rhtml"});
set_rev("application","x-flac",new String[]{"flac"});
set_rev("application","x-font",new String[]{"pfa","pfb","gsf","pcf","pcf.Z"});
set_rev("application","x-freemind",new String[]{"mm"});
set_rev("application","x-futuresplash",new String[]{"spl"});
set_rev("application","x-gnumeric",new String[]{"gnumeric"});
set_rev("application","x-go-sgf",new String[]{"sgf"});
set_rev("application","x-graphing-calculator",new String[]{"gcf"});
set_rev("application","x-gtar",new String[]{"gtar","tgz","taz"});
set_rev("application","x-hdf",new String[]{"hdf"});
set_rev("application","x-httpd-php",new String[]{"phtml","pht","php"});
set_rev("application","x-httpd-php-source",new String[]{"phps"});
set_rev("application","x-httpd-php3",new String[]{"php3"});
set_rev("application","x-httpd-php3-preprocessed",new String[]{"php3p"});
set_rev("application","x-httpd-php4",new String[]{"php4"});
set_rev("application","x-ica",new String[]{"ica"});
set_rev("application","x-internet-signup",new String[]{"ins","isp"});
set_rev("application","x-iphone",new String[]{"iii"});
set_rev("application","x-iso9660-image",new String[]{"iso"});
set_rev("application","x-java-jnlp-file",new String[]{"jnlp"});
set_rev("application","x-javascript",new String[]{"js"});
set_rev("application","x-jmol",new String[]{"jmz"});
set_rev("application","x-kchart",new String[]{"chrt"});
set_rev("application","x-killustrator",new String[]{"kil"});
set_rev("application","x-koan",new String[]{"skp","skd","skt","skm"});
set_rev("application","x-kpresenter",new String[]{"kpr","kpt"});
set_rev("application","x-kspread",new String[]{"ksp"});
set_rev("application","x-kword",new String[]{"kwd","kwt"});
set_rev("application","x-latex",new String[]{"latex"});
set_rev("application","x-lha",new String[]{"lha"});
set_rev("application","x-lyx",new String[]{"lyx"});
set_rev("application","x-lzh",new String[]{"lzh"});
set_rev("application","x-lzx",new String[]{"lzx"});
set_rev("application","x-maker",new String[]{"frm","maker","frame","fm","fb","book","fbdoc"});
set_rev("application","x-mif",new String[]{"mif"});
set_rev("application","x-ms-wmd",new String[]{"wmd"});
set_rev("application","x-ms-wmz",new String[]{"wmz"});
set_rev("application","x-msdos-program",new String[]{"com","exe","bat","dll"});
set_rev("application","x-msi",new String[]{"msi"});
set_rev("application","x-netcdf",new String[]{"nc"});
set_rev("application","x-ns-proxy-autoconfig",new String[]{"pac"});
set_rev("application","x-nwc",new String[]{"nwc"});
set_rev("application","x-object",new String[]{"o"});
set_rev("application","x-oz-application",new String[]{"oza"});
set_rev("application","x-pkcs7-certreqresp",new String[]{"p7r"});
set_rev("application","x-pkcs7-crl",new String[]{"crl"});
set_rev("application","x-python-code",new String[]{"pyc","pyo"});
set_rev("application","x-quicktimeplayer",new String[]{"qtl"});
set_rev("application","x-redhat-package-manager",new String[]{"rpm"});
set_rev("application","x-sh",new String[]{"sh"});
set_rev("application","x-shar",new String[]{"shar"});
set_rev("application","x-shockwave-flash",new String[]{"swf","swfl"});
set_rev("application","x-stuffit",new String[]{"sit","sitx"});
set_rev("application","x-sv4cpio",new String[]{"sv4cpio"});
set_rev("application","x-sv4crc",new String[]{"sv4crc"});
set_rev("application","x-tar",new String[]{"tar"});
set_rev("application","x-tcl",new String[]{"tcl"});
set_rev("application","x-tex-gf",new String[]{"gf"});
set_rev("application","x-tex-pk",new String[]{"pk"});
set_rev("application","x-texinfo",new String[]{"texinfo","texi"});
set_rev("application","x-trash",new String[]{"~","%","bak","old","sik"});
set_rev("application","x-troff",new String[]{"t","tr","roff"});
set_rev("application","x-troff-man",new String[]{"man"});
set_rev("application","x-troff-me",new String[]{"me"});
set_rev("application","x-troff-ms",new String[]{"ms"});
set_rev("application","x-ustar",new String[]{"ustar"});
set_rev("application","x-wais-source",new String[]{"src"});
set_rev("application","x-wingz",new String[]{"wz"});
set_rev("application","x-x509-ca-cert",new String[]{"crt"});
set_rev("application","x-xcf",new String[]{"xcf"});
set_rev("application","x-xfig",new String[]{"fig"});
set_rev("application","x-xpinstall",new String[]{"xpi"});
set_rev("audio","basic",new String[]{"au","snd"});
set_rev("audio","midi",new String[]{"mid","midi","kar"});
set_rev("audio","mpeg",new String[]{"mpga","mpega","mp2","mp3","m4a"});
set_rev("audio","mpegurl",new String[]{"m3u"});
set_rev("audio","ogg",new String[]{"oga","spx"});
set_rev("audio","prs.sid",new String[]{"sid"});
set_rev("audio","x-aiff",new String[]{"aif","aiff","aifc"});
set_rev("audio","x-gsm",new String[]{"gsm"});
set_rev("audio","x-mpegurl",new String[]{"m3u"});
set_rev("audio","x-ms-wma",new String[]{"wma"});
set_rev("audio","x-ms-wax",new String[]{"wax"});
set_rev("audio","x-pn-realaudio",new String[]{"ra","rm","ram"});
set_rev("audio","x-realaudio",new String[]{"ra"});
set_rev("audio","x-scpls",new String[]{"pls"});
set_rev("audio","x-sd2",new String[]{"sd2"});
set_rev("audio","x-wav",new String[]{"wav"});
set_rev("chemical","x-alchemy",new String[]{"alc"});
set_rev("chemical","x-cache",new String[]{"cac","cache"});
set_rev("chemical","x-cache-csf",new String[]{"csf"});
set_rev("chemical","x-cactvs-binary",new String[]{"cbin","cascii","ctab"});
set_rev("chemical","x-cdx",new String[]{"cdx"});
set_rev("chemical","x-cerius",new String[]{"cer"});
set_rev("chemical","x-chem3d",new String[]{"c3d"});
set_rev("chemical","x-chemdraw",new String[]{"chm"});
set_rev("chemical","x-cif",new String[]{"cif"});
set_rev("chemical","x-cmdf",new String[]{"cmdf"});
set_rev("chemical","x-cml",new String[]{"cml"});
set_rev("chemical","x-compass",new String[]{"cpa"});
set_rev("chemical","x-crossfire",new String[]{"bsd"});
set_rev("chemical","x-csml",new String[]{"csml","csm"});
set_rev("chemical","x-ctx",new String[]{"ctx"});
set_rev("chemical","x-cxf",new String[]{"cxf","cef"});
set_rev("chemical","x-embl-dl-nucleotide",new String[]{"emb","embl"});
set_rev("chemical","x-galactic-spc",new String[]{"spc"});
set_rev("chemical","x-gamess-input",new String[]{"inp","gam","gamin"});
set_rev("chemical","x-gaussian-checkpoint",new String[]{"fch","fchk"});
set_rev("chemical","x-gaussian-cube",new String[]{"cub"});
set_rev("chemical","x-gaussian-input",new String[]{"gau","gjc","gjf"});
set_rev("chemical","x-gaussian-log",new String[]{"gal"});
set_rev("chemical","x-gcg8-sequence",new String[]{"gcg"});
set_rev("chemical","x-genbank",new String[]{"gen"});
set_rev("chemical","x-hin",new String[]{"hin"});
set_rev("chemical","x-isostar",new String[]{"istr","ist"});
set_rev("chemical","x-jcamp-dx",new String[]{"jdx","dx"});
set_rev("chemical","x-kinemage",new String[]{"kin"});
set_rev("chemical","x-macmolecule",new String[]{"mcm"});
set_rev("chemical","x-macromodel-input",new String[]{"mmd","mmod"});
set_rev("chemical","x-mdl-molfile",new String[]{"mol"});
set_rev("chemical","x-mdl-rdfile",new String[]{"rd"});
set_rev("chemical","x-mdl-rxnfile",new String[]{"rxn"});
set_rev("chemical","x-mdl-sdfile",new String[]{"sd","sdf"});
set_rev("chemical","x-mdl-tgf",new String[]{"tgf"});
set_rev("chemical","x-mmcif",new String[]{"mcif"});
set_rev("chemical","x-mol2",new String[]{"mol2"});
set_rev("chemical","x-molconn-Z",new String[]{"b"});
set_rev("chemical","x-mopac-graph",new String[]{"gpt"});
set_rev("chemical","x-mopac-input",new String[]{"mop","mopcrt","mpc","dat","zmt"});
set_rev("chemical","x-mopac-out",new String[]{"moo"});
set_rev("chemical","x-mopac-vib",new String[]{"mvb"});
set_rev("chemical","x-ncbi-asn1",new String[]{"asn"});
set_rev("chemical","x-ncbi-asn1-ascii",new String[]{"prt","ent"});
set_rev("chemical","x-ncbi-asn1-binary",new String[]{"val","aso"});
set_rev("chemical","x-ncbi-asn1-spec",new String[]{"asn"});
set_rev("chemical","x-pdb",new String[]{"pdb","ent"});
set_rev("chemical","x-rosdal",new String[]{"ros"});
set_rev("chemical","x-swissprot",new String[]{"sw"});
set_rev("chemical","x-vamas-iso14976",new String[]{"vms"});
set_rev("chemical","x-vmd",new String[]{"vmd"});
set_rev("chemical","x-xtel",new String[]{"xtel"});
set_rev("chemical","x-xyz",new String[]{"xyz"});
set_rev("image","gif",new String[]{"gif"});
set_rev("image","ief",new String[]{"ief"});
set_rev("image","jpeg",new String[]{"jpeg","jpg","jpe"});
set_rev("image","pcx",new String[]{"pcx"});
set_rev("image","png",new String[]{"png"});
set_rev("image","svg+xml",new String[]{"svg","svgz"});
set_rev("image","tiff",new String[]{"tiff","tif"});
set_rev("image","vnd.djvu",new String[]{"djvu","djv"});
set_rev("image","vnd.wap.wbmp",new String[]{"wbmp"});
set_rev("image","x-cmu-raster",new String[]{"ras"});
set_rev("image","x-coreldraw",new String[]{"cdr"});
set_rev("image","x-coreldrawpattern",new String[]{"pat"});
set_rev("image","x-coreldrawtemplate",new String[]{"cdt"});
set_rev("image","x-corelphotopaint",new String[]{"cpt"});
set_rev("image","x-icon",new String[]{"ico"});
set_rev("image","x-jg",new String[]{"art"});
set_rev("image","x-jng",new String[]{"jng"});
set_rev("image","x-ms-bmp",new String[]{"bmp"});
set_rev("image","x-photoshop",new String[]{"psd"});
set_rev("image","x-portable-anymap",new String[]{"pnm"});
set_rev("image","x-portable-bitmap",new String[]{"pbm"});
set_rev("image","x-portable-graymap",new String[]{"pgm"});
set_rev("image","x-portable-pixmap",new String[]{"ppm"});
set_rev("image","x-rgb",new String[]{"rgb"});
set_rev("image","x-xbitmap",new String[]{"xbm"});
set_rev("image","x-xpixmap",new String[]{"xpm"});
set_rev("image","x-xwindowdump",new String[]{"xwd"});
set_rev("message","rfc822",new String[]{"eml"});
set_rev("model","iges",new String[]{"igs","iges"});
set_rev("model","mesh",new String[]{"msh","mesh","silo"});
set_rev("model","vrml",new String[]{"wrl","vrml"});
set_rev("text","calendar",new String[]{"ics","icz"});
set_rev("text","css",new String[]{"css"});
set_rev("text","csv",new String[]{"csv"});
set_rev("text","h323",new String[]{"323"});
set_rev("text","html",new String[]{"html","htm","shtml"});
set_rev("text","iuls",new String[]{"uls"});
set_rev("text","mathml",new String[]{"mml"});
set_rev("text","plain",new String[]{"asc","txt","text","pot"});
set_rev("text","richtext",new String[]{"rtx"});
set_rev("text","scriptlet",new String[]{"sct","wsc"});
set_rev("text","texmacs",new String[]{"tm","ts"});
set_rev("text","tab-separated-values",new String[]{"tsv"});
set_rev("text","vnd.sun.j2me.app-descriptor",new String[]{"jad"});
set_rev("text","vnd.wap.wml",new String[]{"wml"});
set_rev("text","vnd.wap.wmlscript",new String[]{"wmls"});
set_rev("text","x-bibtex",new String[]{"bib"});
set_rev("text","x-boo",new String[]{"boo"});
set_rev("text","x-c++hdr",new String[]{"h++","hpp","hxx","hh"});
set_rev("text","x-c++src",new String[]{"c++","cpp","cxx","cc"});
set_rev("text","x-chdr",new String[]{"h"});
set_rev("text","x-component",new String[]{"htc"});
set_rev("text","x-csh",new String[]{"csh"});
set_rev("text","x-csrc",new String[]{"c"});
set_rev("text","x-dsrc",new String[]{"d"});
set_rev("text","x-diff",new String[]{"diff","patch"});
set_rev("text","x-haskell",new String[]{"hs"});
set_rev("text","x-java",new String[]{"java"});
set_rev("text","x-literate-haskell",new String[]{"lhs"});
set_rev("text","x-moc",new String[]{"moc"});
set_rev("text","x-pascal",new String[]{"p","pas"});
set_rev("text","x-pcs-gcd",new String[]{"gcd"});
set_rev("text","x-perl",new String[]{"pl","pm"});
set_rev("text","x-python",new String[]{"py"});
set_rev("text","x-setext",new String[]{"etx"});
set_rev("text","x-sh",new String[]{"sh"});
set_rev("text","x-tcl",new String[]{"tcl","tk"});
set_rev("text","x-tex",new String[]{"tex","ltx","sty","cls"});
set_rev("text","x-vcalendar",new String[]{"vcs"});
set_rev("text","x-vcard",new String[]{"vcf"});
set_rev("video","3gpp",new String[]{"3gp"});
set_rev("video","dl",new String[]{"dl"});
set_rev("video","dv",new String[]{"dif","dv"});
set_rev("video","fli",new String[]{"fli"});
set_rev("video","gl",new String[]{"gl"});
set_rev("video","mpeg",new String[]{"mpeg","mpg","mpe"});
set_rev("video","mp4",new String[]{"mp4"});
set_rev("video","ogg",new String[]{"ogv"});
set_rev("video","quicktime",new String[]{"qt","mov"});
set_rev("video","vnd.mpegurl",new String[]{"mxu"});
set_rev("video","x-la-asf",new String[]{"lsf","lsx"});
set_rev("video","x-mng",new String[]{"mng"});
set_rev("video","x-ms-asf",new String[]{"asf","asx"});
set_rev("video","x-ms-wm",new String[]{"wm"});
set_rev("video","x-ms-wmv",new String[]{"wmv"});
set_rev("video","x-ms-wmx",new String[]{"wmx"});
set_rev("video","x-ms-wvx",new String[]{"wvx"});
set_rev("video","x-msvideo",new String[]{"avi"});
set_rev("video","x-sgi-movie",new String[]{"movie"});
set_rev("x-conference","x-cooltalk",new String[]{"ice"});
set_rev("x-epoc","x-sisx-app",new String[]{"sisx"});
set_rev("x-world","x-vrml",new String[]{"vrm","vrml","wrl"});
	}

	private MimeType(){}

	private static void set_rev( String cat, String type, String[] ext ) {
		HashMap<String, String[]>	sub = rev.get( cat );
		if ( sub == null ) {
			sub = new HashMap<String, String[]>();
			rev.put( cat, sub );
		}
		sub.put( type, ext );

		StringBuilder	buf = new StringBuilder( cat );
		buf = buf.append( "/" );
		buf = buf.append( type );
		type = buf.toString();
		for ( int i = 0; i < ext.length; i++ ) {
			map.put( ext[i], type );
		}
	}

	/**
	 * MIME Media Type の取得。拡張子から判定します。
	 * @param file ファイル名。
	 * @return MIME Media Type。
	 * 未知の拡張子であれば application/octet-stream を返します。
	 */
	public static String getMimeType( String file ) {
		String[]	ext = file.split( "\\." );
		String	seek = ext[ext.length - 1].toLowerCase( Locale.ENGLISH );
		String	ret = map.get( seek );
		if ( ret == null )	return "application/octet-stream";
		return ret;
	}

	/**
	 * MIME Media Type の取得。拡張子から判定します。
	 * @param file ファイル名。
	 * @return MIME Media Type。
	 * 未知の拡張子であれば application/octet-stream を返します。
	 */
	public static String getMimeType( File file ) {
		return getMimeType( file.getName() );
	}

	/**
	 * 拡張子の取得。<br>
	 * 例えば、image/gif を指定すると、GIF画像フォーマットの拡張子を返します。<br>
	 * image を指定すると、画像カテゴリの全ての拡張子を返します。
	 * @param mime MIME Media Type。
	 * @return 拡張子。未知の MIME Media Type であると null。
	 */
	public static String[] getExtension( String mime ) {
		String[]	type = mime.split( "/" );
		HashMap<String, String[]>	sub = rev.get( type[0] );
		if ( sub == null )	return null;
		if ( type.length > 1 ) {
			return sub.get( type[1] );
		}
		ArrayList<String>	list = new ArrayList<String>();
		for ( String key: sub.keySet() ) {
			String[]	ext = sub.get( key );
			for ( int i = 0; i < ext.length; i++ ) {
				list.add( ext[i] );
			}
		}
		return list.toArray( new String[0] );
	}
}

