/*
 * Decompiled with CFR 0.152.
 */
package paraselene.supervisor;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import paraselene.Page;
import paraselene.ajax.Ajax;
import paraselene.supervisor.CometHolder;
import paraselene.supervisor.Daemon;
import paraselene.supervisor.DaemonChannel;
import paraselene.supervisor.DaemonForward;
import paraselene.supervisor.Forward;
import paraselene.supervisor.History;
import paraselene.supervisor.KilledByTimeoutException;
import paraselene.supervisor.Option;
import paraselene.supervisor.PageFactory;
import paraselene.supervisor.PageID;
import paraselene.supervisor.RequestParameter;
import paraselene.supervisor.SandBox;
import paraselene.tag.Tag;
import paraselene.ui.PageBypassedDiv;
import paraselene.ui.PageHooker;

class Child
extends Thread
implements DaemonChannel {
    static volatile HashMap<String, Child> name_space = new HashMap();
    volatile Thread parent = null;
    Date start_dt;
    volatile PageFactory factory = null;
    volatile Page main_page = null;
    volatile boolean call_input;
    volatile boolean refresh_f;
    volatile RequestParameter request = null;
    volatile Forward forward = null;
    volatile Page param_page = null;
    volatile Throwable th = null;
    volatile long thread_id = -1L;
    volatile Daemon daemon = null;
    volatile String daemon_name = null;
    volatile ArrayList<History> hist = null;
    volatile Date limit_dt = null;
    volatile KilledByTimeoutException kbt = null;

    Child() {
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addHistory(History h) {
        ArrayList<History> arrayList = this.hist;
        synchronized (arrayList) {
            if (this.hist.contains(h)) {
                return;
            }
            this.hist.add(h);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeHistory(History h) {
        try {
            h.lock();
            ArrayList<History> arrayList = this.hist;
            synchronized (arrayList) {
                this.hist.remove(h);
            }
        }
        finally {
            h.unlock();
        }
    }

    @Override
    public String getDaemonName() {
        return this.daemon_name;
    }

    @Override
    public void startDaemon(String name, Daemon daemon) {
        SandBox.startDaemon(name, daemon);
    }

    @Override
    public void depriveDaemonOfPage() {
        SandBox.depriveDaemonOfPage();
    }

    @Override
    public Object postDaemon(String name, Object obj) {
        return SandBox.postDaemon(name, obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryLockPageForUpdate() {
        if (this.hist == null) {
            return true;
        }
        ArrayList<History> arrayList = this.hist;
        synchronized (arrayList) {
            History h;
            int i;
            int cnt = this.hist.size();
            boolean ret = true;
            for (i = 0; i < cnt && (ret = (h = this.hist.get(i)).tryLock()); ++i) {
            }
            if (ret) {
                return ret;
            }
            for (i = 0; i < cnt; ++i) {
                h = this.hist.get(i);
                h.unlock();
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Page[] getPageForUpdate() {
        if (this.hist == null) {
            return this.request.getHistory().getBrowsingPage();
        }
        ArrayList<History> arrayList = this.hist;
        synchronized (arrayList) {
            int i;
            ArrayList<Page> list = new ArrayList<Page>();
            int cnt = this.hist.size();
            ArrayList<History> drop = new ArrayList<History>();
            for (i = 0; i < cnt; ++i) {
                History h = this.hist.get(i);
                if (h.drop_f) {
                    drop.add(h);
                    continue;
                }
                Page[] p = h.getBrowsingPage();
                for (int j = 0; j < p.length; ++j) {
                    list.add(p[j]);
                }
            }
            cnt = drop.size();
            for (i = 0; i < cnt; ++i) {
                this.hist.remove(drop.get(i));
            }
            return list.toArray(new Page[0]);
        }
    }

    @Override
    public Page[] getPageForUpdate(PageID ... id) {
        Page[] page = this.getPageForUpdate();
        ArrayList<Page> ret = new ArrayList<Page>();
        block0: for (int i = 0; i < page.length; ++i) {
            PageID p = page[i].getID();
            for (int j = 0; j < id.length; ++j) {
                if (id[j] != p) continue;
                ret.add(page[i]);
                continue block0;
            }
        }
        return ret.toArray(new Page[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commitPage(DaemonForward ... fw) {
        if (this.hist == null) {
            return;
        }
        ArrayList<History> arrayList = this.hist;
        synchronized (arrayList) {
            int cnt = this.hist.size();
            for (int i = 0; i < cnt; ++i) {
                History h = this.hist.get(i);
                Page[] p = h.getBrowsingPage();
                for (int j = 0; j < p.length; ++j) {
                    for (int fw_i = 0; fw_i < fw.length; ++fw_i) {
                        if (fw[fw_i].page != p[j]) continue;
                        CometHolder ch = new CometHolder(this.factory, h, fw[fw_i].forward);
                        try {
                            Ajax.addComet(h.session_id, ch.getPostBack());
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                }
                h.unlock();
            }
        }
    }

    @Override
    public void delayTimeout() {
        Date now = new Date();
        this.limit_dt = new Date(now.getTime() + 1800000L);
    }

    private static Forward fix(Forward old_fw, Forward new_fw) {
        Option.trace("old_fw=%s / new_fw=%s", old_fw, new_fw);
        if (new_fw == null || old_fw == new_fw) {
            return old_fw;
        }
        if (old_fw == null) {
            return new_fw;
        }
        if (old_fw.isAjax()) {
            return Forward.merge(old_fw, new_fw);
        }
        return new_fw;
    }

    private static Forward input(Page page, RequestParameter req, Forward fw) throws Throwable {
        if (page == null) {
            return fw;
        }
        PageHooker[] hook = page.getPageHooker();
        History hist = req.getHistory(page.getHistoryKey());
        try {
            for (int i = 0; i < hook.length; ++i) {
                fw = Child.fix(fw, hist.returnStack(hook[i].beforeInput(page, req, fw), false));
                if (!hist.drop_f) continue;
                throw new HistoryDroped();
            }
            fw = Child.fix(fw, hist.returnStack(page.input(req, fw), false));
            fw = hist.returnStack(fw, true);
            if (hist.drop_f) {
                throw new HistoryDroped();
            }
        }
        catch (HistoryDroped hd) {
            throw hd;
        }
        catch (Throwable e) {
            if (hist.drop_f) {
                throw new HistoryDroped();
            }
            throw e;
        }
        return fw;
    }

    private static Page output(Page page, Page from, RequestParameter req, boolean new_f) throws Exception {
        Tag body;
        if (page == null) {
            return null;
        }
        Page old = page;
        page.beginning(req, null);
        page = page.output(from, req);
        if (page == null) {
            page = old;
        }
        if ((body = page.getBodyTag()) != null && body.isModified()) {
            new_f = true;
        }
        PageBypassedDiv[] div = page.getPageBypassedDiv();
        for (int i = 0; i < div.length; ++i) {
            boolean div_new = div[i].isModified();
            div[i].setView(Child.output(div[i].getBypassPage(), from, req, div_new));
        }
        PageHooker[] hook = page.getPageHooker();
        if (page.isAjax() && !new_f) {
            int i;
            Tag[] t = page.getModifiedTag();
            ArrayList<PageHooker> list = new ArrayList<PageHooker>();
            for (i = 0; i < t.length; ++i) {
                PageHooker[] tmp = t[i].getInnerHTMLPart(hook);
                for (int j = 0; j < tmp.length; ++j) {
                    list.add(tmp[j]);
                }
            }
            for (i = 0; i < hook.length; ++i) {
                if (!(hook[i] instanceof PageBypassedDiv)) continue;
                list.add(hook[i]);
            }
            hook = list.toArray(new PageHooker[0]);
        }
        for (int i = 0; i < hook.length; ++i) {
            hook[i].afterOutput(from, old, req);
        }
        if (old != page) {
            old.resetOnLoadScript();
        }
        return page;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void userFunction() {
        History hist = null;
        if (this.main_page == null) {
            return;
        }
        try {
            try {
                hist = this.request.getHistory();
                if (hist != null) {
                    hist.lock();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (this.main_page.getAjaxSupport() == Page.AjaxSupport.SERVER_PUSH) {
                Ajax.entryComet("paraselene_comet");
            }
            if (this.call_input) {
                this.forward = Child.input(this.main_page, this.request, this.forward);
            } else {
                this.param_page = Child.output(this.main_page, this.param_page, this.request, this.refresh_f);
            }
        }
        catch (Throwable e) {
            this.th = e;
        }
        finally {
            if (hist != null) {
                hist.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void daemonFunction() {
        if (this.daemon == null) {
            return;
        }
        try {
            this.daemon.run(this);
        }
        catch (Throwable e) {
            this.th = e;
        }
        this.commitPage(new DaemonForward[0]);
        if (this.kbt != null) {
            this.th = this.kbt;
        }
        try {
            if (this.th != null) {
                this.th.printStackTrace();
            }
            this.daemon.onDestroy(this.th);
        }
        finally {
            Cloneable cloneable;
            if (this.daemon_name != null) {
                cloneable = name_space;
                synchronized (cloneable) {
                    name_space.remove(this.daemon_name);
                }
            }
            if (this.hist != null) {
                cloneable = this.hist;
                synchronized (cloneable) {
                    int cnt = this.hist.size();
                    for (int i = 0; i < cnt; ++i) {
                        this.hist.get(i).unlock();
                    }
                }
            }
            SandBox.removeChild(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.thread_id = Thread.currentThread().getId();
        try {
            Child child = this;
            synchronized (child) {
                this.wait();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.main_page != null) {
            this.userFunction();
        } else {
            this.daemonFunction();
        }
    }

    static class HistoryDroped
    extends Exception {
        HistoryDroped() {
        }
    }
}

