/*
 * Decompiled with CFR 0.152.
 */
package paraselene.supervisor;

import java.io.File;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import paraselene.supervisor.History;
import paraselene.supervisor.HistorySet;
import paraselene.supervisor.Option;
import paraselene.supervisor.RequestItem;
import paraselene.supervisor.SandBox;
import paraselene.supervisor.SessionData;
import paraselene.supervisor.Supervisor;
import paraselene.util.IP;

public class RequestParameter
implements Serializable {
    private static final long serialVersionUID = 2L;
    private HashMap<String, RequestItem> item_map = new HashMap();
    private Method method = Method.GET;
    private URI uri = null;
    private URI sub_uri = null;
    private String context_path = null;
    private transient HttpSession session = null;
    private transient Cookie[] in_cookie = null;
    private String remote_addr = null;
    private HashMap<String, String[]> header = new HashMap();
    private transient Supervisor supervisor = null;
    static final String UA_HEAD = "User-Agent";
    private volatile boolean ajax_used_f = false;
    static final String X_FORWARD = "X-Forwarded-For";

    public static Mobile judgeMobile(String ua) {
        if (ua == null) {
            return Mobile.NO_MOBILE;
        }
        if (ua.indexOf("DoCoMo") != -1) {
            return Mobile.DOCOMO;
        }
        if (ua.indexOf("KDDI") != -1) {
            return Mobile.AU;
        }
        if (ua.indexOf("emobile") != -1) {
            return Mobile.EMOBILE;
        }
        if (ua.indexOf("SoftBank") != -1 || ua.indexOf("Vodafone") != -1 || ua.indexOf("J-PHONE") != -1) {
            return Mobile.J_PHONE;
        }
        if (ua.indexOf("UP.Browser") != -1) {
            return Mobile.TU_KA;
        }
        return Mobile.NO_MOBILE;
    }

    public static SearchEngine judgeSearchEngine(String ua) {
        if (ua == null) {
            return SearchEngine.NO_SEARCHENGINE;
        }
        SearchEngine[] dim = SearchEngine.values();
        ua = ua.toLowerCase(Locale.ENGLISH);
        for (int i = 0; i < dim.length; ++i) {
            if (!dim[i].isHit(ua)) continue;
            return dim[i];
        }
        return SearchEngine.NO_SEARCHENGINE;
    }

    void markAjaxCalled() {
        this.ajax_used_f = true;
    }

    public boolean wasUsedAjax() {
        return this.ajax_used_f;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        return o.hashCode() == this.hashCode();
    }

    public int hashCode() {
        int ret = this.uri.hashCode();
        for (String k : this.item_map.keySet()) {
            ret += k.hashCode();
            RequestItem my_item = this.item_map.get(k);
            String[] v = my_item.getAllValue();
            if (v == null) continue;
            for (int i = 0; i < v.length; ++i) {
                ret += v[i].hashCode();
            }
        }
        return ret;
    }

    public Mobile judgeMobile() {
        String[] ua = this.getHeader(UA_HEAD);
        if (ua == null) {
            return Mobile.NO_MOBILE;
        }
        if (ua.length < 1) {
            return Mobile.NO_MOBILE;
        }
        return RequestParameter.judgeMobile(ua[0]);
    }

    public SearchEngine judgeSearchEngine() {
        String[] ua = this.getHeader(UA_HEAD);
        if (ua == null) {
            return SearchEngine.NO_SEARCHENGINE;
        }
        if (ua.length < 1) {
            return SearchEngine.NO_SEARCHENGINE;
        }
        return RequestParameter.judgeSearchEngine(ua[0]);
    }

    public RequestParameter() {
        try {
            this.uri = new URI("#");
        }
        catch (Exception e) {
            Option.debug(e);
        }
    }

    protected void setMethod(Method m) {
        this.method = m;
    }

    protected void setSession(HttpSession s) {
        this.session = s;
    }

    protected void setCookie(Cookie[] c) {
        this.in_cookie = c;
    }

    protected void setRemoteAddr(String ip) {
        this.remote_addr = ip;
    }

    protected void setURI(URI u) {
        this.uri = u;
    }

    protected void setRelativeURI(URI u) {
        this.sub_uri = u;
    }

    public String getContextPath() {
        return this.context_path;
    }

    protected void setContextPath(String str) {
        this.context_path = str;
    }

    protected void setSupervisor(Supervisor sv) {
        this.supervisor = sv;
    }

    public void setHeader(String name, String[] val) {
        this.header.put(name.toLowerCase(Locale.ENGLISH), val);
    }

    private String getRemoteAddr(HttpServletRequest req) {
        String[] tmp;
        String x = req.getHeader(X_FORWARD);
        if (x != null && (tmp = x.split("[\\.:]")).length >= 4) {
            return x;
        }
        return req.getRemoteAddr();
    }

    void setParam(Method m, HttpServletRequest request, Supervisor sv) {
        this.setSupervisor(sv);
        this.setMethod(m);
        this.setSession(request.getSession(false));
        this.setCookie(request.getCookies());
        this.setRemoteAddr(this.getRemoteAddr(request));
        try {
            int start;
            StringBuffer buf = request.getRequestURL();
            String query = request.getQueryString();
            if (query != null) {
                buf = buf.append("?");
                buf = buf.append(query);
            }
            this.setURI(new URI(buf.toString()));
            String[] path = this.getURI().getPath().split("/");
            this.setContextPath(request.getContextPath());
            String[] cont = this.getContextPath().split("/");
            String last = cont[cont.length - 1];
            for (start = 0; start < path.length && !last.equals(path[start]); ++start) {
            }
            StringBuilder b = new StringBuilder(path[++start]);
            ++start;
            while (start < path.length) {
                b = b.append("/");
                b = b.append(path[start]);
                ++start;
            }
            this.setRelativeURI(new URI(b.toString()));
        }
        catch (Exception e) {
            Option.debug(e);
        }
        Enumeration em = request.getHeaderNames();
        while (em.hasMoreElements()) {
            String key = (String)em.nextElement();
            ArrayList<String> data = new ArrayList<String>();
            Enumeration e2 = request.getHeaders(key);
            while (e2.hasMoreElements()) {
                data.add((String)e2.nextElement());
            }
            this.setHeader(key, data.toArray(new String[0]));
        }
    }

    public Supervisor getSupervisor() {
        return this.supervisor;
    }

    public String[] getHeaderNames() {
        return this.header.keySet().toArray(new String[0]);
    }

    public String[] getHeader(String name) {
        return this.header.get(name.toLowerCase(Locale.ENGLISH));
    }

    public HeaderQuality[] getHeaderWithQuality(String name) {
        String[] org = this.getHeader(name);
        if (org == null) {
            return null;
        }
        ArrayList<HeaderQuality> head = new ArrayList<HeaderQuality>();
        for (int i = 0; i < org.length; ++i) {
            String[] data = org[i].split(",");
            for (int j = 0; j < data.length; ++j) {
                try {
                    head.add(new HeaderQuality(data[j]));
                    continue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
        }
        return head.toArray(new HeaderQuality[0]);
    }

    public String getRemoteAddr() {
        return this.remote_addr;
    }

    public HitRemoteAddrResult isHitRemoteAddr(IP.IPMask ... mask) {
        IP ip = IP.toIP(this.getRemoteAddr());
        if (ip == null) {
            return HitRemoteAddrResult.REMOTE_NOT_IP;
        }
        if (mask == null || mask.length == 0) {
            return HitRemoteAddrResult.MASK_NON;
        }
        for (IP.IPMask ms : mask) {
            IP chk = ms.getIP().mask(ms.getMask());
            if (!chk.equalsLowBit(ip.mask(ms.getMask()))) continue;
            return HitRemoteAddrResult.HIT;
        }
        return HitRemoteAddrResult.NO_HIT;
    }

    public URI getURI() {
        return this.uri;
    }

    public URI getRelativeURI() {
        return this.sub_uri;
    }

    public Cookie[] getCookie() {
        return this.in_cookie;
    }

    public Cookie getCookie(String name) {
        if (name == null) {
            return null;
        }
        for (int i = 0; i < this.in_cookie.length; ++i) {
            if (!this.in_cookie[i].getName().equals(name)) continue;
            return this.in_cookie[i];
        }
        return null;
    }

    private void setRequestItem(String k, String v, File fb, String mime, boolean f) {
        RequestItem item = this.item_map.get(k);
        if (item == null) {
            item = new RequestItem(k);
            this.item_map.put(k, item);
        }
        item.value.add(v);
        item.file.add(fb);
        item.mime.add(mime);
        item.file_flg.add(f);
    }

    public void addItem(String k, String v, File f, String type) {
        this.setRequestItem(k, v, f, type, true);
    }

    public void addItem(String k, String v) {
        this.setRequestItem(k, v, null, null, false);
    }

    public void remove(String k) {
        this.item_map.remove(k);
    }

    public Method getMethod() {
        return this.method;
    }

    public HttpSession getSession() {
        return this.session;
    }

    public HttpSession makeNewSession() {
        if (this.supervisor != null) {
            this.session = this.supervisor.makeNewSession(this.session);
        }
        return this.session;
    }

    public int getHistoryKey(String name) {
        HistorySet set = this.getHistorySet();
        if (set == null) {
            return -1;
        }
        return set.getKey(name);
    }

    public History getHistory(int key) {
        HistorySet set = this.getHistorySet();
        if (set == null) {
            return null;
        }
        return set.get(key);
    }

    public HistorySet getHistorySet() {
        HttpSession session = this.getSession();
        SessionData data = null;
        if (session != null) {
            data = (SessionData)session.getAttribute("paraselene$data");
        }
        if (data == null) {
            data = Supervisor.getSessionData(this.getSupervisor());
        }
        if (data == null) {
            return null;
        }
        return data.hist;
    }

    public History getHistory() {
        return this.getHistory(SandBox.getCurrentPage().getHistoryKey());
    }

    public RequestItem getItem(String key) {
        if (key == null) {
            return null;
        }
        return this.item_map.get(key);
    }

    public String[] getAllKey() {
        int cnt = this.getItemCount();
        String[] ret = new String[cnt];
        int i = 0;
        Iterator<String> i$ = this.item_map.keySet().iterator();
        while (i$.hasNext()) {
            String k;
            ret[i] = k = i$.next();
            ++i;
        }
        return ret;
    }

    public int getItemCount() {
        return this.item_map.size();
    }

    public boolean isExistRequestItem() {
        return this.item_map.size() > 0;
    }

    String makeCacheKey() {
        if (this.getMethod() != Method.GET) {
            return null;
        }
        String[] key = this.getAllKey();
        int code = 0;
        for (int i = 0; i < key.length; ++i) {
            code += key.hashCode();
            RequestItem item = this.getItem(key[i]);
            String[] val = item.getAllValue();
            for (int j = 0; j < val.length; ++j) {
                code += val[j].hashCode();
            }
        }
        return Integer.toString(code ^= this.getRelativeURI().hashCode(), 36);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        String[] header = this.getHeaderNames();
        buf = buf.append(this.getMethod().toString());
        buf = buf.append(" ");
        buf = buf.append(this.getURI());
        buf = buf.append("\n");
        for (int i = 0; i < header.length; ++i) {
            String[] val = this.getHeader(header[i]);
            for (int j = 0; j < val.length; ++j) {
                buf = new StringBuilder(header[i]);
                buf = buf.append(" : ");
                buf = buf.append(val[j]);
                buf = buf.append("\n");
            }
        }
        return buf.toString();
    }

    public static enum HitRemoteAddrResult {
        REMOTE_NOT_IP,
        MASK_NON,
        HIT,
        NO_HIT;

    }

    public class HeaderQuality {
        String val;
        Float q = null;

        HeaderQuality(String org) throws NumberFormatException {
            String[] k;
            String[] data = org.split(";");
            this.val = data[0].trim();
            if (data.length > 1 && (k = data[1].split("="))[0].trim().equals("q") && k.length > 1) {
                this.q = new Float(data[1]);
            }
        }

        public String getValue() {
            return this.val;
        }

        public Float getQuality() {
            return this.q;
        }
    }

    public static enum SearchEngine {
        GOOGLE_ADSENSE("Mediapartners-Google"),
        GOOGLE("Googlebot"),
        YAHOO("Yahoo!", "Slurp"),
        YAHOO_JAPAN("Y!J"),
        MSN("msnbot"),
        BAIDU("Baiduspider"),
        NAVER("Yeti"),
        YANDEX("Yandex"),
        CUIL("Twiceler"),
        ALEXA("ia_archive"),
        NO_SEARCHENGINE(new String[0]);

        private String[] str = null;

        private SearchEngine(String ... s) {
            this.str = new String[s.length];
            for (int i = 0; i < this.str.length; ++i) {
                this.str[i] = s[i].toLowerCase(Locale.ENGLISH);
            }
        }

        boolean isHit(String ua) {
            if (this.str == null) {
                return true;
            }
            for (int i = 0; i < this.str.length; ++i) {
                if (ua.indexOf(this.str[i]) != -1) continue;
                return false;
            }
            return true;
        }
    }

    public static enum Mobile {
        DOCOMO,
        AU,
        TU_KA,
        J_PHONE,
        EMOBILE,
        NO_MOBILE;

        private static final long serialVersionUID = 1L;
    }

    public static enum Method {
        GET,
        POST;

        private static final long serialVersionUID = 2L;
    }
}

