/*
 * Decompiled with CFR 0.152.
 */
package paraselene;

import java.util.HashMap;
import paraselene.HSL;
import paraselene.HTMLPart;
import paraselene.NumberValue;
import paraselene.PlainText;
import paraselene.WebColor;
import paraselene.css.CSSValuable;
import paraselene.tag.AttributeValuable;

public class Color
extends PlainText
implements CSSValuable,
AttributeValuable {
    private static final long serialVersionUID = 2L;
    private int red = -1;
    private int green = -1;
    private int blue = -1;
    private double alpha = 1.0;
    private static HashMap<String, String> color_name = new HashMap();

    @Override
    public HTMLPart getReplica() {
        return new Color(this);
    }

    public Color(Color rgb) {
        this.setColor(rgb);
    }

    public void setColor(Color rgb) {
        this.setColor(rgb.getRed(), rgb.getGreen(), rgb.getBlue(), this.getAlpha());
    }

    public Color(String s) {
        this.setText(s);
    }

    static int toColor(NumberValue num) {
        int v;
        if (num.getUnit() == NumberValue.Unit.PERCENTAGE) {
            num.multiply(256).divide(100);
        }
        if ((v = num.toInteger()) > 256) {
            v = 255;
        }
        return v;
    }

    private boolean set_rgb_text(String str) {
        String[] all = str.split("[\\(\\)]");
        if (all.length != 2) {
            return false;
        }
        if (!"rgb".equalsIgnoreCase(all[0].trim())) {
            return false;
        }
        String[] rgb = all[1].split(",");
        if (rgb.length != 3 || rgb.length != 4) {
            return false;
        }
        NumberValue[] num = new NumberValue[4];
        num[3] = new NumberValue(1);
        for (int i = 0; i < rgb.length; ++i) {
            num[i] = new NumberValue(rgb[i]);
        }
        this.setColor(Color.toColor(num[0]), Color.toColor(num[1]), Color.toColor(num[2]), num[3].toDouble());
        return true;
    }

    private boolean set_hsl_text(String str) {
        String[] all = str.split("[\\(\\)]");
        if (all.length != 2) {
            return false;
        }
        if (!"hsl".equalsIgnoreCase(all[0].trim())) {
            return false;
        }
        String[] hsl = all[1].split(",");
        if (hsl.length != 3 || hsl.length != 4) {
            return false;
        }
        NumberValue[] num = new NumberValue[3];
        num[3] = new NumberValue(1);
        for (int i = 0; i < hsl.length; ++i) {
            num[i] = new NumberValue(hsl[i]);
        }
        HSL h = new HSL(num[0].toDouble(), num[1].toDouble(), num[2].toDouble());
        this.setColor(h, num[3].toDouble());
        return true;
    }

    @Override
    public void setText(String s) {
        if (s == null) {
            super.setText(s);
            return;
        }
        if ((s = s.trim()).isEmpty()) {
            super.setText(s);
            return;
        }
        if (this.set_rgb_text(s)) {
            return;
        }
        if (this.set_hsl_text(s)) {
            return;
        }
        if (s.charAt(0) != '#') {
            String alias = color_name.get(s.toUpperCase());
            if (alias != null) {
                s = alias;
            }
            this.setColor(WebColor.valueOf(s.toUpperCase()));
            return;
        }
        char[] ch = s.substring(1).toCharArray();
        int[] rgb = new int[3];
        if (ch.length == 3) {
            for (int i = 0; i < 3; ++i) {
                StringBuilder buf = new StringBuilder(ch[i]);
                buf = buf.append(ch[i]);
                rgb[i] = Integer.parseInt(buf.toString(), 16);
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                rgb[i] = Integer.parseInt(new String(ch, i * 2, 2), 16);
            }
        }
        this.setColor(rgb[0], rgb[1], rgb[2]);
    }

    public Color(WebColor wc) {
        this.setColor(wc);
    }

    public void setColor(WebColor wc) {
        this.setColor(wc, this.alpha);
    }

    public Color(WebColor wc, double a) {
        this.setColor(wc, a);
    }

    public void setColor(WebColor wc, double a) {
        int r = wc.red;
        int g = wc.green;
        int b = wc.blue;
        this.setColor(wc.red, wc.green, wc.blue, a);
        if (r >= 0 && g >= 0 && b >= 0) {
            return;
        }
        super.setText(wc.name());
    }

    public Color(int r, int g, int b) {
        this.setColor(r, g, b);
    }

    public Color(int r, int g, int b, double a) {
        this.setColor(r, g, b, a);
    }

    public void setColor(int r, int g, int b) {
        this.setColor(r, g, b, this.alpha);
    }

    public void setAlpha(double a) {
        if (this.red < 0 || this.green < 0 || this.blue < 0) {
            return;
        }
        this.setColor(this.red, this.green, this.blue, a);
    }

    public void setColor(int r, int g, int b, double a) {
        this.red = r & 0xFF;
        this.green = g & 0xFF;
        this.blue = b & 0xFF;
        this.alpha = a;
        if (this.alpha < 0.0) {
            this.alpha = 0.0;
        }
        if (this.alpha > 1.0) {
            this.alpha = 1.0;
        }
        if (this.red < 0 || this.green < 0 || this.blue < 0 || this.alpha == 0.0) {
            super.setText("TRANSPARENT");
            return;
        }
        if (this.alpha == 1.0) {
            super.setText(String.format("#%06X", this.red << 16 | this.green << 8 | this.blue));
        } else {
            super.setText(String.format("rgba(%d,%d,%d,%f)", this.getRed(), this.getGreen(), this.getBlue(), this.alpha));
        }
    }

    public int getRed() {
        return this.red;
    }

    public int getGreen() {
        return this.green;
    }

    public int getBlue() {
        return this.blue;
    }

    public double getAlpha() {
        return this.alpha;
    }

    public HSL getHSL() {
        return HSL.getHSL(this);
    }

    public Color(HSL hsl) {
        this.setColor(hsl);
    }

    public void setColor(HSL hsl) {
        hsl.toColor(this);
    }

    public Color(HSL hsl, double a) {
        this.setColor(hsl, a);
    }

    public void setColor(HSL hsl, double a) {
        hsl.toColor(this);
        this.setAlpha(a);
    }

    static {
        color_name.put("GREY", "GRAY");
        color_name.put("DARKGREY", "DARKGRAY");
        color_name.put("DARKSLATEGREY", "DARKSLATEGRAY");
        color_name.put("DIMGREY", "DIMGRAY");
        color_name.put("LIGHTGREY", "LIGHTGRAY");
        color_name.put("LIGHTSLATEGREY", "LIGHTSLATEGRAY");
    }
}

