/*
 * Decompiled with CFR 0.152.
 */
package paraselene;

import java.math.BigDecimal;
import paraselene.HTMLPart;
import paraselene.PlainText;
import paraselene.css.CSSValuable;
import paraselene.mockup.Infinite;
import paraselene.mockup.Leftover;
import paraselene.tag.AttributeValuable;

public class NumberValue
extends PlainText
implements AttributeValuable,
CSSValuable {
    private static final long serialVersionUID = 2L;
    public static final Number INFINITE = new Infinite();
    public static final Number LEFTOVER = new Leftover();
    private Sign sign_data;
    private double val;
    private Unit unit_data;

    public void setNumber(Sign sign, double num, Unit unit) {
        if (num < 0.0) {
            sign = Sign.MINUS;
        }
        num = Math.abs(num);
        this.sign_data = sign;
        this.val = num;
        this.unit_data = unit;
        StringBuilder buf = new StringBuilder(this.sign_data.str);
        String vstr = Double.toString(num);
        String[] part = vstr.split("\\.");
        buf = buf.append(part[0]);
        if (part.length > 1) {
            char[] ch = part[1].toCharArray();
            int len = 0;
            for (int i = 0; i < ch.length; ++i) {
                if (ch[i] == '0') continue;
                len = i + 1;
            }
            if (len > 0) {
                buf = buf.append(".");
                buf = buf.append(part[1].substring(0, len));
            }
        }
        buf = buf.append(this.unit_data.str);
        super.setText(buf.toString());
    }

    public void setNumber(Sign sign, int num, Unit unit) {
        this.setNumber(sign, (double)num, unit);
    }

    public void setNumber(Sign sign, Number num, Unit unit) {
        this.setNumber(sign, num.doubleValue(), unit);
    }

    public void setNumber(Sign sign, double num) {
        this.setNumber(sign, num, Unit.NON);
    }

    public void setNumber(Sign sign, int num) {
        this.setNumber(sign, (double)num, Unit.NON);
    }

    public void setNumber(Sign sign, Number num) {
        this.setNumber(sign, num.doubleValue(), Unit.NON);
    }

    public void setNumber(double num, Unit unit) {
        this.setNumber(Sign.NON, num, unit);
    }

    public void setNumber(int num, Unit unit) {
        this.setNumber(Sign.NON, (double)num, unit);
    }

    public void setNumber(Number num, Unit unit) {
        this.setNumber(Sign.NON, num.doubleValue(), unit);
    }

    @Override
    public void setText(String str) {
        if (INFINITE.toString().equalsIgnoreCase(str)) {
            this.setNumber(Sign.NON, INFINITE);
            super.setText(INFINITE.toString());
            return;
        }
        if (LEFTOVER.toString().equalsIgnoreCase(str)) {
            this.setNumber(Sign.NON, LEFTOVER);
            super.setText(LEFTOVER.toString());
            return;
        }
        int start = 1;
        char ch = str.charAt(0);
        Sign sign = Sign.NON;
        switch (ch) {
            case '+': {
                sign = Sign.PLUS;
                break;
            }
            case '-': {
                sign = Sign.MINUS;
                break;
            }
            default: {
                start = 0;
            }
        }
        Unit unit = Unit.NON;
        str = str.substring(start);
        int len = str.length();
        Unit[] dim = Unit.values();
        for (int i = 0; i < dim.length; ++i) {
            String u;
            int unit_len;
            if (dim[i] == Unit.NON || (start = len - (unit_len = dim[i].str.length())) < 1 || !dim[i].str.equalsIgnoreCase(u = str.substring(start))) continue;
            unit = dim[i];
            len = start;
            break;
        }
        this.setNumber(sign, Double.parseDouble(str.substring(0, len)), unit);
    }

    public void setNumber(double num) {
        this.setNumber(Sign.NON, num, Unit.NON);
    }

    public void setNumber(int num) {
        this.setNumber(Sign.NON, (double)num, Unit.NON);
    }

    public void setNumber(Number num) {
        this.setNumber(Sign.NON, num.doubleValue(), Unit.NON);
    }

    @Override
    public HTMLPart getReplica() {
        return new NumberValue(this.sign_data, this.val, this.unit_data);
    }

    private NumberValue() {
    }

    public NumberValue(Sign sign, double num, Unit unit) {
        this.setNumber(sign, num, unit);
    }

    public NumberValue(Sign sign, double num) {
        this.setNumber(sign, num);
    }

    public NumberValue(double num, Unit unit) {
        this.setNumber(num, unit);
    }

    public NumberValue(double num) {
        this.setNumber(num);
    }

    public NumberValue(String str) {
        this.setText(str);
    }

    public NumberValue(Sign sign, int num, Unit unit) {
        this.setNumber(sign, num, unit);
    }

    public NumberValue(Sign sign, int num) {
        this.setNumber(sign, num);
    }

    public NumberValue(int num, Unit unit) {
        this.setNumber(num, unit);
    }

    public NumberValue(int num) {
        this.setNumber(num);
    }

    public NumberValue(Sign sign, Number num, Unit unit) {
        this.setNumber(sign, num, unit);
    }

    public NumberValue(Sign sign, Number num) {
        this.setNumber(sign, num);
    }

    public NumberValue(Number num, Unit unit) {
        this.setNumber(num, unit);
    }

    public NumberValue(Number num) {
        this.setNumber(num);
    }

    public double toDouble() {
        return this.val;
    }

    public int toInteger() {
        return (int)this.val;
    }

    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.val);
    }

    public Sign getSign() {
        return this.sign_data;
    }

    public Unit getUnit() {
        return this.unit_data;
    }

    public NumberValue add(double p) {
        this.setNumber(this.val + p);
        return this;
    }

    public NumberValue add(int p) {
        return this.add((double)p);
    }

    public NumberValue add(Number p) {
        if (p == null) {
            return this;
        }
        return this.add(p.doubleValue());
    }

    public NumberValue subtract(double p) {
        this.setNumber(this.val - p);
        return this;
    }

    public NumberValue subtract(int p) {
        return this.subtract((double)p);
    }

    public NumberValue subtract(Number p) {
        if (p == null) {
            return this;
        }
        return this.subtract(p.doubleValue());
    }

    public NumberValue multiply(double p) {
        this.setNumber(this.val * p);
        return this;
    }

    public NumberValue multiply(int p) {
        return this.multiply((double)p);
    }

    public NumberValue multiply(Number p) {
        if (p == null) {
            return this;
        }
        return this.multiply(p.doubleValue());
    }

    public NumberValue divide(double p) {
        if (p == 0.0) {
            return this;
        }
        this.setNumber(this.val / p);
        return this;
    }

    public NumberValue divide(int p) {
        return this.divide((double)p);
    }

    public NumberValue divide(Number p) {
        if (p == null) {
            return this;
        }
        return this.divide(p.doubleValue());
    }

    public static enum Unit {
        NON(""),
        EM("em"),
        X_HEIGHT("ex"),
        PIXEL("px"),
        INCHE("in"),
        CENTIMETER("cm"),
        MILLIMETER("mm"),
        POINT("pt"),
        PICA("pc"),
        PERCENTAGE("%"),
        DEGREE("deg"),
        GRADIENT("grad"),
        RADIAN("rad"),
        MILLISECOND("ms"),
        SECOND("s"),
        HERTZ("hz"),
        KILOHERTZ("khz");

        String str;

        private Unit(String u) {
            this.str = u;
        }

        public String toString() {
            return this.str;
        }
    }

    public static enum Sign {
        NON(""),
        PLUS("+"),
        MINUS("-");

        String str;

        private Sign(String s) {
            this.str = s;
        }
    }
}

