/*
 * Decompiled with CFR 0.152.
 */
package paraselene.mockup;

import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import paraselene.Color;
import paraselene.NumberValue;
import paraselene.URIValue;
import paraselene.Valuable;
import paraselene.css.Property;
import paraselene.css.Style;
import paraselene.dyna.DynamicPage;
import paraselene.dyna.GrantTag;
import paraselene.dyna.GrantTagProvider;
import paraselene.dyna.URIResolver;
import paraselene.mockup.Converter;
import paraselene.mockup.DynaTag;
import paraselene.mockup.Make;
import paraselene.mockup.Param;
import paraselene.mockup.TagException;
import paraselene.mockup.TagNew;
import paraselene.tag.Anchor;
import paraselene.tag.Attribute;
import paraselene.tag.AttributeValuable;
import paraselene.tag.Tag;
import paraselene.tag.form.Button;
import paraselene.tag.form.CheckBox;
import paraselene.tag.form.Form;
import paraselene.tag.form.GPButton;
import paraselene.tag.form.Input;
import paraselene.tag.form.MultiTextBox;
import paraselene.tag.form.Select;
import paraselene.tag.form.SelectGroup;
import paraselene.tag.form.SelectItem;
import paraselene.tag.form.SingleTextBox;
import paraselene.tag.form.UploadFile;
import paraselene.tag.list.List;
import paraselene.tag.list.ListItem;
import paraselene.tag.ruby.Ruby;
import paraselene.tag.ruby.RubyText;
import paraselene.tag.table.Column;
import paraselene.tag.table.Line;
import paraselene.tag.table.Table;

public class TagMap {
    private static HashMap<String, Class<Tag>> class_real = new HashMap();
    private static HashMap<String, Object> new_str = new HashMap();
    private static HashMap<String, DynaTag> tag_str = new HashMap();
    static final String TAG = "Tag";
    private static final Object[][] dim = new Object[][]{{"hidden", Input.class, new TagNew(){

        @Override
        public String toString(Tag t) {
            return 1.append("Input.createHidden( ", Make.escape(t.getNameAttribute()), ",", Make.escape(t.getValueString()), ")");
        }
    }, new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 2.setAttr(Input.createHidden(2.seek(attr, "name"), 2.seek(attr, "value")), attr);
        }
    }}, {"file", UploadFile.class, "new UploadFile()", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 3.setAttr(new UploadFile(), attr);
        }
    }}, {"button", Button.class, "new Button(Button.Type.BUTTON)", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 4.setAttr(new Button(Button.Type.BUTTON), attr);
        }
    }}, {"image", Button.class, "new Button(Button.Type.IMAGE)", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 5.setAttr(new Button(Button.Type.IMAGE), attr);
        }
    }}, {"reset", Button.class, "new Button(Button.Type.RESET)", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 6.setAttr(new Button(Button.Type.RESET), attr);
        }
    }}, {"submit", Button.class, "new Button(Button.Type.SUBMIT)", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 7.setAttr(new Button(Button.Type.SUBMIT), attr);
        }
    }}, {"radio", CheckBox.class, "new CheckBox(true)", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 8.setAttr(new CheckBox(true), attr);
        }
    }}, {"checkbox", CheckBox.class, "new CheckBox(false)", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 9.setAttr(new CheckBox(false), attr);
        }
    }}, {"password", SingleTextBox.class, "new SingleTextBox(SingleTextBox.Type.PASSWORD)", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 10.setAttr(new SingleTextBox(SingleTextBox.Type.PASSWORD), attr);
        }
    }}, {"text", SingleTextBox.class, "new SingleTextBox(SingleTextBox.Type.TEXT)", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 11.setAttr(new SingleTextBox(SingleTextBox.Type.TEXT), attr);
        }
    }}, {"search", SingleTextBox.class, "new SingleTextBox(SingleTextBox.Type.SEARCH)", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 12.setAttr(new SingleTextBox(SingleTextBox.Type.SEARCH), attr);
        }
    }}, {"tel", SingleTextBox.class, "new SingleTextBox(SingleTextBox.Type.TELEPHONE)", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 13.setAttr(new SingleTextBox(SingleTextBox.Type.TELEPHONE), attr);
        }
    }}, {"url", SingleTextBox.class, "new SingleTextBox(SingleTextBox.Type.URL)", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 14.setAttr(new SingleTextBox(SingleTextBox.Type.URL), attr);
        }
    }}, {"email", SingleTextBox.class, "new SingleTextBox(SingleTextBox.Type.EMAIL)", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 15.setAttr(new SingleTextBox(SingleTextBox.Type.EMAIL), attr);
        }
    }}, {"datetime", SingleTextBox.class, "new SingleTextBox(SingleTextBox.Type.DATE_AND_TIME)", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 16.setAttr(new SingleTextBox(SingleTextBox.Type.DATE_AND_TIME), attr);
        }
    }}, {"date", SingleTextBox.class, "new SingleTextBox(SingleTextBox.Type.DATE)", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 17.setAttr(new SingleTextBox(SingleTextBox.Type.DATE), attr);
        }
    }}, {"month", SingleTextBox.class, "new SingleTextBox(SingleTextBox.Type.MONTH)", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 18.setAttr(new SingleTextBox(SingleTextBox.Type.MONTH), attr);
        }
    }}, {"week", SingleTextBox.class, "new SingleTextBox(SingleTextBox.Type.WEEK)", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 19.setAttr(new SingleTextBox(SingleTextBox.Type.WEEK), attr);
        }
    }}, {"time", SingleTextBox.class, "new SingleTextBox(SingleTextBox.Type.TIME)", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 20.setAttr(new SingleTextBox(SingleTextBox.Type.TIME), attr);
        }
    }}, {"datetime-local", SingleTextBox.class, "new SingleTextBox(SingleTextBox.Type.LOCAL_DATE_AND_TIME)", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 21.setAttr(new SingleTextBox(SingleTextBox.Type.LOCAL_DATE_AND_TIME), attr);
        }
    }}, {"number", SingleTextBox.class, "new SingleTextBox(SingleTextBox.Type.NUMBER)", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 22.setAttr(new SingleTextBox(SingleTextBox.Type.NUMBER), attr);
        }
    }}, {"range", SingleTextBox.class, "new SingleTextBox(SingleTextBox.Type.RANGE)", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 23.setAttr(new SingleTextBox(SingleTextBox.Type.RANGE), attr);
        }
    }}, {"color", SingleTextBox.class, "new SingleTextBox(SingleTextBox.Type.COLOR)", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 24.setAttr(new SingleTextBox(SingleTextBox.Type.COLOR), attr);
        }
    }}, {"a", Anchor.class, "new Anchor()", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 25.setAttr(new Anchor(), attr);
        }
    }}, {"form", Form.class, "new Form()", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 26.setAttr(new Form(), attr);
        }
    }}, {"textarea", MultiTextBox.class, "new MultiTextBox()", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 27.setAttr(new MultiTextBox(), attr);
        }
    }}, {"button", GPButton.class, "new GPButton()", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 28.setAttr(new GPButton(), attr);
        }
    }}, {"select", Select.class, "new Select()", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 29.setAttr(new Select(), attr);
        }
    }}, {"optgroup", SelectGroup.class, "new SelectGroup()", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 30.setAttr(new SelectGroup(), attr);
        }
    }}, {"option", SelectItem.class, "new SelectItem()", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 31.setAttr(new SelectItem(), attr);
        }
    }}, {"ul", List.class, "new List(List.Type.UNORDERED)", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 32.setAttr(new List(List.Type.UNORDERED), attr);
        }
    }}, {"ol", List.class, "new List(List.Type.ORDERED)", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 33.setAttr(new List(List.Type.ORDERED), attr);
        }
    }}, {"dl", List.class, "new List(List.Type.DEFINITION)", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 34.setAttr(new List(List.Type.DEFINITION), attr);
        }
    }}, {"li", ListItem.class, "new ListItem(ListItem.Type.LIST_ITEM)", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 35.setAttr(new ListItem(ListItem.Type.LIST_ITEM), attr);
        }
    }}, {"dt", ListItem.class, "new ListItem(ListItem.Type.DEFINITION_TERM)", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 36.setAttr(new ListItem(ListItem.Type.DEFINITION_TERM), attr);
        }
    }}, {"dd", ListItem.class, "new ListItem(ListItem.Type.DEFINITION_DESCRIPTION)", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 37.setAttr(new ListItem(ListItem.Type.DEFINITION_DESCRIPTION), attr);
        }
    }}, {"table", Table.class, "new Table()", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 38.setAttr(new Table(), attr);
        }
    }}, {"tr", Line.class, "new Line()", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 39.setAttr(new Line(), attr);
        }
    }}, {"th", Column.class, "new Column(Column.Type.HEADER)", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 40.setAttr(new Column(Column.Type.HEADER), attr);
        }
    }}, {"td", Column.class, "new Column(Column.Type.DATA)", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 41.setAttr(new Column(Column.Type.DATA), attr);
        }
    }}, {"ruby", Ruby.class, "new Ruby()", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 42.setAttr(new Ruby(), attr);
        }
    }}, {"rb", RubyText.class, "new RubyText(RubyText.Type.BASE)", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 43.setAttr(new RubyText(RubyText.Type.BASE), attr);
        }
    }}, {"rbc", RubyText.class, "new RubyText(RubyText.Type.BASE,new RubyText[0])", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 44.setAttr(new RubyText(RubyText.Type.BASE, new RubyText[0]), attr);
        }
    }}, {"rt", RubyText.class, "new RubyText(RubyText.Type.TEXT)", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 45.setAttr(new RubyText(RubyText.Type.TEXT), attr);
        }
    }}, {"rtc", RubyText.class, "new RubyText(RubyText.Type.TEXT,new RubyText[0])", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 46.setAttr(new RubyText(RubyText.Type.TEXT, new RubyText[0]), attr);
        }
    }}, {"rp", RubyText.class, "new RubyText(RubyText.Type.PARENTHESES)", new DynaTag(){

        @Override
        Tag getTag(String name, ArrayList<Attribute> attr) {
            return 47.setAttr(new RubyText(RubyText.Type.PARENTHESES), attr);
        }
    }}};

    private static String getKey(Tag t) throws TagException {
        String name = t.getName();
        if ("input".equals(name)) {
            Attribute attr = t.getAttribute("type");
            if (attr == null) {
                throw new TagException("type\u6307\u5b9a\u306e\u7121\u3044INPUT\u30bf\u30b0\u304c\u3042\u308a\u307e\u3059");
            }
            AttributeValuable txt = attr.get();
            if (txt == null) {
                throw new TagException("type\u5c5e\u6027\u304c\u4e0d\u6b63\u3067\u3059");
            }
            name = txt.toString();
            if (class_real.get(name) == null) {
                throw new TagException("type\u5c5e\u6027\u304c\u4e0d\u6b63\u3067\u3059");
            }
            return name;
        }
        if (class_real.get(name) == null) {
            return TAG;
        }
        return name;
    }

    static Class<Tag> getClass(Tag t) throws TagException {
        String name = TagMap.getKey(t);
        return class_real.get(name);
    }

    static String getClassString(Tag t) throws TagException {
        return TagMap.getSource(t)[0];
    }

    static String[] getSource(Tag t) throws TagException {
        if (Param.provider != null) {
            GrantTag gt = null;
            try {
                for (int i = 0; i < Param.provider.length && (gt = Param.provider[i].getGrantTag(t)) == null; ++i) {
                }
                if (gt != null) {
                    return new String[]{gt.getNewTag().getClass().getName(), gt.getNewString()};
                }
            }
            catch (Exception e) {
                throw new TagException(e.getMessage());
            }
        }
        String[] ret = new String[]{TagMap.getClass(t).getName(), null};
        Object o = new_str.get(TagMap.getKey(t));
        ret[1] = o instanceof TagNew ? ((TagNew)o).toString(t) : (String)o;
        return ret;
    }

    public static Tag makeTag(String n, ArrayList<Attribute> attr, String enc, URIResolver ur, GrantTagProvider[] ex) throws Exception {
        Object a;
        GrantTag gt = null;
        Tag t = new Tag(n, DynamicPage.isSimpleTag(n));
        t.setAttribute(attr.toArray(new Attribute[0]));
        if (ex != null) {
            for (int i = 0; i < ex.length && (gt = ex[i].getGrantTag(t)) == null; ++i) {
            }
            if (gt != null) {
                t = gt.getNewTag();
            }
        }
        int cnt = attr.size();
        for (int i = 0; i < cnt; ++i) {
            a = attr.get(i);
            String a_name = a.getName();
            String a_val = a.getString();
            if (Converter.isURI(a_name)) {
                a_val = ur.resolve(a_val);
            }
            if (Converter.isColor(a_name)) {
                a = new Attribute(a_name, (Valuable)new Color(a_val));
                attr.set(i, (Attribute)a);
            } else if (Converter.isURI(a_name)) {
                if (a_val == null) {
                    a_val = "#";
                } else if ((a_val = a_val.trim()).isEmpty()) {
                    a_val = "#";
                }
                try {
                    URI u = new URI(a_val);
                    a_val = URLDecoder.decode(u.toString(), enc);
                }
                catch (Exception e) {
                    // empty catch block
                }
                a = new Attribute(a_name, (Valuable)new URIValue(a_val, enc));
                attr.set(i, (Attribute)a);
            } else if (Converter.isNumber(a_name)) {
                a = new Attribute(a_name, (Valuable)new NumberValue(a_val));
                attr.set(i, (Attribute)a);
            } else if (Converter.isStyle(a_name)) {
                a = new Attribute(a_name, (Valuable)new Style(Property.create(a_val, enc)));
                attr.set(i, (Attribute)a);
            }
            t.setAttribute((Attribute)a);
        }
        if (gt != null) {
            return TagMap.ScanParam(t, ur, enc);
        }
        String t_name = TagMap.getKey(t);
        if (TAG.equals(t_name)) {
            return t;
        }
        a = t.getAllAttribute();
        attr.clear();
        for (int i = 0; i < ((Attribute[])a).length; ++i) {
            attr.add(a[i]);
        }
        return TagMap.ScanParam(tag_str.get(t_name).getTag(n, attr), ur, enc);
    }

    public static Tag ScanParam(Tag t, URIResolver ur, String enc) throws Exception {
        if (!"param".equals(t.getName())) {
            return t;
        }
        Attribute name_atr = t.getAttribute("name");
        Attribute value_atr = t.getAttribute("value");
        if (name_atr == null || value_atr == null) {
            return t;
        }
        String name = name_atr.getString();
        String value = value_atr.getString();
        if (name == null || value == null) {
            return t;
        }
        if (!ur.isParamURIName(name.toLowerCase(Locale.ENGLISH))) {
            return t;
        }
        t.setAttribute(new Attribute(name, (Valuable)new URIValue(ur.resolve(value), enc)));
        return t;
    }

    static {
        for (int i = 0; i < dim.length; ++i) {
            class_real.put((String)dim[i][0], (Class)dim[i][1]);
            new_str.put((String)dim[i][0], dim[i][2]);
            tag_str.put((String)dim[i][0], (DynaTag)dim[i][3]);
        }
        class_real.put(TAG, Tag.class);
        new_str.put(TAG, new TagNew(){

            @Override
            public String toString(Tag t) {
                return 48.append("new Tag(", Make.escape(t.getName()), ",", Boolean.toString(t.isSimpleTag()), ")");
            }
        });
    }
}

