/*
 * Decompiled with CFR 0.152.
 */
package paraselene.supervisor;

import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import paraselene.Page;
import paraselene.supervisor.AjaxForward;
import paraselene.supervisor.Closure;
import paraselene.supervisor.CometCall;
import paraselene.supervisor.DialogType;
import paraselene.supervisor.EphemeralClosure;
import paraselene.supervisor.ErrorStatus;
import paraselene.supervisor.Feedback;
import paraselene.supervisor.History;
import paraselene.supervisor.JavaScript;
import paraselene.supervisor.LocationCometCall;
import paraselene.supervisor.LocationOutput;
import paraselene.supervisor.NOP;
import paraselene.supervisor.Option;
import paraselene.supervisor.OutputCall;
import paraselene.supervisor.PageFactory;
import paraselene.supervisor.PageID;
import paraselene.supervisor.Popup;
import paraselene.supervisor.RequestParameter;
import paraselene.supervisor.SandBox;
import paraselene.supervisor.SessionData;
import paraselene.supervisor.Supervisor;

public class Forward
implements Serializable {
    private static final long serialVersionUID = 212L;
    boolean weak_f = false;
    private int error = 0;
    private transient URI redirect_uri = null;
    PageID out_page = null;
    private AjaxForward[] ajax = null;
    private AjaxForward not_ajax = null;
    boolean history_f = true;
    boolean session_clear_f = false;
    transient ArrayList<Cookie> out_cookie = new ArrayList();
    boolean done_f = false;
    private boolean leave_f = true;
    private StackTraceElement[] ste403 = new StackTraceElement[0];

    boolean is_refresh() {
        if (this instanceof Feedback) {
            return false;
        }
        return this.out_page != null;
    }

    boolean isRefresh(boolean ajax_f) {
        if (!ajax_f) {
            return true;
        }
        return this.is_refresh();
    }

    boolean isLeave() {
        return this.leave_f && (this.error > 0 || this.redirect_uri != null);
    }

    public void addCookie(Cookie c) {
        this.out_cookie.add(c);
    }

    Forward() {
    }

    public Forward(int stat) {
        this.error = stat;
        if (stat % 100 <= 2) {
            return;
        }
        this.session_clear_f = true;
        this.ste403 = Thread.currentThread().getStackTrace();
    }

    public Forward(URI uri, boolean session_off) {
        this.redirect_uri = uri;
        this.session_clear_f = session_off;
    }

    Forward(URI uri, boolean session_off, boolean lf) {
        this(uri, session_off);
        this.leave_f = lf;
    }

    public Forward(PageID id, boolean history_use, boolean session_off) {
        this(SandBox.getPageFactory(), id, history_use, session_off);
    }

    Forward(PageFactory pf, PageID id, boolean history_use, boolean session_off) {
        if (pf != null && !(this instanceof Closure) && !(this instanceof Feedback)) {
            id = pf.getAjaxSurrogatePage(id);
        }
        this.out_page = id;
        this.history_f = history_use;
        this.session_clear_f = session_off;
    }

    public Forward(PageID id) {
        this(id, true, false);
    }

    public Forward(AjaxForward ... af) {
        if (af.length == 0) {
            af = new AjaxForward[]{new NOP()};
        } else {
            for (AjaxForward a : af) {
                for (Cookie c : ((Forward)((Object)a)).out_cookie) {
                    this.out_cookie.add(c);
                }
            }
        }
        this.ajax = af;
        if (SandBox.isCurrentDaemon()) {
            return;
        }
        this.initTrim(SandBox.getCurrentRequestParameter().getHistory());
    }

    public static Forward merge(Forward ... fw) {
        if (fw.length == 0) {
            return new NOP();
        }
        if (fw.length == 1) {
            return fw[0];
        }
        ArrayList<AjaxForward> list = new ArrayList<AjaxForward>();
        for (int i = 0; i < fw.length; ++i) {
            if (fw[i].weak_f || fw[i] == null || fw[i] instanceof NOP) continue;
            if (fw[i] instanceof AjaxForward) {
                list.add((AjaxForward)((Object)fw[i]));
                Option.trace("add %s", fw[i]);
                continue;
            }
            if (fw[i].isAjaxHold()) {
                for (AjaxForward af : fw[i].getAjaxForward(true)) {
                    if (af == null) continue;
                    list.add(af);
                    Option.trace("add %s", af);
                }
                continue;
            }
            return fw[i];
        }
        switch (list.size()) {
            case 0: {
                return new NOP();
            }
            case 1: {
                return (Forward)list.get(0);
            }
        }
        HashMap pf = new HashMap();
        HashMap<Integer, AjaxForward> closure = new HashMap<Integer, AjaxForward>();
        ArrayList<AjaxForward> etc = new ArrayList<AjaxForward>();
        for (AjaxForward af : list) {
            PageID pid = af.getPageID();
            if (af instanceof Closure) {
                pid = ((Closure)af).close_page.getID();
            } else if (af instanceof Feedback) {
                pid = ((Feedback)af).target.getID();
            }
            if (pid == null || af instanceof JavaScript) {
                etc.add(af);
                continue;
            }
            int id = pid.getID();
            if (af instanceof Closure) {
                Option.trace("Closure %s", pid);
                pf.remove(id);
                if (closure.get(id) instanceof EphemeralClosure) continue;
                closure.put(id, af);
                continue;
            }
            if (closure.get(id) != null) {
                Option.trace("not Closure %s continue", pid);
                continue;
            }
            ArrayList<AjaxForward> l = (ArrayList<AjaxForward>)pf.get(id);
            if (l == null) {
                l = new ArrayList<AjaxForward>();
                pf.put(id, l);
            }
            Option.trace("not Closure %s add", pid);
            l.add(af);
        }
        list = new ArrayList();
        Iterator<Object> i$ = closure.keySet().iterator();
        while (i$.hasNext()) {
            int id = (Integer)i$.next();
            list.add((AjaxForward)closure.get(id));
        }
        i$ = pf.keySet().iterator();
        while (i$.hasNext()) {
            int id = (Integer)i$.next();
            for (AjaxForward af : (ArrayList)pf.get(id)) {
                list.add(af);
            }
        }
        for (AjaxForward af : etc) {
            list.add(af);
        }
        return new Forward(list.toArray(new AjaxForward[0]));
    }

    boolean isAjaxHold() {
        return this.ajax != null;
    }

    boolean isAjax() {
        if (this instanceof AjaxForward) {
            return true;
        }
        return this.isAjaxHold();
    }

    void initTrim(History hist) {
        if (this.ajax == null) {
            return;
        }
        this.ajax = this.trim(this.ajax, hist, true);
        this.not_ajax = this.getNotAjax();
    }

    Forward(History hist, AjaxForward ... af) {
        this.ajax = this.trim(af, hist, false);
        this.not_ajax = this.getNotAjax();
    }

    AjaxForward[] getAjaxForward(boolean ajax_f) {
        if (ajax_f) {
            return this.ajax;
        }
        if (this.not_ajax == null) {
            return null;
        }
        return new AjaxForward[]{this.not_ajax};
    }

    private AjaxForward[] trim(AjaxForward[] af, History hist, boolean fb_ok) {
        int i;
        if (af.length < 1) {
            return af;
        }
        if (hist == null) {
            return null;
        }
        Page[] page = hist.getBrowsingPage();
        DialogType ptype = Popup.Type.MODELESS;
        if (Popup.isModelessAlert(ptype, hist, false)) {
            ptype = Popup.Type.MODAL;
        }
        ArrayList<AjaxForward> list = new ArrayList<AjaxForward>();
        block0: for (i = 0; i < af.length - 1; ++i) {
            if (af[i] == null) continue;
            for (int j = i + 1; j < af.length; ++j) {
                if (!((Object)af[i]).equals(af[j])) continue;
                af[j] = null;
            }
            if (af[i] instanceof Popup) {
                Popup pup = (Popup)af[i];
                pup.overwriteType(ptype);
                ptype = pup.getType();
            }
            if (!(af[i] instanceof Feedback)) continue;
            if (!fb_ok) {
                af[i] = null;
                continue;
            }
            Feedback fb = (Feedback)af[i];
            for (int j = 0; j < af.length; ++j) {
                if (!(af[j] instanceof Closure) || !fb.isSamePage((Closure)af[j])) continue;
                af[i] = null;
                continue block0;
            }
        }
        for (i = 0; i < af.length; ++i) {
            if (af[i] == null) continue;
            list.add(af[i]);
        }
        af = list.toArray(new AjaxForward[0]);
        return af;
    }

    private AjaxForward getNotAjax() {
        Feedback fb;
        if (this.ajax == null) {
            return null;
        }
        AjaxForward ret = fb = new Feedback();
        for (int i = 0; i < this.ajax.length; ++i) {
            if (this.ajax[i] instanceof Popup) {
                return this.ajax[i];
            }
            if (!(this.ajax[i] instanceof Closure) || !fb.isSamePage((Closure)this.ajax[i])) continue;
            ret = this.ajax[i];
        }
        return ret;
    }

    Page getPage(PageFactory pf, Page from) {
        if (this.out_page == null) {
            Option.trace("Forward#getPage -> null", new Object[0]);
            return null;
        }
        if (from != null && this.out_page == from.getID()) {
            Option.trace("Forward#getPage -> %s", from.getUniqueKey());
            return from;
        }
        Page p = pf.getPage(this.out_page.getID());
        Option.trace("Forward#getPage -> %s", p.getUniqueKey());
        return p;
    }

    public PageID getPageID() {
        return this.out_page;
    }

    public URI getRedirectURI() {
        return this.redirect_uri;
    }

    public int getStatus() {
        return this.error;
    }

    void Action(Supervisor sp, HttpServletResponse res) throws Exception {
        if (this.done_f) {
            return;
        }
        this.done_f = true;
        if (this.error != 0) {
            if (this.ste403 != null) {
                StringBuilder buf = new StringBuilder();
                for (StackTraceElement s : this.ste403) {
                    buf = buf.append(s.toString()).append("\n");
                }
                Option.trace("%d Forward\n------------------------------------------------------\n%s", this.error, buf.toString());
            } else {
                res.setContentType("text/plain");
            }
            ErrorStatus.send(res, this.error);
            return;
        }
        if (this.redirect_uri != null) {
            res.sendRedirect(Supervisor.makeWithSessionURI(this.redirect_uri.toString(), null, null));
            return;
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("Forward ");
        if (this.error != 0) {
            buf = buf.append("status: ").append(Integer.toString(this.error));
        } else if (this.redirect_uri != null) {
            buf = buf.append("redirect: ").append(this.redirect_uri.toString());
        } else if (this.ajax != null) {
            buf = buf.append(" << |");
            for (int i = 0; i < this.ajax.length; ++i) {
                buf = buf.append(this.ajax[i].toString());
                buf = buf.append("|");
            }
        } else {
            buf = buf.append("page: ").append(this.getPageID().toString());
        }
        return buf.toString();
    }

    OutputCall makeOutput(PageFactory pf, int nk, Page lp, RequestParameter r, SessionData sd) {
        Option.trace("new LocationOutput <- %s", this);
        return new LocationOutput(pf, nk, lp, this, r, sd);
    }

    CometCall makeCometCall(PageFactory pf, History h) {
        Option.trace("new LocationCometCall <- %s", this);
        return new LocationCometCall(pf, h, this);
    }
}

