/*
 * Decompiled with CFR 0.152.
 */
package paraselene.util;

import paraselene.util.IP;
import paraselene.util.IPv4;

public class IPv6
extends IP {
    public IPv6(String ip) throws IP.IPFormatException {
        super(IPv6.parse(ip.trim()));
    }

    private static int parse(String str, String num) throws IP.IPFormatException {
        try {
            int ret = Integer.parseInt(num, 16);
            if (ret < 0 || ret > 65535) {
                throw new IP.IPFormatException(str);
            }
            return ret;
        }
        catch (NumberFormatException e) {
            throw new IP.IPFormatException(str);
        }
    }

    private static int[] toByte(int[] org) {
        int[] ret = new int[16];
        for (int i = 0; i < org.length; ++i) {
            ret[i * 2] = org[i] >> 8;
            ret[i * 2 + 1] = org[i] & 0xFF;
        }
        return ret;
    }

    private static int[] parse(String str) throws IP.IPFormatException {
        int top_no;
        String[] num = str.split(":");
        if (num.length < 1) {
            throw new IP.IPFormatException(str);
        }
        int last = num.length - 1;
        String[] test = num[last].split("%");
        num[last] = test[0];
        try {
            IPv4 v4 = new IPv4(num[last]);
            String[] sub = new String[]{IPv6.toString(v4.addr[0], v4.addr[1]), IPv6.toString(v4.addr[2], v4.addr[3])};
            String[] fix = new String[num.length + 1];
            for (int n = 0; n < last; ++n) {
                fix[n] = num[n];
            }
            fix[n] = sub[0];
            fix[n + 1] = sub[1];
            num = fix;
        }
        catch (IP.IPFormatException e) {
            // empty catch block
        }
        if (num.length > 8 || num.length < 3) {
            throw new IP.IPFormatException(str);
        }
        for (int i = 0; i < num.length; ++i) {
            num[i] = num[i].trim();
        }
        int[] ret = new int[8];
        for (int i = 0; i < 8; ++i) {
            ret[i] = 0;
        }
        for (top_no = 0; top_no < num.length && !num[top_no].isEmpty(); ++top_no) {
            ret[top_no] = IPv6.parse(str, num[top_no]);
        }
        if (top_no == 8) {
            return IPv6.toByte(ret);
        }
        if (top_no < 8) {
            throw new IP.IPFormatException(str);
        }
        int last_no = num.length - 1;
        int set_no = 7;
        while (last_no > top_no) {
            ret[set_no] = IPv6.parse(str, num[last_no]);
            --last_no;
            --set_no;
        }
        return IPv6.toByte(ret);
    }

    private static String toString(int u, int l) {
        return Integer.toString(u << 8 | l, 16);
    }

    private static String toString(String[] data, int start) {
        StringBuilder buf = new StringBuilder(data[start]);
        while (start < data.length && data[start] != null) {
            buf = buf.append(":").append(data[start]);
            ++start;
        }
        return buf.toString();
    }

    public String toString() {
        int tmp_len;
        int i;
        String[] num = new String[8];
        int zero = -1;
        int tmp_zero = -1;
        int len = 0;
        for (i = 0; i < num.length; ++i) {
            num[i] = IPv6.toString(this.addr[i * 2], this.addr[i * 2 + 1]);
            if (tmp_zero >= 0) {
                if ("0".equals(num[i])) continue;
                int tmp_len2 = i - tmp_zero;
                if (tmp_len2 > len) {
                    zero = tmp_zero;
                    len = tmp_len2;
                }
                tmp_zero = -1;
                continue;
            }
            if (!"0".equals(num[i])) continue;
            tmp_zero = i;
        }
        if (tmp_zero >= 0 && (tmp_len = num.length - tmp_zero) > len) {
            zero = tmp_zero;
            len = tmp_len;
        }
        if (len < 1) {
            return IPv6.toString(num, 0);
        }
        len += zero;
        for (i = zero; i < len; ++i) {
            num[i] = null;
        }
        StringBuilder buf = new StringBuilder(IPv6.toString(num, 0));
        buf = buf.append("::").append(IPv6.toString(num, len));
        return buf.toString();
    }

    private IPv6(IP ip) {
        super(ip);
    }

    @Override
    IP getReplica() {
        return new IPv6(this);
    }
}

