/*
 * Paraselene
 * Copyright (c) 2009-2012  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.supervisor;

import java.util.*;
import java.io.*;
import javax.servlet.http.*;


class ParaseleneException extends Exception {
	ParaseleneException( String s ) {
		super( s );
	}
}

class ErrorStatus {
	private static HashMap<Integer, String>	mes = new HashMap<Integer, String>();
	static {
		mes.put( 204, "No Content" );
		mes.put( 403, "Forbidden" );
		mes.put( 413, "Request Entity Too Large" );
		mes.put( 418, "I'm a teapot" );
		mes.put( 422, "Unprocessable Entity" );
		mes.put( 500, "Internal Server Error" );
		mes.put( 503, "Service Unavailable" );
	}

	static void send( HttpServletResponse res, int no ) {
		try {
			String	str = mes.get( no );
			if ( str == null ) {
				res.sendError( no );
			}
			else {
				res.sendError( no, str );
			}
		}
		catch( IOException e ) {
			e.printStackTrace();
		}
	}
}

