/*
 * Paraselene
 * Copyright (c) 2009-2011  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.supervisor;

import paraselene.*;

/**
 * 遷移先指定。input を処理したページ(自分自身)に画面遷移します。<br>
 * ページのgetAjaxSupportが有効な場合、画面遷移が発生せず画面の再描画になります。
 */
public class Feedback extends Forward implements AjaxForward {
	private static final long serialVersionUID = 2L;
	Page target;

	/**
	 * コンストラクタ。
	 * input と同じインスタンスで output を処理します。<br>
	 * セッションは維持されます。
	 */
	public Feedback() {
		this( SandBox.getCurrentPage() );
	}

	/**
	 * コンストラクタ。
	 * 指定ページの更新を要求します。そのページの output を処理します。<br>
	 * セッションは維持されます。
	 * @param page 更新対象。
	 */
	public Feedback( Page page ) {
		super( page.getParentPage().getID() );
		target = page.getParentPage();
	}

	Page getPage( PageFactory pf, Page from ) {
		Option.trace( "Feedback#getPage -> %s", target.getUniqueKey() );
		return target;
	}

	/**
	 * 同じ動作であるか？
	 * Feedbackであれば同じ動作と見なします。
	 * @param o 比較対象。
	 * @return true:同一動作、false:異なる動作。
	 */
	public boolean equals( Object o ) {
		if ( o instanceof JavaScript )	return false;
		if ( o instanceof NOP )	return false;
		return o instanceof Feedback;
	}

	boolean isSamePage( Closure c ) {
		return ( c.close_page == target );
	}

	public String toString() {
		StringBuilder	buf = new StringBuilder( "Feedback:" );
		if ( target != null ) {
			buf = buf.append( target.getID() );
			buf = buf.append( "/" ).append( target.getUniqueKey() );
		}
		return buf.toString();
	}

	OutputCall makeOutput( PageFactory pf, int nk, Page lp, RequestParameter r, SessionData sd ) {
		Option.trace( "new OutputCall <- %s", this );
		return new OutputCall( pf, nk, lp, this, r, sd );
	}

	CometCall makeCometCall( PageFactory pf, History h ) {
		Option.trace( "new CometCall <- %s", this );
		return new CometCall( pf, h, this );
	}
}

