/*
 * Paraselene
 * Copyright (c) 2009-2011  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.supervisor;

import java.io.*;
import paraselene.*;

/**
 * ページID。
 */
public interface PageID extends Serializable {
	/**
	 * ページの比較。
	 * @param p 比較ページ。
	 * @return true:同一ページ、false:異なるページ。
	 */
	public boolean isSame( Page p );

	/**
	 * ID値の取得。
	 * @return ID値。
	 */
	public int getID();

	/**
	 * ページIDの取得。
	 * @param id ID値。
	 * @return ページID。無ければnull。
	 */
	public PageID getPageID( int id );

	/**
	 * ページファクトリーの取得。
	 * @return ページファクトリー。
	 */
	public PageFactory getPageFactory();
}

