/*
 * Paraselene
 * Copyright (c) 2009, 2010  Akira Terasaki
 * このファイルは同梱されている License.txt に定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
import java.io.*;
import java.util.*;
import paraselene.*;
import paraselene.mockup.*;

public class ColorMake {
	private static Color getStringColor( Color bg ) {
		double[]	f = new double[]{
			bg.getRed(), bg.getGreen(), bg.getBlue()
		};
		double	y = f[0] * 0.2989 + f[1] * 0.5866 + f[2] * 0.1145;
		int	cl = 0;
		if ( y <= 128 )	cl = 0xff;
		return new Color( cl, cl, cl );
	}

	public static void main( String[] argv ) throws Exception {
		ArrayList<Color>	color = new ArrayList<Color>();
		ArrayList<String>	name = new ArrayList<String>();
		BufferedReader	br = new BufferedReader(
			new InputStreamReader(
				new FileInputStream( "../template/color.txt" )
			)
		);
		File	new_file = new File( "../paraselene/WebColor.java" );
		BufferedWriter	bw = new BufferedWriter(
			new OutputStreamWriter(
				new FileOutputStream( new_file )
			)
		);
		SourceHead.init( new File( "../template/head.txt" ) );
		bw.write( SourceHead.getHead( new_file ) );
		bw.write( "package paraselene;\n\n" );
		bw.write( "/**\n * Web140色定義。140色に加え、TRANSPARENT(透明)も存在します。\n" );
		while( true ) {
			String	line = br.readLine();
			if ( line == null )	break;
			String[]	p = line.split( "[\t ]" );
			color.add( new Color( p[0] ) );
			name.add( p[1] );
		}
		br.close();
		bw.write( " * <table>\n" );
		for ( int i = 0; i < 28; i++ ) {
			bw.write( " * <tr>\n" );
			for ( int j = 0; j < 5; j++ ) {
				Color	bg = color.get( i * 5 + j );
				Color	fg = getStringColor( bg );
				bw.write(
					String.format(
						" * <td bgcolor='%s' width='20%%'><font color='%s' size='-1'>%s<br>%s</font></td>\n",
						bg.toString(), fg.toString(), name.get( i * 5 + j ), bg.toString()
					)
				);
			}
			bw.write( " * </tr>\n" );
		}
		bw.write( " * </table>\n */\n" );
		bw.write( "public enum WebColor implements Valuable {\n" );
		int	size = color.size();
		for ( int i = 0; i < size; i++ ) {
			Color	bg = color.get( i );
			Color	fg = getStringColor( bg );
			String	n = name.get( i );
			bw.write( "\t/**\n" );
			bw.write( "\t * " );
			bw.write( n );
			bw.write( "\n\t */\n" );
			bw.write(
				String.format(
					"\t%s( 0x%02x, 0x%02x, 0x%02x )",
					n, bg.getRed(), bg.getGreen(), bg.getBlue()
				)
			);
			if ( i == (size - 1) )	bw.write( ";" );
			else	bw.write( "," );
			bw.write( "\n" );
		}
		bw.write(
			String.format(
				"\tprivate static final long serialVersionUID = %dL;\n",
				new Date().getTime()
			)
		);
		bw.write( "\tint red, green, blue;\n" );
		bw.write( "\tprivate WebColor( int r, int g, int b ) {\n" );
		bw.write( "\t\tred = r;green = g;blue= b;\n" );
		bw.write( "\t}\n}" );
		bw.close();
	}
}
