/*
 * Decompiled with CFR 0.152.
 */
package paraselene.supervisor;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import paraselene.EphemeralPage;
import paraselene.Page;
import paraselene.supervisor.Child;
import paraselene.supervisor.ChildKiller;
import paraselene.supervisor.Daemon;
import paraselene.supervisor.EphemeralPosition;
import paraselene.supervisor.Forward;
import paraselene.supervisor.History;
import paraselene.supervisor.MemoryInformation;
import paraselene.supervisor.Option;
import paraselene.supervisor.PageFactory;
import paraselene.supervisor.PageID;
import paraselene.supervisor.RequestParameter;
import paraselene.tag.Tag;

public class SandBox
extends Thread {
    static volatile long wait_ms = 180000L;
    private static LinkedList<Child> waiting = new LinkedList();
    private static ArrayList<Child> running = new ArrayList();
    private static SandBox sand_box = null;
    static final long DAEMON_TIMEOUT = 1800000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Child getMyself() {
        long my_id = Thread.currentThread().getId();
        ArrayList<Child> arrayList = running;
        synchronized (arrayList) {
            int cnt = running.size();
            for (int i = 0; i < cnt; ++i) {
                Child child = running.get(i);
                if (child.thread_id != my_id) continue;
                return child;
            }
        }
        return null;
    }

    public static Page getCurrentPage() {
        Child child = SandBox.getMyself();
        if (child == null) {
            return null;
        }
        return child.main_page;
    }

    public static RequestParameter getCurrentRequestParameter() {
        Child child = SandBox.getMyself();
        if (child == null) {
            return null;
        }
        return child.request;
    }

    public static History getCurrentPageHistory() {
        return SandBox.getCurrentRequestParameter().getHistory();
    }

    public static boolean isCurrentInput() {
        Child child = SandBox.getMyself();
        if (child == null) {
            return false;
        }
        return child.call_input;
    }

    public static PageFactory getPageFactory() {
        Child child = SandBox.getMyself();
        if (child == null) {
            return null;
        }
        return child.factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object doModal(PageID id, EphemeralPosition p, Tag hint, Object c) throws Page.PageException {
        if (!SandBox.isCurrentInput()) {
            throw new Page.PageException("no input method.");
        }
        RequestParameter req = SandBox.getCurrentRequestParameter();
        if (req == null) {
            throw new Page.PageException("cannot getCurrentRequestParameter()");
        }
        Page page = SandBox.getPageFactory().getPage(id);
        if (!(page instanceof EphemeralPage)) {
            throw new Page.PageException(id + " isn't EphemeralPage");
        }
        Child child = SandBox.getMyself();
        History hist = req.getHistory();
        page.setPopupType(p, hint);
        page.beginning(req, c);
        page.setPopupType(null, null);
        hist.callStack(child, page, p, hint);
        child.parent.interrupt();
        Child child2 = child;
        synchronized (child2) {
            try {
                hist.unlock();
                child.wait(3600000L);
                hist.lock();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return hist.popStack(child);
    }

    public static boolean isCurrentDaemon() {
        Child child = SandBox.getMyself();
        if (child == null) {
            return false;
        }
        return child.daemon != null;
    }

    private SandBox() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getWaitChild() {
        LinkedList<Child> linkedList = waiting;
        synchronized (linkedList) {
            return waiting.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getRunningChild() {
        ArrayList<Child> arrayList = running;
        synchronized (arrayList) {
            return running.size();
        }
    }

    public static boolean isSafeFreeMemory() {
        MemoryInformation mem = new MemoryInformation();
        mem.doGC();
        return mem.isSafeFreeMemory();
    }

    public static long getTimeoutMinute() {
        return wait_ms / 60000L;
    }

    public static void setTimeoutMinute(long min) {
        wait_ms = min * 60L * 1000L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void doStart() {
        LinkedList<Child> linkedList = waiting;
        synchronized (linkedList) {
            if (sand_box != null) {
                return;
            }
            ChildKiller.init(running);
            sand_box = new SandBox();
            sand_box.setDaemon(true);
            sand_box.setPriority(1);
            sand_box.setDaemon(true);
            sand_box.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int low_cnt;
        int running_last_cnt = low_cnt = 20;
        int include_cnt = low_cnt >> 2;
        long max_interval = 15000L;
        long interval = 500L;
        long last_tm = 0L;
        while (true) {
            if (waiting == null || running == null) {
                return;
            }
            try {
                Object object;
                Object object2 = waiting;
                synchronized (object2) {
                    Child child;
                    int cnt = waiting.size();
                    if (cnt > 0 && !Option.isReleaseMode()) {
                        while ((cnt = waiting.size()) > 0) {
                            child = waiting.poll();
                            object = child;
                            synchronized (object) {
                                child.notifyAll();
                            }
                        }
                    }
                    if (SandBox.isSafeFreeMemory() && cnt < running_last_cnt && Option.isReleaseMode()) {
                        for (int i = 0; i < include_cnt; ++i) {
                            Child child2 = new Child();
                            waiting.wait(10L);
                            waiting.offer(child2);
                        }
                    } else if (cnt > running_last_cnt + include_cnt) {
                        child = waiting.poll();
                        object = child;
                        synchronized (object) {
                            child.notifyAll();
                        }
                    }
                }
                object2 = this;
                synchronized (object2) {
                    last_tm = new Date().getTime();
                    this.wait(interval, 1);
                }
                long time_sub = new Date().getTime() - last_tm;
                int cnt = 0;
                if (running == null) break;
                object = running;
                synchronized (object) {
                    cnt = running.size() - running_last_cnt;
                }
                if (cnt > running_last_cnt) {
                    running_last_cnt = cnt;
                } else if (low_cnt < running_last_cnt) {
                    --running_last_cnt;
                }
                include_cnt = running_last_cnt >> 2;
                if (time_sub < interval) {
                    interval >>= 1;
                    continue;
                }
                if (interval >= max_interval) continue;
                interval += 100L;
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    Thread.sleep(1000L);
                }
                catch (Exception ee) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Child getChild() {
        Child child = null;
        LinkedList<Child> linkedList = waiting;
        synchronized (linkedList) {
            int cnt = waiting.size();
            if (cnt > 0) {
                child = waiting.poll();
            }
        }
        if (child == null) {
            child = new Child();
        }
        while (child.getState() != Thread.State.WAITING) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        return child;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void startChild(Child child) {
        Object object = running;
        synchronized (object) {
            running.add(child);
        }
        object = child;
        synchronized (object) {
            child.start_dt = new Date();
            child.limit_dt = new Date(child.start_dt.getTime() + 1800000L);
            child.notifyAll();
        }
        object = sand_box;
        synchronized (object) {
            sand_box.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static History[] getCurrentHistory() {
        Child myself = SandBox.getMyself();
        if (myself == null) {
            return null;
        }
        Object hist = null;
        if (myself.daemon != null) {
            ArrayList<History> arrayList = myself.hist;
            synchronized (arrayList) {
                return myself.hist.toArray(new History[0]);
            }
        }
        return new History[]{SandBox.getCurrentRequestParameter().getHistory()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startDaemon(String name, Daemon daemon) {
        History[] hist = SandBox.getCurrentHistory();
        if (hist == null) {
            return;
        }
        Child child = null;
        HashMap<String, Child> hashMap = Child.name_space;
        synchronized (hashMap) {
            child = Child.name_space.get(name);
            if (child == null) {
                child = SandBox.getChild();
                child.factory = SandBox.getPageFactory();
                child.daemon = daemon;
                child.hist = new ArrayList();
                if (name != null) {
                    child.daemon_name = name;
                    Child.name_space.put(name, child);
                }
                for (int i = 0; i < hist.length; ++i) {
                    child.addHistory(hist[i]);
                }
                SandBox.startChild(child);
                return;
            }
        }
        for (int i = 0; i < hist.length; ++i) {
            child.addHistory(hist[i]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void depriveDaemonOfPage() {
        History[] hist = SandBox.getCurrentHistory();
        if (hist == null) {
            return;
        }
        if (hist.length == 0) {
            return;
        }
        ArrayList<Child> list = new ArrayList<Child>();
        ArrayList<Child> arrayList = running;
        synchronized (arrayList) {
            int cnt = running.size();
            for (int i = 0; i < cnt; ++i) {
                Child child = running.get(i);
                list.add(child);
            }
        }
        int cnt = list.size();
        for (int i = 0; i < cnt; ++i) {
            Child child = (Child)list.get(i);
            if (child.hist == null) continue;
            for (int j = 0; j < hist.length; ++j) {
                child.removeHistory(hist[j]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object postDaemon(String name, Object obj) {
        Child child = null;
        HashMap<String, Child> hashMap = Child.name_space;
        synchronized (hashMap) {
            child = Child.name_space.get(name);
        }
        if (child == null) {
            return null;
        }
        return child.daemon.post(obj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isAliveDaemon(String name) {
        HashMap<String, Child> hashMap = Child.name_space;
        synchronized (hashMap) {
            return Child.name_space.get(name) != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void removeChild(Child child) {
        ArrayList<Child> arrayList = running;
        synchronized (arrayList) {
            running.remove(child);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void kick(Child child, boolean start_f) throws Throwable {
        child.parent = Thread.currentThread();
        if (start_f) {
            SandBox.startChild(child);
        } else {
            Child child2 = child;
            synchronized (child2) {
                child.notifyAll();
            }
        }
        child.join(wait_ms);
        if (!child.isAlive()) {
            SandBox.removeChild(child);
            if (child.th != null) {
                throw child.th;
            }
            return;
        }
        throw ChildKiller.kill(child);
    }

    static Forward input(PageFactory pf, Page action, RequestParameter req, Forward fw) throws Throwable {
        Child child = SandBox.getChild();
        child.factory = pf;
        child.main_page = action;
        child.request = req;
        child.forward = fw;
        child.call_input = true;
        return SandBox.input_sub(child, true, null);
    }

    static Forward input_sub(Child child, boolean start_f, History hist) throws Throwable {
        block6: {
            try {
                if (hist != null) {
                    hist.unlock();
                }
                SandBox.kick(child, start_f);
                if (hist != null) {
                    hist.lock();
                }
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                Forward next = null;
                if (hist == null) {
                    hist = child.request.getHistory(child.main_page.getHistoryKey());
                }
                if (hist != null) {
                    next = hist.getStackForward(child);
                }
                if (next == null) break block6;
                child.forward = next;
            }
        }
        return child.forward;
    }

    static Page output(PageFactory pf, Page action, Page page, RequestParameter req, boolean refresh_f) throws Throwable {
        Child child = SandBox.getChild();
        child.factory = pf;
        child.main_page = action;
        child.param_page = page;
        child.request = req;
        child.call_input = false;
        child.refresh_f = refresh_f;
        SandBox.kick(child, true);
        return child.param_page;
    }
}

