/*
 * Paraselene
 * Copyright (c) 2009-2011  Akira Terasaki
 * このファイルは同梱されている License.txt に定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene;

import java.util.*;
import java.io.*;

/**
 * MIME Media Type。以下の物が取得可能です。
 * <table border='1'>
 * <tr><th>MIME Media Type</th><th>拡張子</th>
 * <tr><td>application/andrew-inset</td><td>ez&nbsp;</td></tr>
 * <tr><td>application/annodex</td><td>anx&nbsp;</td></tr>
 * <tr><td>application/atom+xml</td><td>atom&nbsp;</td></tr>
 * <tr><td>application/atomcat+xml</td><td>atomcat&nbsp;</td></tr>
 * <tr><td>application/atomserv+xml</td><td>atomsrv&nbsp;</td></tr>
 * <tr><td>application/atomsvc+xml</td><td>atomsvc&nbsp;</td></tr>
 * <tr><td>application/auth-policy+xml</td><td>apxml&nbsp;</td></tr>
 * <tr><td>application/bbolin</td><td>lin&nbsp;</td></tr>
 * <tr><td>application/cap</td><td>pcap&nbsp;cap&nbsp;</td></tr>
 * <tr><td>application/ccxml+xml</td><td>ccxml&nbsp;</td></tr>
 * <tr><td>application/cellml+xml</td><td>cml&nbsp;cellml&nbsp;</td></tr>
 * <tr><td>application/cpl+xml</td><td>cpl&nbsp;</td></tr>
 * <tr><td>application/cu-seeme</td><td>cu&nbsp;</td></tr>
 * <tr><td>application/davmount+xml</td><td>davmount&nbsp;</td></tr>
 * <tr><td>application/dicom</td><td>dcm&nbsp;</td></tr>
 * <tr><td>application/dsptype</td><td>tsp&nbsp;</td></tr>
 * <tr><td>application/dssc+der</td><td>dssc&nbsp;</td></tr>
 * <tr><td>application/dssc+xml</td><td>xdssc&nbsp;</td></tr>
 * <tr><td>application/dvcs</td><td>dvc&nbsp;</td></tr>
 * <tr><td>application/ecmascript</td><td>es&nbsp;</td></tr>
 * <tr><td>application/emma+xml</td><td>emma&nbsp;</td></tr>
 * <tr><td>application/fastinfoset</td><td>finf&nbsp;</td></tr>
 * <tr><td>application/font-tdpfr</td><td>pfr&nbsp;</td></tr>
 * <tr><td>application/futuresplash</td><td>spl&nbsp;</td></tr>
 * <tr><td>application/hta</td><td>hta&nbsp;</td></tr>
 * <tr><td>application/hyperstudio</td><td>stk&nbsp;</td></tr>
 * <tr><td>application/ipfix</td><td>ipfix&nbsp;</td></tr>
 * <tr><td>application/java-archive</td><td>jar&nbsp;</td></tr>
 * <tr><td>application/java-serialized-object</td><td>ser&nbsp;</td></tr>
 * <tr><td>application/java-vm</td><td>class&nbsp;</td></tr>
 * <tr><td>application/javascript</td><td>js&nbsp;</td></tr>
 * <tr><td>application/json</td><td>json&nbsp;</td></tr>
 * <tr><td>application/lost+xml</td><td>lostxml&nbsp;</td></tr>
 * <tr><td>application/m3g</td><td>m3g&nbsp;</td></tr>
 * <tr><td>application/mac-binhex40</td><td>hqx&nbsp;</td></tr>
 * <tr><td>application/mac-compactpro</td><td>cpt&nbsp;</td></tr>
 * <tr><td>application/marc</td><td>mrc&nbsp;</td></tr>
 * <tr><td>application/mathematica</td><td>nb&nbsp;nbp&nbsp;ma&nbsp;mb&nbsp;</td></tr>
 * <tr><td>application/mathml+xml</td><td>mml&nbsp;</td></tr>
 * <tr><td>application/mbox</td><td>mbox&nbsp;</td></tr>
 * <tr><td>application/metalink+xml</td><td>metalink&nbsp;</td></tr>
 * <tr><td>application/mp21</td><td>mp21&nbsp;m21&nbsp;</td></tr>
 * <tr><td>application/msaccess</td><td>mdb&nbsp;</td></tr>
 * <tr><td>application/msword</td><td>doc&nbsp;dot&nbsp;</td></tr>
 * <tr><td>application/mxf</td><td>mxf&nbsp;</td></tr>
 * <tr><td>application/ocsp-request</td><td>orq&nbsp;</td></tr>
 * <tr><td>application/ocsp-response</td><td>ors&nbsp;</td></tr>
 * <tr><td>application/octet-stream</td><td>lzh&nbsp;iso&nbsp;so&nbsp;img&nbsp;class&nbsp;dll&nbsp;bin&nbsp;lha&nbsp;exe&nbsp;</td></tr>
 * <tr><td>application/oda</td><td>oda&nbsp;</td></tr>
 * <tr><td>application/oebps-package+xml</td><td>opf&nbsp;</td></tr>
 * <tr><td>application/ogg</td><td>ogx&nbsp;</td></tr>
 * <tr><td>application/pdf</td><td>pdf&nbsp;</td></tr>
 * <tr><td>application/pgp-keys</td><td>key&nbsp;</td></tr>
 * <tr><td>application/pgp-signature</td><td>pgp&nbsp;sig&nbsp;</td></tr>
 * <tr><td>application/pics-rules</td><td>prf&nbsp;</td></tr>
 * <tr><td>application/pkcs10</td><td>p10&nbsp;</td></tr>
 * <tr><td>application/pkcs7-mime</td><td>p7m&nbsp;p7c&nbsp;</td></tr>
 * <tr><td>application/pkcs7-signature</td><td>p7s&nbsp;</td></tr>
 * <tr><td>application/pkix-cert</td><td>cer&nbsp;</td></tr>
 * <tr><td>application/pkix-crl</td><td>crl&nbsp;</td></tr>
 * <tr><td>application/pkix-pkipath</td><td>pkipath&nbsp;</td></tr>
 * <tr><td>application/pls+xml</td><td>pls&nbsp;</td></tr>
 * <tr><td>application/postscript</td><td>eps&nbsp;eps3&nbsp;ai&nbsp;eps2&nbsp;epsf&nbsp;epsi&nbsp;ps&nbsp;</td></tr>
 * <tr><td>application/prs.cww</td><td>cww&nbsp;cw&nbsp;</td></tr>
 * <tr><td>application/prs.nprend</td><td>rnd&nbsp;rct&nbsp;</td></tr>
 * <tr><td>application/rar</td><td>rar&nbsp;</td></tr>
 * <tr><td>application/rdf+xml</td><td>rdf&nbsp;</td></tr>
 * <tr><td>application/reginfo+xml</td><td>rif&nbsp;</td></tr>
 * <tr><td>application/relax-ng-compact-syntax</td><td>rnc&nbsp;</td></tr>
 * <tr><td>application/resource-lists+xml</td><td>rl&nbsp;</td></tr>
 * <tr><td>application/resource-lists-diff+xml</td><td>rld&nbsp;</td></tr>
 * <tr><td>application/rls-services+xml</td><td>rs&nbsp;</td></tr>
 * <tr><td>application/rss+xml</td><td>rss&nbsp;</td></tr>
 * <tr><td>application/rtf</td><td>rtf&nbsp;</td></tr>
 * <tr><td>application/scvp-cv-request</td><td>scq&nbsp;</td></tr>
 * <tr><td>application/scvp-cv-response</td><td>scs&nbsp;</td></tr>
 * <tr><td>application/scvp-vp-request</td><td>spq&nbsp;</td></tr>
 * <tr><td>application/scvp-vp-response</td><td>spp&nbsp;</td></tr>
 * <tr><td>application/sdp</td><td>sdp&nbsp;</td></tr>
 * <tr><td>application/sgml-open-catalog</td><td>soc&nbsp;</td></tr>
 * <tr><td>application/shf+xml</td><td>shf&nbsp;</td></tr>
 * <tr><td>application/sieve</td><td>sieve&nbsp;siv&nbsp;</td></tr>
 * <tr><td>application/simple-filter+xml</td><td>cl&nbsp;</td></tr>
 * <tr><td>application/smil</td><td>smil&nbsp;sml&nbsp;smi&nbsp;</td></tr>
 * <tr><td>application/sparql-query</td><td>rq&nbsp;</td></tr>
 * <tr><td>application/sparql-results+xml</td><td>srx&nbsp;</td></tr>
 * <tr><td>application/srgs</td><td>gram&nbsp;</td></tr>
 * <tr><td>application/srgs+xml</td><td>grxml&nbsp;</td></tr>
 * <tr><td>application/ssml+xml</td><td>ssml&nbsp;</td></tr>
 * <tr><td>application/timestamp-query</td><td>tsq&nbsp;</td></tr>
 * <tr><td>application/timestamp-reply</td><td>tsr&nbsp;</td></tr>
 * <tr><td>application/vnd.3M.Post-it-Notes</td><td>pwn&nbsp;</td></tr>
 * <tr><td>application/vnd.3gpp.pic-bw-large</td><td>plb&nbsp;</td></tr>
 * <tr><td>application/vnd.3gpp.pic-bw-small</td><td>psb&nbsp;</td></tr>
 * <tr><td>application/vnd.3gpp.pic-bw-var</td><td>pvb&nbsp;</td></tr>
 * <tr><td>application/vnd.3gpp2.sms</td><td>sms&nbsp;</td></tr>
 * <tr><td>application/vnd.3gpp2.tcap</td><td>tcap&nbsp;</td></tr>
 * <tr><td>application/vnd.FloGraphIt</td><td>gph&nbsp;</td></tr>
 * <tr><td>application/vnd.HandHeld-Entertainment+xml</td><td>zmm&nbsp;</td></tr>
 * <tr><td>application/vnd.Kinar</td><td>kne&nbsp;sdf&nbsp;knp&nbsp;</td></tr>
 * <tr><td>application/vnd.MFER</td><td>mwf&nbsp;</td></tr>
 * <tr><td>application/vnd.Mobius.DAF</td><td>daf&nbsp;</td></tr>
 * <tr><td>application/vnd.Mobius.DIS</td><td>dis&nbsp;</td></tr>
 * <tr><td>application/vnd.Mobius.MBK</td><td>mbk&nbsp;</td></tr>
 * <tr><td>application/vnd.Mobius.MQY</td><td>mqy&nbsp;</td></tr>
 * <tr><td>application/vnd.Mobius.MSL</td><td>msl&nbsp;</td></tr>
 * <tr><td>application/vnd.Mobius.PLC</td><td>plc&nbsp;</td></tr>
 * <tr><td>application/vnd.Mobius.TXF</td><td>txf&nbsp;</td></tr>
 * <tr><td>application/vnd.Quark.QuarkXPress</td><td>qxl&nbsp;qwd&nbsp;qxd&nbsp;qwt&nbsp;qxt&nbsp;qxb&nbsp;</td></tr>
 * <tr><td>application/vnd.SimTech-MindMapper</td><td>twds&nbsp;twd&nbsp;</td></tr>
 * <tr><td>application/vnd.accpac.simply.aso</td><td>aso&nbsp;</td></tr>
 * <tr><td>application/vnd.accpac.simply.imp</td><td>imp&nbsp;</td></tr>
 * <tr><td>application/vnd.acucobol</td><td>acu&nbsp;</td></tr>
 * <tr><td>application/vnd.acucorp</td><td>acutc&nbsp;atc&nbsp;</td></tr>
 * <tr><td>application/vnd.adobe.xdp+xml</td><td>xdp&nbsp;</td></tr>
 * <tr><td>application/vnd.adobe.xfdf</td><td>xfdf&nbsp;</td></tr>
 * <tr><td>application/vnd.airzip.filesecure.azf</td><td>azf&nbsp;</td></tr>
 * <tr><td>application/vnd.airzip.filesecure.azs</td><td>azs&nbsp;</td></tr>
 * <tr><td>application/vnd.americandynamics.acc</td><td>acc&nbsp;</td></tr>
 * <tr><td>application/vnd.amiga.ami</td><td>ami&nbsp;</td></tr>
 * <tr><td>application/vnd.android.package-archive</td><td>apk&nbsp;</td></tr>
 * <tr><td>application/vnd.anser-web-certificate-issue-initiation</td><td>cii&nbsp;</td></tr>
 * <tr><td>application/vnd.anser-web-funds-transfer-initiation</td><td>fti&nbsp;</td></tr>
 * <tr><td>application/vnd.apple.installer+xml</td><td>distz&nbsp;mpkg&nbsp;pkg&nbsp;dist&nbsp;</td></tr>
 * <tr><td>application/vnd.apple.mpegurl</td><td>m3u8&nbsp;</td></tr>
 * <tr><td>application/vnd.aristanetworks.swi</td><td>swi&nbsp;</td></tr>
 * <tr><td>application/vnd.audiograph</td><td>aep&nbsp;</td></tr>
 * <tr><td>application/vnd.autopackage</td><td>package&nbsp;</td></tr>
 * <tr><td>application/vnd.blueice.multipass</td><td>mpm&nbsp;</td></tr>
 * <tr><td>application/vnd.bluetooth.ep.oob</td><td>ep&nbsp;</td></tr>
 * <tr><td>application/vnd.bmi</td><td>bmi&nbsp;</td></tr>
 * <tr><td>application/vnd.businessobjects</td><td>rep&nbsp;</td></tr>
 * <tr><td>application/vnd.cendio.thinlinc.clientconf</td><td>tlclient&nbsp;</td></tr>
 * <tr><td>application/vnd.chemdraw+xml</td><td>cdxml&nbsp;</td></tr>
 * <tr><td>application/vnd.chipnuts.karaoke-mmd</td><td>mmd&nbsp;</td></tr>
 * <tr><td>application/vnd.cinderella</td><td>cdy&nbsp;</td></tr>
 * <tr><td>application/vnd.claymore</td><td>cla&nbsp;</td></tr>
 * <tr><td>application/vnd.cloanto.rp9</td><td>rp9&nbsp;</td></tr>
 * <tr><td>application/vnd.clonk.c4group</td><td>c4u&nbsp;c4g&nbsp;c4f&nbsp;c4d&nbsp;c4p&nbsp;</td></tr>
 * <tr><td>application/vnd.commerce-battelle</td><td>icf&nbsp;ic1&nbsp;ic0&nbsp;icd&nbsp;ic3&nbsp;ic2&nbsp;ic5&nbsp;ica&nbsp;ic4&nbsp;ic7&nbsp;ic6&nbsp;ic8&nbsp;</td></tr>
 * <tr><td>application/vnd.commonspace</td><td>cst&nbsp;csp&nbsp;</td></tr>
 * <tr><td>application/vnd.contact.cmsg</td><td>cdbcmsg&nbsp;</td></tr>
 * <tr><td>application/vnd.cosmocaller</td><td>cmc&nbsp;</td></tr>
 * <tr><td>application/vnd.crick.clicker</td><td>clkx&nbsp;</td></tr>
 * <tr><td>application/vnd.crick.clicker.keyboard</td><td>clkk&nbsp;</td></tr>
 * <tr><td>application/vnd.crick.clicker.palette</td><td>clkp&nbsp;</td></tr>
 * <tr><td>application/vnd.crick.clicker.template</td><td>clkt&nbsp;</td></tr>
 * <tr><td>application/vnd.crick.clicker.wordbank</td><td>clkw&nbsp;</td></tr>
 * <tr><td>application/vnd.criticaltools.wbs+xml</td><td>wbs&nbsp;</td></tr>
 * <tr><td>application/vnd.ctc-posml</td><td>pml&nbsp;</td></tr>
 * <tr><td>application/vnd.cups-ppd</td><td>ppd&nbsp;</td></tr>
 * <tr><td>application/vnd.curl</td><td>curl&nbsp;</td></tr>
 * <tr><td>application/vnd.data-vision.rdz</td><td>rdz&nbsp;</td></tr>
 * <tr><td>application/vnd.denovo.fcselayout-link</td><td>fe_launch&nbsp;</td></tr>
 * <tr><td>application/vnd.dna</td><td>dna&nbsp;</td></tr>
 * <tr><td>application/vnd.dpgraph</td><td>mwc&nbsp;dpgraph&nbsp;dpg&nbsp;</td></tr>
 * <tr><td>application/vnd.dreamfactory</td><td>dfac&nbsp;</td></tr>
 * <tr><td>application/vnd.dynageo</td><td>geo&nbsp;</td></tr>
 * <tr><td>application/vnd.ecowin.chart</td><td>mag&nbsp;</td></tr>
 * <tr><td>application/vnd.enliven</td><td>nml&nbsp;</td></tr>
 * <tr><td>application/vnd.epson.esf</td><td>esf&nbsp;</td></tr>
 * <tr><td>application/vnd.epson.msf</td><td>msf&nbsp;</td></tr>
 * <tr><td>application/vnd.epson.quickanime</td><td>qam&nbsp;</td></tr>
 * <tr><td>application/vnd.epson.salt</td><td>slt&nbsp;</td></tr>
 * <tr><td>application/vnd.epson.ssf</td><td>ssf&nbsp;</td></tr>
 * <tr><td>application/vnd.ericsson.quickcall</td><td>qca&nbsp;qcall&nbsp;</td></tr>
 * <tr><td>application/vnd.eszigno3+xml</td><td>et3&nbsp;es3&nbsp;</td></tr>
 * <tr><td>application/vnd.ezpix-album</td><td>ez2&nbsp;</td></tr>
 * <tr><td>application/vnd.ezpix-package</td><td>ez3&nbsp;</td></tr>
 * <tr><td>application/vnd.fdf</td><td>fdf&nbsp;</td></tr>
 * <tr><td>application/vnd.fdsn.mseed</td><td>mseed&nbsp;msd&nbsp;</td></tr>
 * <tr><td>application/vnd.fluxtime.clip</td><td>ftc&nbsp;</td></tr>
 * <tr><td>application/vnd.font-fontforge-sfd</td><td>sfd&nbsp;</td></tr>
 * <tr><td>application/vnd.framemaker</td><td>fm&nbsp;</td></tr>
 * <tr><td>application/vnd.frogans.fnc</td><td>fnc&nbsp;</td></tr>
 * <tr><td>application/vnd.frogans.ltf</td><td>ltf&nbsp;</td></tr>
 * <tr><td>application/vnd.fsc.weblaunch</td><td>fsc&nbsp;</td></tr>
 * <tr><td>application/vnd.fsdn.seed</td><td>dataless&nbsp;seed&nbsp;</td></tr>
 * <tr><td>application/vnd.fujitsu.oasys</td><td>oas&nbsp;</td></tr>
 * <tr><td>application/vnd.fujitsu.oasys2</td><td>oa2&nbsp;</td></tr>
 * <tr><td>application/vnd.fujitsu.oasys3</td><td>oa3&nbsp;</td></tr>
 * <tr><td>application/vnd.fujitsu.oasysgp</td><td>fg5&nbsp;</td></tr>
 * <tr><td>application/vnd.fujitsu.oasysprs</td><td>bh2&nbsp;</td></tr>
 * <tr><td>application/vnd.fujixerox.ddd</td><td>ddd&nbsp;</td></tr>
 * <tr><td>application/vnd.fujixerox.docuworks</td><td>xdw&nbsp;</td></tr>
 * <tr><td>application/vnd.fujixerox.docuworks.binder</td><td>xbd&nbsp;</td></tr>
 * <tr><td>application/vnd.fuzzysheet</td><td>fzs&nbsp;</td></tr>
 * <tr><td>application/vnd.genomatix.tuxedo</td><td>txd&nbsp;</td></tr>
 * <tr><td>application/vnd.geogebra.file</td><td>ggb&nbsp;</td></tr>
 * <tr><td>application/vnd.geogebra.tool</td><td>ggt&nbsp;</td></tr>
 * <tr><td>application/vnd.geometry-explorer</td><td>gex&nbsp;gre&nbsp;</td></tr>
 * <tr><td>application/vnd.geonext</td><td>gxt&nbsp;</td></tr>
 * <tr><td>application/vnd.geoplan</td><td>g2w&nbsp;</td></tr>
 * <tr><td>application/vnd.geospace</td><td>g3w&nbsp;</td></tr>
 * <tr><td>application/vnd.google-earth.kml+xml</td><td>kml&nbsp;</td></tr>
 * <tr><td>application/vnd.google-earth.kmz</td><td>kmz&nbsp;</td></tr>
 * <tr><td>application/vnd.grafeq</td><td>gqs&nbsp;gqf&nbsp;</td></tr>
 * <tr><td>application/vnd.groove-account</td><td>gac&nbsp;</td></tr>
 * <tr><td>application/vnd.groove-help</td><td>ghf&nbsp;</td></tr>
 * <tr><td>application/vnd.groove-identity-message</td><td>gim&nbsp;</td></tr>
 * <tr><td>application/vnd.groove-injector</td><td>grv&nbsp;</td></tr>
 * <tr><td>application/vnd.groove-tool-message</td><td>gtm&nbsp;</td></tr>
 * <tr><td>application/vnd.groove-tool-template</td><td>tpl&nbsp;</td></tr>
 * <tr><td>application/vnd.groove-vcard</td><td>vcg&nbsp;</td></tr>
 * <tr><td>application/vnd.hbci</td><td>hbci&nbsp;upa&nbsp;bpd&nbsp;kom&nbsp;pkd&nbsp;hbc&nbsp;</td></tr>
 * <tr><td>application/vnd.hhe.lesson-player</td><td>les&nbsp;</td></tr>
 * <tr><td>application/vnd.hp-HPGL</td><td>hpgl&nbsp;</td></tr>
 * <tr><td>application/vnd.hp-PCL</td><td>pcl&nbsp;</td></tr>
 * <tr><td>application/vnd.hp-hpid</td><td>hpi&nbsp;hpid&nbsp;</td></tr>
 * <tr><td>application/vnd.hp-hps</td><td>hps&nbsp;</td></tr>
 * <tr><td>application/vnd.hp-jlyt</td><td>jlt&nbsp;</td></tr>
 * <tr><td>application/vnd.hydrostatix.sof-data</td><td>sfd-hdstx&nbsp;</td></tr>
 * <tr><td>application/vnd.hzn-3d-crossword</td><td>x3d&nbsp;</td></tr>
 * <tr><td>application/vnd.ibm.MiniPay</td><td>mpy&nbsp;</td></tr>
 * <tr><td>application/vnd.ibm.electronic-media</td><td>emm&nbsp;</td></tr>
 * <tr><td>application/vnd.ibm.modcap</td><td>afp&nbsp;list3820&nbsp;pseg3820&nbsp;listafp&nbsp;</td></tr>
 * <tr><td>application/vnd.ibm.rights-management</td><td>irm&nbsp;</td></tr>
 * <tr><td>application/vnd.ibm.secure-container</td><td>sc&nbsp;</td></tr>
 * <tr><td>application/vnd.iccprofile</td><td>icc&nbsp;icm&nbsp;</td></tr>
 * <tr><td>application/vnd.igloader</td><td>igl&nbsp;</td></tr>
 * <tr><td>application/vnd.immervision-ivp</td><td>ivp&nbsp;</td></tr>
 * <tr><td>application/vnd.immervision-ivu</td><td>ivu&nbsp;</td></tr>
 * <tr><td>application/vnd.intercon.formnet</td><td>xpw&nbsp;xpx&nbsp;</td></tr>
 * <tr><td>application/vnd.intu.qbo</td><td>qbo&nbsp;</td></tr>
 * <tr><td>application/vnd.intu.qfx</td><td>qfx&nbsp;</td></tr>
 * <tr><td>application/vnd.ipunplugged.rcprofile</td><td>rcprofile&nbsp;</td></tr>
 * <tr><td>application/vnd.irepository.package+xml</td><td>irp&nbsp;</td></tr>
 * <tr><td>application/vnd.is-xpr</td><td>xpr&nbsp;</td></tr>
 * <tr><td>application/vnd.jam</td><td>jam&nbsp;</td></tr>
 * <tr><td>application/vnd.jcp.javame.midlet-rms</td><td>rms&nbsp;</td></tr>
 * <tr><td>application/vnd.jisp</td><td>jisp&nbsp;</td></tr>
 * <tr><td>application/vnd.joost.joda-archive</td><td>joda&nbsp;</td></tr>
 * <tr><td>application/vnd.kahootz</td><td>ktr&nbsp;ktz&nbsp;</td></tr>
 * <tr><td>application/vnd.kde.karbon</td><td>karbon&nbsp;</td></tr>
 * <tr><td>application/vnd.kde.kchart</td><td>chrt&nbsp;</td></tr>
 * <tr><td>application/vnd.kde.kformula</td><td>kfo&nbsp;</td></tr>
 * <tr><td>application/vnd.kde.kivio</td><td>flw&nbsp;</td></tr>
 * <tr><td>application/vnd.kde.kontour</td><td>kon&nbsp;</td></tr>
 * <tr><td>application/vnd.kde.kpresenter</td><td>kpr&nbsp;kpt&nbsp;</td></tr>
 * <tr><td>application/vnd.kde.kspread</td><td>ksp&nbsp;</td></tr>
 * <tr><td>application/vnd.kde.kword</td><td>kwd&nbsp;kwt&nbsp;</td></tr>
 * <tr><td>application/vnd.kenameaapp</td><td>htke&nbsp;</td></tr>
 * <tr><td>application/vnd.kidspiration</td><td>kia&nbsp;</td></tr>
 * <tr><td>application/vnd.koan</td><td>skm&nbsp;skp&nbsp;skd&nbsp;skt&nbsp;</td></tr>
 * <tr><td>application/vnd.kodak-descriptor</td><td>sse&nbsp;</td></tr>
 * <tr><td>application/vnd.llamagraphics.life-balance.desktop</td><td>lbd&nbsp;</td></tr>
 * <tr><td>application/vnd.llamagraphics.life-balance.exchange+xml</td><td>lbe&nbsp;</td></tr>
 * <tr><td>application/vnd.lotus-1-2-3</td><td>wk4&nbsp;123&nbsp;wk3&nbsp;wk1&nbsp;</td></tr>
 * <tr><td>application/vnd.lotus-approach</td><td>vew&nbsp;apr&nbsp;</td></tr>
 * <tr><td>application/vnd.lotus-freelance</td><td>pre&nbsp;prz&nbsp;</td></tr>
 * <tr><td>application/vnd.lotus-notes</td><td>ns2&nbsp;ns4&nbsp;ns3&nbsp;ndl&nbsp;nsf&nbsp;nsh&nbsp;nsg&nbsp;ntf&nbsp;</td></tr>
 * <tr><td>application/vnd.lotus-organizer</td><td>or2&nbsp;org&nbsp;or3&nbsp;</td></tr>
 * <tr><td>application/vnd.lotus-screencam</td><td>scm&nbsp;</td></tr>
 * <tr><td>application/vnd.lotus-wordpro</td><td>lwp&nbsp;sam&nbsp;</td></tr>
 * <tr><td>application/vnd.macports.portpkg</td><td>portpkg&nbsp;</td></tr>
 * <tr><td>application/vnd.marlin.drm.mdcf</td><td>mdc&nbsp;</td></tr>
 * <tr><td>application/vnd.mcd</td><td>mcd&nbsp;</td></tr>
 * <tr><td>application/vnd.medcalcdata</td><td>mc1&nbsp;</td></tr>
 * <tr><td>application/vnd.mediastation.cdkey</td><td>cdkey&nbsp;</td></tr>
 * <tr><td>application/vnd.mfmp</td><td>mfm&nbsp;</td></tr>
 * <tr><td>application/vnd.micrografx.flo</td><td>flo&nbsp;</td></tr>
 * <tr><td>application/vnd.micrografx.igx</td><td>igx&nbsp;</td></tr>
 * <tr><td>application/vnd.mif</td><td>mif&nbsp;</td></tr>
 * <tr><td>application/vnd.mophun.application</td><td>mpn&nbsp;</td></tr>
 * <tr><td>application/vnd.mophun.certificate</td><td>mpc&nbsp;</td></tr>
 * <tr><td>application/vnd.mozilla.xul+xml</td><td>xul&nbsp;</td></tr>
 * <tr><td>application/vnd.ms-artgalry</td><td>cil&nbsp;</td></tr>
 * <tr><td>application/vnd.ms-asf</td><td>asf&nbsp;</td></tr>
 * <tr><td>application/vnd.ms-cab-compressed</td><td>cab&nbsp;</td></tr>
 * <tr><td>application/vnd.ms-excel</td><td>xlb&nbsp;xls&nbsp;xlt&nbsp;</td></tr>
 * <tr><td>application/vnd.ms-excel.addin.macroEnabled.12</td><td>xlam&nbsp;</td></tr>
 * <tr><td>application/vnd.ms-excel.sheet.binary.macroEnabled.12</td><td>xlsb&nbsp;</td></tr>
 * <tr><td>application/vnd.ms-excel.sheet.macroEnabled.12</td><td>xlsm&nbsp;</td></tr>
 * <tr><td>application/vnd.ms-excel.template.macroEnabled.12</td><td>xltm&nbsp;</td></tr>
 * <tr><td>application/vnd.ms-fontobject</td><td>eot&nbsp;</td></tr>
 * <tr><td>application/vnd.ms-htmlhelp</td><td>chm&nbsp;</td></tr>
 * <tr><td>application/vnd.ms-ims</td><td>ims&nbsp;</td></tr>
 * <tr><td>application/vnd.ms-lrm</td><td>lrm&nbsp;</td></tr>
 * <tr><td>application/vnd.ms-pki.seccat</td><td>cat&nbsp;</td></tr>
 * <tr><td>application/vnd.ms-pki.stl</td><td>stl&nbsp;</td></tr>
 * <tr><td>application/vnd.ms-powerpoint</td><td>pps&nbsp;ppt&nbsp;</td></tr>
 * <tr><td>application/vnd.ms-powerpoint.addin.macroEnabled.12</td><td>ppam&nbsp;</td></tr>
 * <tr><td>application/vnd.ms-powerpoint.presentation.macroEnabled.12</td><td>pptm&nbsp;</td></tr>
 * <tr><td>application/vnd.ms-powerpoint.slide.macroEnabled.12</td><td>sldm&nbsp;</td></tr>
 * <tr><td>application/vnd.ms-powerpoint.slideshow.macroEnabled.12</td><td>ppsm&nbsp;</td></tr>
 * <tr><td>application/vnd.ms-powerpoint.template.macroEnabled.12</td><td>potm&nbsp;</td></tr>
 * <tr><td>application/vnd.ms-project</td><td>mpp&nbsp;</td></tr>
 * <tr><td>application/vnd.ms-tnef</td><td>tnf&nbsp;tnef&nbsp;</td></tr>
 * <tr><td>application/vnd.ms-word.document.macroEnabled.12</td><td>docm&nbsp;</td></tr>
 * <tr><td>application/vnd.ms-word.template.macroEnabled.12</td><td>dotm&nbsp;</td></tr>
 * <tr><td>application/vnd.ms-works</td><td>wps&nbsp;wcm&nbsp;wks&nbsp;wdb&nbsp;</td></tr>
 * <tr><td>application/vnd.ms-wpl</td><td>wpl&nbsp;</td></tr>
 * <tr><td>application/vnd.ms-xpsdocument</td><td>xps&nbsp;</td></tr>
 * <tr><td>application/vnd.mseq</td><td>mseq&nbsp;</td></tr>
 * <tr><td>application/vnd.multiad.creator</td><td>crtr&nbsp;</td></tr>
 * <tr><td>application/vnd.multiad.creator.cif</td><td>cif&nbsp;</td></tr>
 * <tr><td>application/vnd.musician</td><td>mus&nbsp;</td></tr>
 * <tr><td>application/vnd.muvee.style</td><td>msty&nbsp;</td></tr>
 * <tr><td>application/vnd.nervana</td><td>kcm&nbsp;request&nbsp;entity&nbsp;bkm&nbsp;</td></tr>
 * <tr><td>application/vnd.neurolanguage.nlu</td><td>nlu&nbsp;</td></tr>
 * <tr><td>application/vnd.noblenet-directory</td><td>nnd&nbsp;</td></tr>
 * <tr><td>application/vnd.noblenet-sealer</td><td>nns&nbsp;</td></tr>
 * <tr><td>application/vnd.noblenet-web</td><td>nnw&nbsp;</td></tr>
 * <tr><td>application/vnd.nokia.n-gage.ac+xml</td><td>ac&nbsp;</td></tr>
 * <tr><td>application/vnd.nokia.n-gage.data</td><td>ngdat&nbsp;</td></tr>
 * <tr><td>application/vnd.nokia.n-gage.symbian.install</td><td>n-gage&nbsp;</td></tr>
 * <tr><td>application/vnd.nokia.radio-preset</td><td>rpst&nbsp;</td></tr>
 * <tr><td>application/vnd.nokia.radio-presets</td><td>rpss&nbsp;</td></tr>
 * <tr><td>application/vnd.novadigm.EDM</td><td>edm&nbsp;</td></tr>
 * <tr><td>application/vnd.novadigm.EDX</td><td>edx&nbsp;</td></tr>
 * <tr><td>application/vnd.novadigm.EXT</td><td>ext&nbsp;</td></tr>
 * <tr><td>application/vnd.oasis.opendocument.chart</td><td>odc&nbsp;</td></tr>
 * <tr><td>application/vnd.oasis.opendocument.chart-template</td><td>otc&nbsp;</td></tr>
 * <tr><td>application/vnd.oasis.opendocument.database</td><td>odb&nbsp;</td></tr>
 * <tr><td>application/vnd.oasis.opendocument.formula</td><td>odf&nbsp;</td></tr>
 * <tr><td>application/vnd.oasis.opendocument.formula-template</td><td>otf&nbsp;</td></tr>
 * <tr><td>application/vnd.oasis.opendocument.graphics</td><td>odg&nbsp;</td></tr>
 * <tr><td>application/vnd.oasis.opendocument.graphics-template</td><td>otg&nbsp;</td></tr>
 * <tr><td>application/vnd.oasis.opendocument.image</td><td>odi&nbsp;</td></tr>
 * <tr><td>application/vnd.oasis.opendocument.image-template</td><td>oti&nbsp;</td></tr>
 * <tr><td>application/vnd.oasis.opendocument.presentation</td><td>odp&nbsp;</td></tr>
 * <tr><td>application/vnd.oasis.opendocument.presentation-template</td><td>otp&nbsp;</td></tr>
 * <tr><td>application/vnd.oasis.opendocument.spreadsheet</td><td>ods&nbsp;</td></tr>
 * <tr><td>application/vnd.oasis.opendocument.spreadsheet-template</td><td>ots&nbsp;</td></tr>
 * <tr><td>application/vnd.oasis.opendocument.text</td><td>odt&nbsp;</td></tr>
 * <tr><td>application/vnd.oasis.opendocument.text-master</td><td>odm&nbsp;</td></tr>
 * <tr><td>application/vnd.oasis.opendocument.text-template</td><td>ott&nbsp;</td></tr>
 * <tr><td>application/vnd.oasis.opendocument.text-web</td><td>oth&nbsp;</td></tr>
 * <tr><td>application/vnd.olpc-sugar</td><td>xo&nbsp;</td></tr>
 * <tr><td>application/vnd.oma.dd+xml</td><td>dd&nbsp;</td></tr>
 * <tr><td>application/vnd.oma.dd2+xml</td><td>dd2&nbsp;</td></tr>
 * <tr><td>application/vnd.oma.drm.content</td><td>dcf&nbsp;</td></tr>
 * <tr><td>application/vnd.oma.drm.dcf</td><td>o4v&nbsp;o4a&nbsp;</td></tr>
 * <tr><td>application/vnd.oma.drm.message</td><td>dm&nbsp;</td></tr>
 * <tr><td>application/vnd.oma.drm.rights+wbxml</td><td>drc&nbsp;</td></tr>
 * <tr><td>application/vnd.oma.drm.rights+xml</td><td>dr&nbsp;</td></tr>
 * <tr><td>application/vnd.openofficeorg.extension</td><td>oxt&nbsp;</td></tr>
 * <tr><td>application/vnd.openxmlformats-officedocument.presentationml.presentation</td><td>pptx&nbsp;</td></tr>
 * <tr><td>application/vnd.openxmlformats-officedocument.presentationml.slide</td><td>sldx&nbsp;</td></tr>
 * <tr><td>application/vnd.openxmlformats-officedocument.presentationml.slideshow</td><td>ppsx&nbsp;</td></tr>
 * <tr><td>application/vnd.openxmlformats-officedocument.presentationml.template</td><td>potx&nbsp;</td></tr>
 * <tr><td>application/vnd.openxmlformats-officedocument.spreadsheetml.sheet</td><td>xlsx&nbsp;</td></tr>
 * <tr><td>application/vnd.openxmlformats-officedocument.spreadsheetml.template</td><td>xltx&nbsp;</td></tr>
 * <tr><td>application/vnd.openxmlformats-officedocument.wordprocessingml.document</td><td>docx&nbsp;</td></tr>
 * <tr><td>application/vnd.openxmlformats-officedocument.wordprocessingml.template</td><td>dotx&nbsp;</td></tr>
 * <tr><td>application/vnd.osa.netdeploy</td><td>ndc&nbsp;</td></tr>
 * <tr><td>application/vnd.osgi.dp</td><td>dp&nbsp;</td></tr>
 * <tr><td>application/vnd.palm</td><td>oprc&nbsp;prc&nbsp;pqa&nbsp;pdb&nbsp;</td></tr>
 * <tr><td>application/vnd.pg.format</td><td>str&nbsp;</td></tr>
 * <tr><td>application/vnd.pg.osasli</td><td>ei6&nbsp;</td></tr>
 * <tr><td>application/vnd.piaccess.application-license</td><td>pil&nbsp;</td></tr>
 * <tr><td>application/vnd.picsel</td><td>efif&nbsp;</td></tr>
 * <tr><td>application/vnd.pocketlearn</td><td>plf&nbsp;</td></tr>
 * <tr><td>application/vnd.powerbuilder6</td><td>pbd&nbsp;</td></tr>
 * <tr><td>application/vnd.preminet</td><td>preminet&nbsp;</td></tr>
 * <tr><td>application/vnd.previewsystems.box</td><td>box&nbsp;vbox&nbsp;</td></tr>
 * <tr><td>application/vnd.proteus.magazine</td><td>mgz&nbsp;</td></tr>
 * <tr><td>application/vnd.publishare-delta-tree</td><td>qps&nbsp;</td></tr>
 * <tr><td>application/vnd.pvi.ptid1</td><td>ptid&nbsp;</td></tr>
 * <tr><td>application/vnd.qualcomm.brew-app-res</td><td>bar&nbsp;</td></tr>
 * <tr><td>application/vnd.realvnc.bed</td><td>bed&nbsp;</td></tr>
 * <tr><td>application/vnd.recordare.musicxml</td><td>mxl&nbsp;</td></tr>
 * <tr><td>application/vnd.rim.cod</td><td>cod&nbsp;</td></tr>
 * <tr><td>application/vnd.route66.link66+xml</td><td>link66&nbsp;</td></tr>
 * <tr><td>application/vnd.sailingtracker.track</td><td>st&nbsp;</td></tr>
 * <tr><td>application/vnd.scribus</td><td>scd&nbsp;slaz&nbsp;sla&nbsp;</td></tr>
 * <tr><td>application/vnd.sealed.3df</td><td>s3df&nbsp;</td></tr>
 * <tr><td>application/vnd.sealed.csf</td><td>scsf&nbsp;</td></tr>
 * <tr><td>application/vnd.sealed.doc</td><td>sdoc&nbsp;s1w&nbsp;sdo&nbsp;</td></tr>
 * <tr><td>application/vnd.sealed.eml</td><td>seml&nbsp;sem&nbsp;</td></tr>
 * <tr><td>application/vnd.sealed.mht</td><td>smh&nbsp;smht&nbsp;</td></tr>
 * <tr><td>application/vnd.sealed.ppt</td><td>s1p&nbsp;sppt&nbsp;</td></tr>
 * <tr><td>application/vnd.sealed.tiff</td><td>stif&nbsp;</td></tr>
 * <tr><td>application/vnd.sealed.xls</td><td>s1e&nbsp;sxls&nbsp;sxl&nbsp;</td></tr>
 * <tr><td>application/vnd.sealedmedia.softseal.html</td><td>stml&nbsp;s1h&nbsp;</td></tr>
 * <tr><td>application/vnd.sealedmedia.softseal.pdf</td><td>s1a&nbsp;spdf&nbsp;spd&nbsp;</td></tr>
 * <tr><td>application/vnd.seemail</td><td>see&nbsp;</td></tr>
 * <tr><td>application/vnd.sema</td><td>sema&nbsp;</td></tr>
 * <tr><td>application/vnd.semd</td><td>semd&nbsp;</td></tr>
 * <tr><td>application/vnd.semf</td><td>semf&nbsp;</td></tr>
 * <tr><td>application/vnd.shana.informed.formdata</td><td>ifm&nbsp;</td></tr>
 * <tr><td>application/vnd.shana.informed.formtemplate</td><td>itp&nbsp;</td></tr>
 * <tr><td>application/vnd.shana.informed.interchange</td><td>iif&nbsp;</td></tr>
 * <tr><td>application/vnd.shana.informed.package</td><td>ipk&nbsp;</td></tr>
 * <tr><td>application/vnd.smaf</td><td>mmf&nbsp;</td></tr>
 * <tr><td>application/vnd.smart.teacher</td><td>teacher&nbsp;</td></tr>
 * <tr><td>application/vnd.software602.filler.form+xml</td><td>fo&nbsp;</td></tr>
 * <tr><td>application/vnd.software602.filler.form-xml-zip</td><td>zfo&nbsp;</td></tr>
 * <tr><td>application/vnd.solent.sdkm+xml</td><td>sdkd&nbsp;sdkm&nbsp;</td></tr>
 * <tr><td>application/vnd.spotfire.dxp</td><td>dxp&nbsp;</td></tr>
 * <tr><td>application/vnd.spotfire.sfs</td><td>sfs&nbsp;</td></tr>
 * <tr><td>application/vnd.stardivision.calc</td><td>sdc&nbsp;</td></tr>
 * <tr><td>application/vnd.stardivision.chart</td><td>sds&nbsp;</td></tr>
 * <tr><td>application/vnd.stardivision.draw</td><td>sda&nbsp;</td></tr>
 * <tr><td>application/vnd.stardivision.impress</td><td>sdd&nbsp;</td></tr>
 * <tr><td>application/vnd.stardivision.math</td><td>sdf&nbsp;</td></tr>
 * <tr><td>application/vnd.stardivision.writer</td><td>sdw&nbsp;</td></tr>
 * <tr><td>application/vnd.stardivision.writer-global</td><td>sgl&nbsp;</td></tr>
 * <tr><td>application/vnd.sun.wadl+xml</td><td>wadl&nbsp;</td></tr>
 * <tr><td>application/vnd.sun.xml.calc</td><td>sxc&nbsp;</td></tr>
 * <tr><td>application/vnd.sun.xml.calc.template</td><td>stc&nbsp;</td></tr>
 * <tr><td>application/vnd.sun.xml.draw</td><td>sxd&nbsp;</td></tr>
 * <tr><td>application/vnd.sun.xml.draw.template</td><td>std&nbsp;</td></tr>
 * <tr><td>application/vnd.sun.xml.impress</td><td>sxi&nbsp;</td></tr>
 * <tr><td>application/vnd.sun.xml.impress.template</td><td>sti&nbsp;</td></tr>
 * <tr><td>application/vnd.sun.xml.math</td><td>sxm&nbsp;</td></tr>
 * <tr><td>application/vnd.sun.xml.writer</td><td>sxw&nbsp;</td></tr>
 * <tr><td>application/vnd.sun.xml.writer.global</td><td>sxg&nbsp;</td></tr>
 * <tr><td>application/vnd.sun.xml.writer.template</td><td>stw&nbsp;</td></tr>
 * <tr><td>application/vnd.sus-calendar</td><td>sus&nbsp;susp&nbsp;</td></tr>
 * <tr><td>application/vnd.symbian.install</td><td>sis&nbsp;</td></tr>
 * <tr><td>application/vnd.syncml+xml</td><td>xsm&nbsp;</td></tr>
 * <tr><td>application/vnd.syncml.dm+wbxml</td><td>bdm&nbsp;</td></tr>
 * <tr><td>application/vnd.syncml.dm+xml</td><td>xdm&nbsp;</td></tr>
 * <tr><td>application/vnd.tao.intent-module-archive</td><td>tao&nbsp;</td></tr>
 * <tr><td>application/vnd.tmobile-livetv</td><td>tmo&nbsp;</td></tr>
 * <tr><td>application/vnd.trid.tpt</td><td>tpt&nbsp;</td></tr>
 * <tr><td>application/vnd.triscape.mxs</td><td>mxs&nbsp;</td></tr>
 * <tr><td>application/vnd.trueapp</td><td>tra&nbsp;</td></tr>
 * <tr><td>application/vnd.ufdl</td><td>frm&nbsp;ufd&nbsp;ufdl&nbsp;</td></tr>
 * <tr><td>application/vnd.uiq.theme</td><td>utz&nbsp;</td></tr>
 * <tr><td>application/vnd.umajin</td><td>umj&nbsp;</td></tr>
 * <tr><td>application/vnd.unity</td><td>unityweb&nbsp;</td></tr>
 * <tr><td>application/vnd.uoml+xml</td><td>uoml&nbsp;uo&nbsp;</td></tr>
 * <tr><td>application/vnd.vcx</td><td>vcx&nbsp;</td></tr>
 * <tr><td>application/vnd.vd-study</td><td>mxi&nbsp;model-inter&nbsp;study-inter&nbsp;</td></tr>
 * <tr><td>application/vnd.vectorworks</td><td>vwx&nbsp;</td></tr>
 * <tr><td>application/vnd.vidsoft.vidconference</td><td>vsc&nbsp;</td></tr>
 * <tr><td>application/vnd.visio</td><td>vsw&nbsp;vsd&nbsp;vss&nbsp;vst&nbsp;</td></tr>
 * <tr><td>application/vnd.visionary</td><td>vis&nbsp;</td></tr>
 * <tr><td>application/vnd.vsf</td><td>vsf&nbsp;</td></tr>
 * <tr><td>application/vnd.wap.mms-message</td><td>mms&nbsp;</td></tr>
 * <tr><td>application/vnd.wap.sic</td><td>sic&nbsp;</td></tr>
 * <tr><td>application/vnd.wap.slc</td><td>slc&nbsp;</td></tr>
 * <tr><td>application/vnd.wap.wbxml</td><td>wbxml&nbsp;</td></tr>
 * <tr><td>application/vnd.wap.wmlc</td><td>wmlc&nbsp;</td></tr>
 * <tr><td>application/vnd.wap.wmlscriptc</td><td>wmlsc&nbsp;</td></tr>
 * <tr><td>application/vnd.webturbo</td><td>wtb&nbsp;</td></tr>
 * <tr><td>application/vnd.wfa.wsc</td><td>wsc&nbsp;</td></tr>
 * <tr><td>application/vnd.wmc</td><td>wmc&nbsp;</td></tr>
 * <tr><td>application/vnd.wolfram.mathematica.package</td><td>m&nbsp;</td></tr>
 * <tr><td>application/vnd.wolfram.player</td><td>nbp&nbsp;</td></tr>
 * <tr><td>application/vnd.wordperfect</td><td>wpd&nbsp;</td></tr>
 * <tr><td>application/vnd.wordperfect5.1</td><td>wp5&nbsp;</td></tr>
 * <tr><td>application/vnd.wqd</td><td>wqd&nbsp;</td></tr>
 * <tr><td>application/vnd.wt.stf</td><td>stf&nbsp;</td></tr>
 * <tr><td>application/vnd.wv.csp+wbxml</td><td>wv&nbsp;</td></tr>
 * <tr><td>application/vnd.xara</td><td>xar&nbsp;</td></tr>
 * <tr><td>application/vnd.xfdl</td><td>xfd&nbsp;xfdl&nbsp;</td></tr>
 * <tr><td>application/vnd.xmpie.cpkg</td><td>cpkg&nbsp;</td></tr>
 * <tr><td>application/vnd.xmpie.dpkg</td><td>dpkg&nbsp;</td></tr>
 * <tr><td>application/vnd.xmpie.ppkg</td><td>ppkg&nbsp;</td></tr>
 * <tr><td>application/vnd.xmpie.xlim</td><td>xlim&nbsp;</td></tr>
 * <tr><td>application/vnd.yamaha.hv-dic</td><td>hvd&nbsp;</td></tr>
 * <tr><td>application/vnd.yamaha.hv-script</td><td>hvs&nbsp;</td></tr>
 * <tr><td>application/vnd.yamaha.hv-voice</td><td>hvp&nbsp;</td></tr>
 * <tr><td>application/vnd.yamaha.openscoreformat</td><td>osf&nbsp;</td></tr>
 * <tr><td>application/vnd.yamaha.smaf-audio</td><td>saf&nbsp;</td></tr>
 * <tr><td>application/vnd.yamaha.smaf-phrase</td><td>spf&nbsp;</td></tr>
 * <tr><td>application/vnd.yellowriver-custom-menu</td><td>cmp&nbsp;</td></tr>
 * <tr><td>application/vnd.zul</td><td>zir&nbsp;zirz&nbsp;</td></tr>
 * <tr><td>application/vnd.zzazz.deck+xml</td><td>zaz&nbsp;</td></tr>
 * <tr><td>application/voicexml+xml</td><td>vxml&nbsp;</td></tr>
 * <tr><td>application/watcherinfo+xml</td><td>wif&nbsp;</td></tr>
 * <tr><td>application/wsdl+xml</td><td>wsdl&nbsp;</td></tr>
 * <tr><td>application/wspolicy+xml</td><td>wspolicy&nbsp;</td></tr>
 * <tr><td>application/x-123</td><td>wk&nbsp;</td></tr>
 * <tr><td>application/x-7z-compressed</td><td>7z&nbsp;</td></tr>
 * <tr><td>application/x-abiword</td><td>abw&nbsp;</td></tr>
 * <tr><td>application/x-apple-diskimage</td><td>dmg&nbsp;</td></tr>
 * <tr><td>application/x-bcpio</td><td>bcpio&nbsp;</td></tr>
 * <tr><td>application/x-bittorrent</td><td>torrent&nbsp;</td></tr>
 * <tr><td>application/x-bzip2</td><td>bz2&nbsp;</td></tr>
 * <tr><td>application/x-cab</td><td>cab&nbsp;</td></tr>
 * <tr><td>application/x-cbr</td><td>cbr&nbsp;</td></tr>
 * <tr><td>application/x-cbz</td><td>cbz&nbsp;</td></tr>
 * <tr><td>application/x-cdf</td><td>cda&nbsp;cdf&nbsp;</td></tr>
 * <tr><td>application/x-cdlink</td><td>vcd&nbsp;</td></tr>
 * <tr><td>application/x-chess-pgn</td><td>pgn&nbsp;</td></tr>
 * <tr><td>application/x-cpio</td><td>cpio&nbsp;</td></tr>
 * <tr><td>application/x-csh</td><td>csh&nbsp;</td></tr>
 * <tr><td>application/x-debian-package</td><td>deb&nbsp;udeb&nbsp;</td></tr>
 * <tr><td>application/x-director</td><td>dcr&nbsp;dir&nbsp;dxr&nbsp;</td></tr>
 * <tr><td>application/x-dms</td><td>dms&nbsp;</td></tr>
 * <tr><td>application/x-doom</td><td>wad&nbsp;</td></tr>
 * <tr><td>application/x-dvi</td><td>dvi&nbsp;</td></tr>
 * <tr><td>application/x-font</td><td>pfa&nbsp;pcf&nbsp;pfb&nbsp;pcf.Z&nbsp;gsf&nbsp;</td></tr>
 * <tr><td>application/x-freemind</td><td>mm&nbsp;</td></tr>
 * <tr><td>application/x-futuresplash</td><td>spl&nbsp;</td></tr>
 * <tr><td>application/x-gnumeric</td><td>gnumeric&nbsp;</td></tr>
 * <tr><td>application/x-go-sgf</td><td>sgf&nbsp;</td></tr>
 * <tr><td>application/x-graphing-calculator</td><td>gcf&nbsp;</td></tr>
 * <tr><td>application/x-gtar</td><td>taz&nbsp;tgz&nbsp;gtar&nbsp;</td></tr>
 * <tr><td>application/x-gzip</td><td>gz&nbsp;tgz&nbsp;</td></tr>
 * <tr><td>application/x-hdf</td><td>hdf&nbsp;</td></tr>
 * <tr><td>application/x-httpd-eruby</td><td>rhtml&nbsp;</td></tr>
 * <tr><td>application/x-httpd-php</td><td>pht&nbsp;php&nbsp;phtml&nbsp;</td></tr>
 * <tr><td>application/x-httpd-php-source</td><td>phps&nbsp;</td></tr>
 * <tr><td>application/x-httpd-php3</td><td>php3&nbsp;</td></tr>
 * <tr><td>application/x-httpd-php3-preprocessed</td><td>php3p&nbsp;</td></tr>
 * <tr><td>application/x-httpd-php4</td><td>php4&nbsp;</td></tr>
 * <tr><td>application/x-httpd-php5</td><td>php5&nbsp;</td></tr>
 * <tr><td>application/x-ica</td><td>ica&nbsp;</td></tr>
 * <tr><td>application/x-info</td><td>info&nbsp;</td></tr>
 * <tr><td>application/x-internet-signup</td><td>isp&nbsp;ins&nbsp;</td></tr>
 * <tr><td>application/x-iphone</td><td>iii&nbsp;</td></tr>
 * <tr><td>application/x-iso9660-image</td><td>iso&nbsp;</td></tr>
 * <tr><td>application/x-jam</td><td>jam&nbsp;</td></tr>
 * <tr><td>application/x-java-archive</td><td>jar&nbsp;</td></tr>
 * <tr><td>application/x-java-jnlp-file</td><td>jnlp&nbsp;</td></tr>
 * <tr><td>application/x-java-pack200</td><td>pack&nbsp;</td></tr>
 * <tr><td>application/x-jmol</td><td>jmz&nbsp;</td></tr>
 * <tr><td>application/x-kchart</td><td>chrt&nbsp;</td></tr>
 * <tr><td>application/x-killustrator</td><td>kil&nbsp;</td></tr>
 * <tr><td>application/x-koan</td><td>skm&nbsp;skp&nbsp;skd&nbsp;skt&nbsp;</td></tr>
 * <tr><td>application/x-kpresenter</td><td>kpr&nbsp;kpt&nbsp;</td></tr>
 * <tr><td>application/x-kspread</td><td>ksp&nbsp;</td></tr>
 * <tr><td>application/x-kword</td><td>kwd&nbsp;kwt&nbsp;</td></tr>
 * <tr><td>application/x-latex</td><td>latex&nbsp;</td></tr>
 * <tr><td>application/x-lha</td><td>lha&nbsp;</td></tr>
 * <tr><td>application/x-lyx</td><td>lyx&nbsp;</td></tr>
 * <tr><td>application/x-lzh</td><td>lzh&nbsp;</td></tr>
 * <tr><td>application/x-lzx</td><td>lzx&nbsp;</td></tr>
 * <tr><td>application/x-maker</td><td>frm&nbsp;fm&nbsp;fbdoc&nbsp;frame&nbsp;maker&nbsp;book&nbsp;fb&nbsp;</td></tr>
 * <tr><td>application/x-mif</td><td>mif&nbsp;</td></tr>
 * <tr><td>application/x-ms-wmd</td><td>wmd&nbsp;</td></tr>
 * <tr><td>application/x-ms-wmz</td><td>wmz&nbsp;</td></tr>
 * <tr><td>application/x-msdos-program</td><td>com&nbsp;dll&nbsp;bat&nbsp;exe&nbsp;</td></tr>
 * <tr><td>application/x-msi</td><td>msi&nbsp;</td></tr>
 * <tr><td>application/x-netcdf</td><td>nc&nbsp;cdf&nbsp;</td></tr>
 * <tr><td>application/x-ns-proxy-autoconfig</td><td>dat&nbsp;pac&nbsp;</td></tr>
 * <tr><td>application/x-nwc</td><td>nwc&nbsp;</td></tr>
 * <tr><td>application/x-object</td><td>o&nbsp;</td></tr>
 * <tr><td>application/x-oz-application</td><td>oza&nbsp;</td></tr>
 * <tr><td>application/x-perl</td><td>pl&nbsp;</td></tr>
 * <tr><td>application/x-pkcs7-certreqresp</td><td>p7r&nbsp;</td></tr>
 * <tr><td>application/x-pkcs7-crl</td><td>crl&nbsp;</td></tr>
 * <tr><td>application/x-python-code</td><td>pyc&nbsp;pyo&nbsp;</td></tr>
 * <tr><td>application/x-qgis</td><td>shp&nbsp;shx&nbsp;qgs&nbsp;</td></tr>
 * <tr><td>application/x-quicktimeplayer</td><td>qtl&nbsp;</td></tr>
 * <tr><td>application/x-redhat-package-manager</td><td>rpm&nbsp;</td></tr>
 * <tr><td>application/x-rpm</td><td>rpm&nbsp;</td></tr>
 * <tr><td>application/x-ruby</td><td>rb&nbsp;</td></tr>
 * <tr><td>application/x-sh</td><td>sh&nbsp;</td></tr>
 * <tr><td>application/x-shar</td><td>shar&nbsp;</td></tr>
 * <tr><td>application/x-shockwave-flash</td><td>swf&nbsp;swfl&nbsp;</td></tr>
 * <tr><td>application/x-silverlight</td><td>scr&nbsp;</td></tr>
 * <tr><td>application/x-stuffit</td><td>sit&nbsp;sitx&nbsp;</td></tr>
 * <tr><td>application/x-sv4cpio</td><td>sv4cpio&nbsp;</td></tr>
 * <tr><td>application/x-sv4crc</td><td>sv4crc&nbsp;</td></tr>
 * <tr><td>application/x-tar</td><td>tar&nbsp;</td></tr>
 * <tr><td>application/x-tcl</td><td>tcl&nbsp;</td></tr>
 * <tr><td>application/x-tex</td><td>tex&nbsp;</td></tr>
 * <tr><td>application/x-tex-gf</td><td>gf&nbsp;</td></tr>
 * <tr><td>application/x-tex-pk</td><td>pk&nbsp;</td></tr>
 * <tr><td>application/x-texinfo</td><td>texinfo&nbsp;texi&nbsp;</td></tr>
 * <tr><td>application/x-trash</td><td>old&nbsp;bak&nbsp;%&nbsp;~&nbsp;sik&nbsp;</td></tr>
 * <tr><td>application/x-troff</td><td>t&nbsp;tr&nbsp;roff&nbsp;</td></tr>
 * <tr><td>application/x-troff-man</td><td>3&nbsp;2&nbsp;1&nbsp;7&nbsp;6&nbsp;5&nbsp;4&nbsp;8&nbsp;man&nbsp;</td></tr>
 * <tr><td>application/x-troff-me</td><td>me&nbsp;</td></tr>
 * <tr><td>application/x-troff-ms</td><td>ms&nbsp;</td></tr>
 * <tr><td>application/x-ustar</td><td>ustar&nbsp;</td></tr>
 * <tr><td>application/x-wais-source</td><td>src&nbsp;</td></tr>
 * <tr><td>application/x-wingz</td><td>wz&nbsp;</td></tr>
 * <tr><td>application/x-x509-ca-cert</td><td>crt&nbsp;</td></tr>
 * <tr><td>application/x-xcf</td><td>xcf&nbsp;</td></tr>
 * <tr><td>application/x-xfig</td><td>fig&nbsp;</td></tr>
 * <tr><td>application/x-xpinstall</td><td>xpi&nbsp;</td></tr>
 * <tr><td>application/x-xz</td><td>xz&nbsp;</td></tr>
 * <tr><td>application/xcap-att+xml</td><td>xav&nbsp;</td></tr>
 * <tr><td>application/xcap-caps+xml</td><td>xca&nbsp;</td></tr>
 * <tr><td>application/xcap-el+xml</td><td>xel&nbsp;</td></tr>
 * <tr><td>application/xcap-error+xml</td><td>xer&nbsp;</td></tr>
 * <tr><td>application/xcap-ns+xml</td><td>xns&nbsp;</td></tr>
 * <tr><td>application/xhtml+xml</td><td>xhtm&nbsp;xhtml&nbsp;xht&nbsp;</td></tr>
 * <tr><td>application/xml</td><td>xsl&nbsp;xsd&nbsp;xml&nbsp;</td></tr>
 * <tr><td>application/xml-dtd</td><td>dtd&nbsp;</td></tr>
 * <tr><td>application/xop+xml</td><td>xop&nbsp;</td></tr>
 * <tr><td>application/xslt+xml</td><td>xsl&nbsp;xslt&nbsp;</td></tr>
 * <tr><td>application/xspf+xml</td><td>xspf&nbsp;</td></tr>
 * <tr><td>application/xv+xml</td><td>xvm&nbsp;xhvml&nbsp;mxml&nbsp;xvml&nbsp;</td></tr>
 * <tr><td>application/zip</td><td>zip&nbsp;</td></tr>
 * <tr><td>audio/32kadpcm</td><td>726&nbsp;</td></tr>
 * <tr><td>audio/AMR</td><td>amr&nbsp;</td></tr>
 * <tr><td>audio/AMR-WB</td><td>awb&nbsp;</td></tr>
 * <tr><td>audio/ATRAC-ADVANCED-LOSSLESS</td><td>aal&nbsp;</td></tr>
 * <tr><td>audio/ATRAC-X</td><td>atx&nbsp;</td></tr>
 * <tr><td>audio/ATRAC3</td><td>aa3&nbsp;at3&nbsp;omg&nbsp;</td></tr>
 * <tr><td>audio/EVRC</td><td>evc&nbsp;</td></tr>
 * <tr><td>audio/EVRCB</td><td>evb&nbsp;</td></tr>
 * <tr><td>audio/EVRCWB</td><td>evw&nbsp;</td></tr>
 * <tr><td>audio/L16</td><td>l16&nbsp;</td></tr>
 * <tr><td>audio/SMV</td><td>smv&nbsp;</td></tr>
 * <tr><td>audio/ac3</td><td>ac3&nbsp;</td></tr>
 * <tr><td>audio/amr</td><td>amr&nbsp;</td></tr>
 * <tr><td>audio/amr-wb</td><td>awb&nbsp;</td></tr>
 * <tr><td>audio/annodex</td><td>axa&nbsp;</td></tr>
 * <tr><td>audio/basic</td><td>au&nbsp;snd&nbsp;</td></tr>
 * <tr><td>audio/dls</td><td>dls&nbsp;</td></tr>
 * <tr><td>audio/flac</td><td>flac&nbsp;</td></tr>
 * <tr><td>audio/iLBC</td><td>lbc&nbsp;</td></tr>
 * <tr><td>audio/midi</td><td>midi&nbsp;kar&nbsp;mid&nbsp;</td></tr>
 * <tr><td>audio/mobile-xmf</td><td>mxmf&nbsp;</td></tr>
 * <tr><td>audio/mpeg</td><td>m4a&nbsp;mp1&nbsp;mp2&nbsp;mpga&nbsp;mp3&nbsp;mpega&nbsp;</td></tr>
 * <tr><td>audio/mpegurl</td><td>m3u&nbsp;</td></tr>
 * <tr><td>audio/ogg</td><td>oga&nbsp;spx&nbsp;ogg&nbsp;</td></tr>
 * <tr><td>audio/prs.sid</td><td>sid&nbsp;psid&nbsp;</td></tr>
 * <tr><td>audio/qcelp</td><td>qcp&nbsp;</td></tr>
 * <tr><td>audio/vnd.audikoz</td><td>koz&nbsp;</td></tr>
 * <tr><td>audio/vnd.digital-winds</td><td>eol&nbsp;</td></tr>
 * <tr><td>audio/vnd.dolby.mlp</td><td>mlp&nbsp;</td></tr>
 * <tr><td>audio/vnd.dts</td><td>dts&nbsp;</td></tr>
 * <tr><td>audio/vnd.dts.hd</td><td>dtshd&nbsp;</td></tr>
 * <tr><td>audio/vnd.everad.plj</td><td>plj&nbsp;</td></tr>
 * <tr><td>audio/vnd.lucent.voice</td><td>lvp&nbsp;</td></tr>
 * <tr><td>audio/vnd.ms-playready.media.pya</td><td>pya&nbsp;</td></tr>
 * <tr><td>audio/vnd.nortel.vbk</td><td>vbk&nbsp;</td></tr>
 * <tr><td>audio/vnd.nuera.ecelp4800</td><td>ecelp4800&nbsp;</td></tr>
 * <tr><td>audio/vnd.nuera.ecelp7470</td><td>ecelp7470&nbsp;</td></tr>
 * <tr><td>audio/vnd.nuera.ecelp9600</td><td>ecelp9600&nbsp;</td></tr>
 * <tr><td>audio/vnd.sealedmedia.softseal.mpeg</td><td>smp3&nbsp;smp&nbsp;s1m&nbsp;</td></tr>
 * <tr><td>audio/x-aiff</td><td>aifc&nbsp;aif&nbsp;aiff&nbsp;</td></tr>
 * <tr><td>audio/x-gsm</td><td>gsm&nbsp;</td></tr>
 * <tr><td>audio/x-mod</td><td>med&nbsp;669&nbsp;m15&nbsp;ult&nbsp;mod&nbsp;mtm&nbsp;uni&nbsp;</td></tr>
 * <tr><td>audio/x-mpegurl</td><td>m3u&nbsp;</td></tr>
 * <tr><td>audio/x-ms-wax</td><td>wax&nbsp;</td></tr>
 * <tr><td>audio/x-ms-wma</td><td>wma&nbsp;</td></tr>
 * <tr><td>audio/x-pn-realaudio</td><td>ra&nbsp;rm&nbsp;ram&nbsp;</td></tr>
 * <tr><td>audio/x-realaudio</td><td>ra&nbsp;</td></tr>
 * <tr><td>audio/x-s3m</td><td>s3m&nbsp;</td></tr>
 * <tr><td>audio/x-scpls</td><td>pls&nbsp;</td></tr>
 * <tr><td>audio/x-sd2</td><td>sd2&nbsp;</td></tr>
 * <tr><td>audio/x-stm</td><td>stm&nbsp;</td></tr>
 * <tr><td>audio/x-wav</td><td>wav&nbsp;</td></tr>
 * <tr><td>chemical/x-alchemy</td><td>alc&nbsp;</td></tr>
 * <tr><td>chemical/x-cache</td><td>cac&nbsp;cache&nbsp;</td></tr>
 * <tr><td>chemical/x-cache-csf</td><td>csf&nbsp;</td></tr>
 * <tr><td>chemical/x-cactvs-binary</td><td>ctab&nbsp;cascii&nbsp;cbin&nbsp;</td></tr>
 * <tr><td>chemical/x-cdx</td><td>cdx&nbsp;</td></tr>
 * <tr><td>chemical/x-cerius</td><td>cer&nbsp;</td></tr>
 * <tr><td>chemical/x-chem3d</td><td>c3d&nbsp;</td></tr>
 * <tr><td>chemical/x-chemdraw</td><td>chm&nbsp;</td></tr>
 * <tr><td>chemical/x-cif</td><td>cif&nbsp;</td></tr>
 * <tr><td>chemical/x-cmdf</td><td>cmdf&nbsp;</td></tr>
 * <tr><td>chemical/x-cml</td><td>cml&nbsp;</td></tr>
 * <tr><td>chemical/x-compass</td><td>cpa&nbsp;</td></tr>
 * <tr><td>chemical/x-crossfire</td><td>bsd&nbsp;</td></tr>
 * <tr><td>chemical/x-csml</td><td>csml&nbsp;csm&nbsp;</td></tr>
 * <tr><td>chemical/x-ctx</td><td>ctx&nbsp;</td></tr>
 * <tr><td>chemical/x-cxf</td><td>cxf&nbsp;cef&nbsp;</td></tr>
 * <tr><td>chemical/x-embl-dl-nucleotide</td><td>embl&nbsp;emb&nbsp;</td></tr>
 * <tr><td>chemical/x-galactic-spc</td><td>spc&nbsp;</td></tr>
 * <tr><td>chemical/x-gamess-input</td><td>inp&nbsp;gamin&nbsp;gam&nbsp;</td></tr>
 * <tr><td>chemical/x-gaussian-checkpoint</td><td>fchk&nbsp;fch&nbsp;</td></tr>
 * <tr><td>chemical/x-gaussian-cube</td><td>cub&nbsp;</td></tr>
 * <tr><td>chemical/x-gaussian-input</td><td>gau&nbsp;gjc&nbsp;gjf&nbsp;</td></tr>
 * <tr><td>chemical/x-gaussian-log</td><td>gal&nbsp;</td></tr>
 * <tr><td>chemical/x-gcg8-sequence</td><td>gcg&nbsp;</td></tr>
 * <tr><td>chemical/x-genbank</td><td>gen&nbsp;</td></tr>
 * <tr><td>chemical/x-hin</td><td>hin&nbsp;</td></tr>
 * <tr><td>chemical/x-isostar</td><td>ist&nbsp;istr&nbsp;</td></tr>
 * <tr><td>chemical/x-jcamp-dx</td><td>dx&nbsp;jdx&nbsp;</td></tr>
 * <tr><td>chemical/x-kinemage</td><td>kin&nbsp;</td></tr>
 * <tr><td>chemical/x-macmolecule</td><td>mcm&nbsp;</td></tr>
 * <tr><td>chemical/x-macromodel-input</td><td>mmod&nbsp;mmd&nbsp;</td></tr>
 * <tr><td>chemical/x-mdl-molfile</td><td>mol&nbsp;</td></tr>
 * <tr><td>chemical/x-mdl-rdfile</td><td>rd&nbsp;</td></tr>
 * <tr><td>chemical/x-mdl-rxnfile</td><td>rxn&nbsp;</td></tr>
 * <tr><td>chemical/x-mdl-sdfile</td><td>sdf&nbsp;sd&nbsp;</td></tr>
 * <tr><td>chemical/x-mdl-tgf</td><td>tgf&nbsp;</td></tr>
 * <tr><td>chemical/x-mmcif</td><td>mcif&nbsp;</td></tr>
 * <tr><td>chemical/x-mol2</td><td>mol2&nbsp;</td></tr>
 * <tr><td>chemical/x-molconn-Z</td><td>b&nbsp;</td></tr>
 * <tr><td>chemical/x-mopac-graph</td><td>gpt&nbsp;</td></tr>
 * <tr><td>chemical/x-mopac-input</td><td>mpc&nbsp;zmt&nbsp;mop&nbsp;mopcrt&nbsp;</td></tr>
 * <tr><td>chemical/x-mopac-out</td><td>moo&nbsp;</td></tr>
 * <tr><td>chemical/x-mopac-vib</td><td>mvb&nbsp;</td></tr>
 * <tr><td>chemical/x-ncbi-asn1</td><td>asn&nbsp;</td></tr>
 * <tr><td>chemical/x-ncbi-asn1-ascii</td><td>prt&nbsp;ent&nbsp;</td></tr>
 * <tr><td>chemical/x-ncbi-asn1-binary</td><td>val&nbsp;aso&nbsp;</td></tr>
 * <tr><td>chemical/x-ncbi-asn1-spec</td><td>asn&nbsp;</td></tr>
 * <tr><td>chemical/x-pdb</td><td>pdb&nbsp;ent&nbsp;</td></tr>
 * <tr><td>chemical/x-rosdal</td><td>ros&nbsp;</td></tr>
 * <tr><td>chemical/x-swissprot</td><td>sw&nbsp;</td></tr>
 * <tr><td>chemical/x-vamas-iso14976</td><td>vms&nbsp;</td></tr>
 * <tr><td>chemical/x-vmd</td><td>vmd&nbsp;</td></tr>
 * <tr><td>chemical/x-xtel</td><td>xtel&nbsp;</td></tr>
 * <tr><td>chemical/x-xyz</td><td>xyz&nbsp;</td></tr>
 * <tr><td>image/bmp</td><td>bmp&nbsp;</td></tr>
 * <tr><td>image/fits</td><td>fts&nbsp;fits&nbsp;fit&nbsp;</td></tr>
 * <tr><td>image/gif</td><td>gif&nbsp;</td></tr>
 * <tr><td>image/ief</td><td>ief&nbsp;</td></tr>
 * <tr><td>image/jp2</td><td>jp2&nbsp;jpg2&nbsp;</td></tr>
 * <tr><td>image/jpeg</td><td>jpg&nbsp;jpeg&nbsp;jfif&nbsp;jpe&nbsp;</td></tr>
 * <tr><td>image/jpm</td><td>jpm&nbsp;jpgm&nbsp;</td></tr>
 * <tr><td>image/jpx</td><td>jpf&nbsp;jpx&nbsp;</td></tr>
 * <tr><td>image/pcx</td><td>pcx&nbsp;</td></tr>
 * <tr><td>image/png</td><td>png&nbsp;</td></tr>
 * <tr><td>image/prs.btif</td><td>btif&nbsp;btf&nbsp;</td></tr>
 * <tr><td>image/prs.pti</td><td>pti&nbsp;</td></tr>
 * <tr><td>image/svg+xml</td><td>svgz&nbsp;svg&nbsp;</td></tr>
 * <tr><td>image/t38</td><td>t38&nbsp;</td></tr>
 * <tr><td>image/tiff</td><td>tif&nbsp;tiff&nbsp;</td></tr>
 * <tr><td>image/tiff-fx</td><td>tfx&nbsp;</td></tr>
 * <tr><td>image/vnd.adobe.photoshop</td><td>psd&nbsp;</td></tr>
 * <tr><td>image/vnd.djvu</td><td>djvu&nbsp;djv&nbsp;</td></tr>
 * <tr><td>image/vnd.dxf</td><td>dxf&nbsp;</td></tr>
 * <tr><td>image/vnd.fastbidsheet</td><td>fbs&nbsp;</td></tr>
 * <tr><td>image/vnd.fpx</td><td>fpx&nbsp;</td></tr>
 * <tr><td>image/vnd.fst</td><td>fst&nbsp;</td></tr>
 * <tr><td>image/vnd.fujixerox.edmics-mmr</td><td>mmr&nbsp;</td></tr>
 * <tr><td>image/vnd.fujixerox.edmics-rlc</td><td>rlc&nbsp;</td></tr>
 * <tr><td>image/vnd.globalgraphics.pgb</td><td>pgb&nbsp;</td></tr>
 * <tr><td>image/vnd.microsoft.icon</td><td>ico&nbsp;</td></tr>
 * <tr><td>image/vnd.ms-modi</td><td>mdi&nbsp;</td></tr>
 * <tr><td>image/vnd.radiance</td><td>hdr&nbsp;xyze&nbsp;rgbe&nbsp;</td></tr>
 * <tr><td>image/vnd.sealed.png</td><td>spng&nbsp;s1n&nbsp;spn&nbsp;</td></tr>
 * <tr><td>image/vnd.sealedmedia.softseal.gif</td><td>sgif&nbsp;s1g&nbsp;sgi&nbsp;</td></tr>
 * <tr><td>image/vnd.sealedmedia.softseal.jpg</td><td>sjp&nbsp;s1j&nbsp;sjpg&nbsp;</td></tr>
 * <tr><td>image/vnd.wap.wbmp</td><td>wbmp&nbsp;</td></tr>
 * <tr><td>image/vnd.xiff</td><td>xif&nbsp;</td></tr>
 * <tr><td>image/x-canon-cr2</td><td>cr2&nbsp;</td></tr>
 * <tr><td>image/x-canon-crw</td><td>crw&nbsp;</td></tr>
 * <tr><td>image/x-cmu-raster</td><td>ras&nbsp;</td></tr>
 * <tr><td>image/x-coreldraw</td><td>cdr&nbsp;</td></tr>
 * <tr><td>image/x-coreldrawpattern</td><td>pat&nbsp;</td></tr>
 * <tr><td>image/x-coreldrawtemplate</td><td>cdt&nbsp;</td></tr>
 * <tr><td>image/x-corelphotopaint</td><td>cpt&nbsp;</td></tr>
 * <tr><td>image/x-epson-erf</td><td>erf&nbsp;</td></tr>
 * <tr><td>image/x-icon</td><td>ico&nbsp;</td></tr>
 * <tr><td>image/x-jg</td><td>art&nbsp;</td></tr>
 * <tr><td>image/x-jng</td><td>jng&nbsp;</td></tr>
 * <tr><td>image/x-ms-bmp</td><td>bmp&nbsp;</td></tr>
 * <tr><td>image/x-nikon-nef</td><td>nef&nbsp;</td></tr>
 * <tr><td>image/x-olympus-orf</td><td>orf&nbsp;</td></tr>
 * <tr><td>image/x-photoshop</td><td>psd&nbsp;</td></tr>
 * <tr><td>image/x-portable-anymap</td><td>pnm&nbsp;</td></tr>
 * <tr><td>image/x-portable-bitmap</td><td>pbm&nbsp;</td></tr>
 * <tr><td>image/x-portable-graymap</td><td>pgm&nbsp;</td></tr>
 * <tr><td>image/x-portable-pixmap</td><td>ppm&nbsp;</td></tr>
 * <tr><td>image/x-rgb</td><td>rgb&nbsp;</td></tr>
 * <tr><td>image/x-targa</td><td>tga&nbsp;</td></tr>
 * <tr><td>image/x-xbitmap</td><td>xbm&nbsp;</td></tr>
 * <tr><td>image/x-xpixmap</td><td>xpm&nbsp;</td></tr>
 * <tr><td>image/x-xwindowdump</td><td>xwd&nbsp;</td></tr>
 * <tr><td>message/global</td><td>u8msg&nbsp;</td></tr>
 * <tr><td>message/global-delivery-status</td><td>u8dsn&nbsp;</td></tr>
 * <tr><td>message/global-disposition-notification</td><td>u8mdn&nbsp;</td></tr>
 * <tr><td>message/global-headers</td><td>u8hdr&nbsp;</td></tr>
 * <tr><td>message/rfc822</td><td>eml&nbsp;mail&nbsp;art&nbsp;</td></tr>
 * <tr><td>model/iges</td><td>igs&nbsp;iges&nbsp;</td></tr>
 * <tr><td>model/mesh</td><td>silo&nbsp;msh&nbsp;mesh&nbsp;</td></tr>
 * <tr><td>model/vnd.dwf</td><td>dwf&nbsp;</td></tr>
 * <tr><td>model/vnd.gdl</td><td>dor&nbsp;ism&nbsp;lmp&nbsp;rsm&nbsp;gdl&nbsp;msm&nbsp;win&nbsp;gsm&nbsp;</td></tr>
 * <tr><td>model/vnd.gtw</td><td>gtw&nbsp;</td></tr>
 * <tr><td>model/vnd.moml+xml</td><td>moml&nbsp;</td></tr>
 * <tr><td>model/vnd.mts</td><td>mts&nbsp;</td></tr>
 * <tr><td>model/vnd.parasolid.transmit.binary</td><td>xmt_bin&nbsp;x_b&nbsp;</td></tr>
 * <tr><td>model/vnd.parasolid.transmit.text</td><td>xmt_txt&nbsp;x_t&nbsp;</td></tr>
 * <tr><td>model/vnd.vtu</td><td>vtu&nbsp;</td></tr>
 * <tr><td>model/vrml</td><td>vrml&nbsp;wrl&nbsp;</td></tr>
 * <tr><td>model/x3d+binary</td><td>x3db&nbsp;</td></tr>
 * <tr><td>model/x3d+vrml</td><td>x3dv&nbsp;</td></tr>
 * <tr><td>model/x3d+xml</td><td>x3d&nbsp;</td></tr>
 * <tr><td>multipart/voice-message</td><td>vpm&nbsp;</td></tr>
 * <tr><td>text/cache-manifest</td><td>manifest&nbsp;</td></tr>
 * <tr><td>text/calendar</td><td>ics&nbsp;ifb&nbsp;icz&nbsp;</td></tr>
 * <tr><td>text/css</td><td>css&nbsp;</td></tr>
 * <tr><td>text/csv</td><td>csv&nbsp;</td></tr>
 * <tr><td>text/dns</td><td>soa&nbsp;zone&nbsp;</td></tr>
 * <tr><td>text/h323</td><td>323&nbsp;</td></tr>
 * <tr><td>text/html</td><td>shtml&nbsp;html&nbsp;htm&nbsp;</td></tr>
 * <tr><td>text/iuls</td><td>uls&nbsp;</td></tr>
 * <tr><td>text/javascript</td><td>js&nbsp;</td></tr>
 * <tr><td>text/mathml</td><td>mml&nbsp;</td></tr>
 * <tr><td>text/plain</td><td>text&nbsp;c&nbsp;hh&nbsp;hxx&nbsp;h&nbsp;txt&nbsp;pot&nbsp;f90&nbsp;el&nbsp;asc&nbsp;cxx&nbsp;pm&nbsp;brf&nbsp;cc&nbsp;</td></tr>
 * <tr><td>text/prs.fallenstein.rst</td><td>rst&nbsp;</td></tr>
 * <tr><td>text/prs.lines.tag</td><td>tag&nbsp;dsc&nbsp;</td></tr>
 * <tr><td>text/richtext</td><td>rtx&nbsp;</td></tr>
 * <tr><td>text/scriptlet</td><td>wsc&nbsp;sct&nbsp;</td></tr>
 * <tr><td>text/sgml</td><td>sgm&nbsp;sgml&nbsp;</td></tr>
 * <tr><td>text/tab-separated-values</td><td>tsv&nbsp;</td></tr>
 * <tr><td>text/texmacs</td><td>tm&nbsp;ts&nbsp;</td></tr>
 * <tr><td>text/uri-list</td><td>uris&nbsp;uri&nbsp;</td></tr>
 * <tr><td>text/vnd.DMClientScript</td><td>dms&nbsp;</td></tr>
 * <tr><td>text/vnd.abc</td><td>abc&nbsp;</td></tr>
 * <tr><td>text/vnd.esmertec.theme-descriptor</td><td>jtd&nbsp;</td></tr>
 * <tr><td>text/vnd.fly</td><td>fly&nbsp;</td></tr>
 * <tr><td>text/vnd.fmi.flexstor</td><td>flx&nbsp;</td></tr>
 * <tr><td>text/vnd.graphviz</td><td>gv&nbsp;dot&nbsp;</td></tr>
 * <tr><td>text/vnd.in3d.3dml</td><td>3dm&nbsp;3dml&nbsp;</td></tr>
 * <tr><td>text/vnd.in3d.spot</td><td>spo&nbsp;spot&nbsp;</td></tr>
 * <tr><td>text/vnd.ms-mediapackage</td><td>mpf&nbsp;</td></tr>
 * <tr><td>text/vnd.net2phone.commcenter.command</td><td>ccc&nbsp;</td></tr>
 * <tr><td>text/vnd.si.uricatalogue</td><td>uric&nbsp;</td></tr>
 * <tr><td>text/vnd.sun.j2me.app-descriptor</td><td>jad&nbsp;</td></tr>
 * <tr><td>text/vnd.trolltech.linguist</td><td>ts&nbsp;</td></tr>
 * <tr><td>text/vnd.wap.si</td><td>si&nbsp;</td></tr>
 * <tr><td>text/vnd.wap.sl</td><td>sl&nbsp;</td></tr>
 * <tr><td>text/vnd.wap.wml</td><td>wml&nbsp;</td></tr>
 * <tr><td>text/vnd.wap.wmlscript</td><td>wmls&nbsp;</td></tr>
 * <tr><td>text/x-bibtex</td><td>bib&nbsp;</td></tr>
 * <tr><td>text/x-boo</td><td>boo&nbsp;</td></tr>
 * <tr><td>text/x-c++hdr</td><td>hh&nbsp;h++&nbsp;hxx&nbsp;hpp&nbsp;</td></tr>
 * <tr><td>text/x-c++src</td><td>cpp&nbsp;cxx&nbsp;c++&nbsp;cc&nbsp;</td></tr>
 * <tr><td>text/x-chdr</td><td>h&nbsp;</td></tr>
 * <tr><td>text/x-component</td><td>htc&nbsp;</td></tr>
 * <tr><td>text/x-csh</td><td>csh&nbsp;</td></tr>
 * <tr><td>text/x-csrc</td><td>c&nbsp;</td></tr>
 * <tr><td>text/x-diff</td><td>diff&nbsp;patch&nbsp;</td></tr>
 * <tr><td>text/x-dsrc</td><td>d&nbsp;</td></tr>
 * <tr><td>text/x-haskell</td><td>hs&nbsp;</td></tr>
 * <tr><td>text/x-java</td><td>java&nbsp;</td></tr>
 * <tr><td>text/x-literate-haskell</td><td>lhs&nbsp;</td></tr>
 * <tr><td>text/x-moc</td><td>moc&nbsp;</td></tr>
 * <tr><td>text/x-pascal</td><td>pas&nbsp;p&nbsp;</td></tr>
 * <tr><td>text/x-pcs-gcd</td><td>gcd&nbsp;</td></tr>
 * <tr><td>text/x-perl</td><td>pl&nbsp;pm&nbsp;</td></tr>
 * <tr><td>text/x-pod</td><td>pod&nbsp;</td></tr>
 * <tr><td>text/x-python</td><td>py&nbsp;</td></tr>
 * <tr><td>text/x-scala</td><td>scala&nbsp;</td></tr>
 * <tr><td>text/x-setext</td><td>etx&nbsp;</td></tr>
 * <tr><td>text/x-sh</td><td>sh&nbsp;</td></tr>
 * <tr><td>text/x-tcl</td><td>tcl&nbsp;tk&nbsp;</td></tr>
 * <tr><td>text/x-tex</td><td>cls&nbsp;ltx&nbsp;tex&nbsp;sty&nbsp;</td></tr>
 * <tr><td>text/x-vcalendar</td><td>vcs&nbsp;</td></tr>
 * <tr><td>text/x-vcard</td><td>vcf&nbsp;</td></tr>
 * <tr><td>text/xml</td><td>xml&nbsp;</td></tr>
 * <tr><td>text/xml-external-parsed-entity</td><td>ent&nbsp;</td></tr>
 * <tr><td>video/3gpp</td><td>3gpp&nbsp;3gp&nbsp;</td></tr>
 * <tr><td>video/3gpp2</td><td>3gpp2&nbsp;3g2&nbsp;</td></tr>
 * <tr><td>video/annodex</td><td>axv&nbsp;</td></tr>
 * <tr><td>video/dl</td><td>dl&nbsp;</td></tr>
 * <tr><td>video/dv</td><td>dv&nbsp;dif&nbsp;</td></tr>
 * <tr><td>video/fli</td><td>fli&nbsp;</td></tr>
 * <tr><td>video/gl</td><td>gl&nbsp;</td></tr>
 * <tr><td>video/mj2</td><td>mj2&nbsp;mjp2&nbsp;</td></tr>
 * <tr><td>video/mp4</td><td>mpg4&nbsp;mp4&nbsp;</td></tr>
 * <tr><td>video/mpeg</td><td>mpeg&nbsp;mpg&nbsp;mpe&nbsp;</td></tr>
 * <tr><td>video/ogg</td><td>ogv&nbsp;</td></tr>
 * <tr><td>video/quicktime</td><td>mov&nbsp;qt&nbsp;</td></tr>
 * <tr><td>video/vnd.fvt</td><td>fvt&nbsp;</td></tr>
 * <tr><td>video/vnd.mpegurl</td><td>mxu&nbsp;m4u&nbsp;</td></tr>
 * <tr><td>video/vnd.ms-playready.media.pyv</td><td>pyv&nbsp;</td></tr>
 * <tr><td>video/vnd.nokia.interleaved-multimedia</td><td>nim&nbsp;</td></tr>
 * <tr><td>video/vnd.sealed.mpeg1</td><td>smpg&nbsp;s11&nbsp;</td></tr>
 * <tr><td>video/vnd.sealed.mpeg4</td><td>s14&nbsp;</td></tr>
 * <tr><td>video/vnd.sealed.swf</td><td>ssw&nbsp;sswf&nbsp;</td></tr>
 * <tr><td>video/vnd.sealedmedia.softseal.mov</td><td>smo&nbsp;s1q&nbsp;smov&nbsp;</td></tr>
 * <tr><td>video/x-flv</td><td>flv&nbsp;</td></tr>
 * <tr><td>video/x-la-asf</td><td>lsx&nbsp;lsf&nbsp;</td></tr>
 * <tr><td>video/x-matroska</td><td>mpv&nbsp;mkv&nbsp;</td></tr>
 * <tr><td>video/x-mng</td><td>mng&nbsp;</td></tr>
 * <tr><td>video/x-ms-asf</td><td>asf&nbsp;asx&nbsp;</td></tr>
 * <tr><td>video/x-ms-wm</td><td>wm&nbsp;</td></tr>
 * <tr><td>video/x-ms-wmv</td><td>wmv&nbsp;</td></tr>
 * <tr><td>video/x-ms-wmx</td><td>wmx&nbsp;</td></tr>
 * <tr><td>video/x-ms-wvx</td><td>wvx&nbsp;</td></tr>
 * <tr><td>video/x-msvideo</td><td>avi&nbsp;</td></tr>
 * <tr><td>video/x-sgi-movie</td><td>movie&nbsp;</td></tr>
 * <tr><td>x-conference/x-cooltalk</td><td>ice&nbsp;</td></tr>
 * <tr><td>x-epoc/x-sisx-app</td><td>sisx&nbsp;</td></tr>
 * <tr><td>x-world/x-vrml</td><td>vrml&nbsp;wrl&nbsp;vrm&nbsp;</td></tr>
 * </table>
 */
public class MimeType {
	private static HashMap<String, String>	map = new HashMap<String, String>();
	private static HashMap<String, HashMap<String, String[]>>	rev = new HashMap<String, HashMap<String, String[]>>();
	static {
set_rev("application","andrew-inset",new String[]{"ez"});
set_rev("application","annodex",new String[]{"anx"});
set_rev("application","atom+xml",new String[]{"atom"});
set_rev("application","atomcat+xml",new String[]{"atomcat"});
set_rev("application","atomserv+xml",new String[]{"atomsrv"});
set_rev("application","atomsvc+xml",new String[]{"atomsvc"});
set_rev("application","auth-policy+xml",new String[]{"apxml"});
set_rev("application","bbolin",new String[]{"lin"});
set_rev("application","cap",new String[]{"pcap","cap"});
set_rev("application","ccxml+xml",new String[]{"ccxml"});
set_rev("application","cellml+xml",new String[]{"cml","cellml"});
set_rev("application","cpl+xml",new String[]{"cpl"});
set_rev("application","cu-seeme",new String[]{"cu"});
set_rev("application","davmount+xml",new String[]{"davmount"});
set_rev("application","dicom",new String[]{"dcm"});
set_rev("application","dsptype",new String[]{"tsp"});
set_rev("application","dssc+der",new String[]{"dssc"});
set_rev("application","dssc+xml",new String[]{"xdssc"});
set_rev("application","dvcs",new String[]{"dvc"});
set_rev("application","ecmascript",new String[]{"es"});
set_rev("application","emma+xml",new String[]{"emma"});
set_rev("application","fastinfoset",new String[]{"finf"});
set_rev("application","font-tdpfr",new String[]{"pfr"});
set_rev("application","futuresplash",new String[]{"spl"});
set_rev("application","hta",new String[]{"hta"});
set_rev("application","hyperstudio",new String[]{"stk"});
set_rev("application","ipfix",new String[]{"ipfix"});
set_rev("application","java-archive",new String[]{"jar"});
set_rev("application","java-serialized-object",new String[]{"ser"});
set_rev("application","java-vm",new String[]{"class"});
set_rev("application","javascript",new String[]{"js"});
set_rev("application","json",new String[]{"json"});
set_rev("application","lost+xml",new String[]{"lostxml"});
set_rev("application","m3g",new String[]{"m3g"});
set_rev("application","mac-binhex40",new String[]{"hqx"});
set_rev("application","mac-compactpro",new String[]{"cpt"});
set_rev("application","marc",new String[]{"mrc"});
set_rev("application","mathematica",new String[]{"nb","nbp","ma","mb"});
set_rev("application","mathml+xml",new String[]{"mml"});
set_rev("application","mbox",new String[]{"mbox"});
set_rev("application","metalink+xml",new String[]{"metalink"});
set_rev("application","mp21",new String[]{"mp21","m21"});
set_rev("application","msaccess",new String[]{"mdb"});
set_rev("application","msword",new String[]{"doc","dot"});
set_rev("application","mxf",new String[]{"mxf"});
set_rev("application","ocsp-request",new String[]{"orq"});
set_rev("application","ocsp-response",new String[]{"ors"});
set_rev("application","octet-stream",new String[]{"lzh","iso","so","img","class","dll","bin","lha","exe"});
set_rev("application","oda",new String[]{"oda"});
set_rev("application","oebps-package+xml",new String[]{"opf"});
set_rev("application","ogg",new String[]{"ogx"});
set_rev("application","pdf",new String[]{"pdf"});
set_rev("application","pgp-keys",new String[]{"key"});
set_rev("application","pgp-signature",new String[]{"pgp","sig"});
set_rev("application","pics-rules",new String[]{"prf"});
set_rev("application","pkcs10",new String[]{"p10"});
set_rev("application","pkcs7-mime",new String[]{"p7m","p7c"});
set_rev("application","pkcs7-signature",new String[]{"p7s"});
set_rev("application","pkix-cert",new String[]{"cer"});
set_rev("application","pkix-crl",new String[]{"crl"});
set_rev("application","pkix-pkipath",new String[]{"pkipath"});
set_rev("application","pls+xml",new String[]{"pls"});
set_rev("application","postscript",new String[]{"eps","eps3","ai","eps2","epsf","epsi","ps"});
set_rev("application","prs.cww",new String[]{"cww","cw"});
set_rev("application","prs.nprend",new String[]{"rnd","rct"});
set_rev("application","rar",new String[]{"rar"});
set_rev("application","rdf+xml",new String[]{"rdf"});
set_rev("application","reginfo+xml",new String[]{"rif"});
set_rev("application","relax-ng-compact-syntax",new String[]{"rnc"});
set_rev("application","resource-lists+xml",new String[]{"rl"});
set_rev("application","resource-lists-diff+xml",new String[]{"rld"});
set_rev("application","rls-services+xml",new String[]{"rs"});
set_rev("application","rss+xml",new String[]{"rss"});
set_rev("application","rtf",new String[]{"rtf"});
set_rev("application","scvp-cv-request",new String[]{"scq"});
set_rev("application","scvp-cv-response",new String[]{"scs"});
set_rev("application","scvp-vp-request",new String[]{"spq"});
set_rev("application","scvp-vp-response",new String[]{"spp"});
set_rev("application","sdp",new String[]{"sdp"});
set_rev("application","sgml-open-catalog",new String[]{"soc"});
set_rev("application","shf+xml",new String[]{"shf"});
set_rev("application","sieve",new String[]{"sieve","siv"});
set_rev("application","simple-filter+xml",new String[]{"cl"});
set_rev("application","smil",new String[]{"smil","sml","smi"});
set_rev("application","sparql-query",new String[]{"rq"});
set_rev("application","sparql-results+xml",new String[]{"srx"});
set_rev("application","srgs",new String[]{"gram"});
set_rev("application","srgs+xml",new String[]{"grxml"});
set_rev("application","ssml+xml",new String[]{"ssml"});
set_rev("application","timestamp-query",new String[]{"tsq"});
set_rev("application","timestamp-reply",new String[]{"tsr"});
set_rev("application","vnd.3M.Post-it-Notes",new String[]{"pwn"});
set_rev("application","vnd.3gpp.pic-bw-large",new String[]{"plb"});
set_rev("application","vnd.3gpp.pic-bw-small",new String[]{"psb"});
set_rev("application","vnd.3gpp.pic-bw-var",new String[]{"pvb"});
set_rev("application","vnd.3gpp2.sms",new String[]{"sms"});
set_rev("application","vnd.3gpp2.tcap",new String[]{"tcap"});
set_rev("application","vnd.FloGraphIt",new String[]{"gph"});
set_rev("application","vnd.HandHeld-Entertainment+xml",new String[]{"zmm"});
set_rev("application","vnd.Kinar",new String[]{"kne","sdf","knp"});
set_rev("application","vnd.MFER",new String[]{"mwf"});
set_rev("application","vnd.Mobius.DAF",new String[]{"daf"});
set_rev("application","vnd.Mobius.DIS",new String[]{"dis"});
set_rev("application","vnd.Mobius.MBK",new String[]{"mbk"});
set_rev("application","vnd.Mobius.MQY",new String[]{"mqy"});
set_rev("application","vnd.Mobius.MSL",new String[]{"msl"});
set_rev("application","vnd.Mobius.PLC",new String[]{"plc"});
set_rev("application","vnd.Mobius.TXF",new String[]{"txf"});
set_rev("application","vnd.Quark.QuarkXPress",new String[]{"qxl","qwd","qxd","qwt","qxt","qxb"});
set_rev("application","vnd.SimTech-MindMapper",new String[]{"twds","twd"});
set_rev("application","vnd.accpac.simply.aso",new String[]{"aso"});
set_rev("application","vnd.accpac.simply.imp",new String[]{"imp"});
set_rev("application","vnd.acucobol",new String[]{"acu"});
set_rev("application","vnd.acucorp",new String[]{"acutc","atc"});
set_rev("application","vnd.adobe.xdp+xml",new String[]{"xdp"});
set_rev("application","vnd.adobe.xfdf",new String[]{"xfdf"});
set_rev("application","vnd.airzip.filesecure.azf",new String[]{"azf"});
set_rev("application","vnd.airzip.filesecure.azs",new String[]{"azs"});
set_rev("application","vnd.americandynamics.acc",new String[]{"acc"});
set_rev("application","vnd.amiga.ami",new String[]{"ami"});
set_rev("application","vnd.android.package-archive",new String[]{"apk"});
set_rev("application","vnd.anser-web-certificate-issue-initiation",new String[]{"cii"});
set_rev("application","vnd.anser-web-funds-transfer-initiation",new String[]{"fti"});
set_rev("application","vnd.apple.installer+xml",new String[]{"distz","mpkg","pkg","dist"});
set_rev("application","vnd.apple.mpegurl",new String[]{"m3u8"});
set_rev("application","vnd.aristanetworks.swi",new String[]{"swi"});
set_rev("application","vnd.audiograph",new String[]{"aep"});
set_rev("application","vnd.autopackage",new String[]{"package"});
set_rev("application","vnd.blueice.multipass",new String[]{"mpm"});
set_rev("application","vnd.bluetooth.ep.oob",new String[]{"ep"});
set_rev("application","vnd.bmi",new String[]{"bmi"});
set_rev("application","vnd.businessobjects",new String[]{"rep"});
set_rev("application","vnd.cendio.thinlinc.clientconf",new String[]{"tlclient"});
set_rev("application","vnd.chemdraw+xml",new String[]{"cdxml"});
set_rev("application","vnd.chipnuts.karaoke-mmd",new String[]{"mmd"});
set_rev("application","vnd.cinderella",new String[]{"cdy"});
set_rev("application","vnd.claymore",new String[]{"cla"});
set_rev("application","vnd.cloanto.rp9",new String[]{"rp9"});
set_rev("application","vnd.clonk.c4group",new String[]{"c4u","c4g","c4f","c4d","c4p"});
set_rev("application","vnd.commerce-battelle",new String[]{"icf","ic1","ic0","icd","ic3","ic2","ic5","ica","ic4","ic7","ic6","ic8"});
set_rev("application","vnd.commonspace",new String[]{"cst","csp"});
set_rev("application","vnd.contact.cmsg",new String[]{"cdbcmsg"});
set_rev("application","vnd.cosmocaller",new String[]{"cmc"});
set_rev("application","vnd.crick.clicker",new String[]{"clkx"});
set_rev("application","vnd.crick.clicker.keyboard",new String[]{"clkk"});
set_rev("application","vnd.crick.clicker.palette",new String[]{"clkp"});
set_rev("application","vnd.crick.clicker.template",new String[]{"clkt"});
set_rev("application","vnd.crick.clicker.wordbank",new String[]{"clkw"});
set_rev("application","vnd.criticaltools.wbs+xml",new String[]{"wbs"});
set_rev("application","vnd.ctc-posml",new String[]{"pml"});
set_rev("application","vnd.cups-ppd",new String[]{"ppd"});
set_rev("application","vnd.curl",new String[]{"curl"});
set_rev("application","vnd.data-vision.rdz",new String[]{"rdz"});
set_rev("application","vnd.denovo.fcselayout-link",new String[]{"fe_launch"});
set_rev("application","vnd.dna",new String[]{"dna"});
set_rev("application","vnd.dpgraph",new String[]{"mwc","dpgraph","dpg"});
set_rev("application","vnd.dreamfactory",new String[]{"dfac"});
set_rev("application","vnd.dynageo",new String[]{"geo"});
set_rev("application","vnd.ecowin.chart",new String[]{"mag"});
set_rev("application","vnd.enliven",new String[]{"nml"});
set_rev("application","vnd.epson.esf",new String[]{"esf"});
set_rev("application","vnd.epson.msf",new String[]{"msf"});
set_rev("application","vnd.epson.quickanime",new String[]{"qam"});
set_rev("application","vnd.epson.salt",new String[]{"slt"});
set_rev("application","vnd.epson.ssf",new String[]{"ssf"});
set_rev("application","vnd.ericsson.quickcall",new String[]{"qca","qcall"});
set_rev("application","vnd.eszigno3+xml",new String[]{"et3","es3"});
set_rev("application","vnd.ezpix-album",new String[]{"ez2"});
set_rev("application","vnd.ezpix-package",new String[]{"ez3"});
set_rev("application","vnd.fdf",new String[]{"fdf"});
set_rev("application","vnd.fdsn.mseed",new String[]{"mseed","msd"});
set_rev("application","vnd.fluxtime.clip",new String[]{"ftc"});
set_rev("application","vnd.font-fontforge-sfd",new String[]{"sfd"});
set_rev("application","vnd.framemaker",new String[]{"fm"});
set_rev("application","vnd.frogans.fnc",new String[]{"fnc"});
set_rev("application","vnd.frogans.ltf",new String[]{"ltf"});
set_rev("application","vnd.fsc.weblaunch",new String[]{"fsc"});
set_rev("application","vnd.fsdn.seed",new String[]{"dataless","seed"});
set_rev("application","vnd.fujitsu.oasys",new String[]{"oas"});
set_rev("application","vnd.fujitsu.oasys2",new String[]{"oa2"});
set_rev("application","vnd.fujitsu.oasys3",new String[]{"oa3"});
set_rev("application","vnd.fujitsu.oasysgp",new String[]{"fg5"});
set_rev("application","vnd.fujitsu.oasysprs",new String[]{"bh2"});
set_rev("application","vnd.fujixerox.ddd",new String[]{"ddd"});
set_rev("application","vnd.fujixerox.docuworks",new String[]{"xdw"});
set_rev("application","vnd.fujixerox.docuworks.binder",new String[]{"xbd"});
set_rev("application","vnd.fuzzysheet",new String[]{"fzs"});
set_rev("application","vnd.genomatix.tuxedo",new String[]{"txd"});
set_rev("application","vnd.geogebra.file",new String[]{"ggb"});
set_rev("application","vnd.geogebra.tool",new String[]{"ggt"});
set_rev("application","vnd.geometry-explorer",new String[]{"gex","gre"});
set_rev("application","vnd.geonext",new String[]{"gxt"});
set_rev("application","vnd.geoplan",new String[]{"g2w"});
set_rev("application","vnd.geospace",new String[]{"g3w"});
set_rev("application","vnd.google-earth.kml+xml",new String[]{"kml"});
set_rev("application","vnd.google-earth.kmz",new String[]{"kmz"});
set_rev("application","vnd.grafeq",new String[]{"gqs","gqf"});
set_rev("application","vnd.groove-account",new String[]{"gac"});
set_rev("application","vnd.groove-help",new String[]{"ghf"});
set_rev("application","vnd.groove-identity-message",new String[]{"gim"});
set_rev("application","vnd.groove-injector",new String[]{"grv"});
set_rev("application","vnd.groove-tool-message",new String[]{"gtm"});
set_rev("application","vnd.groove-tool-template",new String[]{"tpl"});
set_rev("application","vnd.groove-vcard",new String[]{"vcg"});
set_rev("application","vnd.hbci",new String[]{"hbci","upa","bpd","kom","pkd","hbc"});
set_rev("application","vnd.hhe.lesson-player",new String[]{"les"});
set_rev("application","vnd.hp-HPGL",new String[]{"hpgl"});
set_rev("application","vnd.hp-PCL",new String[]{"pcl"});
set_rev("application","vnd.hp-hpid",new String[]{"hpi","hpid"});
set_rev("application","vnd.hp-hps",new String[]{"hps"});
set_rev("application","vnd.hp-jlyt",new String[]{"jlt"});
set_rev("application","vnd.hydrostatix.sof-data",new String[]{"sfd-hdstx"});
set_rev("application","vnd.hzn-3d-crossword",new String[]{"x3d"});
set_rev("application","vnd.ibm.MiniPay",new String[]{"mpy"});
set_rev("application","vnd.ibm.electronic-media",new String[]{"emm"});
set_rev("application","vnd.ibm.modcap",new String[]{"afp","list3820","pseg3820","listafp"});
set_rev("application","vnd.ibm.rights-management",new String[]{"irm"});
set_rev("application","vnd.ibm.secure-container",new String[]{"sc"});
set_rev("application","vnd.iccprofile",new String[]{"icc","icm"});
set_rev("application","vnd.igloader",new String[]{"igl"});
set_rev("application","vnd.immervision-ivp",new String[]{"ivp"});
set_rev("application","vnd.immervision-ivu",new String[]{"ivu"});
set_rev("application","vnd.intercon.formnet",new String[]{"xpw","xpx"});
set_rev("application","vnd.intu.qbo",new String[]{"qbo"});
set_rev("application","vnd.intu.qfx",new String[]{"qfx"});
set_rev("application","vnd.ipunplugged.rcprofile",new String[]{"rcprofile"});
set_rev("application","vnd.irepository.package+xml",new String[]{"irp"});
set_rev("application","vnd.is-xpr",new String[]{"xpr"});
set_rev("application","vnd.jam",new String[]{"jam"});
set_rev("application","vnd.jcp.javame.midlet-rms",new String[]{"rms"});
set_rev("application","vnd.jisp",new String[]{"jisp"});
set_rev("application","vnd.joost.joda-archive",new String[]{"joda"});
set_rev("application","vnd.kahootz",new String[]{"ktr","ktz"});
set_rev("application","vnd.kde.karbon",new String[]{"karbon"});
set_rev("application","vnd.kde.kchart",new String[]{"chrt"});
set_rev("application","vnd.kde.kformula",new String[]{"kfo"});
set_rev("application","vnd.kde.kivio",new String[]{"flw"});
set_rev("application","vnd.kde.kontour",new String[]{"kon"});
set_rev("application","vnd.kde.kpresenter",new String[]{"kpr","kpt"});
set_rev("application","vnd.kde.kspread",new String[]{"ksp"});
set_rev("application","vnd.kde.kword",new String[]{"kwd","kwt"});
set_rev("application","vnd.kenameaapp",new String[]{"htke"});
set_rev("application","vnd.kidspiration",new String[]{"kia"});
set_rev("application","vnd.koan",new String[]{"skm","skp","skd","skt"});
set_rev("application","vnd.kodak-descriptor",new String[]{"sse"});
set_rev("application","vnd.llamagraphics.life-balance.desktop",new String[]{"lbd"});
set_rev("application","vnd.llamagraphics.life-balance.exchange+xml",new String[]{"lbe"});
set_rev("application","vnd.lotus-1-2-3",new String[]{"wk4","123","wk3","wk1"});
set_rev("application","vnd.lotus-approach",new String[]{"vew","apr"});
set_rev("application","vnd.lotus-freelance",new String[]{"pre","prz"});
set_rev("application","vnd.lotus-notes",new String[]{"ns2","ns4","ns3","ndl","nsf","nsh","nsg","ntf"});
set_rev("application","vnd.lotus-organizer",new String[]{"or2","org","or3"});
set_rev("application","vnd.lotus-screencam",new String[]{"scm"});
set_rev("application","vnd.lotus-wordpro",new String[]{"lwp","sam"});
set_rev("application","vnd.macports.portpkg",new String[]{"portpkg"});
set_rev("application","vnd.marlin.drm.mdcf",new String[]{"mdc"});
set_rev("application","vnd.mcd",new String[]{"mcd"});
set_rev("application","vnd.medcalcdata",new String[]{"mc1"});
set_rev("application","vnd.mediastation.cdkey",new String[]{"cdkey"});
set_rev("application","vnd.mfmp",new String[]{"mfm"});
set_rev("application","vnd.micrografx.flo",new String[]{"flo"});
set_rev("application","vnd.micrografx.igx",new String[]{"igx"});
set_rev("application","vnd.mif",new String[]{"mif"});
set_rev("application","vnd.mophun.application",new String[]{"mpn"});
set_rev("application","vnd.mophun.certificate",new String[]{"mpc"});
set_rev("application","vnd.mozilla.xul+xml",new String[]{"xul"});
set_rev("application","vnd.ms-artgalry",new String[]{"cil"});
set_rev("application","vnd.ms-asf",new String[]{"asf"});
set_rev("application","vnd.ms-cab-compressed",new String[]{"cab"});
set_rev("application","vnd.ms-excel",new String[]{"xlb","xls","xlt"});
set_rev("application","vnd.ms-excel.addin.macroEnabled.12",new String[]{"xlam"});
set_rev("application","vnd.ms-excel.sheet.binary.macroEnabled.12",new String[]{"xlsb"});
set_rev("application","vnd.ms-excel.sheet.macroEnabled.12",new String[]{"xlsm"});
set_rev("application","vnd.ms-excel.template.macroEnabled.12",new String[]{"xltm"});
set_rev("application","vnd.ms-fontobject",new String[]{"eot"});
set_rev("application","vnd.ms-htmlhelp",new String[]{"chm"});
set_rev("application","vnd.ms-ims",new String[]{"ims"});
set_rev("application","vnd.ms-lrm",new String[]{"lrm"});
set_rev("application","vnd.ms-pki.seccat",new String[]{"cat"});
set_rev("application","vnd.ms-pki.stl",new String[]{"stl"});
set_rev("application","vnd.ms-powerpoint",new String[]{"pps","ppt"});
set_rev("application","vnd.ms-powerpoint.addin.macroEnabled.12",new String[]{"ppam"});
set_rev("application","vnd.ms-powerpoint.presentation.macroEnabled.12",new String[]{"pptm"});
set_rev("application","vnd.ms-powerpoint.slide.macroEnabled.12",new String[]{"sldm"});
set_rev("application","vnd.ms-powerpoint.slideshow.macroEnabled.12",new String[]{"ppsm"});
set_rev("application","vnd.ms-powerpoint.template.macroEnabled.12",new String[]{"potm"});
set_rev("application","vnd.ms-project",new String[]{"mpp"});
set_rev("application","vnd.ms-tnef",new String[]{"tnf","tnef"});
set_rev("application","vnd.ms-word.document.macroEnabled.12",new String[]{"docm"});
set_rev("application","vnd.ms-word.template.macroEnabled.12",new String[]{"dotm"});
set_rev("application","vnd.ms-works",new String[]{"wps","wcm","wks","wdb"});
set_rev("application","vnd.ms-wpl",new String[]{"wpl"});
set_rev("application","vnd.ms-xpsdocument",new String[]{"xps"});
set_rev("application","vnd.mseq",new String[]{"mseq"});
set_rev("application","vnd.multiad.creator",new String[]{"crtr"});
set_rev("application","vnd.multiad.creator.cif",new String[]{"cif"});
set_rev("application","vnd.musician",new String[]{"mus"});
set_rev("application","vnd.muvee.style",new String[]{"msty"});
set_rev("application","vnd.nervana",new String[]{"kcm","request","entity","bkm"});
set_rev("application","vnd.neurolanguage.nlu",new String[]{"nlu"});
set_rev("application","vnd.noblenet-directory",new String[]{"nnd"});
set_rev("application","vnd.noblenet-sealer",new String[]{"nns"});
set_rev("application","vnd.noblenet-web",new String[]{"nnw"});
set_rev("application","vnd.nokia.n-gage.ac+xml",new String[]{"ac"});
set_rev("application","vnd.nokia.n-gage.data",new String[]{"ngdat"});
set_rev("application","vnd.nokia.n-gage.symbian.install",new String[]{"n-gage"});
set_rev("application","vnd.nokia.radio-preset",new String[]{"rpst"});
set_rev("application","vnd.nokia.radio-presets",new String[]{"rpss"});
set_rev("application","vnd.novadigm.EDM",new String[]{"edm"});
set_rev("application","vnd.novadigm.EDX",new String[]{"edx"});
set_rev("application","vnd.novadigm.EXT",new String[]{"ext"});
set_rev("application","vnd.oasis.opendocument.chart",new String[]{"odc"});
set_rev("application","vnd.oasis.opendocument.chart-template",new String[]{"otc"});
set_rev("application","vnd.oasis.opendocument.database",new String[]{"odb"});
set_rev("application","vnd.oasis.opendocument.formula",new String[]{"odf"});
set_rev("application","vnd.oasis.opendocument.formula-template",new String[]{"otf"});
set_rev("application","vnd.oasis.opendocument.graphics",new String[]{"odg"});
set_rev("application","vnd.oasis.opendocument.graphics-template",new String[]{"otg"});
set_rev("application","vnd.oasis.opendocument.image",new String[]{"odi"});
set_rev("application","vnd.oasis.opendocument.image-template",new String[]{"oti"});
set_rev("application","vnd.oasis.opendocument.presentation",new String[]{"odp"});
set_rev("application","vnd.oasis.opendocument.presentation-template",new String[]{"otp"});
set_rev("application","vnd.oasis.opendocument.spreadsheet",new String[]{"ods"});
set_rev("application","vnd.oasis.opendocument.spreadsheet-template",new String[]{"ots"});
set_rev("application","vnd.oasis.opendocument.text",new String[]{"odt"});
set_rev("application","vnd.oasis.opendocument.text-master",new String[]{"odm"});
set_rev("application","vnd.oasis.opendocument.text-template",new String[]{"ott"});
set_rev("application","vnd.oasis.opendocument.text-web",new String[]{"oth"});
set_rev("application","vnd.olpc-sugar",new String[]{"xo"});
set_rev("application","vnd.oma.dd+xml",new String[]{"dd"});
set_rev("application","vnd.oma.dd2+xml",new String[]{"dd2"});
set_rev("application","vnd.oma.drm.content",new String[]{"dcf"});
set_rev("application","vnd.oma.drm.dcf",new String[]{"o4v","o4a"});
set_rev("application","vnd.oma.drm.message",new String[]{"dm"});
set_rev("application","vnd.oma.drm.rights+wbxml",new String[]{"drc"});
set_rev("application","vnd.oma.drm.rights+xml",new String[]{"dr"});
set_rev("application","vnd.openofficeorg.extension",new String[]{"oxt"});
set_rev("application","vnd.openxmlformats-officedocument.presentationml.presentation",new String[]{"pptx"});
set_rev("application","vnd.openxmlformats-officedocument.presentationml.slide",new String[]{"sldx"});
set_rev("application","vnd.openxmlformats-officedocument.presentationml.slideshow",new String[]{"ppsx"});
set_rev("application","vnd.openxmlformats-officedocument.presentationml.template",new String[]{"potx"});
set_rev("application","vnd.openxmlformats-officedocument.spreadsheetml.sheet",new String[]{"xlsx"});
set_rev("application","vnd.openxmlformats-officedocument.spreadsheetml.template",new String[]{"xltx"});
set_rev("application","vnd.openxmlformats-officedocument.wordprocessingml.document",new String[]{"docx"});
set_rev("application","vnd.openxmlformats-officedocument.wordprocessingml.template",new String[]{"dotx"});
set_rev("application","vnd.osa.netdeploy",new String[]{"ndc"});
set_rev("application","vnd.osgi.dp",new String[]{"dp"});
set_rev("application","vnd.palm",new String[]{"oprc","prc","pqa","pdb"});
set_rev("application","vnd.pg.format",new String[]{"str"});
set_rev("application","vnd.pg.osasli",new String[]{"ei6"});
set_rev("application","vnd.piaccess.application-license",new String[]{"pil"});
set_rev("application","vnd.picsel",new String[]{"efif"});
set_rev("application","vnd.pocketlearn",new String[]{"plf"});
set_rev("application","vnd.powerbuilder6",new String[]{"pbd"});
set_rev("application","vnd.preminet",new String[]{"preminet"});
set_rev("application","vnd.previewsystems.box",new String[]{"box","vbox"});
set_rev("application","vnd.proteus.magazine",new String[]{"mgz"});
set_rev("application","vnd.publishare-delta-tree",new String[]{"qps"});
set_rev("application","vnd.pvi.ptid1",new String[]{"ptid"});
set_rev("application","vnd.qualcomm.brew-app-res",new String[]{"bar"});
set_rev("application","vnd.realvnc.bed",new String[]{"bed"});
set_rev("application","vnd.recordare.musicxml",new String[]{"mxl"});
set_rev("application","vnd.rim.cod",new String[]{"cod"});
set_rev("application","vnd.route66.link66+xml",new String[]{"link66"});
set_rev("application","vnd.sailingtracker.track",new String[]{"st"});
set_rev("application","vnd.scribus",new String[]{"scd","slaz","sla"});
set_rev("application","vnd.sealed.3df",new String[]{"s3df"});
set_rev("application","vnd.sealed.csf",new String[]{"scsf"});
set_rev("application","vnd.sealed.doc",new String[]{"sdoc","s1w","sdo"});
set_rev("application","vnd.sealed.eml",new String[]{"seml","sem"});
set_rev("application","vnd.sealed.mht",new String[]{"smh","smht"});
set_rev("application","vnd.sealed.ppt",new String[]{"s1p","sppt"});
set_rev("application","vnd.sealed.tiff",new String[]{"stif"});
set_rev("application","vnd.sealed.xls",new String[]{"s1e","sxls","sxl"});
set_rev("application","vnd.sealedmedia.softseal.html",new String[]{"stml","s1h"});
set_rev("application","vnd.sealedmedia.softseal.pdf",new String[]{"s1a","spdf","spd"});
set_rev("application","vnd.seemail",new String[]{"see"});
set_rev("application","vnd.sema",new String[]{"sema"});
set_rev("application","vnd.semd",new String[]{"semd"});
set_rev("application","vnd.semf",new String[]{"semf"});
set_rev("application","vnd.shana.informed.formdata",new String[]{"ifm"});
set_rev("application","vnd.shana.informed.formtemplate",new String[]{"itp"});
set_rev("application","vnd.shana.informed.interchange",new String[]{"iif"});
set_rev("application","vnd.shana.informed.package",new String[]{"ipk"});
set_rev("application","vnd.smaf",new String[]{"mmf"});
set_rev("application","vnd.smart.teacher",new String[]{"teacher"});
set_rev("application","vnd.software602.filler.form+xml",new String[]{"fo"});
set_rev("application","vnd.software602.filler.form-xml-zip",new String[]{"zfo"});
set_rev("application","vnd.solent.sdkm+xml",new String[]{"sdkd","sdkm"});
set_rev("application","vnd.spotfire.dxp",new String[]{"dxp"});
set_rev("application","vnd.spotfire.sfs",new String[]{"sfs"});
set_rev("application","vnd.stardivision.calc",new String[]{"sdc"});
set_rev("application","vnd.stardivision.chart",new String[]{"sds"});
set_rev("application","vnd.stardivision.draw",new String[]{"sda"});
set_rev("application","vnd.stardivision.impress",new String[]{"sdd"});
set_rev("application","vnd.stardivision.math",new String[]{"sdf"});
set_rev("application","vnd.stardivision.writer",new String[]{"sdw"});
set_rev("application","vnd.stardivision.writer-global",new String[]{"sgl"});
set_rev("application","vnd.sun.wadl+xml",new String[]{"wadl"});
set_rev("application","vnd.sun.xml.calc",new String[]{"sxc"});
set_rev("application","vnd.sun.xml.calc.template",new String[]{"stc"});
set_rev("application","vnd.sun.xml.draw",new String[]{"sxd"});
set_rev("application","vnd.sun.xml.draw.template",new String[]{"std"});
set_rev("application","vnd.sun.xml.impress",new String[]{"sxi"});
set_rev("application","vnd.sun.xml.impress.template",new String[]{"sti"});
set_rev("application","vnd.sun.xml.math",new String[]{"sxm"});
set_rev("application","vnd.sun.xml.writer",new String[]{"sxw"});
set_rev("application","vnd.sun.xml.writer.global",new String[]{"sxg"});
set_rev("application","vnd.sun.xml.writer.template",new String[]{"stw"});
set_rev("application","vnd.sus-calendar",new String[]{"sus","susp"});
set_rev("application","vnd.symbian.install",new String[]{"sis"});
set_rev("application","vnd.syncml+xml",new String[]{"xsm"});
set_rev("application","vnd.syncml.dm+wbxml",new String[]{"bdm"});
set_rev("application","vnd.syncml.dm+xml",new String[]{"xdm"});
set_rev("application","vnd.tao.intent-module-archive",new String[]{"tao"});
set_rev("application","vnd.tmobile-livetv",new String[]{"tmo"});
set_rev("application","vnd.trid.tpt",new String[]{"tpt"});
set_rev("application","vnd.triscape.mxs",new String[]{"mxs"});
set_rev("application","vnd.trueapp",new String[]{"tra"});
set_rev("application","vnd.ufdl",new String[]{"frm","ufd","ufdl"});
set_rev("application","vnd.uiq.theme",new String[]{"utz"});
set_rev("application","vnd.umajin",new String[]{"umj"});
set_rev("application","vnd.unity",new String[]{"unityweb"});
set_rev("application","vnd.uoml+xml",new String[]{"uoml","uo"});
set_rev("application","vnd.vcx",new String[]{"vcx"});
set_rev("application","vnd.vd-study",new String[]{"mxi","model-inter","study-inter"});
set_rev("application","vnd.vectorworks",new String[]{"vwx"});
set_rev("application","vnd.vidsoft.vidconference",new String[]{"vsc"});
set_rev("application","vnd.visio",new String[]{"vsw","vsd","vss","vst"});
set_rev("application","vnd.visionary",new String[]{"vis"});
set_rev("application","vnd.vsf",new String[]{"vsf"});
set_rev("application","vnd.wap.mms-message",new String[]{"mms"});
set_rev("application","vnd.wap.sic",new String[]{"sic"});
set_rev("application","vnd.wap.slc",new String[]{"slc"});
set_rev("application","vnd.wap.wbxml",new String[]{"wbxml"});
set_rev("application","vnd.wap.wmlc",new String[]{"wmlc"});
set_rev("application","vnd.wap.wmlscriptc",new String[]{"wmlsc"});
set_rev("application","vnd.webturbo",new String[]{"wtb"});
set_rev("application","vnd.wfa.wsc",new String[]{"wsc"});
set_rev("application","vnd.wmc",new String[]{"wmc"});
set_rev("application","vnd.wolfram.mathematica.package",new String[]{"m"});
set_rev("application","vnd.wolfram.player",new String[]{"nbp"});
set_rev("application","vnd.wordperfect",new String[]{"wpd"});
set_rev("application","vnd.wordperfect5.1",new String[]{"wp5"});
set_rev("application","vnd.wqd",new String[]{"wqd"});
set_rev("application","vnd.wt.stf",new String[]{"stf"});
set_rev("application","vnd.wv.csp+wbxml",new String[]{"wv"});
set_rev("application","vnd.xara",new String[]{"xar"});
set_rev("application","vnd.xfdl",new String[]{"xfd","xfdl"});
set_rev("application","vnd.xmpie.cpkg",new String[]{"cpkg"});
set_rev("application","vnd.xmpie.dpkg",new String[]{"dpkg"});
set_rev("application","vnd.xmpie.ppkg",new String[]{"ppkg"});
set_rev("application","vnd.xmpie.xlim",new String[]{"xlim"});
set_rev("application","vnd.yamaha.hv-dic",new String[]{"hvd"});
set_rev("application","vnd.yamaha.hv-script",new String[]{"hvs"});
set_rev("application","vnd.yamaha.hv-voice",new String[]{"hvp"});
set_rev("application","vnd.yamaha.openscoreformat",new String[]{"osf"});
set_rev("application","vnd.yamaha.smaf-audio",new String[]{"saf"});
set_rev("application","vnd.yamaha.smaf-phrase",new String[]{"spf"});
set_rev("application","vnd.yellowriver-custom-menu",new String[]{"cmp"});
set_rev("application","vnd.zul",new String[]{"zir","zirz"});
set_rev("application","vnd.zzazz.deck+xml",new String[]{"zaz"});
set_rev("application","voicexml+xml",new String[]{"vxml"});
set_rev("application","watcherinfo+xml",new String[]{"wif"});
set_rev("application","wsdl+xml",new String[]{"wsdl"});
set_rev("application","wspolicy+xml",new String[]{"wspolicy"});
set_rev("application","x-123",new String[]{"wk"});
set_rev("application","x-7z-compressed",new String[]{"7z"});
set_rev("application","x-abiword",new String[]{"abw"});
set_rev("application","x-apple-diskimage",new String[]{"dmg"});
set_rev("application","x-bcpio",new String[]{"bcpio"});
set_rev("application","x-bittorrent",new String[]{"torrent"});
set_rev("application","x-bzip2",new String[]{"bz2"});
set_rev("application","x-cab",new String[]{"cab"});
set_rev("application","x-cbr",new String[]{"cbr"});
set_rev("application","x-cbz",new String[]{"cbz"});
set_rev("application","x-cdf",new String[]{"cda","cdf"});
set_rev("application","x-cdlink",new String[]{"vcd"});
set_rev("application","x-chess-pgn",new String[]{"pgn"});
set_rev("application","x-cpio",new String[]{"cpio"});
set_rev("application","x-csh",new String[]{"csh"});
set_rev("application","x-debian-package",new String[]{"deb","udeb"});
set_rev("application","x-director",new String[]{"dcr","dir","dxr"});
set_rev("application","x-dms",new String[]{"dms"});
set_rev("application","x-doom",new String[]{"wad"});
set_rev("application","x-dvi",new String[]{"dvi"});
set_rev("application","x-font",new String[]{"pfa","pcf","pfb","pcf.Z","gsf"});
set_rev("application","x-freemind",new String[]{"mm"});
set_rev("application","x-futuresplash",new String[]{"spl"});
set_rev("application","x-gnumeric",new String[]{"gnumeric"});
set_rev("application","x-go-sgf",new String[]{"sgf"});
set_rev("application","x-graphing-calculator",new String[]{"gcf"});
set_rev("application","x-gtar",new String[]{"taz","tgz","gtar"});
set_rev("application","x-gzip",new String[]{"gz","tgz"});
set_rev("application","x-hdf",new String[]{"hdf"});
set_rev("application","x-httpd-eruby",new String[]{"rhtml"});
set_rev("application","x-httpd-php",new String[]{"pht","php","phtml"});
set_rev("application","x-httpd-php-source",new String[]{"phps"});
set_rev("application","x-httpd-php3",new String[]{"php3"});
set_rev("application","x-httpd-php3-preprocessed",new String[]{"php3p"});
set_rev("application","x-httpd-php4",new String[]{"php4"});
set_rev("application","x-httpd-php5",new String[]{"php5"});
set_rev("application","x-ica",new String[]{"ica"});
set_rev("application","x-info",new String[]{"info"});
set_rev("application","x-internet-signup",new String[]{"isp","ins"});
set_rev("application","x-iphone",new String[]{"iii"});
set_rev("application","x-iso9660-image",new String[]{"iso"});
set_rev("application","x-jam",new String[]{"jam"});
set_rev("application","x-java-archive",new String[]{"jar"});
set_rev("application","x-java-jnlp-file",new String[]{"jnlp"});
set_rev("application","x-java-pack200",new String[]{"pack"});
set_rev("application","x-jmol",new String[]{"jmz"});
set_rev("application","x-kchart",new String[]{"chrt"});
set_rev("application","x-killustrator",new String[]{"kil"});
set_rev("application","x-koan",new String[]{"skm","skp","skd","skt"});
set_rev("application","x-kpresenter",new String[]{"kpr","kpt"});
set_rev("application","x-kspread",new String[]{"ksp"});
set_rev("application","x-kword",new String[]{"kwd","kwt"});
set_rev("application","x-latex",new String[]{"latex"});
set_rev("application","x-lha",new String[]{"lha"});
set_rev("application","x-lyx",new String[]{"lyx"});
set_rev("application","x-lzh",new String[]{"lzh"});
set_rev("application","x-lzx",new String[]{"lzx"});
set_rev("application","x-maker",new String[]{"frm","fm","fbdoc","frame","maker","book","fb"});
set_rev("application","x-mif",new String[]{"mif"});
set_rev("application","x-ms-wmd",new String[]{"wmd"});
set_rev("application","x-ms-wmz",new String[]{"wmz"});
set_rev("application","x-msdos-program",new String[]{"com","dll","bat","exe"});
set_rev("application","x-msi",new String[]{"msi"});
set_rev("application","x-netcdf",new String[]{"nc","cdf"});
set_rev("application","x-ns-proxy-autoconfig",new String[]{"dat","pac"});
set_rev("application","x-nwc",new String[]{"nwc"});
set_rev("application","x-object",new String[]{"o"});
set_rev("application","x-oz-application",new String[]{"oza"});
set_rev("application","x-perl",new String[]{"pl"});
set_rev("application","x-pkcs7-certreqresp",new String[]{"p7r"});
set_rev("application","x-pkcs7-crl",new String[]{"crl"});
set_rev("application","x-python-code",new String[]{"pyc","pyo"});
set_rev("application","x-qgis",new String[]{"shp","shx","qgs"});
set_rev("application","x-quicktimeplayer",new String[]{"qtl"});
set_rev("application","x-redhat-package-manager",new String[]{"rpm"});
set_rev("application","x-rpm",new String[]{"rpm"});
set_rev("application","x-ruby",new String[]{"rb"});
set_rev("application","x-sh",new String[]{"sh"});
set_rev("application","x-shar",new String[]{"shar"});
set_rev("application","x-shockwave-flash",new String[]{"swf","swfl"});
set_rev("application","x-silverlight",new String[]{"scr"});
set_rev("application","x-stuffit",new String[]{"sit","sitx"});
set_rev("application","x-sv4cpio",new String[]{"sv4cpio"});
set_rev("application","x-sv4crc",new String[]{"sv4crc"});
set_rev("application","x-tar",new String[]{"tar"});
set_rev("application","x-tcl",new String[]{"tcl"});
set_rev("application","x-tex",new String[]{"tex"});
set_rev("application","x-tex-gf",new String[]{"gf"});
set_rev("application","x-tex-pk",new String[]{"pk"});
set_rev("application","x-texinfo",new String[]{"texinfo","texi"});
set_rev("application","x-trash",new String[]{"old","bak","%","~","sik"});
set_rev("application","x-troff",new String[]{"t","tr","roff"});
set_rev("application","x-troff-man",new String[]{"3","2","1","7","6","5","4","8","man"});
set_rev("application","x-troff-me",new String[]{"me"});
set_rev("application","x-troff-ms",new String[]{"ms"});
set_rev("application","x-ustar",new String[]{"ustar"});
set_rev("application","x-wais-source",new String[]{"src"});
set_rev("application","x-wingz",new String[]{"wz"});
set_rev("application","x-x509-ca-cert",new String[]{"crt"});
set_rev("application","x-xcf",new String[]{"xcf"});
set_rev("application","x-xfig",new String[]{"fig"});
set_rev("application","x-xpinstall",new String[]{"xpi"});
set_rev("application","x-xz",new String[]{"xz"});
set_rev("application","xcap-att+xml",new String[]{"xav"});
set_rev("application","xcap-caps+xml",new String[]{"xca"});
set_rev("application","xcap-el+xml",new String[]{"xel"});
set_rev("application","xcap-error+xml",new String[]{"xer"});
set_rev("application","xcap-ns+xml",new String[]{"xns"});
set_rev("application","xhtml+xml",new String[]{"xhtm","xhtml","xht"});
set_rev("application","xml",new String[]{"xsl","xsd","xml"});
set_rev("application","xml-dtd",new String[]{"dtd"});
set_rev("application","xop+xml",new String[]{"xop"});
set_rev("application","xslt+xml",new String[]{"xsl","xslt"});
set_rev("application","xspf+xml",new String[]{"xspf"});
set_rev("application","xv+xml",new String[]{"xvm","xhvml","mxml","xvml"});
set_rev("application","zip",new String[]{"zip"});
set_rev("audio","32kadpcm",new String[]{"726"});
set_rev("audio","AMR",new String[]{"amr"});
set_rev("audio","AMR-WB",new String[]{"awb"});
set_rev("audio","ATRAC-ADVANCED-LOSSLESS",new String[]{"aal"});
set_rev("audio","ATRAC-X",new String[]{"atx"});
set_rev("audio","ATRAC3",new String[]{"aa3","at3","omg"});
set_rev("audio","EVRC",new String[]{"evc"});
set_rev("audio","EVRCB",new String[]{"evb"});
set_rev("audio","EVRCWB",new String[]{"evw"});
set_rev("audio","L16",new String[]{"l16"});
set_rev("audio","SMV",new String[]{"smv"});
set_rev("audio","ac3",new String[]{"ac3"});
set_rev("audio","amr",new String[]{"amr"});
set_rev("audio","amr-wb",new String[]{"awb"});
set_rev("audio","annodex",new String[]{"axa"});
set_rev("audio","basic",new String[]{"au","snd"});
set_rev("audio","dls",new String[]{"dls"});
set_rev("audio","flac",new String[]{"flac"});
set_rev("audio","iLBC",new String[]{"lbc"});
set_rev("audio","midi",new String[]{"midi","kar","mid"});
set_rev("audio","mobile-xmf",new String[]{"mxmf"});
set_rev("audio","mpeg",new String[]{"m4a","mp1","mp2","mpga","mp3","mpega"});
set_rev("audio","mpegurl",new String[]{"m3u"});
set_rev("audio","ogg",new String[]{"oga","spx","ogg"});
set_rev("audio","prs.sid",new String[]{"sid","psid"});
set_rev("audio","qcelp",new String[]{"qcp"});
set_rev("audio","vnd.audikoz",new String[]{"koz"});
set_rev("audio","vnd.digital-winds",new String[]{"eol"});
set_rev("audio","vnd.dolby.mlp",new String[]{"mlp"});
set_rev("audio","vnd.dts",new String[]{"dts"});
set_rev("audio","vnd.dts.hd",new String[]{"dtshd"});
set_rev("audio","vnd.everad.plj",new String[]{"plj"});
set_rev("audio","vnd.lucent.voice",new String[]{"lvp"});
set_rev("audio","vnd.ms-playready.media.pya",new String[]{"pya"});
set_rev("audio","vnd.nortel.vbk",new String[]{"vbk"});
set_rev("audio","vnd.nuera.ecelp4800",new String[]{"ecelp4800"});
set_rev("audio","vnd.nuera.ecelp7470",new String[]{"ecelp7470"});
set_rev("audio","vnd.nuera.ecelp9600",new String[]{"ecelp9600"});
set_rev("audio","vnd.sealedmedia.softseal.mpeg",new String[]{"smp3","smp","s1m"});
set_rev("audio","x-aiff",new String[]{"aifc","aif","aiff"});
set_rev("audio","x-gsm",new String[]{"gsm"});
set_rev("audio","x-mod",new String[]{"med","669","m15","ult","mod","mtm","uni"});
set_rev("audio","x-mpegurl",new String[]{"m3u"});
set_rev("audio","x-ms-wax",new String[]{"wax"});
set_rev("audio","x-ms-wma",new String[]{"wma"});
set_rev("audio","x-pn-realaudio",new String[]{"ra","rm","ram"});
set_rev("audio","x-realaudio",new String[]{"ra"});
set_rev("audio","x-s3m",new String[]{"s3m"});
set_rev("audio","x-scpls",new String[]{"pls"});
set_rev("audio","x-sd2",new String[]{"sd2"});
set_rev("audio","x-stm",new String[]{"stm"});
set_rev("audio","x-wav",new String[]{"wav"});
set_rev("chemical","x-alchemy",new String[]{"alc"});
set_rev("chemical","x-cache",new String[]{"cac","cache"});
set_rev("chemical","x-cache-csf",new String[]{"csf"});
set_rev("chemical","x-cactvs-binary",new String[]{"ctab","cascii","cbin"});
set_rev("chemical","x-cdx",new String[]{"cdx"});
set_rev("chemical","x-cerius",new String[]{"cer"});
set_rev("chemical","x-chem3d",new String[]{"c3d"});
set_rev("chemical","x-chemdraw",new String[]{"chm"});
set_rev("chemical","x-cif",new String[]{"cif"});
set_rev("chemical","x-cmdf",new String[]{"cmdf"});
set_rev("chemical","x-cml",new String[]{"cml"});
set_rev("chemical","x-compass",new String[]{"cpa"});
set_rev("chemical","x-crossfire",new String[]{"bsd"});
set_rev("chemical","x-csml",new String[]{"csml","csm"});
set_rev("chemical","x-ctx",new String[]{"ctx"});
set_rev("chemical","x-cxf",new String[]{"cxf","cef"});
set_rev("chemical","x-embl-dl-nucleotide",new String[]{"embl","emb"});
set_rev("chemical","x-galactic-spc",new String[]{"spc"});
set_rev("chemical","x-gamess-input",new String[]{"inp","gamin","gam"});
set_rev("chemical","x-gaussian-checkpoint",new String[]{"fchk","fch"});
set_rev("chemical","x-gaussian-cube",new String[]{"cub"});
set_rev("chemical","x-gaussian-input",new String[]{"gau","gjc","gjf"});
set_rev("chemical","x-gaussian-log",new String[]{"gal"});
set_rev("chemical","x-gcg8-sequence",new String[]{"gcg"});
set_rev("chemical","x-genbank",new String[]{"gen"});
set_rev("chemical","x-hin",new String[]{"hin"});
set_rev("chemical","x-isostar",new String[]{"ist","istr"});
set_rev("chemical","x-jcamp-dx",new String[]{"dx","jdx"});
set_rev("chemical","x-kinemage",new String[]{"kin"});
set_rev("chemical","x-macmolecule",new String[]{"mcm"});
set_rev("chemical","x-macromodel-input",new String[]{"mmod","mmd"});
set_rev("chemical","x-mdl-molfile",new String[]{"mol"});
set_rev("chemical","x-mdl-rdfile",new String[]{"rd"});
set_rev("chemical","x-mdl-rxnfile",new String[]{"rxn"});
set_rev("chemical","x-mdl-sdfile",new String[]{"sdf","sd"});
set_rev("chemical","x-mdl-tgf",new String[]{"tgf"});
set_rev("chemical","x-mmcif",new String[]{"mcif"});
set_rev("chemical","x-mol2",new String[]{"mol2"});
set_rev("chemical","x-molconn-Z",new String[]{"b"});
set_rev("chemical","x-mopac-graph",new String[]{"gpt"});
set_rev("chemical","x-mopac-input",new String[]{"mpc","zmt","mop","mopcrt"});
set_rev("chemical","x-mopac-out",new String[]{"moo"});
set_rev("chemical","x-mopac-vib",new String[]{"mvb"});
set_rev("chemical","x-ncbi-asn1",new String[]{"asn"});
set_rev("chemical","x-ncbi-asn1-ascii",new String[]{"prt","ent"});
set_rev("chemical","x-ncbi-asn1-binary",new String[]{"val","aso"});
set_rev("chemical","x-ncbi-asn1-spec",new String[]{"asn"});
set_rev("chemical","x-pdb",new String[]{"pdb","ent"});
set_rev("chemical","x-rosdal",new String[]{"ros"});
set_rev("chemical","x-swissprot",new String[]{"sw"});
set_rev("chemical","x-vamas-iso14976",new String[]{"vms"});
set_rev("chemical","x-vmd",new String[]{"vmd"});
set_rev("chemical","x-xtel",new String[]{"xtel"});
set_rev("chemical","x-xyz",new String[]{"xyz"});
set_rev("image","bmp",new String[]{"bmp"});
set_rev("image","fits",new String[]{"fts","fits","fit"});
set_rev("image","gif",new String[]{"gif"});
set_rev("image","ief",new String[]{"ief"});
set_rev("image","jp2",new String[]{"jp2","jpg2"});
set_rev("image","jpeg",new String[]{"jpg","jpeg","jfif","jpe"});
set_rev("image","jpm",new String[]{"jpm","jpgm"});
set_rev("image","jpx",new String[]{"jpf","jpx"});
set_rev("image","pcx",new String[]{"pcx"});
set_rev("image","png",new String[]{"png"});
set_rev("image","prs.btif",new String[]{"btif","btf"});
set_rev("image","prs.pti",new String[]{"pti"});
set_rev("image","svg+xml",new String[]{"svgz","svg"});
set_rev("image","t38",new String[]{"t38"});
set_rev("image","tiff",new String[]{"tif","tiff"});
set_rev("image","tiff-fx",new String[]{"tfx"});
set_rev("image","vnd.adobe.photoshop",new String[]{"psd"});
set_rev("image","vnd.djvu",new String[]{"djvu","djv"});
set_rev("image","vnd.dxf",new String[]{"dxf"});
set_rev("image","vnd.fastbidsheet",new String[]{"fbs"});
set_rev("image","vnd.fpx",new String[]{"fpx"});
set_rev("image","vnd.fst",new String[]{"fst"});
set_rev("image","vnd.fujixerox.edmics-mmr",new String[]{"mmr"});
set_rev("image","vnd.fujixerox.edmics-rlc",new String[]{"rlc"});
set_rev("image","vnd.globalgraphics.pgb",new String[]{"pgb"});
set_rev("image","vnd.microsoft.icon",new String[]{"ico"});
set_rev("image","vnd.ms-modi",new String[]{"mdi"});
set_rev("image","vnd.radiance",new String[]{"hdr","xyze","rgbe"});
set_rev("image","vnd.sealed.png",new String[]{"spng","s1n","spn"});
set_rev("image","vnd.sealedmedia.softseal.gif",new String[]{"sgif","s1g","sgi"});
set_rev("image","vnd.sealedmedia.softseal.jpg",new String[]{"sjp","s1j","sjpg"});
set_rev("image","vnd.wap.wbmp",new String[]{"wbmp"});
set_rev("image","vnd.xiff",new String[]{"xif"});
set_rev("image","x-canon-cr2",new String[]{"cr2"});
set_rev("image","x-canon-crw",new String[]{"crw"});
set_rev("image","x-cmu-raster",new String[]{"ras"});
set_rev("image","x-coreldraw",new String[]{"cdr"});
set_rev("image","x-coreldrawpattern",new String[]{"pat"});
set_rev("image","x-coreldrawtemplate",new String[]{"cdt"});
set_rev("image","x-corelphotopaint",new String[]{"cpt"});
set_rev("image","x-epson-erf",new String[]{"erf"});
set_rev("image","x-icon",new String[]{"ico"});
set_rev("image","x-jg",new String[]{"art"});
set_rev("image","x-jng",new String[]{"jng"});
set_rev("image","x-ms-bmp",new String[]{"bmp"});
set_rev("image","x-nikon-nef",new String[]{"nef"});
set_rev("image","x-olympus-orf",new String[]{"orf"});
set_rev("image","x-photoshop",new String[]{"psd"});
set_rev("image","x-portable-anymap",new String[]{"pnm"});
set_rev("image","x-portable-bitmap",new String[]{"pbm"});
set_rev("image","x-portable-graymap",new String[]{"pgm"});
set_rev("image","x-portable-pixmap",new String[]{"ppm"});
set_rev("image","x-rgb",new String[]{"rgb"});
set_rev("image","x-targa",new String[]{"tga"});
set_rev("image","x-xbitmap",new String[]{"xbm"});
set_rev("image","x-xpixmap",new String[]{"xpm"});
set_rev("image","x-xwindowdump",new String[]{"xwd"});
set_rev("message","global",new String[]{"u8msg"});
set_rev("message","global-delivery-status",new String[]{"u8dsn"});
set_rev("message","global-disposition-notification",new String[]{"u8mdn"});
set_rev("message","global-headers",new String[]{"u8hdr"});
set_rev("message","rfc822",new String[]{"eml","mail","art"});
set_rev("model","iges",new String[]{"igs","iges"});
set_rev("model","mesh",new String[]{"silo","msh","mesh"});
set_rev("model","vnd.dwf",new String[]{"dwf"});
set_rev("model","vnd.gdl",new String[]{"dor","ism","lmp","rsm","gdl","msm","win","gsm"});
set_rev("model","vnd.gtw",new String[]{"gtw"});
set_rev("model","vnd.moml+xml",new String[]{"moml"});
set_rev("model","vnd.mts",new String[]{"mts"});
set_rev("model","vnd.parasolid.transmit.binary",new String[]{"xmt_bin","x_b"});
set_rev("model","vnd.parasolid.transmit.text",new String[]{"xmt_txt","x_t"});
set_rev("model","vnd.vtu",new String[]{"vtu"});
set_rev("model","vrml",new String[]{"vrml","wrl"});
set_rev("model","x3d+binary",new String[]{"x3db"});
set_rev("model","x3d+vrml",new String[]{"x3dv"});
set_rev("model","x3d+xml",new String[]{"x3d"});
set_rev("multipart","voice-message",new String[]{"vpm"});
set_rev("text","cache-manifest",new String[]{"manifest"});
set_rev("text","calendar",new String[]{"ics","ifb","icz"});
set_rev("text","css",new String[]{"css"});
set_rev("text","csv",new String[]{"csv"});
set_rev("text","dns",new String[]{"soa","zone"});
set_rev("text","h323",new String[]{"323"});
set_rev("text","html",new String[]{"shtml","html","htm"});
set_rev("text","iuls",new String[]{"uls"});
set_rev("text","javascript",new String[]{"js"});
set_rev("text","mathml",new String[]{"mml"});
set_rev("text","plain",new String[]{"text","c","hh","hxx","h","txt","pot","f90","el","asc","cxx","pm","brf","cc"});
set_rev("text","prs.fallenstein.rst",new String[]{"rst"});
set_rev("text","prs.lines.tag",new String[]{"tag","dsc"});
set_rev("text","richtext",new String[]{"rtx"});
set_rev("text","scriptlet",new String[]{"wsc","sct"});
set_rev("text","sgml",new String[]{"sgm","sgml"});
set_rev("text","tab-separated-values",new String[]{"tsv"});
set_rev("text","texmacs",new String[]{"tm","ts"});
set_rev("text","uri-list",new String[]{"uris","uri"});
set_rev("text","vnd.DMClientScript",new String[]{"dms"});
set_rev("text","vnd.abc",new String[]{"abc"});
set_rev("text","vnd.esmertec.theme-descriptor",new String[]{"jtd"});
set_rev("text","vnd.fly",new String[]{"fly"});
set_rev("text","vnd.fmi.flexstor",new String[]{"flx"});
set_rev("text","vnd.graphviz",new String[]{"gv","dot"});
set_rev("text","vnd.in3d.3dml",new String[]{"3dm","3dml"});
set_rev("text","vnd.in3d.spot",new String[]{"spo","spot"});
set_rev("text","vnd.ms-mediapackage",new String[]{"mpf"});
set_rev("text","vnd.net2phone.commcenter.command",new String[]{"ccc"});
set_rev("text","vnd.si.uricatalogue",new String[]{"uric"});
set_rev("text","vnd.sun.j2me.app-descriptor",new String[]{"jad"});
set_rev("text","vnd.trolltech.linguist",new String[]{"ts"});
set_rev("text","vnd.wap.si",new String[]{"si"});
set_rev("text","vnd.wap.sl",new String[]{"sl"});
set_rev("text","vnd.wap.wml",new String[]{"wml"});
set_rev("text","vnd.wap.wmlscript",new String[]{"wmls"});
set_rev("text","x-bibtex",new String[]{"bib"});
set_rev("text","x-boo",new String[]{"boo"});
set_rev("text","x-c++hdr",new String[]{"hh","h++","hxx","hpp"});
set_rev("text","x-c++src",new String[]{"cpp","cxx","c++","cc"});
set_rev("text","x-chdr",new String[]{"h"});
set_rev("text","x-component",new String[]{"htc"});
set_rev("text","x-csh",new String[]{"csh"});
set_rev("text","x-csrc",new String[]{"c"});
set_rev("text","x-diff",new String[]{"diff","patch"});
set_rev("text","x-dsrc",new String[]{"d"});
set_rev("text","x-haskell",new String[]{"hs"});
set_rev("text","x-java",new String[]{"java"});
set_rev("text","x-literate-haskell",new String[]{"lhs"});
set_rev("text","x-moc",new String[]{"moc"});
set_rev("text","x-pascal",new String[]{"pas","p"});
set_rev("text","x-pcs-gcd",new String[]{"gcd"});
set_rev("text","x-perl",new String[]{"pl","pm"});
set_rev("text","x-pod",new String[]{"pod"});
set_rev("text","x-python",new String[]{"py"});
set_rev("text","x-scala",new String[]{"scala"});
set_rev("text","x-setext",new String[]{"etx"});
set_rev("text","x-sh",new String[]{"sh"});
set_rev("text","x-tcl",new String[]{"tcl","tk"});
set_rev("text","x-tex",new String[]{"cls","ltx","tex","sty"});
set_rev("text","x-vcalendar",new String[]{"vcs"});
set_rev("text","x-vcard",new String[]{"vcf"});
set_rev("text","xml",new String[]{"xml"});
set_rev("text","xml-external-parsed-entity",new String[]{"ent"});
set_rev("video","3gpp",new String[]{"3gpp","3gp"});
set_rev("video","3gpp2",new String[]{"3gpp2","3g2"});
set_rev("video","annodex",new String[]{"axv"});
set_rev("video","dl",new String[]{"dl"});
set_rev("video","dv",new String[]{"dv","dif"});
set_rev("video","fli",new String[]{"fli"});
set_rev("video","gl",new String[]{"gl"});
set_rev("video","mj2",new String[]{"mj2","mjp2"});
set_rev("video","mp4",new String[]{"mpg4","mp4"});
set_rev("video","mpeg",new String[]{"mpeg","mpg","mpe"});
set_rev("video","ogg",new String[]{"ogv"});
set_rev("video","quicktime",new String[]{"mov","qt"});
set_rev("video","vnd.fvt",new String[]{"fvt"});
set_rev("video","vnd.mpegurl",new String[]{"mxu","m4u"});
set_rev("video","vnd.ms-playready.media.pyv",new String[]{"pyv"});
set_rev("video","vnd.nokia.interleaved-multimedia",new String[]{"nim"});
set_rev("video","vnd.sealed.mpeg1",new String[]{"smpg","s11"});
set_rev("video","vnd.sealed.mpeg4",new String[]{"s14"});
set_rev("video","vnd.sealed.swf",new String[]{"ssw","sswf"});
set_rev("video","vnd.sealedmedia.softseal.mov",new String[]{"smo","s1q","smov"});
set_rev("video","x-flv",new String[]{"flv"});
set_rev("video","x-la-asf",new String[]{"lsx","lsf"});
set_rev("video","x-matroska",new String[]{"mpv","mkv"});
set_rev("video","x-mng",new String[]{"mng"});
set_rev("video","x-ms-asf",new String[]{"asf","asx"});
set_rev("video","x-ms-wm",new String[]{"wm"});
set_rev("video","x-ms-wmv",new String[]{"wmv"});
set_rev("video","x-ms-wmx",new String[]{"wmx"});
set_rev("video","x-ms-wvx",new String[]{"wvx"});
set_rev("video","x-msvideo",new String[]{"avi"});
set_rev("video","x-sgi-movie",new String[]{"movie"});
set_rev("x-conference","x-cooltalk",new String[]{"ice"});
set_rev("x-epoc","x-sisx-app",new String[]{"sisx"});
set_rev("x-world","x-vrml",new String[]{"vrml","wrl","vrm"});
	}

	private MimeType(){}

	private static void set_rev( String cat, String type, String[] ext ) {
		HashMap<String, String[]>	sub = rev.get( cat );
		if ( sub == null ) {
			sub = new HashMap<String, String[]>();
			rev.put( cat, sub );
		}
		sub.put( type, ext );

		StringBuilder	buf = new StringBuilder( cat );
		buf = buf.append( "/" );
		buf = buf.append( type );
		type = buf.toString();
		for ( int i = 0; i < ext.length; i++ ) {
			map.put( ext[i], type );
		}
	}

	/**
	 * MIME Media Type の取得。拡張子から判定します。
	 * @param file ファイル名。
	 * @return MIME Media Type。
	 * 未知の拡張子であれば application/octet-stream を返します。
	 */
	public static String getMimeType( String file ) {
		String[]	ext = file.split( "\\." );
		String	seek = ext[ext.length - 1].toLowerCase( Locale.ENGLISH );
		String	ret = map.get( seek );
		if ( ret == null )	return "application/octet-stream";
		return ret;
	}

	/**
	 * MIME Media Type の取得。拡張子から判定します。
	 * @param file ファイル名。
	 * @return MIME Media Type。
	 * 未知の拡張子であれば application/octet-stream を返します。
	 */
	public static String getMimeType( File file ) {
		return getMimeType( file.getName() );
	}

	/**
	 * 拡張子の取得。<br>
	 * 例えば、image/gif を指定すると、GIF画像フォーマットの拡張子を返します。<br>
	 * image を指定すると、画像カテゴリの全ての拡張子を返します。
	 * @param mime MIME Media Type。
	 * @return 拡張子。未知の MIME Media Type であると null。
	 */
	public static String[] getExtension( String mime ) {
		String[]	type = mime.split( "/" );
		HashMap<String, String[]>	sub = rev.get( type[0] );
		if ( sub == null )	return null;
		if ( type.length > 1 ) {
			return sub.get( type[1] );
		}
		ArrayList<String>	list = new ArrayList<String>();
		for ( String key: sub.keySet() ) {
			String[]	ext = sub.get( key );
			for ( int i = 0; i < ext.length; i++ ) {
				list.add( ext[i] );
			}
		}
		return list.toArray( new String[0] );
	}
}

