/*
 * Paraselene
 * Copyright (c) 2009-2011  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.tag.form;

import paraselene.*;
import paraselene.tag.*;

/**
 * OPTGROUPタグ。
 */
public class SelectGroup extends Tag {
	private static final long serialVersionUID = 1L;
	private static final String NAME = "optgroup";
	private static final String LABEL = "label";

	Select	list = null;

	/**
	 * コンストラクタ。
	 */
	public SelectGroup() {
		super( NAME, false );
	}

	protected Tag newReplica() {
		return new SelectGroup();
	}

	/**
	 * コンストラクタ。
	 * @param label ラベル。
	 */
	public SelectGroup( String label ) {
		this();
		setLabel( label );
	}

	/**
	 * ラベルの設定。
	 * @param label ラベル。
	 */
	public void setLabel( String label ) {
		setAttribute( LABEL, label );
	}

	/**
	 * 選択項目の取得。
	 * @return 選択項目の配列。
	 */
	public SelectItem[] getItemArray() {
		return Select.getItemArray( this );
	}

	public void addHTMLPart( HTMLPart d ) {
		super.addHTMLPart( d );
		if ( list != null )	list.setup( d );
	}

	public void addHTMLPart( int idx, HTMLPart d ) {
		super.addHTMLPart( idx, d );
		if ( list != null )	list.setup( d );
	}

}

