/*
 * Paraselene
 * Copyright (c) 2009-2011  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に同意できる場合にのみ
 * 利用可能です。
 */
package paraselene.ui;

import paraselene.*;
import paraselene.supervisor.*;
import paraselene.component.logic.*;

/**
 * メッセージボックス。
 */
public class MessageBox {
	private static PageID	page_id = null;

	private MessageBox(){}

	/**
	 * メッセージボックスを表示します。
	 * ユーザーがボタン押下するまでこのメソッドからリターンしません。<br>
	 * 戻り値は、引数で指定したボタン文字列に対応します。
	 * @param title タイトル。
	 * @param message メッセージ本文。
	 * @param color ダイアログ背景色。
	 * @param button ボタンに表示する文字列。
	 * 省略すると"OK"を１つ指定したことになります。
	 * @return 0以上は押下されたボタン番号を表します。button引数に対応します。<br>
	 * -1は、ボタン押下以外で閉じられた事を示します。
	 * -1のの時は、セッションタイムアウトなどが起きている可能性が高いため、
	 * アプリが使用中のリソースを解放し、処理を終えた方が良いでしょう。
	 */
	public static int doModal( String title, String message, Color color, String ... button ) {
		try {
			if ( page_id == null ) {
				page_id = MessageBoxHtml.migrate();
			}
			return (Integer)SandBox.doModal( page_id, EphemeralPosition.MODAL, null,
				new MessageBoxHtml.Param( color, title, message, button ) );
		}
		catch( Exception e ){
			e.printStackTrace();
		}
		return -1;
	}
	/**
	 * メッセージボックスを表示します。
	 * doModal(title, message, new Color(WebColor.ALICEBLUE), button)
	 * と等価です。
	 * @param title タイトル。
	 * @param message メッセージ本文。
	 * @param button ボタンに表示する文字列。
	 * 省略すると"OK"を１つ指定したことになります。
	 * @return {@link #doModal(String,String,Color,String[])}を参照して下さい。
	 */
	public static int doModal( String title, String message, String ... button ) {
		return doModal( title, message, new Color( WebColor.ALICEBLUE ), button );
	}
}

