#include "SyncQueue.h"
#include "WorkPool.h"

int main()
{
  void generator(SyncList<int>*);
  void worker(int, WorkPool<int,int>*);

  pards_init();

  SyncQueue<int> *work = new SyncQueue<int>(2);
  SyncQueue<int> *output = new SyncQueue<int>(2); 

  /* 
     SyncList<int> *work = new SyncList<int>;
     SyncList<int> *output = new SyncList<int>;
  */


  //  WorkPool<int,int> *pool = new WorkPool<int,int>(work,output,2);
  WorkPool<int,int> *pool = new WorkPool<int,int>(work,output);

  SPAWN(generator(work));
  SPAWN(worker(1, pool));
  SPAWN(worker(2, pool));

  while(1){
    printf("%d...\n",output->read());
    if((output = output->release()) == 0) break;
  }

  //  delete pool;

  pards_finalize();
}


void generator(SyncList<int> *a)
{
  int i;
  SyncList<int> *current;
  current = a;

  for(i = 0; i < 10; i++){
    current->write(i);
    current = current->create();
  }
  current->write(i);
  current->writecdr(0);
}

void worker(int id, WorkPool<int,int> *workpool)
{
  while(1){
    WorkItem<int,int> item = workpool->getwork();
    if(item.output == 0) break;
    else{
      item.output->write(item.work*2);
      printf("(%d by [%d])\n",item.work*2,id);
    }
  }
  // workpool->release();
}
