#ifndef SYNCQUEUE_H
#define SYNCQUEUE_H

#include "SyncList.h"

template <class T> class SyncQueue : public SyncList<T> {
 private:
  int queue_sem_id;
  int queue_size;
  void free_queue_sem();
  void free_local();
 public:
  SyncQueue(int s = -1);
  SyncQueue(SyncQueue<T>*);
  ~SyncQueue();
  virtual void writecdr(SyncQueue<T>*);
  virtual SyncQueue<T> *readcdr();
  virtual void free();
  virtual SyncQueue<T> *release();
  virtual SyncQueue<T> *create();
};

template <class T> SyncQueue<T>::~SyncQueue()
{
  if(Sync<T>::created_by_new) free_local();
}

template <class T> SyncQueue<T>::SyncQueue(int s)
{
  if(s > 0){
    queue_size = s;
    queue_sem_id = pards_semget(s);
  } else if (s == 0) {
    pards_error("Arg of SyncQueue's constructor should be more than 0",
		CRITICAL);
    queue_size = 1;
    queue_sem_id = pards_semget(1);
  }
  else
    queue_sem_id = -1;
}

template <class T> SyncQueue<T>::SyncQueue(SyncQueue<T>* prev)
{
  queue_sem_id = -1;
  prev->writecdr(this);
}

template <class T> SyncQueue<T>* SyncQueue<T>::readcdr()
{
  return (SyncQueue<T>*) SyncList<T>::readcdr();
}

template <class T> void SyncQueue<T>::writecdr(SyncQueue<T>* c)
{
  if(queue_sem_id == -1){
    pards_error("SyncQueue<T>::writecdr: Queue length is not set",CRITICAL);
    SyncList<T>::writecdr(c);
  }
  else{
    pards_sem_use(queue_sem_id);
    if(c != 0){
      if(c->queue_sem_id != -1){
        pards_error("Cdr's queue_sem_id is already set. Multiple items' cdr? \n",
                    INFO);
      }
      c->queue_sem_id = queue_sem_id; // not locking...
      c->queue_size = queue_size; // not locking...
    }
    SyncList<T>::writecdr(c);
  }
}

template <class T> void SyncQueue<T>::free_queue_sem()
{
  pards_sem_use_val(queue_sem_id, queue_size);
  pards_semfree(queue_sem_id);
}

template <class T> void SyncQueue<T>::free_local()
{
  if(queue_sem_id == -1) {
    pards_error("SyncQueue<T>::free: Queue length is not set",CRITICAL);
  } else {
    pards_sem_rel(queue_sem_id);
    if(!*SyncList<T>::cdr_is_written || *SyncList<T>::cdr == 0)
      free_queue_sem();
  }
}

template <class T> void SyncQueue<T>::free()
{
  free_local();
  SyncList<T>::free();
}

template <class T> SyncQueue<T>* SyncQueue<T>::release()
{
  SyncQueue<T>* crntcdr;
  crntcdr = readcdr();
  delete this;
  return crntcdr;
}

template <class T> SyncQueue<T>* SyncQueue<T>::create()
{
  SyncQueue<T> *new_cell = new SyncQueue<T>;
  writecdr(new_cell);
  return new_cell;
}

#endif
