#ifndef LIBPARDS_H
#define LIBPARDS_H

#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <sys/shm.h>
#include <errno.h>
#include <signal.h>

#if !defined(_SC_NPROCESSORS_ONLN) // for pards_get_nprocs
#if defined(__hpux__)
#include <sys/mpctl.h>
#elif defined(__FreeBSD__)
#include <sys/sysctl.h>
#endif
#endif

// 4th Argument of semctl
#if defined(__GNU_LIBRARY__) && !defined(_SEM_SEMUN_UNDEFINED)
#else
union semun {
  int val;
  struct semid_ds *buf;
  unsigned short *array;
  struct seminfo *__buf;
};
#endif

// error level used in pards_error
#define DBG 0
#define INFO 1
#define CRITICAL 2
#define FATAL 3
#define NO_PRINT 4

// undef this if your compiler does not support exception...
#define PARDS_USE_EXCEPTION
// disallow dynamic allocation of shared memory (not stable...)
#define NO_EXTEND_SHM

#define NUM_OF_PROCS 16 //default process number
#ifdef NO_EXTEND_SHM
#define NALLOC_BYTES 16777216 // Size of Shmem Allocation Unit:(16MB)
#define NUM_SHM_ID 2 // disallow dynamic allocation of shared memory
#else
#define NALLOC_BYTES 1048576 // Size of Shmem Allocation Unit: (1MB)
#define NUM_SHM_ID 1000 // number of max shmem id
#endif
#define NUM_SEM_ID 100000 // number of max semaphore id

#define IPC_PERM 0600 // permission of ipc resources

// for pards_finalize
#define DO_WAIT 1 
#define NO_WAIT 0

// for pards_fork
#define ERROR_IF_NOT_AVAIL 0
#define FUNC_IF_NOT_AVAIL 1

#define SPAWN(func) do{if(pards_fork(ERROR_IF_NOT_AVAIL) == 0){func; pards_exit();}}while(0)
#define SPAWN_F(func) do{pid_t pid; if((pid = pards_fork(FUNC_IF_NOT_AVAIL)) == 0){func; pards_exit();} else if(pid == -1){func;}}while(0)

void pards_init(int ap = NUM_OF_PROCS, unsigned bytes = NALLOC_BYTES);
void pards_finalize(int wait = DO_WAIT);
int pards_semget(int initval = 0);
void pards_semfree(int);
void pards_lock(int);
void pards_unlock(int);
void pards_sem_rel(int);
void pards_sem_use(int);
void pards_sem_use_val(int,int);
pid_t pards_fork(int mode = ERROR_IF_NOT_AVAIL);
void pards_exit();
void pards_error(char*,int);
void pards_perror(char*,int);
void* pards_shmalloc(unsigned);
void pards_shmfree(void*);

int pards_is_in_shm(char*);

int pards_set_error_level(int);
int pards_get_error_level();

int pards_get_nprocs();
int pards_avail_processes();

#endif
