#include "parblock.h"

PBInfo* pards_begin_parallel(int procnum)
{
  int i, pid;

  // procnum + 1 (for size) - 1 (parent doesn't need pid)
  int* ch = (int*)malloc(sizeof(int) * procnum);
  int* cnt = (int*)pards_shmalloc(sizeof(int));
  *cnt = 0;
  int wid = pards_semget();
  int bid = pards_semget();
  pards_lock(bid); 
  ch[0] = procnum;
  for(i = 1; i < procnum; i++){
    if((pid = fork()) == -1){
      pards_error("error in pards_begin_parallel",CRITICAL);
#ifdef PARDS_USE_EXCEPTION      
      throw ForkException();
#endif
    } else {
      if(pid == 0){ // child
	return new PBInfo(i,ch,cnt,wid,bid);
      } else { // parent
	ch[i] = pid;
      }
    }
  }
  // parent
  return new PBInfo(0,ch,cnt,wid,bid);
}

void PBInfo::free(){
  pards_semfree(barrier_write_sem_id);
  pards_semfree(barrier_block_sem_id);
  pards_shmfree(barrier_count);
}

void pards_end_parallel(PBInfo* pbinfo){
  pbinfo->join();
  pbinfo->free();
  delete pbinfo;
}

void PBInfo::join(){
  if(pno != 0){_exit(0);}
  else{
    for(int i = 1; i < children[0]; i++){
      int status;
      waitpid(children[i],&status,0);
    }
  }
}

void pards_barrier(PBInfo* pbinfo){
  pbinfo->barrier();
}

void PBInfo::barrier(){
  pards_lock(barrier_write_sem_id);
  (*barrier_count)++;
  if(*barrier_count == children[0]) // last process
    pards_unlock(barrier_block_sem_id); // wake up other processes
  else
    pards_unlock(barrier_write_sem_id); // last process keep this lock

  pards_lock(barrier_block_sem_id); // wait for the last process
  (*barrier_count)--;
  if(*barrier_count == 0) // if 0, I am the last process leaving barrier
    pards_unlock(barrier_write_sem_id); // keep block_sem_id's lock
  else
    pards_unlock(barrier_block_sem_id); // wake up other waiting processes
}
