#include <windows.h>
#include <stdio.h>
#include "Sync.h"

int fib(int);

int fibtest(int v)
{
/*
  if(argc < 2) {printf("usage: fib NUM (use small number like 10)\n"); exit(0);}
  int v = atoi(argv[1]);
*/
  DWORD t1, t2;
  int num;

  printf("serial version\n");
  t1 = GetTickCount();
  num = fib(v); 
  t2 = GetTickCount();
  printf("fib %d = %d\n",v, num);
  printf("elapsed time = %f sec\n",
	 (double)(t2 - t1)/1000.0);

  printf("parallel version (2CPU)\n");
  t1 = GetTickCount();

  pards_init();
  
  Sync<int> a;

  SPAWN(a.write(fib(v-1)));
  int b = fib(v-2);

  num = a.read() + b;

  a.free();

  t2 = GetTickCount();
  printf("fib %d = %d\n",v, num);
  printf("elapsed time = %f sec\n",
	 (double)(t2 - t1)/1000.0);

  pards_finalize();
  return 0;
}


int fib(int a)
{
  if(a == 1) return 1;
  else if (a == 2) return 1;
  else return fib(a-1) + fib(a-2);
}
