//package libsvm;
import java.io.*;
import java.util.*;

class LevenshteinDistance
{
  static int isutf8(String args) throws UnsupportedEncodingException
  {
    int ret = -1;
    byte[] c = args.getBytes("UTF-8");
    if((c[0]&0x80) == 0x00) ret = 1;
    else if((c[0]&0xe0) == 0xc0 && (c[1]&0xc0) == 0x80) ret = 2;
    else if((c[0]&0xf0) == 0xe0 && (c[1]&0xc0) == 0x80 
                                && (c[2]&0xc0) == 0x80 ) ret = 3;
    return(ret);
  }
  static Boolean equal(String s1, String s2) throws UnsupportedEncodingException
  {
    Boolean ret = false;
    if(isutf8(s1)==isutf8(s2))
    {
      int f=0;
      for(int i=0;i<isutf8(s1);++i)
      {
        byte[] c1 = s1.getBytes("UTF-8");
        byte[] c2 = s2.getBytes("UTF-8");
        if(c1[i]==c2[i]) ++f;
      }
      if(f==isutf8(s1)) ret = true;
    }
    return(ret);
  }
  static int edit(String px, String py) throws UnsupportedEncodingException
  {
    Vector<Vector> row = new Vector<Vector>();
    int len1=0,len2=0;
    int i,j;
    int result;
    len1 = px.length();
    len2 = py.length();
    for(i=0; i<len1+1; ++i)
    {
      row.add(new Vector());
      for(j=0; j<len2+1; ++j)
      {
        row.get(i).add(0);
      }
    }

    for(i=0;i<len1+1;i++) row.get(i).set(0,i);
    for(i=0;i<len2+1;i++) row.get(0).set(i,i);
    for(i=1;i<=len1;++i)
    {
      for(j=1;j<=len2;++j)
      {
        row.get(i).set(j,Math.min(Math.min(
                      (Integer)(row.get(i-1).get(j-1)) 
          + (equal(px.substring(i-1),py.substring(j-1))?0:1) , // replace
                      (Integer)(row.get(i).get(j-1)) + 1),     // delete
                      (Integer)(row.get(i-1).get(j)) + 1  ));  // insert
      }
    }
    result=(Integer)(row.get(len1).get(len2));

    return result;
  }

  public static void main(String[] args) throws UnsupportedEncodingException
  {
    System.out.println(LevenshteinDistance.edit("あい","あいう"));
  }
}