#include <cppcutter.h>
#include <particles.h>
#include <iostream>
using namespace std;

namespace test_particles
{
  void cut_setup()
  {
  }
  void cut_teardown()
  {
  }

  void test_construction(void)
  {
    Particles<int> a(3);
    vector<Particle<int> > p = a.get_particles();
    cppcut_assert_equal(3, (int)p.size());
    cppcut_assert_equal(3, a.size());
    Particles<int> b(3,2);
    for(int i=0;i<3;++i)
      cut_assert_equal_string("(0,0)", b[i].toString().c_str());
  }
  void test_manipulate(void)
  {
    Particles<int> b(3,2);
    Particle<int> c(2);
    c[0]=1; c[1]=2;
    cut_assert_equal_string("(1,2)", c.toString().c_str());
    b[0] = c;
    cut_assert_equal_string("(1,2)", b[0].toString().c_str());
    int n=10;
    for(int i=0;i<3;++i)
    {
      for(int j=0;j<2;++j)
      {
        b[i][j] = n++;
      }
    }
    cut_assert_equal_string("(10,11)", b[0].toString().c_str());
    cut_assert_equal_string("(12,13)", b[1].toString().c_str());
    cut_assert_equal_string("(14,15)", b[2].toString().c_str());
//    cppcut_assert_equal(0,b.dump_particles());
  }
  void test_dumping(void)
  {
    Particles<int> a(3,2);
    cppcut_assert_equal(0,a.dump_particles());
  }

}
