﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Windows.Forms;

namespace PDFAnnotList
{
    static class Program
    {
        /// <summary>
        /// アプリケーションのメイン エントリ ポイントです。
        /// </summary>
        [STAThread]
        static void Main()
        {
            Application.EnableVisualStyles();
            Application.SetCompatibleTextRenderingDefault(false);

            string readFilePath = ShowOpenFileDialog();
            if (!File.Exists(readFilePath))
            {
                return;
            }

            try
            {
                PDFAnnotationReader reader = new PDFAnnotationReader();
                ICollection<Annotation> annots = reader.Read(readFilePath);

                string writeFilePath = ShowSaveFileDialog();
                XmlSpreadsheetWriter writer = new XmlSpreadsheetWriter();
                writer.Write(writeFilePath, annots);
            }
            catch (Exception e)
            {
                MessageBox.Show(e.Message, "Error", MessageBoxButtons.OK, MessageBoxIcon.Error);
            }
        }

        /// <summary>
        /// ファイルを開くダイアログを表示し、選択されたファイルパスを返します。
        /// </summary>
        /// <returns>選択されたファイルのパス。ダイアログでキャンセルされた際は空文字列。</returns>
        static string ShowOpenFileDialog()
        {
            OpenFileDialog dlg = new OpenFileDialog();
            dlg.Filter = "PDF Files (*.pdf)|*.pdf";
            dlg.Title = "Open";
            dlg.RestoreDirectory = true;

            if (dlg.ShowDialog() == DialogResult.OK)
            {
                return dlg.FileName;
            }

            return "";
        }

        /// <summary>
        /// ファイルの保存ダイアログを表示し、入力されたファイルパスを返します。
        /// </summary>
        /// <returns>入力されたファイルのパス。ダイアログでキャンセルされた際は空文字列。</returns>
        static string ShowSaveFileDialog()
        {
            SaveFileDialog dlg = new SaveFileDialog();
            dlg.Filter = "XML Spreadsheet (*.xml)|*.xml";
            dlg.Title = "Save";
            dlg.RestoreDirectory = true;

            if (dlg.ShowDialog() == DialogResult.OK)
            {
                return dlg.FileName;
            }

            return "";
        }
    }
}
